<?php
  //ini_set('display_errors', 0);
  //ini_set('display_startup_errors', 0);
  //error_reporting(E_ALL);

  define('ABSPATH', __DIR__);

  require_once "./Components/Locales.php";
  require_once "./Components/APP.php";

  $url = $_SERVER["REQUEST_URI"];
  $query_str = parse_url($url);
  $custom_url = false;
  $custom_url_address = null;
  $productId = null;

  if (preg_match('/\/product\/([a-zA-Z0-9^\/\?\&]+)/i', $query_str['path'], $matches, PREG_OFFSET_CAPTURE)) {
    $productId = $matches[1][0];
  }

  $refType = key_exists('ref_type', $_GET) ? $_GET['ref_type'] : null;

  $transparent = key_exists('transparent', $_GET) ? 1 : 0 ;
  $embed = key_exists('embed', $_GET) ? 1 : 0 ;
  $customizemode = key_exists('customizemode', $_GET) ? 1 : 0 ;
  $mobilepreview = key_exists('mobilepreview', $_GET) ? 1 : 0 ;
  $rtlchange = key_exists('rtl', $_GET) ? 1 : 0 ;
  $rtlStateForce = $rtlchange == 0 ? null : $_GET['rtl'];

  $disablelogs = key_exists('disablelogs', $_GET) ? 1 : 0 ;
  $dlid = key_exists("dlid", $_GET) ? $_GET['dlid'] : "0";
  $cmsauth = key_exists("cmsauth", $_GET) ? $_GET['cmsauth'] : "0";
  $canva = key_exists("canva", $_GET) ? $_GET['canva'] : "0";
  $debug = key_exists("debug", $_GET) ? 1 : 0;
  $debug = 1;
  $coverMode = key_exists("cover", $_GET) ? 1 : 0;
  $protectedParameters = key_exists("pp", $_GET) ? $_GET['pp'] : 0;
  $loaderColor = key_exists("loadercolor", $_GET) ? $_GET['loadercolor'] : 0;
  $blockLayout = key_exists("layout", $_GET) && $_GET['layout'] == 0;

  $requestData = APP::getFullRequestUrlWithParams([ 'isCustomUrl' => boolval($custom_url) ]);

  $pid = $requestData['pid'];
  $iid = $requestData['iid'];
  $page = $requestData['page'];

  if ($custom_url) {
    APP::$rootPathAWS = "https://dkl18tmi4r0t8.cloudfront.net/flipbook/202402_cuv";
  }

  $url = APP::$viewerApi . "/$pid/$iid?dlid=" . $dlid;

  if ($cmsauth != '0') {
    $url = APP::$viewerApi . "/$pid/$iid?dlid=" . $dlid . "&cmsauth=" . $cmsauth;
  }

  $ch = curl_init();

  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Origin: ' . $_SERVER['HTTP_HOST']
  ]);

  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  $output = curl_exec($ch);

  curl_close($ch); 
  $pagesNum = 0;

  if ($output) {
    $is_canva = 0;

    $obj = json_decode($output);
    
    if ($custom_url) {
      $custom_url_address = $pid;
      $iid = $obj->id;
      $pid = $obj->publisher_id;
    }
    
    if (property_exists($obj, "is_canva") && ($obj->is_canva == "1" || $obj->is_canva == true)) {
      $is_canva = 1;
    }
    
    $bookModel = [];
    

    if (property_exists($obj, 'error')) {
      $bookModel = json_encode(array(
        'bookId' => $iid,
        'publisherId' => $pid,
        'error' => true
      ));
    } else {
      $bookModel = $obj;
    }
    
    if ((!$customizemode && property_exists($obj, "published") && !$obj->published) || !is_object($obj) || isset($obj) && property_exists($obj,"code") && $obj->code == 404) {
      // header("Location: https://publuu.com/flipbook-maker/#nle2_".$pid."_".$iid);
      return include("Components/templates/404.php");
      exit;
    }

    $rightToLeft = property_exists($obj->settings, 'show_right_to_left') && boolval($obj->settings->show_right_to_left) ? 1 : 0;
    
    $backgroundImageColor = "";

    if (property_exists($obj->settings, 'background_image_color')) {
      $backgroundImageColor = $obj->settings->background_image_color; 
    }

    if (!property_exists($obj->settings, 'background_mode')) {
      $obj->settings->background_mode = 0;
      $obj->settings->background_color = "#ffffff";
    } else {
      if ($obj->settings->background_mode == 0) {
        $backgroundImageColor = $obj->settings->background_color;
      } else if ($obj->settings->background_mode == 1) {
        $backgroundImageColor = $obj->settings->background_texture_color;
      } else if ($obj->settings->background_mode == 2) {
        $backgroundImageColor = $obj->settings->background_image_color;
      }
    }

    if ($obj->description == "") {
      $obj->description = Locales::_t('Default Description');
    }

    if (!property_exists($obj, 'name')) {
      $obj->name = Locales::_t('State Protected');
      $obj->description = "";
    }
    
    if (property_exists($obj, "is_converted") && ($obj->is_converted == "0" || $obj->is_converted == false)) {
      $obj->name = Locales::_t('State Still Converting');
      $obj->is_converted = 0;
    } else {
      $obj->is_converted = 1;
    }

    if (property_exists($obj, "pages")) {
      $pagesNum = intval($obj->pages);
    }
  }
  else {
    var_dump("N DATA!");
    exit;
  }

  function security($obj) {
    $obj->name = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->name);
    $obj->description = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->description);

    if (strpos($obj->name, "<script>") !== false || $obj->name == "\">") {
      $obj->name = Locales::_t("Security Title");
    }

    if (strpos($obj->description, "<script>") !== false || $obj->description == "\">") {
      $obj->name = Locales::_t("Security Description");
    }

    return $obj;
  }

  $obj = security($obj);
  $protectedDomainSettings = [];

  if (property_exists($obj, "settings")) {
    $protectedDomainSettings["enable_protected_domain"] = boolval(intval($obj->settings->enable_protected_domain));
    $protectedDomainSettings["protected_domains"] = $obj->settings->protected_domains;
    $protectedDomainSettings["pid"] = $pid;
    $protectedDomainSettings["iid"] = $iid;
    $protectedDomainSettings["dlid_verified"] = property_exists($obj->settings, "dlid_verified") ? boolval($obj->settings->dlid_verified) : null;
    $protectedDomainSettings["customize_mode"] = $customizemode;
    $protectedDomainSettings["pp"] = $protectedParameters;
  }

  $bodyBackgroundColor = $transparent == 1 ? 'transparent' : ($backgroundImageColor ? "#" . $backgroundImageColor : "none");

  $min = false;
?>

<!DOCTYPE html>
<html lang="<?= Locales::getLocale(); ?>" itemscope itemtype="http://schema.org/Book">
  <head>
    <style>
      html {
        overflow: hidden;
      }
      body {
        overflow: auto;
      }
      html, body {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        height: 100vh;
        margin: 0;
        padding: 0;
      }
    </style>

    <?php include("Components/templates/head-simple.php"); ?>
<!-- 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.10.38/pdf.min.mjs" type="module"></script>
    <script src="https://cdn.jsdelivr.net/npm/pdf.js-viewer@0.2.8/pdf.min.js"></script> -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.10.38/pdf.min.mjs" type="module"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.10.38/pdf_viewer.mjs" type="module"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.10.38/pdf_viewer.min.css">

    <script type="text/javascript">      
      window._translations = <?= json_encode(Locales::getTranslations()) ?>;
      window.disablelogs =  <?= $disablelogs ?>;

      window.perftime = 0;
      window.perfcount = 0;
      window.dlid = <?= $dlid ?>;
      window.productId = '<?= $productId ?>';
      window.blockLayout = '<?= $blockLayout ?>';

      const AudioContext = window.AudioContext || window.webkitAudioContext;
      const audioCtx = new AudioContext();
      const audioElements = document.querySelectorAll('.flip-audio');
      var audio = audioElements[0];
      window.audio = audio;

      var APPv = <?= APP::$v ?>,
        APPm = <?= APP::$minimized ? 'true' : 'false' ?>,
        bookId = <?= $iid ?>,
        PreloadImages = true,
        publisherId = <?= $pid ?>,
        disablelogs = <?= $disablelogs ?>, 
        transparent = <?= $transparent ?>,
        embedmode = <?= $embed ?>,
        debugMode = <?= $debug ?>,
        bookModel = <?= json_encode($bookModel) ?>,
        loaderInfo = {
          "title": encodeURIComponent('<?= addslashes($obj->name) ?>'),
          "backgroundColor": "<?= $backgroundImageColor ?>",
          "logo": "<?= $obj->settings->toplogo_image ?>",
          "isCanva": "<?= $obj->is_canva == 1 ? 1 : 0 ?>",
          "color": "<?= $loaderColor ?>"
        },
        coverMode = <?= $coverMode ?>,
        customizemode = <?= $customizemode ?>,
        mobilepreview = <?= $mobilepreview ?>,
        rtlChange = <?= $rtlchange ?>,
        rightToLeft = <?= $rtlStateForce == null ? $rightToLeft : $rtlStateForce ?>,
        cmsAuth = <?= $cmsauth ?>,
        isConverted = <?= $is_canva ? $obj->is_converted : 'true' ?>,
        isCanva = <?= $is_canva ?>,
        forceOnePage = false,
        pagesNum = <?= $pagesNum ?>,
        embeduid = "",
        localErrorLogs = 1,
        customUrl = '<?= $custom_url ? 1 : 0 ?>';
      
      var APPonReady = {
        _list: [],
        add: function(clb) {
          if (typeof clb == 'function') APPonReady._list.push(clb);
          if (typeof APP !='undefined' && window.APP && window.APP.ready && APP.ready()) {
            for (var i = APPonReady._list.length - 1; i >= 0; i--) {
              APPonReady._list[i]();
            }
            APPonReady._list = [];
          }
        }
      };
    </script>

    <script>
      window._config = {
        ROOT_PATH: "<?= APP::$rootPath ?>/",
        API_PUBLUU: "<?= APP::$rootApi ?>",
        CMS_PUBLUU_CF: "<?= APP::$cloudfrontCMS ?>",
        PATH_CF_FLIP: "<?= APP::$rootPathAWS ?>/",
        VIEWER_API: "<?= APP::$viewerApi ?>",
        LEADS_API: "<?= APP::$leadsApi ?>",
        LOGS_API: "<?= APP::$logsApi ?>",
        CUSTOMIZE_ORIGINS: <?= json_encode(APP::$customizeOrigins) ?>,
        VERSION: "<?= APP::$v ?>"
      };
    </script>
  </head>
  <body class="noselect" oncontextmenu="return true;" style="background: <?= $bodyBackgroundColor ?>">
    <div class="book-layout" style="position: absolute; right: 100%; top: 0;">
      <?php include("Components/templates/contentDescription.php"); ?>
      
      <p class="powered-by" itemprop="publisher" itemscope itemtype="http://schema.org/Organization">
        Made with <a href="https://publuu.com/flipbook-maker/" title="Create Flipbooks with Publuu">Publuu - flipbook maker</a>
      </p>
    </div>

    <script>
      const element = document.createElement("script");
      element.src = "<?= APP::getPathToJsFile('init') ?>";
      document.head.appendChild(element);
    </script>

    <noscript><a href="https://publuu.com/flipbook-maker/"><?= Locales::_t('Powered By'); ?></a></noscript>
  </body>
</html>