<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



$url = $_SERVER["REQUEST_URI"];
$query_str = parse_url($url);

$powered_by_link = '';
for ($i = 1; $i < (count(explode('/', $url)) - 2); $i++) { 
  $powered_by_link .= '../';
}
$powered_by_link .= 'content/index.php';

$aData = explode("/", $query_str['path']);
$custom_url = null;
if( $aData[1] == "view"){
    //var_dump($aData);
    $pid = $aData[2];
    $iid = $aData[3];
    $page = isset($aData[5]) ? $aData[5] : 1;
}
else{
    if (!is_int(intval($aData[2])) || (is_int(intval($aData[2])) && intval($aData[2]) == 0)) {
      $custom_url = $aData[2];
      $page = isset($aData[4]) ? $aData[4] : 1;
    } else {
      $pid = $aData[2];
      $iid = $aData[3];
      $page = isset($aData[5]) ? $aData[5] : 1;
    }
}
$transparent = key_exists('transparent', $_GET) ? 1 : 0 ;
$embed = key_exists('embed', $_GET) ? 1 : 0 ;
$customizemode = key_exists('customizemode', $_GET) ? 1 : 0 ;

$disablelogs = key_exists('disablelogs', $_GET) ? 1 : 0 ;
$dlid = key_exists("dlid", $_GET) ? $_GET['dlid'] : "0";
$cmsauth = key_exists("cmsauth", $_GET) ? $_GET['cmsauth'] : "0";
$canva = key_exists("canva", $_GET) ? $_GET['canva'] : "0";
$forceSinglePageMode = false;

define('ABSPATH', __DIR__);

require_once "./Components/APP.php";

//get data in php
    if ($custom_url) {
      $url = APP::$apiPath."/publishers/issuesviewer/$custom_url";
    } else {
      $url = APP::$apiPath."/publishers/$pid/issues/$iid?content=1";
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $output = curl_exec($ch);
    $issue = $output;
    
    $pagesNum = 0;
    
if( $output ){
  $obj = json_decode($output);

    $issueTitle = property_exists($obj->issue_info, 'title') ? $obj->issue_info->title : '';
    $issueDescription = property_exists($obj->issue_info, 'description') ? $obj->issue_info->description : '';
    $issueContent = json_decode($obj->issue_info->content);
    $issue = json_decode($issue);
    unset($issue->issue_info);
    $issue = json_encode($issue);

    if ($custom_url) {
      $iid = $obj->id;
      $pid = $obj->publisher_id;
    }

  //   $content_url = APP::$genPath."link/pdf_contents/$iid.txt";
  //   curl_setopt($ch, CURLOPT_URL, $content_url);
  //   $content = curl_exec($ch);
  //   $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  //   if ($httpcode == 404) {
  //     $obj = json_decode($output);
  //     $content = '<h1>' . $obj->settings->name . '</h1>
  // <h2>' . $obj->settings->description . '</h2>';
  //   } else {
  //     $content = json_decode($content);
  //     $content[0]->content = json_decode($content[0]->content);
  //   }
    curl_close($ch);
    
     if( (!$customizemode &&  property_exists( $obj, "published" ) && !$obj->published) || !is_object($obj) || isset($obj) && property_exists($obj,"code") && $obj->code == 404){
         header("Location: https://publuu.com/flipbook-maker/#nle2_".$pid."_".$iid);
         exit;
     }
     
 
    if( $obj->description==""){
        $obj->description = "Welcome to interactive presentation, created with Publuu. Enjoy the reading!";
    }
    if( !property_exists( $obj, 'name' ) ){
      $obj->name = "Protected";
      $obj->description = "";
    }
    if( property_exists($obj, "is_converted") && ($obj->is_converted == "0" || $obj->is_converted == false) ){
        $obj->name = "Flipbook is converting. This will take just a moment.";
    }
    else{
        $obj->is_converted=1;
    }
    
    if( property_exists($obj, "pages") ){
        $pagesNum = intval($obj->pages);
    }
    else{
        
    }
}
else{
    var_dump("N DATA!");
    exit;
}


if( $disablelogs ){
    $obj->name = "NO LOG - " . $obj->name;
}

function security( $obj ){
    $obj->name = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->name);
    $obj->description = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->description);
    if( strpos($obj->name, "<script>") !== false || $obj->name == "\">" ){
        $obj->name = "Wrong name";
    }
    if( strpos($obj->description, "<script>") !== false || $obj->description == "\">" ){
        $obj->name = "Wrong description";
    }
    return $obj;
}

$obj = security( $obj );

$min = false;

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta itemprop="image" content="<?=APP::$genPath?>share.php?iid=<?=$iid?>&pid=<?=$pid?>">
<meta property="og:image" content="<?=APP::$genPath?>share.php?iid=<?=$iid?>&pid=<?=$pid?>">
<meta name="twitter:image:src" content="<?=APP::$genPath?>share.php?iid=<?=$iid?>&pid=<?=$pid?>">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:title" content="<?=$obj->name?>">
<meta name="twitter:title" content="<?=$obj->name?>">
<title><?=$obj->name?></title> 
<meta name="description" content="<?=$obj->description ?>">
<meta property="og:description" content="<?=$obj->description?>">
<meta name="twitter:description" content="<?=$obj->description?>">
<meta name="twitter:text:description" content="<?=$obj->description?>">        
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" >

<script src="<?= APP::$rootPath?>/page-flip.browser.js?v=<?=APP::$v?>"></script>
<!-- generics -->
<link rel="icon" href="<?=APP::$rootPath?>/favicon-32.png" sizes="32x32">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-57.png" sizes="57x57">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-76.png" sizes="76x76">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-96.png" sizes="96x96">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-128.png" sizes="128x128">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-192.png" sizes="192x192">
<link rel="icon" href="<?=APP::$rootPath?>/favicon-228.png" sizes="228x228">

<!-- Android -->
<link rel="shortcut icon" sizes="196x196" href="<?=APP::$rootPath?>/favicon-196.png">

<!-- iOS -->
<link rel="apple-touch-icon" href="<?=APP::$rootPath?>/favicon-120.png" sizes="120x120">
<link rel="apple-touch-icon" href="<?=APP::$rootPath?>/favicon-152.png" sizes="152x152">
<link rel="apple-touch-icon" href="<?=APP::$rootPath?>/favicon-180.png" sizes="180x180">

<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&display=swap" rel="stylesheet">

<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/APP-xs<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/APP-xs<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" media="all" />
<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/APP-sm<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/APP-sm<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" media="(min-width:568px)" />
<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/APP-md<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/APP-md<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" media="(min-width:868px)" />
<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/APP-lg<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/APP-lg<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" media="(min-width:1200px)" />
<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/APP-xl<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/APP-xl<?=(APP::$minimized?'.min':'')?>.css?v=<?=APP::$v?>" media="(min-width:1600px)" />

<link rel="preload" as="style" href="<?= APP::$rootPath?>/assets/css/Menu.css?v=<?=APP::$v?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::$rootPath?>/assets/css/Menu.css?v=<?=APP::$v?>" />

<script type="text/javascript"> 
  var isLandscape = false;
  var isAndroid = (/android/gi).test(navigator.appVersion);
  var isIDevice = (/iphone|ipad/gi).test(navigator.appVersion);
  var isIPhone = (/iphone/gi).test(navigator.appVersion);
  var iOsHeight = 0;

  window.timingcount = 0;
  window.timingsum = 0;
  window.dlid = <?= $dlid ?>;
  
  var APPv = <?=APP::$v?>,
      APPm = <?=APP::$minimized?'true':'false'?>,
      bookId = <?=$iid?>,
      PreloadImages = true,
      publisherId = <?=$pid?>,
      disablelogs = <?=$disablelogs?>, 
      transparent = <?=$transparent?>,
      embedmode = <?=$embed?>,
      customizemode = <?=$customizemode?>,
      cmsAuth = <?=$cmsauth?>,
      isConverted = true,
      forceOnePage = false,
      pagesNum = <?=$pagesNum?>,
      embeduid = "";

  var APPonReady = {
    _list: [],
    add: function(clb) {
      if (typeof clb=='function') APPonReady._list.push(clb);
      if (typeof APP!='undefined'&&APP.ready()) {
        for (var i = APPonReady._list.length - 1; i >= 0; i--) {
          APPonReady._list[i]();
        }
        APPonReady._list = [];
      }
    }
  };
  </script>
  <script src="https://www.youtube.com/iframe_api"></script>
  <script src="https://player.vimeo.com/api/player.js"></script>
	<script async src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
</head>
<body class="noselect" oncontextmenu="return true;" style="background: #<?= $obj->settings->background_texture_color ?>">
  <?php if (isset($issueContent) && is_array($issueContent)) : ?>
    <h1><?= (isset($issueTitle) && strlen($issueTitle)) ? $issueTitle : $obj->settings->name ?></h1>
    <h2><?= (isset($issueDescription) && strlen($issueDescription)) ? $issueDescription : $obj->settings->description ?></h2>

    <div class='nav-links'>
    <?php foreach ($issueContent as $key=>$value) : ?>
    <a class='internalLink'<?php echo ($key == 0) ?  ' rel="index"' : (($key == 1) ? ' rel="next"' :  (($key == count($issueContent) - 1) ? ' rel="last"' : '')) ?> href='./<?= $value->page + 1 ?>' title='<?= $value->title ?>'><?= $value->page + 1 ?></a>
    <?php endforeach; ?>
  </div>

    <div class='text-container'>
    <?php foreach ($issueContent as $value) : 
      if (isset($page) && $page == $value->page + 1 && $page <= count($issueContent)) : ?>
        <p><?= $value->text ?></p>
      <?php elseif (!isset($page) || $page > count($issueContent)) : ?>
        <p><?= $value->text ?></p>
      <?php endif; 
    endforeach; ?>
  </div>
  <?php endif; ?>

  <p class="powered-by" itemprop="publisher" itemscope itemtype="http://schema.org/Organization">
    <a href="<?php echo $powered_by_link ?>" title="Flipbook made with Publuu" itemprop="url"> 
      <span itemprop="name">Made with Publuu.com</span> 
    </a>
  </p>

  <script type="text/javascript" src="<?= APP::$rootPath?>/assets/scripts/APP.js"></script>
  <script src="<?= APP::$rootPath?>/assets/scripts/boot.js" defer></script>
  <script>
    window.disablelogs =  <?=$disablelogs?>;
    let data = JSON.parse(<?php echo json_encode($issue, true) ?>);
    document.addEventListener('DOMContentLoaded', () =>  {
      const boot = new Boot(data);
      boot.render();
    });
  </script>
</body>
</html>
