<?php
  //ini_set('display_errors', 0);
  //ini_set('display_startup_errors', 0);
  //error_reporting(E_ALL);

  define('ABSPATH', __DIR__);

  require_once "./Components/Locales.php";
  require_once "./Components/APP.php";

  $url = $_SERVER["REQUEST_URI"];
  $query_str = parse_url($url);
  $custom_url = false;
  $custom_url_address = null;
  $productId = null;

  if (preg_match('/\/product\/([a-zA-Z0-9^\/\?\&]+)/i', $query_str['path'], $matches, PREG_OFFSET_CAPTURE)) {
    $productId = $matches[1][0];
  }

  $transparent = key_exists('transparent', $_GET) ? 1 : 0 ;
  $embed = key_exists('embed', $_GET) ? 1 : 0 ;
  $customizemode = key_exists('customizemode', $_GET) ? 1 : 0 ;
  $mobilepreview = key_exists('mobilepreview', $_GET) ? 1 : 0 ;
  $rtlchange = key_exists('rtl', $_GET) ? 1 : 0 ;
  $rtlStateForce = $rtlchange == 0 ? null : $_GET['rtl'];

  $disablelogs = key_exists('disablelogs', $_GET) ? 1 : 0 ;
  $dlid = key_exists("dlid", $_GET) ? $_GET['dlid'] : "0";
  $cmsauth = key_exists("cmsauth", $_GET) ? $_GET['cmsauth'] : "0";
  $canva = key_exists("canva", $_GET) ? $_GET['canva'] : "0";
  $debug = key_exists("debug", $_GET) ? 1 : 0;
  $debug = 1;
  $coverMode = key_exists("cover", $_GET) ? 1 : 0;
  $protectedParameters = key_exists("pp", $_GET) ? $_GET['pp'] : 0;
  $loaderColor = key_exists("loadercolor", $_GET) ? $_GET['loadercolor'] : 0;

  $requestData = APP::getFullRequestUrlWithParams([ 'isCustomUrl' => boolval($custom_url) ]);

  $pid = $requestData['pid'];
  $iid = $requestData['iid'];
  $page = $requestData['page'];

  if ($custom_url) {
    APP::$rootPathAWS = "https://dkl18tmi4r0t8.cloudfront.net/flipbook/202402_cuv";
  }

  $url = APP::$viewerApi . "/$pid/$iid?dlid=" . $dlid;

  if ($cmsauth != '0') {
    $url = APP::$viewerApi . "/$pid/$iid?dlid=" . $dlid . "&cmsauth=" . $cmsauth;
  }

  $ch = curl_init();

  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'authorizationToken: ""',
    'Origin: ' . $_SERVER['HTTP_HOST']
  ]);

  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  $output = curl_exec($ch);

  curl_close($ch); 
  $pagesNum = 0;

  if ($output) {
    $is_canva = 0;

    $obj = json_decode($output);
    
    if ($custom_url) {
      $custom_url_address = $pid;
      $iid = $obj->id;
      $pid = $obj->publisher_id;
    }
    
    if (property_exists($obj, "is_canva") && ($obj->is_canva == "1" || $obj->is_canva == true)) {
      $is_canva = 1;
    }
    
    $bookModel = [];
    

    if (property_exists($obj, 'error')) {
      $bookModel = json_encode(array(
        'bookId' => $iid,
        'publisherId' => $pid,
        'error' => true
      ));
    } else {
      $bookModel = $obj;
    }
    
    if ((!$customizemode && property_exists($obj, "published") && !$obj->published) || !is_object($obj) || isset($obj) && property_exists($obj,"code") && $obj->code == 404) {
      // header("Location: https://publuu.com/flipbook-maker/#nle2_".$pid."_".$iid);
      return include("Components/templates/404.php");
      exit;
    }

    $rightToLeft = property_exists($obj->settings, 'show_right_to_left') && boolval($obj->settings->show_right_to_left) ? 1 : 0;
    
    $backgroundImageColor = "";

    if (property_exists($obj->settings, 'background_image_color')) {
      $backgroundImageColor = $obj->settings->background_image_color; 
    }

    if (!property_exists($obj->settings, 'background_mode')) {
      $obj->settings->background_mode = 0;
      $obj->settings->background_color = "#ffffff";
    } else {
      if ($obj->settings->background_mode == 0) {
        $backgroundImageColor = $obj->settings->background_color;
      } else if ($obj->settings->background_mode == 1) {
        $backgroundImageColor = $obj->settings->background_texture_color;
      } else if ($obj->settings->background_mode == 2) {
        $backgroundImageColor = $obj->settings->background_image_color;
      }
    }

    if ($obj->description == "") {
      $obj->description = Locales::_t('Default Description');
    }

    if (!property_exists($obj, 'name')) {
      $obj->name = Locales::_t('State Protected');
      $obj->description = "";
    }
    
    if (property_exists($obj, "is_converted") && ($obj->is_converted == "0" || $obj->is_converted == false)) {
      $obj->name = Locales::_t('State Still Converting');
      $obj->is_converted = 0;
    } else {
      $obj->is_converted = 1;
    }

    if (property_exists($obj, "pages")) {
      $pagesNum = intval($obj->pages);
    }
  }
  else {
    var_dump("N DATA!");
    exit;
  }

  function security($obj) {
    $obj->name = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->name);
    $obj->description = preg_replace('~<\s*\bscript\b[^>]*>(.*?)<\s*\/\s*script\s*>~is', '', $obj->description);

    if (strpos($obj->name, "<script>") !== false || $obj->name == "\">") {
      $obj->name = Locales::_t('Security Title');
    }

    if (strpos($obj->description, "<script>") !== false || $obj->description == "\">") {
      $obj->name = Locales::_t('Security Description');
    }

    return $obj;
  }

  $obj = security($obj);
  $protectedDomainSettings = [];
  $pages_description = [];

  if (property_exists($obj, 'settings')) {
    $protectedDomainSettings['enable_protected_domain'] = boolval(intval($obj->settings->enable_protected_domain));
    $protectedDomainSettings['protected_domains'] = $obj->settings->protected_domains;
    $protectedDomainSettings['pid'] = $pid;
    $protectedDomainSettings['iid'] = $iid;
    $protectedDomainSettings['dlid_verified'] = property_exists($obj->settings, 'dlid_verified') ? boolval($obj->settings->dlid_verified) : null;
    $protectedDomainSettings['customize_mode'] = $customizemode;
    $protectedDomainSettings['pp'] = $protectedParameters;
  }

  $powered_by_link = null;

  if (key_exists('pages_description', $obj)) {
    $pages_description = str_replace('\n', '{n}', $obj->pages_description);
    $pages_description = json_decode($pages_description);
    $linkParts = [$_SERVER['HTTP_HOST'], explode('/', $_SERVER['REQUEST_URI'])[1], $pid, $iid, 'page']; 
    $linkToPage = 'https://' . implode('/', $linkParts);

    $powered_by_link = 'https://' . $linkParts[0] . '/' . $linkParts[1] . '/content/';
  } else {
    $linkParts = [$_SERVER['HTTP_HOST'], explode('/', $_SERVER['REQUEST_URI'])[1], $pid, $iid, 'page']; 
    $powered_by_link = 'https://' . $linkParts[0] . '/' . $linkParts[1] . '/content/';
  }

  $min = false;
?>
<!DOCTYPE html>
  <html lang="<?= Locales::getLocale(); ?>" itemscope itemtype="http://schema.org/Book">
  <head>
    <?php 
      include("Components/templates/head.php");
    ?>

    <script>
      window._config = {
        ROOT_PATH: '<?= APP::$rootPath ?>/',
        API_PUBLUU: '<?= APP::$rootApi ?>',
        CMS_PUBLUU_CF: '<?= APP::$cloudfrontCMS ?>',
        PATH_CF_FLIP: '<?= APP::$rootPathAWS ?>/',
        VIEWER_API: '<?= APP::$viewerApi ?>',
        LEADS_API: '<?= APP::$leadsApi ?>',
        LOGS_API: '<?= APP::$logsApi ?>',
        VERSION: '<?= APP::$v ?>'
      };
    </script>

    <?php if ($pid == 195653) : ?>
      <style>
        :root {
          --modal-bg-color: rgba(0, 0, 0, 0.5) !important;
        }
      </style>
    <?php endif; ?>
  </head>
  <body serverid="WWW1" servertime="<?= time(); ?>" class="noselect" oncontextmenu="return true;" style="<?= ($backgroundImageColor && !$transparent) ? "background: #".$backgroundImageColor : "none" ?>">
    <?php 
      if (!$customizemode && !$disablelogs) {
        include("Components/templates/googleTagsScripts.php");
      }
        
      include("Components/templates/passwordForm.php");
    ?>

    <div class="media-viewer" hidden>
      <div class="media-viewer__content-container">
        <div class="media-viewer__content">
          <div class="navigation-left" hidden></div>
          <div class="media-viewer__close modal__close"></div>
          <div class="navigation-right" hidden></div>
        </div>
      </div>
    </div>

    <div id="container">
      <div id="root" hidden>
        <header id="header"></header>
        <main id="main"></main>      
        <footer id="footer"></footer>
      </div>

      <sidebar id="sidebar"></sidebar>
      <sidebar id="sidebarTOC"></sidebar>
      <sidebar id="sidebarSearch"></sidebar>
      <sidebar id="sidebarWishlist"></sidebar>
    </div>

    <div class="fs-modal">
      <div class="wrapper">
        <svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
          <path d="M2.8 15.8L0 13v7h7l-2.8-2.8 4.34-4.32-1.42-1.42L2.8 15.8zM17.2 4.2L20 7V0h-7l2.8 2.8-4.34 4.32 1.42 1.42L17.2 4.2zm-1.4 13L13 20h7v-7l-2.8 2.8-4.32-4.34-1.42 1.42 4.33 4.33zM4.2 2.8L7 0H0v7l2.8-2.8 4.32 4.34 1.42-1.42L4.2 2.8z"/>
        </svg>
        <span><?= Locales::_t('Elements Description Fullscreen'); ?></span>
      </div>
    </div>
    
    <div class="spinner-modal">
      <div class="wrapper">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
          <circle cx="50" cy="50" fill="none" stroke="#3461c9" stroke-width="6" r="32" stroke-dasharray="150.79644737231007 52.26548245743669">
            <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform>
          </circle>
        </svg>
      </div>
    </div>

    <?php
      include("Components/templates/leadForm.php"); 
      include("Components/templates/audioForm.php");
      include("Components/templates/shareForm.php"); 
      include("Components/templates/printForm.php");
      include("Components/templates/alertForm.php");
      include("Components/templates/productForm.php");
      include("Components/templates/contentDescription.php");
      include("Components/templates/cookiePolicy.php");
    ?>

    <script type="text/javascript">
      window._translations = <?= json_encode(Locales::getTranslations()) ?>;
      window.disablelogs =  <?=$disablelogs?>;

      window.perftime = 0;
      window.perfcount = 0;
      window.productId = '<?= $productId ?>';

      const AudioContext = window.AudioContext || window.webkitAudioContext;
      const audioCtx = new AudioContext();

      let audioElements = document.querySelectorAll('.flip-audio');
      var audio = audioElements[0];

      var APPv = <?=APP::$v?>,
        APPm = <?=APP::$minimized?'true':'false'?>,
        bookId = <?=$iid?>,
        PreloadImages = true,
        publisherId = <?=$pid?>,
        disablelogs = <?=$disablelogs?>, 
        transparent = <?=$transparent?>,
        embedmode = <?=$embed?>,
        debugMode = <?= $debug ?>,
        bookModel = <?= json_encode($bookModel) ?>,
        loaderInfo = {
          'title': '<?= addslashes($obj->name) ?>',
          'backgroundColor': '<?= $backgroundImageColor ?>',
          'logo': '<?= $obj->settings->toplogo_image ?>',
          'isCanva': '<?= $obj->is_canva == 1 ? 1 : 0 ?>',
          'color': '<?= $loaderColor ?>'
        },
        coverMode = <?= $coverMode ?>,
        customizemode = <?=$customizemode?>,
        mobilepreview = <?=$mobilepreview?>,
        rtlChange = <?= $rtlchange ?>,
        rightToLeft = <?= $rightToLeft ?>,
        cmsAuth = <?=$cmsauth?>,
        isConverted = <?=$is_canva ? $obj->is_converted : 'true'?>,
        isCanva = <?=$is_canva?>,
        forceOnePage = false,
        pagesNum = <?=$pagesNum?>,
        embeduid = "",
        localErrorLogs = 1,
        customUrl = '<?= $custom_url ? 1 : 0 ?>';

      window.addEventListener('message', event => {
        if (event.origin.startsWith('https://cms1.publuu.com') || event.origin.startsWith('https://cms9.publuu.com') || event.origin.startsWith('https://cmsa.publuu.com')) { 
          if (typeof APP!='undefined') APP.handleFlipBookEditorResponse(event.data);
        } else {
          if (typeof event.data === 'string' || event.data instanceof String) {
            if (event.data.startsWith('puid:')) {
              HELPER.setLocalStorageData("uid",event.data.substring(5),365);
              embeduid = event.data.substring(5);
            }
          }

          return; 
        } 
      });

      function sleep (time) {
        return new Promise((resolve) => setTimeout(resolve, time));
      }

      var APPonReady = {
        _list: [],
        add: function(clb) {
          if (typeof clb=='function') APPonReady._list.push(clb);
          if (typeof APP!='undefined'&&APP.ready()) {
            for (var i = APPonReady._list.length - 1; i >= 0; i--) {
              APPonReady._list[i]();
            }

            APPonReady._list = [];
          }
        }
      };
    </script>

    <script crossorigin="anonymous" type="text/javascript" src="<?= APP::getPathToJsFile('APP')?>"></script>

    <script crossorigin="anonymous" src="<?= APP::getMainPath() ?>/assets/scripts/VideoEmbed.js?v=<?=APP::$v?>"></script>

    <?php if ($customizemode) : ?>
      <script crossorigin="anonymous" src="<?= APP::getMainPath() ?>/assets/scripts/page-flip-hard.browser.js?v=<?=APP::$v?>"></script>
      <script crossorigin="anonymous" src="<?= APP::getMainPath() ?>/assets/scripts/page-flip-rtl.browser-final.js?v=<?=APP::$v?>"></script>
    <?php elseif ($rightToLeft) : ?>
      <script crossorigin="anonymous" src="<?= APP::getMainPath() ?>/assets/scripts/page-flip-rtl.browser-final.js?v=<?=APP::$v?>"></script>
    <?php else : ?>
      <script crossorigin="anonymous" src="<?= APP::getMainPath() ?>/assets/scripts/page-flip-hard.browser.js?v=<?=APP::$v?>"></script>
    <?php endif; ?>

	  <script crossorigin="anonymous" type="text/javascript" async="async" defer="defer" src="<?= APP::getMainPath() ?>/assets/scripts/Layout<?=(APP::$minimized?'.min':'')?>.js?v=<?=APP::$v?>"></script>
    
    <script>
      APP.checkProtectedEmbed(<?= json_encode($protectedDomainSettings) ?>);
    </script>

    <script type="text/javascript">  
      window.document.addEventListener("visibilitychange", function(e) {
        if (!oLogs) {
          return;
        }

        if (window.document.visibilityState == "hidden") {
          if (oLogs.logs_state_visible === 3) {
            oLogs.logs_state_visible = 2;
          } else {
            oLogs.logs_state_visible = 1;
            oLogs.lastActionTime = Date.now();
          }
        } else {
          oLogs.sleepTime += Date.now() - oLogs.lastActionTime;
          oLogs.logs_state_visible = 3;
        }
      });

      document.addEventListener('touchmove', function (event) {
        if (event.scale !== 1) {
          event.preventDefault();
        }
      }, false);

      function showLoginSend() {
        window.parent.postMessage({
          'func': 'showLoginSend',
          'message': 'Message text from iframe.'
        }, "*");
      }    
    </script>   

    <noscript><a href="https://publuu.com"><?= Locales::_t('Powered By'); ?></a></noscript>
  </body>
</html>