!(function (t, e) {
  'object' == typeof exports && 'undefined' != typeof module
    ? e(exports)
    : 'function' == typeof define && define.amd
    ? define(['exports'], e)
    : e(((t = t || self).St = {}));
})(this, function (t) {
  'use strict';
  class e {
    constructor(t, e) {
      (this.state = {
        angle: 0,
        area: [],
        position: { x: 0, y: 0 },
        hardAngle: 0,
        hardDrawingAngle: 0,
        bottomPage: false,
      }),
        (this.odblaskDiv = null),
        (this.odblaskDiv2 = null),
        (this.createdDensity = e),
        (this.nowDrawingDensity = this.createdDensity),
        (this.render = t);
    }
    setDensity(t) {
      (this.createdDensity = t), (this.nowDrawingDensity = t);
    }
    setDrawingDensity(t) {
      this.nowDrawingDensity = t;
    }
    setPosition(t, from) {
      this.state.position = t;
    }
    setAngle(t) {
      this.state.angle = t;
    }
    setFlipAngle(t) {
      this.state.flipangle = t;
    }
    setOdblask() {
      if (forceOnePage) {
        this.odblaskDiv = document.querySelector('#marcincrop2 .odblask');
      } else {
        this.odblaskDiv = this.element.querySelector('.odblask');
      }
    }
    setArea(t) {
      this.state.area = t;
    }
    setHardDrawingAngle(t) {
      this.state.hardDrawingAngle = t;
    }
    setHardAngle(t) {
      (this.state.hardAngle = t), (this.state.hardDrawingAngle = t);
    }
    setOrientation(t) {
      this.orientation = t;
    }
    getDrawingDensity() {
      return this.nowDrawingDensity;
    }
    getDensity() {
      return this.createdDensity;
    }
    getHardAngle() {
      return this.state.hardAngle;
    }
  }
  class i extends e {
    constructor(t, e, i) {
      super(t, i),
        (this.image = null),
        (this.isLoad = !1),
        (this.loadingAngle = 0),
        (this.image = new Image()),
        (this.image.src = e);
    }
    draw(t) {
      const e = this.render.getContext(),
        i = this.render.convertToGlobal(this.state.position),
        s = this.render.getRect().pageWidth,
        n = this.render.getRect().height;
      e.save(), e.translate(i.x, i.y), e.beginPath();
      for (let t of this.state.area)
        null !== t && ((t = this.render.convertToGlobal(t)), e.lineTo(t.x - i.x, t.y - i.y));
      e.rotate(this.state.angle),
        e.clip(),
        this.isLoad
          ? e.drawImage(this.image, 0, 0, s, n)
          : this.drawLoader(e, { x: 0, y: 0 }, s, n),
        e.restore();
    }
    simpleDraw(t) {
      const e = this.render.getRect(),
        i = this.render.getContext(),
        s = e.pageWidth,
        n = e.height,
        h = 1 === t ? e.left + e.pageWidth : e.left,
        o = e.top;
      this.isLoad ? i.drawImage(this.image, h, o, s, n) : this.drawLoader(i, { x: h, y: o }, s, n);
    }
    drawLoader(t, e, i, s) {
      t.beginPath(),
        (t.strokeStyle = 'rgb(200, 200, 200)'),
        (t.fillStyle = 'rgb(255, 255, 255)'),
        (t.lineWidth = 1),
        t.rect(e.x + 1, e.y + 1, i - 1, s - 1),
        t.stroke(),
        t.fill();
      const n = { x: e.x + i / 2, y: e.y + s / 2 };
      t.beginPath(),
        (t.lineWidth = 10),
        t.arc(n.x, n.y, 20, this.loadingAngle, (3 * Math.PI) / 2 + this.loadingAngle),
        t.stroke(),
        t.closePath(),
        (this.loadingAngle += 0.07),
        this.loadingAngle >= 2 * Math.PI && (this.loadingAngle = 0);
    }
    load() {
      this.isLoad ||
        (this.image.onload = () => {
          this.isLoad = !0;
        });
    }
    newTemporaryCopy() {
      return this;
    }
    getTemporaryCopy() {
      return this;
    }
    hideTemporaryCopy() {}
  }
  class s {
    constructor(t, e) {
      (this.pages = []),
        (this.currentPageIndex = 0),
        (this.currentSpreadIndex = 0),
        (this.prevSpreadIndex = null),
        (this.landscapeSpread = []),
        (this.portraitSpread = []),
        (this.render = e),
        (this.app = t),
        (this.currentPageIndex = 0),
        (this.isShowCover = this.app.getSettings().showCover);
    }
    destroy() {
      this.pages = [];
    }
    createSpread() {
      (this.landscapeSpread = []), (this.portraitSpread = []);
      for (let t = 0; t < this.pages.length; t++) this.portraitSpread.push([t]);
      let t = 0;
      this.isShowCover && (this.pages[0].setDensity('soft'), this.landscapeSpread.push([t]), t++);
      for (let e = t; e < this.pages.length; e += 2)
        e < this.pages.length - 1
          ? this.landscapeSpread.push([e, e + 1])
          : (this.landscapeSpread.push([e]), this.pages[e].setDensity('soft'));
    }
    getSpread() {
      return 'landscape' === this.render.getOrientation()
        ? this.landscapeSpread
        : this.portraitSpread;
    }
    getSpreadIndexByPage(t) {
      const e = this.getSpread();
      for (let i = 0; i < e.length; i++) if (t === e[i][0] || t === e[i][1]) return i;
      return null;
    }
    getPageCount() {
      return this.pages.length;
    }
    getPages() {
      return this.pages;
    }
    getPage(t) {
      if (t >= 0 && t < this.pages.length) return this.pages[t];
      throw new Error('Invalid page number');
    }
    nextBy(t) {
      const e = this.pages.indexOf(t);
      return e < this.pages.length - 1 ? this.pages[e + 1] : null;
    }
    prevBy(t) {
      const e = this.pages.indexOf(t);
      return e > 0 ? this.pages[e - 1] : null;
    }
    getFlippingPage(t) {
      const e = this.currentSpreadIndex;
      if ('portrait' === this.render.getOrientation())
        return 0 === t ? this.pages[e].newTemporaryCopy() : this.pages[e - 1];
      {
        const i = 0 === t ? this.getSpread()[e + 1] : this.getSpread()[e - 1];
        return 1 === i.length || 0 === t ? this.pages[i[0]] : this.pages[i[1]];
      }
    }
    getBottomPage(t) {
      const e = this.currentSpreadIndex;
      if ('portrait' === this.render.getOrientation())
        return 0 === t ? this.pages[e + 1] : this.pages[e - 1];
      {
        const i = 0 === t ? this.getSpread()[e + 1] : this.getSpread()[e - 1];
        return 1 === i.length ? this.pages[i[0]] : 0 === t ? this.pages[i[1]] : this.pages[i[0]];
      }
    }
    getPageByNum(t, spread) {
      if ('landscape' === this.render.getOrientation()) {
        const i = this.getSpread()[spread];
        return 1 === i.length ? this.pages[i[0]] : 0 === t ? this.pages[i[1]] : this.pages[i[0]];
      }
    }
    showNext() {
      this.currentSpreadIndex < this.getSpread().length &&
        ((this.prevSpreadIndex = this.currentSpreadIndex),
        this.currentSpreadIndex++,
        this.showSpread());
    }
    showPrev() {
      this.currentSpreadIndex > 0 &&
        ((this.prevSpreadIndex = this.currentSpreadIndex),
        this.currentSpreadIndex--,
        this.showSpread());
    }
    getCurrentPageIndex() {
      return this.currentPageIndex;
    }
    show(t = null) {
      if ((null === t && (t = this.currentPageIndex), t < 0 || t >= this.pages.length)) return;
      const e = this.getSpreadIndexByPage(t);

      if (null !== e) {
        this.prevSpreadIndex = e; //this.currentPageIndex;//e;//this.currentPageIndex;//ta zmiana bo ianczje wesjcie na przedostatnia strone nie pozwalalo zmienic na ostatnia

        this.currentSpreadIndex = e;
        this.showSpread();
      }
    }
    getCurrentSpreadIndex() {
      return this.currentSpreadIndex;
    }
    getPrevSpreadIndex() {
      return this.prevSpreadIndex;
    }
    setCurrentSpreadIndex(t) {
      if (!(t >= 0 && t < this.getSpread().length)) throw new Error('Invalid page');
      this.prevSpreadIndex = this.currentSpreadIndex;
      this.currentSpreadIndex = t;
    }
    setPrevSpreadIndex(t) {
      if (!(t >= 0 && t < this.getSpread().length)) throw new Error('Invalid page');
      this.prevSpreadIndex = t;
    }
    showSpreadLandscapeAndLastMarcin() {}
    showSpread() {
      const t = this.getSpread()[this.currentSpreadIndex];

      //tutaj trzeba wcisnac warunek ze jak page 1 tylko to right
      if (this.pages.length === 1) {
        this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]]);
      } else {
        2 === t.length
          ? (this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(this.pages[t[1]]))
          : 'landscape' === this.render.getOrientation() && t[0] === this.pages.length - 1
          ? (this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(null))
          : (this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]])),
          (this.currentPageIndex = t[0]),
          this.app.updatePageIndex(this.currentPageIndex);
      }
    }
  }

  class n extends s {
    constructor(t, e, i) {
      super(t, e), (this.imagesHref = i);
    }
    load() {
      for (const t of this.imagesHref) {
        const e = new i(this.render, t, 'soft');
        e.load(), this.pages.push(e);
      }
      this.createSpread();
    }
  }
  class h {
    static GetDistanceBetweenTwoPoint(t, e) {
      return null === t || null === e
        ? 1 / 0
        : Math.sqrt(Math.pow(e.x - t.x, 2) + Math.pow(e.y - t.y, 2));
    }
    static GetSegmentLength(t) {
      return h.GetDistanceBetweenTwoPoint(t[0], t[1]);
    }
    static GetAngleBetweenTwoLine(t, e) {
      const i = t[0].y - t[1].y,
        s = e[0].y - e[1].y,
        n = t[1].x - t[0].x,
        h = e[1].x - e[0].x;
      return Math.acos((i * s + n * h) / (Math.sqrt(i * i + n * n) * Math.sqrt(s * s + h * h)));
    }
    static PointInRect(t, e) {
      return null === e
        ? null
        : e.x >= t.left && e.x <= t.width + t.left && e.y >= t.top && e.y <= t.top + t.height
        ? e
        : null;
    }
    static GetRotatedPoint(t, e, i) {
      return {
        x: t.x * Math.cos(i) + t.y * Math.sin(i) + e.x,
        y: t.y * Math.cos(i) - t.x * Math.sin(i) + e.y,
      };
    }
    static LimitPointToCircle(t, e, i) {
      if (h.GetDistanceBetweenTwoPoint(t, i) <= e) return i;
      const s = t.x,
        n = t.y,
        o = i.x,
        a = i.y;
      let r =
        Math.sqrt(
          (Math.pow(e, 2) * Math.pow(s - o, 2)) / (Math.pow(s - o, 2) + Math.pow(n - a, 2)),
        ) + s;
      i.x < 0 && (r *= -1);
      let g = ((r - s) * (n - a)) / (s - o) + n;
      return s - o + n === 0 && (g = e), { x: r, y: g };
    }
    static GetIntersectBetweenTwoSegment(t, e, i) {
      return h.PointInRect(t, h.GetIntersectBeetwenTwoLine(e, i));
    }
    static GetIntersectBeetwenTwoLine(t, e) {
      const i = t[0].y - t[1].y,
        s = e[0].y - e[1].y,
        n = t[1].x - t[0].x,
        h = e[1].x - e[0].x,
        o = t[0].x * t[1].y - t[1].x * t[0].y,
        a = e[0].x * e[1].y - e[1].x * e[0].y,
        r = i * a - s * o,
        g = n * a - h * o,
        l = -(o * h - a * n) / (i * h - s * n),
        d = -(i * a - s * o) / (i * h - s * n);
      if (isFinite(l) && isFinite(d)) return { x: l, y: d };
      if (Math.abs(r - g) < 0.1) throw new Error('Segment included');
      return null;
    }
    static GetCordsFromTwoPoint(t, e) {
      if (forceOnePage) {
        const roznicaX = Math.abs(t.x - e.x);
        var roznicaY = Math.abs(t.y - e.y);
        const n = Math.max(roznicaX, roznicaY);
        const h = [];
        function o(t, e, i, s, n) {
          return e > t ? t + n * (i / s) : e < t ? t - n * (i / s) : t;
        }

        let fullanim = false;
        if (roznicaY <= 1) {
          fullanim = true;
          roznicaY = t.y / -10;
        }
        const roznicaYC = roznicaY;

        for (let a = 1; a <= n; ) {
          if (a >= n / 2 && fullanim) {
            var mult = n / a - 1;
            roznicaY = roznicaYC * mult;
          }
          let y = o(t.y, e.y, roznicaY, n, a);
          h.push({ x: o(t.x, e.x, roznicaX, n, a), y: y }); //-0.25*o
          a += 0.5;
        }

        h.push(e);
        return h;
      } else {
        return this.GetCordsFromTwoPointOld(t, e);
      }
    }

    static GetCordsFromTwoPointOld(t, e) {
      const i = Math.abs(t.x - e.x),
        s = Math.abs(t.y - e.y),
        n = Math.max(i, s),
        h = [t];
      function o(t, e, i, s, n) {
        return e > t ? t + n * (i / s) : e < t ? t - n * (i / s) : t;
      }

      for (let a = 1; a <= n; a += 1) {
        h.push({ x: o(t.x, e.x, i, n, a), y: o(t.y, e.y, s, n, a) });
      }

      return h;
    }
  }

  class o extends e {
    constructor(t, e, i) {
      super(t, i),
        (this.copiedElement = null),
        (this.temporaryCopy = null),
        (this.isLoad = !1),
        (this.element = e),
        this.element.classList.add('stf__item'),
        this.element.classList.add('--' + i);
    }
    newTemporaryCopy() {
      return 'hard' === this.nowDrawingDensity
        ? this
        : (null === this.temporaryCopy &&
            ((this.copiedElement = this.element.cloneNode(!0)),
            this.element.parentElement.appendChild(this.copiedElement),
            (this.temporaryCopy = new o(this.render, this.copiedElement, this.nowDrawingDensity))),
          this.getTemporaryCopy());
    }
    getTemporaryCopy() {
      return this.temporaryCopy;
    }
    hideTemporaryCopy() {
      null !== this.temporaryCopy &&
        (this.copiedElement.remove(), (this.copiedElement = null), (this.temporaryCopy = null));
    }
    draw(t, warstwa) {
      const e = t || this.nowDrawingDensity,
        i = this.render.convertToGlobal(this.state.position),
        s = this.render.getRect().pageWidth,
        n = this.render.getRect().height;
      this.element.classList.remove('--simple');
      let left = e === 'clipping' && this.render.getDirection() === 0 ? `${s}px` : '0px';
      const h = `
        display: block;
        z-index: ${this.element.style.zIndex};
        left: ${left};
        top: 0px;
        width: ${s}px;
        height: ${n}px;
      `; //w trakcie

      if ('soft' === e) this.drawSoft(i, h, warstwa);
      if ('clipping' === e) this.clippingDraw(h);
    }

    drawSoftCrop_4punkty(op) {
      //CROP DIV - OK

      let pageWidth = this.render.getRect().pageWidth;
      let pageHeight = this.render.getRect().height;
      let przekatna = Math.ceil(Math.sqrt(pageHeight * pageHeight + pageWidth * pageWidth));
      let przesuniecie_pion = pageHeight;
      let trans_x = przekatna - this.state.area[1].x;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      document.getElementById('marcincrop2').style.cssText = `width: ${przekatna}px;height: ${
        2 * przesuniecie_pion + pageHeight
      }px;
            top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x}px, 0px, 0) rotate(${
        this.state.flipangle
      }rad);opacity: 1.0;`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let ab = pageWidth - this.state.area[1].x;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);

      if (this.state.area[0].x > this.state.area[3].x) {
        //dolny prowadzi
        bb = bb * -1;
      }

      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma'); //lewa pozioma
      marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
      marcin_leftPage_insidecrop2.style.transform = `translate3d(${cc}px, ${bb}px, 0) rotate(-${this.state.flipangle}rad)`;
      marcin_leftPage_insidecrop2.style.opacity = op;

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
      marcin_zagiecie.style.height = `${pageHeight}px`;
      marcin_zagiecie.style.width = `${pageWidth}px`;
      marcin_zagiecie.style.transformOrigin = `0% 0%`;
      marcin_zagiecie.style.willChange = `transform`;
      marcin_zagiecie.style.transform = `translate3d(${przekatna - cc}px, ${bb}px, 0) rotate(${
        this.state.flipangle
      }rad)`;
      marcin_zagiecie.style.opacity = op;

      //odblask
      let ciegnoprowadzace = h.GetDistanceBetweenTwoPoint(this.state.area[0], this.state.area[1]);
      let ciegnoawaryjne = 0;
      if (this.state.area[0].x > this.state.area[3].x) {
        //dolny prowadzi
        ciegnoawaryjne = ciegnoprowadzace;
        ciegnoprowadzace = h.GetDistanceBetweenTwoPoint(this.state.area[3], this.state.area[2]);
        let extrah = this.render.getRect().height;
        if (this.odblaskDiv) {
          this.odblaskDiv.classList.add('fliped');

          let odblaskw = ciegnoprowadzace;
          let bbb = odblaskw / Math.cos(this.state.flipangle);

          this.odblaskDiv.style.cssText = `
                 transform-origin: ${0}px ${this.render.getRect().height}px;
                left: 0px; display: block; 
                height: ${przekatna + extrah}px;width: ${odblaskw}px;background-size: ${odblaskw}px;
                transform: translate3d(${0}px, -${0}px, 0) rotate(${-this.state
            .flipangle}rad); z-index: 10;`;
        }
      } else {
        let extrah = this.render.getRect().height;
        if (this.odblaskDiv) {
          this.odblaskDiv.classList.add('fliped');

          let odblaskw = ciegnoprowadzace;
          let bbb = odblaskw / Math.cos(this.state.flipangle);

          this.odblaskDiv.style.cssText = `
                 transform-origin: 0px ${extrah}px;
                left: 0px; display: block; 
                height: ${przekatna + extrah}px;width: ${odblaskw}px;background-size: ${odblaskw}px;
                transform: translate3d(${odblaskw - bbb}px, -${extrah}px, 0) rotate(${-this.state
            .flipangle}rad); z-index: 10;`;
        }
      }
    }

    drawSoftCrop_3punkty_top(op) {
      let pageWidth = this.render.getRect().pageWidth;
      let pageHeight = this.render.getRect().height;
      let przekatna = Math.ceil(Math.sqrt(pageHeight * pageHeight + pageWidth * pageWidth));
      let przesuniecie_pion = 2 * pageHeight;
      let fb_maskh = 2 * przesuniecie_pion + pageHeight;
      let trans_x = przekatna - pageWidth;
      let trans_y = this.state.area[2].y;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      let marcin_crop2 = document.getElementById('marcincrop2');
      marcin_crop2.style.cssText = `width: ${przekatna}px;height: ${fb_maskh}px; 
            top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x}px, ${trans_y}px, 0) rotate(${
        this.state.flipangle
      }rad);`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma');
      let ab = trans_y;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);
      marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
      marcin_leftPage_insidecrop2.style.transform = `translate3d(${bb}px, -${cc}px, 0) rotate(-${this.state.flipangle}rad)`;

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      let _ab = pageHeight - trans_y;
      let _cc = Math.abs(Math.cos(this.state.flipangle) * _ab);
      let _bb = Math.abs(Math.sin(this.state.flipangle) * _ab);

      marcin_zagiecie.style.transform = `translate3d(${przekatna + _bb}px, -${
        pageHeight - _cc
      }px, 0) rotate(${this.state.flipangle}rad)`;
      marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
      marcin_zagiecie.style.transformOrigin = `0% 100%`;
      marcin_zagiecie.style.willChange = `transform`;

      let extrah = this.render.getRect().height;
      if (this.odblaskDiv) {
        this.odblaskDiv.classList.add('fliped');
        this.odblaskDiv.style.cssText = `
             transform-origin: 0px ${extrah}px;
            left: 0px; display: block;  
            height: ${przekatna + extrah}px;width: ${bb}px;background-size: ${bb}px;
            transform: translate3d(${0}px, -${extrah}px, 0) rotate(${-this.state
          .flipangle}rad); z-index: 10;`;
      }
    }

    drawSoftCrop_3punkty_bottom(op) {
      let przekatna = Math.ceil(
        Math.sqrt(
          this.render.getRect().height * this.render.getRect().height +
            this.render.getRect().pageWidth * this.render.getRect().pageWidth,
        ),
      );
      let przesuniecie_pion = this.render.getRect().height;
      let fb_maskh = 2 * przesuniecie_pion + this.render.getRect().height;
      let trans_x = przekatna - this.render.getRect().pageWidth;
      let trans_y = this.state.area[2].y;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      let marcin_crop2 = document.getElementById('marcincrop2');
      marcin_crop2.style.cssText = `width: ${przekatna}px;height: ${fb_maskh}px;top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x}px, ${trans_y}px, 0) rotate(${
        this.state.flipangle
      }rad);`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma');
      let ab = trans_y;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);
      marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
      marcin_leftPage_insidecrop2.style.transform = `translate3d(-${bb}px, -${cc}px, 0) rotate(-${this.state.flipangle}rad)`;

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      let _ab = this.render.getRect().height - trans_y;
      let _cc = Math.abs(Math.cos(this.state.flipangle) * _ab);
      let _bb = Math.abs(Math.sin(this.state.flipangle) * _ab);

      marcin_zagiecie.style.transform = `translate3d(${przekatna - _bb}px, -${
        this.render.getRect().height - _cc
      }px, 0) rotate(${this.state.flipangle}rad)`;
      marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
      marcin_zagiecie.style.transformOrigin = `0% 100%`;
      marcin_zagiecie.style.willChange = `transform`;

      //odblask
      let extrah = this.render.getRect().height;
      if (this.odblaskDiv) {
        this.odblaskDiv.classList.add('fliped');
        this.odblaskDiv.style.cssText = `
             transform-origin: 0px ${this.render.getRect().height}px;
            left: 0px; display: block;  
            height: ${przekatna + extrah}px;width: ${_bb}px;background-size: ${_bb}px;
            transform: translate3d(${0}px, ${0}px, 0) rotate(${-this.state
          .flipangle}rad); z-index: 10;`;
      }
      //
    }

    drawSoftCrop() {
      this.setFlipAngle(this.render.shadow.angle + 4.71238898);
      let op =
        this.render.shadow.progress > 175 ? `${(200 - this.render.shadow.progress) / 25}` : 1.0;

      if (this.state.area[1] !== null && this.state.area[3] !== null) {
        //4 punkty prawy dolny rog
        this.drawSoftCrop_4punkty(op);
      } else if (
        this.state.area[2] !== null &&
        this.state.area[3] !== null &&
        this.state.area[4] !== null
      ) {
        //3 punkty prawy dolny rog
        this.drawSoftCrop_3punkty_bottom(op);
      } else {
        this.drawSoftCrop_3punkty_top(op);
      }
    }

    drawSoft_warstwaFlip_clipPathOld(i, op, e, t) {
      this.element.style.cssText =
        e +
        `transform-origin: 0 0; clip-path: ${i};-webkit-clip-path: ${i};${op};` +
        (this.render.isSafari() && 0 === this.state.angle
          ? `transform: translate(${t.x}px, ${t.y}px);`
          : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
    }

    drawSoft_mobile_new(t, e = '', warstwa = '?', portrait = true) {
      var op = 'opacity: 1.0';
      var clip = ``;

      if (warstwa === 'fp') {
        //to tylko przy 1 klatce i tylko forconepage  albo portrait
        if (
          this.element.children &&
          !this.element.getAttribute('extraLayer') &&
          (forceOnePage || portrait)
        ) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());

          if (this.render.getDirection() === 0) {
            document.getElementById('marcincrop2').hidden = false;
            pageNum = pageNum + 1;
            let _this = this;
            APP.Book.getPage(pageNum, function (PageObj) {
              _this.element.setAttribute('extraLayer', 'yes');
              extraLayer.style.cssText = `background-image:url(${PageObj.getCover('p533')});`;
              extraLayer.classList.add('blured1');
              _this.element.appendChild(extraLayer);
              _this.element.appendChild(odblaskExtra);
              _this.element.id = 'marcin_corner';
              document.getElementById('marcincrop2').innerHTML = '';
              document.getElementById('marcincrop2').appendChild(_this.element);
              //
              let cloneBottom = _this.render.flippingPage.element.cloneNode();
              cloneBottom.id = 'cloneBottom';
              cloneBottom.classList.add('back');
              cloneBottom.classList.add('--left');
              cloneBottom.id = 'lewapozioma';
              cloneBottom.style.zIndex = '3';
              cloneBottom.style.left = 'unset';
              cloneBottom.style.bottom = 'unset';

              if (PageObj.getPage()) {
                cloneBottom.style.backgroundImage = PageObj.getPage().raster.style.backgroundImage;
              }
              document.getElementById('marcincrop2').appendChild(cloneBottom);
              cloneBottom.appendChild(_this.render.underShadow);
              //
            });
          }
        }
        //
        //
        if (this.render.getDirection() === 1) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;
          let i = `polygon(${this.render.getRect().pageWidth - x1}px 0, 100% 0%, 100% 100%, ${
            this.render.getRect().pageWidth - x2
          }px 100%)`; //lewa strona
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej

          let opval = (1.0 - (x1 + x2) / 2 / this.render.getRect().pageWidth) * 2;
          op = `opacity: ${opval}`;
          extraLeftFliped.style.cssText = extraLeftFliped.style.cssText + clip + op;
        } else {
          this.drawSoftCrop();
        }
      }

      if (warstwa !== 'fp') {
        if (this.render.getDirection() === 0 && forceOnePage && !is_mobile()) {
          this.element.style.cssText = e + `${op}`;
        } else {
          this.element.style.cssText =
            e +
            `transform-origin: 0 0; ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
            (this.render.isSafari() && 0 === this.state.angle
              ? `transform: translate(${t.x}px, ${t.y}px);`
              : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
        }
      } else {
        if (this.render.getDirection() === 0 && (forceOnePage || portrait)) {
        } else {
          this.drawSoft_warstwaFlip_clipPathOld(i, op, e, t);
        }
      }
    }

    drawSoft_mobile(t, e = '', warstwa = '?') {
      var op = 'opacity: 1.0';
      var clip = ``;

      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa === 'fp') {
        if (this.element.children && !this.element.getAttribute('extraLayer')) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());
          if (this.render.getDirection() === 0) {
            pageNum = pageNum + 1;
            let _this = this;
            if (!mobile_test_horizontal() || forceOnePage) {
              APP.Book.getPage(pageNum, function (PageObj) {
                extraLayer.style.cssText = `background-image:url(${PageObj.getCover('p533')});`;
                _this.element.appendChild(extraLayer);
                _this.element.appendChild(odblaskExtra);
                _this.element.setAttribute('extraLayer', 'yes');
              });
            }
          }
        }

        if (this.render.getDirection() === 1) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;
          let i = `polygon(${this.render.getRect().pageWidth - x1}px 0, 100% 0%, 100% 100%, ${
            this.render.getRect().pageWidth - x2
          }px 100%)`; //lewa strona
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej

          let opval = (1.0 - (x1 + x2) / 2 / this.render.getRect().pageWidth) * 2;
          //op = `opacity: ${opval}`;
          extraLeftFliped.style.cssText = extraLeftFliped.style.cssText + clip + op;
        }

        this.drawSoft_warstwaFlip_clipPathOld(i, op, e, t);
      } else {
        this.element.style.cssText =
          e +
          `transform-origin: 0 0; ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
          (this.render.isSafari() && 0 === this.state.angle
            ? `transform: translate(${t.x}px, ${t.y}px);`
            : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
      }
    }

    drawSoft_desktop_onepage(t, e, warstwa) {
      //        if( forceOnePage && direction === 1 ){
      var op = 'opacity: 1.0';

      if (warstwa === 'fp') {
        //to tylko przy 1 klatce i tylko forconepage mobiel albo horizontal

        if (
          this.element.children &&
          !this.element.getAttribute('extraLayer') &&
          (forceOnePage || !(is_mobile() && is_horisontalOld()))
        ) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());

          if (this.render.getDirection() === 0) {
            document.getElementById('marcincrop2').hidden = false;
            pageNum = pageNum + 1;

            let _this = this;
            APP.Book.getPage(pageNum, function (PageObj) {
              _this.element.setAttribute('extraLayer', 'yes');
              extraLayer.style.cssText = `background-image:url(${PageObj.getCover('p533')});`;

              extraLayer.classList.add('blured1');
              _this.element.appendChild(extraLayer);
              _this.element.appendChild(odblaskExtra);
              _this.element.id = 'marcin_corner';
              document.getElementById('marcincrop2').innerHTML = '';
              document.getElementById('marcincrop2').appendChild(_this.element);

              let cloneBottom = _this.render.flippingPage.element.cloneNode();
              cloneBottom.id = 'cloneBottom';
              cloneBottom.classList.add('back');
              cloneBottom.classList.add('--left');
              cloneBottom.id = 'lewapozioma';
              cloneBottom.style.zIndex = '3';
              cloneBottom.style.left = 'unset';
              cloneBottom.style.bottom = 'unset';

              //if there are any hotspots on right page append them to cloneBottom
              var hotspotslayer =
                _this.render.rightPage.element.getElementsByClassName('hotspots-container');
              if (hotspotslayer.length > 0) {
                let clonedHotspotsDiv = hotspotslayer[0].cloneNode(true);
                clonedHotspotsDiv.innerHTML = hotspotslayer[0].innerHTML;
                cloneBottom.appendChild(clonedHotspotsDiv);

                if (clonedHotspotsDiv.childNodes.length) {
                  clonedHotspotsDiv.childNodes.forEach((node) => {
                    if (node.dataset && node.dataset.type == 'video') {
                      if(!!node.querySelector('iframe')){
                        node.querySelector('iframe').src = '';
                      }
                    }
                  });
                }
              }

              if (PageObj.getPage()) {
                cloneBottom.style.backgroundImage = PageObj.getPage().raster.style.backgroundImage;
              }
              document.getElementById('marcincrop2').appendChild(cloneBottom);
              cloneBottom.appendChild(_this.render.underShadow);
              _this.element.style.display = 'block';
            });
          }
        }

        if (this.render.getDirection() === 1) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;
          let i = `polygon(${this.render.getRect().pageWidth - x1}px 0, 100% 0%, 100% 100%, ${
            this.render.getRect().pageWidth - x2
          }px 100%)`; //lewa strona
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej
          let avg_ciegno =
            (this.render.getRect().pageWidth - x1 + (this.render.getRect().pageWidth - x2)) / 2;
          let progress = this.render.getRect().pageWidth / ((x1 + x2) / 2);

          // let opval = (1.0-((x1 + x2)/2)/this.render.getRect().pageWidth);
          op = `opacity: ${(avg_ciegno / this.render.getRect().pageWidth) * 1.4}`;
          extraLeftFliped.style.cssText = extraLeftFliped.style.cssText + clip + op;
        } else {
          this.drawSoftCrop();
        }
      }

      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa !== 'fp') {
        if (this.render.getDirection() === 0 && forceOnePage && !is_mobile()) {
          this.element.style.cssText = e + `${op}`;
        } else {
          this.element.style.cssText =
            e +
            `transform-origin: 0 0; ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
            (this.render.isSafari() && 0 === this.state.angle
              ? `transform: translate(${t.x}px, ${t.y}px);`
              : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
        }
      } else {
        if (this.render.getDirection() === 0 && forceOnePage) {
        } else {
          this.drawSoft_warstwaFlip_clipPathOld(i, op, e, t);
        }
      }
    }

    drawSoft_desktop_old(t, e, warstwa) {
      var op = 'opacity: 1.0';
      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa === 'fp') {
        if (
          this.element.children &&
          this.odblaskDiv &&
          !this.odblaskDiv.getAttribute('extraLayer')
        ) {
          this.odblaskDiv.setAttribute('extraLayer', 'yes');
        }
      }

      var clip = `clip-path: ${i};-webkit-clip-path: ${i};${op};`;

      this.element.style.cssText =
        e +
        `transform-origin: 0 0; ${clip}` +
        (this.render.isSafari() && 0 === this.state.angle
          ? `transform: translate(${t.x}px, ${t.y}px);`
          : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);
           `);
    }

    drawSoft(t, e = '', warstwa = '?') {
      if (is_mobile()) {
        if (window.innerWidth <= window.innerHeight) {
          this.drawSoft_mobile_new(t, e, warstwa, window.innerWidth <= window.innerHeight);
        } else {
          //poziom mobile

          if (forceOnePage) {
            this.drawSoft_mobile_new(t, e, warstwa, window.innerWidth <= window.innerHeight);
          } else {
            this.drawSoft_mobile(t, e, warstwa);
          }
        }
      } else {
        if (forceOnePage) {
          this.drawSoft_desktop_onepage(t, e, warstwa);
        } else {
          this.drawSoft_desktop_old(t, e, warstwa);
        }
      }
    } //end drawSoft

    simpleDraw(t) {
      //w kazdej klatce
      const e = this.render.getRect(),
        i = e.pageWidth,
        s = e.height,
        n = 1 === t ? e.left + e.pageWidth : e.left,
        h = e.top;
      //tu jest bald 1 strony n = 0 zamaist 332

      this.element.classList.add('--simple');
      this.element.style.cssText = `position: absolute; display: block; height: ${s}px; \n            left: ${n}px; \n            top: ${h}px; \n            width: ${i}px; \n            z-index: ${
        this.render.getSettings().startZIndex + 1
      };`;

      if (is_mobile()) {
        document.getElementById(
          'stf__marcinBookShadow',
        ).style.cssText = `height: ${s}px; left: ${n}px; top: ${h}px; width: ${i}px;`;
      }
    }

    clippingDraw(t) {
      let i = 'polygon( ';
      for (const l of this.state.area)
        if (null !== l) {
          i += l.x + 'px ' + l.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      const style = `${t} ${e} transform-origin: 0 0; clip-path: ${i}; -webkit-clip-path: ${i}`;
      this.element.style.cssText = style;
    }

    getElement() {
      return this.element;
    }
    load() {
      this.isLoad = !0;
    }
    setOrientation(t) {
      super.setOrientation(t);
    }
    setDrawingDensity(t) {
      this.element.classList.remove('--soft', '--hard'),
        this.element.classList.add('--' + t),
        super.setDrawingDensity(t);
    }
  }
  class a extends s {
    constructor(t, e, i, s) {
      super(t, e), (this.element = i), (this.pagesElement = s);
    }
    load() {
      for (const t of this.pagesElement) {
        const e = new o(this.render, t, 'hard' === t.dataset.density ? 'hard' : 'soft');

        e.load(), this.pages.push(e);
      }

      this.pages[this.pages.length - 1].element.classList.add('last');

      this.createSpread();
    }
  }
  class r {
    constructor(t, e, i, s) {
      (this.direction = t),
        (this.corner = e),
        (this.topIntersectPoint = null),
        (this.sideIntersectPoint = null),
        (this.bottomIntersectPoint = null),
        (this.pageWidth = parseFloat(i, 10)),
        (this.pageHeight = parseFloat(s, 10));
    }
    calc(t) {
      try {
        return (
          (this.position = this.calcAngleAndPosition(t)),
          this.calculateIntersectPoint(this.position),
          !0
        );
      } catch (t) {
        return !1;
      }
    }
    getFlippingClipArea() {
      const t = [];
      let e = !1;
      return (
        t.push(this.rect.topLeft),
        t.push(this.topIntersectPoint),
        null === this.sideIntersectPoint
          ? (e = !0)
          : (t.push(this.sideIntersectPoint), null === this.bottomIntersectPoint && (e = !1)),
        t.push(this.bottomIntersectPoint),
        (e || 'bottom' === this.corner) && t.push(this.rect.bottomLeft),
        t
      );
    }
    getFirstFlippingClipArea() {
      const t = [];
      if ('top' === this.corner) {
        t.push({ x: this.pageWidth - this.topIntersectPoint.x + 1, y: this.topIntersectPoint.y });
        t.push({ x: this.pageWidth + 1, y: 0 });
        t.push({ x: this.pageWidth + 1, y: this.pageHeight });
        if (null !== this.sideIntersectPoint) {
          if (h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10) {
            t.push({ x: 0, y: this.pageHeight });
            t.push({
              x: this.pageWidth - this.sideIntersectPoint.x + 1,
              y: this.sideIntersectPoint.y,
            });
          }
        } else {
          t.push({
            x: this.pageWidth - this.bottomIntersectPoint.x + 1,
            y: this.bottomIntersectPoint.y,
          });
        }
      }

      if ('bottom' === this.corner) {
        t.push({ x: this.pageWidth + 1, y: 0 });
        t.push({ x: this.pageWidth + 1, y: this.pageHeight });
        t.push({
          x: this.pageWidth - this.bottomIntersectPoint.x + 1,
          y: this.bottomIntersectPoint.y,
        });
        if (null !== this.sideIntersectPoint) {
          if (
            h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.bottomIntersectPoint) >= 10
          ) {
            t.push({
              x: this.pageWidth - this.sideIntersectPoint.x + 1,
              y: this.sideIntersectPoint.y,
            });
            t.push({ x: 0, y: 0 });
          }
        } else {
          t.push({ x: this.pageWidth - this.topIntersectPoint.x + 1, y: this.topIntersectPoint.y });
        }
      }
      return t;
    }
    getLastFlippingClipArea() {
      const t = [];
      if ('top' === this.corner) {
        t.push({ x: 0, y: 0 });
        t.push({ x: this.topIntersectPoint.x, y: this.topIntersectPoint.y });
        if (null !== this.sideIntersectPoint) {
          if (h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10) {
            t.push({ x: this.sideIntersectPoint.x, y: this.sideIntersectPoint.y });
            t.push({ x: this.pageWidth, y: this.pageHeight });
          }
        } else {
          t.push({ x: this.bottomIntersectPoint.x, y: this.bottomIntersectPoint.y });
        }
        t.push({ x: 0, y: this.pageHeight });
      }

      if ('bottom' === this.corner) {
        t.push({ x: 0, y: 0 });
        if (null !== this.sideIntersectPoint) {
          if (
            h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.bottomIntersectPoint) >= 10
          ) {
            t.push({ x: this.pageWidth, y: 0 });
            t.push(this.sideIntersectPoint);
          }
        } else {
          t.push(this.topIntersectPoint);
        }
        t.push(this.bottomIntersectPoint);
        t.push({ x: 0, y: this.pageHeight });
      }
      return t;
    }
    getBottomClipArea() {
      const t = [];
      return (
        null !== this.topIntersectPoint
          ? t.push({ x: this.topIntersectPoint.x - 1, y: this.topIntersectPoint.y })
          : '',
        'top' === this.corner
          ? t.push({ x: this.pageWidth, y: 0 })
          : (null !== this.topIntersectPoint && t.push({ x: this.pageWidth, y: 0 }),
            t.push({ x: this.pageWidth, y: this.pageHeight })),
        null !== this.sideIntersectPoint
          ? h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10 &&
            t.push({ x: this.sideIntersectPoint.x, y: this.sideIntersectPoint.y + 1 })
          : 'top' === this.corner && t.push({ x: this.pageWidth, y: this.pageHeight }),
        null !== this.bottomIntersectPoint
          ? t.push({ x: this.bottomIntersectPoint.x - 1, y: this.bottomIntersectPoint.y })
          : '',
        t
      );
    }
    getAngle() {
      return 0 === this.direction ? -this.angle : this.angle;
    }
    getRect() {
      return this.rect;
    }
    getPosition() {
      return this.position;
    }
    getActiveCorner() {
      return 0 === this.direction ? this.rect.topLeft : this.rect.topRight;
    }
    getDirection() {
      return this.direction;
    }
    getFlippingProgress() {
      return Math.abs(((this.position.x - this.pageWidth) / (2 * this.pageWidth)) * 100);
    }
    getCorner() {
      return this.corner;
    }
    getBottomPagePosition() {
      return 1 === this.direction ? { x: this.pageWidth, y: 0 } : { x: 0, y: 0 };
    }
    getShadowStartPoint() {
      return 'top' === this.corner
        ? this.topIntersectPoint
        : null !== this.sideIntersectPoint
        ? this.sideIntersectPoint
        : this.topIntersectPoint;
    }
    getShadowAngle() {
      const t = h.GetAngleBetweenTwoLine(this.getSegmentToShadowLine(), [
        { x: 0, y: 0 },
        { x: this.pageWidth, y: 0 },
      ]);
      return 0 === this.direction ? t : Math.PI - t;
    }
    calcAngleAndPosition(t) {
      let e = t;
      if (
        (this.updateAngleAndGeometry(e),
        (e =
          'top' === this.corner
            ? this.checkPositionAtCenterLine(e, { x: 0, y: 0 }, { x: 0, y: this.pageHeight })
            : this.checkPositionAtCenterLine(e, { x: 0, y: this.pageHeight }, { x: 0, y: 0 })),
        Math.abs(e.x - this.pageWidth) < 1 && Math.abs(e.y) < 1)
      )
        throw new Error('Point is too small');
      return e;
    }
    updateAngleAndGeometry(t) {
      (this.angle = this.calculateAngle(t)), (this.rect = this.getPageRect(t));
    }
    calculateAngle(t) {
      const e = this.pageWidth - t.x + 1,
        i = 'bottom' === this.corner ? this.pageHeight - t.y : t.y;
      let s = 2 * Math.acos(e / Math.sqrt(i * i + e * e));
      i < 0 && (s = -s);
      const n = Math.PI - s;
      if (!isFinite(s) || (n >= 0 && n < 0.003)) throw new Error('The G point is too small');
      return 'bottom' === this.corner && (s = -s), s;
    }
    getPageRect(t) {
      return 'top' === this.corner
        ? this.getRectFromBasePoint(
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
            t,
          )
        : this.getRectFromBasePoint(
            [
              { x: 0, y: -this.pageHeight },
              { x: this.pageWidth, y: -this.pageHeight },
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
            t,
          );
    }
    getRectFromBasePoint(t, e) {
      return {
        topLeft: this.getRotatedPoint(t[0], e),
        topRight: this.getRotatedPoint(t[1], e),
        bottomLeft: this.getRotatedPoint(t[2], e),
        bottomRight: this.getRotatedPoint(t[3], e),
      };
    }
    getRotatedPoint(t, e) {
      return {
        x: t.x * Math.cos(this.angle) + t.y * Math.sin(this.angle) + e.x,
        y: t.y * Math.cos(this.angle) - t.x * Math.sin(this.angle) + e.y,
      };
    }
    calculateIntersectPoint(t) {
      const e = {
        left: -1,
        top: -1,
        width: this.pageWidth + 2,
        height: this.pageHeight + 2,
      };
      'top' === this.corner
        ? ((this.topIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.topRight],
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
          )),
          (this.sideIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.bottomLeft],
            [
              { x: this.pageWidth, y: 0 },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )),
          (this.bottomIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.bottomLeft, this.rect.bottomRight],
            [
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )))
        : ((this.topIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.topLeft, this.rect.topRight],
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
          )),
          (this.sideIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.topLeft],
            [
              { x: this.pageWidth, y: 0 },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )),
          (this.bottomIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.bottomLeft, this.rect.bottomRight],
            [
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )));
    }
    checkPositionAtCenterLine(t, e, i) {
      let s = t;
      const n = h.LimitPointToCircle(e, this.pageWidth, s);
      s !== n && ((s = n), this.updateAngleAndGeometry(s));
      const o = Math.sqrt(Math.pow(this.pageWidth, 2) + Math.pow(this.pageHeight, 2));
      let a = this.rect.bottomRight,
        r = this.rect.topLeft;
      if (
        ('bottom' === this.corner && ((a = this.rect.topRight), (r = this.rect.bottomLeft)),
        a.x <= 0)
      ) {
        const t = h.LimitPointToCircle(i, o, r);
        t !== s && ((s = t), this.updateAngleAndGeometry(s));
      }
      return s;
    }
    getSegmentToShadowLine() {
      const t = this.getShadowStartPoint();
      return [
        t,
        t !== this.sideIntersectPoint && null !== this.sideIntersectPoint
          ? this.sideIntersectPoint
          : this.bottomIntersectPoint,
      ];
    }
  }
  class g {
    constructor(t, e) {
      (this.flippingPage = null),
        (this.lastFrameFlippingPage = null),
        (this.underFlippingPage = null),
        (this.bottomPage = null),
        (this.calc = null),
        (this.state = 'read'),
        (this.initialAction = ''),
        (this.render = t),
        (this.app = e);
    }
    fold(t, l) {
      this.initialAction = 'fold';
      this.setState('user_fold'),
        null === this.calc && this.start(t, l),
        this.do(this.render.convertToPage(t));
      APP.Book.onUserFoldState();
    }
    flip(t) {
      if ((null !== this.calc && this.render.finishAnimation(), !this.start(t))) return;

      const e = this.getBoundsRect();
      this.initialAction = 'flip';
      this.setState('flipping');
      var startX = e.height / 10;
      var i = e.height / 10,
        s = 'bottom' === this.calc.getCorner() ? e.height - i : i,
        n = 'bottom' === this.calc.getCorner() ? e.height : 0; //0
      if (forceOnePage) {
        startX = 0;
        (i = 1),
          (s = 'bottom' === this.calc.getCorner() ? e.height - i : i),
          (n = 'bottom' === this.calc.getCorner() ? e.height : 0); //0
      }

      this.calc.calc({ x: e.pageWidth - startX, y: s }),
        this.animateFlippingTo(
          { x: parseInt(e.pageWidth - startX), y: s },
          { x: -e.pageWidth, y: n },
          !0,
        );
    }
    start(t, l) {
      this.reset();
      let e = this.render.convertToBook(t),
        i = this.getBoundsRect(),
        s = this.getDirectionByPoint(e),
        n = e.y >= i.height / 2 ? 'bottom' : 'top';

      if (l && 'portrait' === this.render.getOrientation()) {
        if (t.x - l.x > 0) {
          s = 1;
        } else {
          s = 0;
        }
      }

      if (!this.checkDirection(s)) return !1;

      try {
        if (
          ((this.flippingPage = this.app.getPageCollection().getFlippingPage(s)),
          (this.bottomPage = this.app.getPageCollection().getBottomPage(s)),
          'landscape' === this.render.getOrientation())
        ) {
          if (1 === s) {
            const t = this.app.getPageCollection().nextBy(this.flippingPage);
            if (this.flippingPage.element.classList[1] === '_page_1') {
              this.underFlippingPage = this.app.getPageCollection().nextBy(this.flippingPage);
            }
            if (
              this.app.getPageCollection().prevSpreadIndex >
                this.app.getPageCollection().currentSpreadIndex + 1 &&
              this.app.getPageCollection().currentSpreadIndex - 1 === 0
            ) {
              let page = this.app
                .getPageCollection()
                .getPageByNum(1, this.app.getPageCollection().prevSpreadIndex);
              this.underFlippingPage = page;
            }
            if (
              this.app.getPageCollection().prevSpreadIndex ===
                this.app.getPageCollection().landscapeSpread.length - 1 &&
              this.currentPageIndex - 1 === 0
            ) {
              let page = this.app
                .getPageCollection()
                .getPageByNum(1, this.app.getPageCollection().prevSpreadIndex);
              this.underFlippingPage = page;
            }
            null !== t &&
              this.flippingPage.getDensity() !== t.getDensity() &&
              (this.flippingPage.setDrawingDensity('soft'), t.setDrawingDensity('soft'));
          } else {
            const t = this.app.getPageCollection().prevBy(this.flippingPage);
            if (
              null === this.underFlippingPage &&
              this.flippingPage.element.classList[1] ===
                `_page_${this.app.getPageCollection().pages.length}`
            ) {
              if (
                this.app.getPageCollection().prevSpreadIndex + 1 ==
                  this.app.getPageCollection().currentSpreadIndex ||
                this.app.getPageCollection().prevSpreadIndex - 1 ==
                  this.app.getPageCollection().currentSpreadIndex
              ) {
                this.underFlippingPage = this.app.getPageCollection().prevBy(this.flippingPage);
              } else {
                let page = this.app
                  .getPageCollection()
                  .getPageByNum(s, this.app.getPageCollection().prevSpreadIndex);

                this.underFlippingPage = page;
              }
            }

            null !== t &&
              this.flippingPage.getDensity() !== t.getDensity() &&
              (this.flippingPage.setDrawingDensity('soft'), t.setDrawingDensity('soft'));
          }
        }

        return (
          this.render.setDirection(s),
          (this.calc = new r(s, n, i.pageWidth.toString(10), i.height.toString(10))),
          !0
        );
      } catch (t) {
        return !1;
      }
    }

    do(t) {
      //0.08-0.09 (max: 0.71) 1%

      if (null !== this.calc && this.calc.calc(t)) {
        const t = this.calc.getFlippingProgress();
        this.bottomPage.setArea(this.calc.getBottomClipArea()),
          this.bottomPage.setPosition(this.calc.getBottomPagePosition(), 'bottom'),
          this.bottomPage.setAngle(0),
          this.bottomPage.setHardAngle(0),
          this.flippingPage.setArea(this.calc.getFlippingClipArea()),
          this.flippingPage.setOdblask(),
          this.flippingPage.setPosition(this.calc.getActiveCorner(), 'fpgetActiveCorner'),
          this.flippingPage.setAngle(this.calc.getAngle()),
          this.flippingPage.setFlipAngle(0),
          0 === this.calc.getDirection()
            ? this.flippingPage.setHardAngle((90 * (200 - 2 * t)) / 100)
            : this.flippingPage.setHardAngle((-90 * (200 - 2 * t)) / 100),
          1 === this.calc.getDirection()
            ? null !== this.underFlippingPage
              ? this.underFlippingPage.setArea(this.calc.getFirstFlippingClipArea())
              : ''
            : null !== this.underFlippingPage
            ? this.underFlippingPage.setArea(this.calc.getLastFlippingClipArea())
            : '',
          null !== this.underFlippingPage
            ? this.underFlippingPage.setPosition(this.calc.getBottomPagePosition())
            : '',
          null !== this.underFlippingPage ? this.underFlippingPage.setAngle(0) : '',
          null !== this.underFlippingPage ? this.underFlippingPage.setHardAngle(0) : '',
          this.render.setPageRect(this.calc.getRect()),
          this.render.setBottomPage(this.bottomPage),
          this.render.setFlippingPage(this.flippingPage),
          this.render.setUnderFlippingPage(this.underFlippingPage),
          this.render.setShadowData(
            this.calc.getShadowStartPoint(),
            this.calc.getShadowAngle(),
            t,
            this.calc.getDirection(),
          );
      }
    }
    flipToPage(t, e) {
      const i = this.app.getPageCollection().getCurrentSpreadIndex(),
        s = this.app.getPageCollection().getSpreadIndexByPage(t);
      this.app.getPageCollection().setPrevSpreadIndex(i);
      try {
        s > i && (this.app.getPageCollection().setCurrentSpreadIndex(s - 1), this.flipNext(e)),
          s < i && (this.app.getPageCollection().setCurrentSpreadIndex(s + 1), this.flipPrev(e));
      } catch (t) {}
    }
    flipNext(t) {
      this.flip({
        x: this.render.getRect().left + 2 * this.render.getRect().pageWidth,
        y: 'top' === t ? 1 : this.render.getRect().height - 2,
      });
    }
    flipPrev(t) {
      this.flip({
        x: 10,
        y: 'top' === t ? 1 : this.render.getRect().height - 2,
      });
    }
    stopMove() {
      if (null === this.calc) return;
      const t = this.calc.getPosition(),
        e = this.getBoundsRect(),
        i = 'bottom' === this.calc.getCorner() ? e.height : 0;
      let dist = 0;
      if (this.render.getOrientation() === 'portrait') {
        dist = e.pageWidth / 2 - 50;
      }
      if (t.x <= dist && is_safari()) {
        let audio = document.querySelector('.current-audio');
        if (audio) audio.play();
      }
      t.x <= dist
        ? this.animateFlippingTo(t, { x: -e.pageWidth, y: i }, !0)
        : this.animateFlippingTo(t, { x: e.pageWidth, y: i }, !1);
    }

    showCorner() {
      if (!this.checkState('read', 'fold_corner')) return;

      const e = this.getBoundsRect(),
        i = e.pageWidth,
        s = Math.sqrt(Math.pow(i, 2) + Math.pow(e.height, 2)) / 5,
        n = this.render.convertToBook(t);

      if (null === this.calc) {
        if (!this.start(t)) {
          return;
        }

        this.setState('fold_corner');

        this.calc.calc({ x: i - 1, y: 1 });
        const s = 70,
          n = 'bottom' === this.calc.getCorner() ? e.height - 1 : 1,
          h = 'bottom' === this.calc.getCorner() ? e.height - s : s;

        this.animateFlippingToCorner({ x: i - 0, y: n }, { x: i - s, y: h - 30 });
      } else {
        this.do(this.render.convertToPage(t));
      }
    }
    /**
     *
     * @param {type} t - pcozatek
     * @param {type} e - kniecz
     * @param {type} i = czy d kolejnej przejsc
     * @param {type} s
     */
    animateFlippingTo(t, e, i, s = !0) {
      const n = h.GetCordsFromTwoPoint(t, e);

      const frames = [];
      for (const t of n) frames.push(() => this.do(t));

      const duration = this.getAnimationDuration(n.length);

      this.render.startAnimation(frames, duration, () => {
        // HELPER.showfps( `${window.perfcount} => ${window.perftime / window.perfcount}` );
        if (
          this.flippingPage &&
          this.flippingPage.element.children.length > 0 &&
          this.flippingPage.element.children[0].length > 0
        ) {
          this.flippingPage.element.children[0].children[0].children[1].style.cssText = '';
        }
        

        this.calc &&
          (i &&
            (1 === this.calc.getDirection()
              ? this.app.turnToPrevPage()
              : this.app.turnToNextPage()),
          s &&
            (this.render.setBottomPage(null),
            this.render.setFlippingPage(null),
            this.render.setUnderFlippingPage(null),
            this.render.clearShadow(),
            this.setState('read'),
            this.reset()));
            APP.Book.onReadState();
            
        // Show/Hide arrow after animation on first/last pages.
        const currentPage = APP.Book.getCurrentPage();
        if (currentPage >= 1 && currentPage < (APP.Book.isDoublePage() ? APP.Book.getModel().pages - 1 : APP.Book.getModel().pages)) {
            APP.Book.showHideArrows(currentPage);
        }

        //console.log("animation ended", this.app.pages);
        APP.Book.getBookModelSettings().show_book_thickness ? this.xxx() : null;
      });
    }

    xxx() {
      let pageNum = Number(this.app.getCurrentPageIndex());
      if (this.app.setting.bookPage === 1) {
        return;
      }
      if (forceOnePage) {
        let pages_left = this.app.setting.bookPages - (pageNum + 1); //nie pokazujemy ostatnij
        !is_mobile() && this.render.redrawLinesCanvasPagesForOnePage(pages_left);
      } else {
        var newPages = [];

        newPages = [pageNum + 1, pageNum + 2];

        var numbersPagesOnBottom = [
          newPages[1] >= this.app.setting.bookPages ? 0 : newPages[0] / 2 - 1,
          newPages[0] <= 1 ? 0 : parseInt((this.app.setting.bookPages - newPages[1]) / 2),
        ];
        !is_mobile() &&
          this.render.redrawLinesCanvasPagesForTwoPage(
            numbersPagesOnBottom[0],
            numbersPagesOnBottom[1],
          );
      }
    }

    animateFlippingToCorner(from, to, firststart = true) {
      const n = h.GetCordsFromTwoPoint(from, to);
      const nback = h.GetCordsFromTwoPoint(to, from);

      const frames = [];
      for (const t of n) {
        frames.push(() => this.do(t));
      }

      var step;
      for (step = 0; step < n.length / 2; step++) {
        frames.push(() => this.do(t));
      }

      for (const t of nback) frames.push(() => this.do(t));
      const duration = 700;
      var self = this;

      this.render.startAnimation(frames, duration, () => {
        if (this.calc) {
          this.render.setBottomPage(null);
          this.render.setFlippingPage(null);
          this.render.setUnderFlippingPage(null);
          this.render.clearShadow();
          this.setState('read');
          this.reset();
        }
      });
    }

    getCalculation() {
      return this.calc;
    }
    getState() {
      return this.state;
    }
    setState(t) {
      this.state !== t && (this.app.updateState(t), (this.state = t));
    }
    getDirectionByPoint(t) {
      const e = this.getBoundsRect();
      if ('portrait' === this.render.getOrientation()) {
        if (t.x - e.pageWidth <= e.width / 5) return 1;
      } else if (t.x < e.width / 2) return 1;
      return 0;
    }
    getAnimationDuration(t) {
      const e = this.app.getSettings().flippingTime;
      var dur = t >= e ? e : (t / e) * e; //1e3

      return e;
    }
    checkDirection(t) {
      return 0 === t
        ? this.app.getCurrentPageIndex() < this.app.getPageCount() - 1
        : this.app.getCurrentPageIndex() >= 1;
    }
    reset() {
      if (this.flippingPage && this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.display = 'none';
      }

      (this.calc = null),
        (this.flippingPage = null),
        (this.bottomPage = null),
        (this.underFlippingPage = null);
    }
    getBoundsRect() {
      return this.render.getRect();
    }
    checkState(...t) {
      for (const e of t) if (this.state === e) return !0;
      return !1;
    }
  }
  class l {
    constructor(t, e) {
      (this.leftPage = null),
        (this.rightPage = null),
        (this.flippingPage = null),
        (this.bottomPage = null),
        (this.underFlippingPage = null),
        (this.direction = null),
        (this.directionNamed = null),
        (this.orientation = null),
        (this.shadow = null),
        (this.animation = null),
        (this.pageRect = null),
        (this.boundsRect = null),
        (this.timer = 0),
        (this.safari = !1),
        (this.setting = e),
        (this.app = t),
        (this.testcounter = 0),
        (this.testtime_df = [0, 0, 0, 0, 0]),
        (this.testcount_df = 0),
        (this.outershadow_currentbg_opacity = null),
        (this.outershadow_currentbg_direction = null);
      const i = new RegExp('Version\\/[\\d\\.]+.*Safari/');
      this.safari = null !== i.exec(window.navigator.userAgent);
    }
    showfps(x) {
      document.getElementsByClassName('header__book-name')[0].style.fontSize = '9px';
      document.getElementsByClassName('header__book-name')[0].innerHTML = x;
    }

    render(t) {
      if (null !== this.animation) {
        let e = Math.round((t - this.animation.startedAt) / this.animation.durationFrame);

        if (forceOnePage) {
          let progress =
            (t - this.animation.startedAt + this.animation.durationFrame) / this.animation.duration;
          progress = progress > 1.0 ? 1.0 : progress;
          e = Math.round(Math.sin((progress * Math.PI) / 2) * this.animation.frames.length);
          if (this.animation.frameNum == 0) {
            e = Math.round(0.01 * this.animation.frames.length);
          }
        }

        if (e >= this.animation.frames.length) {
          this.animation.frames[this.animation.frames.length - 1]();
          this.timer = t;
          this.drawFrame();
        }

        this.animation.frameNum++;
        this.testcounter++;
        e < this.animation.frames.length
          ? this.animation.frames[e]() //locked anim
          : (this.animation.onAnimateEnd(),
            (this.animation = null),
            (this.testcounter = 0),
            (document.getElementById('stf__marcinBookShadow').style.display = ''));
      }
      this.timer = t;
      this.drawFrame();
    }
    //

    start() {
      this.update();
      const t = (e) => {
        this.render(e), requestAnimationFrame(t);
      };
      requestAnimationFrame(t);
    }
    startAnimation(frames, e, callback) {
      this.finishAnimation();
      this.animation = {
        frames: frames,
        duration: e,
        durationFrame: e / frames.length,
        onAnimateEnd: callback,
        startedAt: this.timer,
        frameNum: 0,
        frameNumE: 0,
        marcinLastFrame: false,
      };
    }

    finishAnimation() {
      null !== this.animation &&
        (this.animation.frames[this.animation.frames.length - 1](),
        null !== this.animation.onAnimateEnd && this.animation.onAnimateEnd()),
        (this.animation = null);
    }
    update_ThicknesTwoPage() {
      if (!is_mobile() && APP.Book.getBookModelSettings().show_book_thickness) {
        if (forceOnePage) {
          // if (this.app.getCurrentPageIndex() + 1 > 1) { // bylo this.app.setting.bookPage > 1
            let pages_left = this.setting.bookPages - this.app.getCurrentPageIndex() - 1;
            this.redrawLinesCanvasPagesForOnePage(
              this.app.getCurrentPageIndex() === 0 ? pages_left : pages_left,
              true,
            );
          // }
        } else {
          if (this.leftPage !== null || this.rightPage !== null) {
            let leftP = this.leftPage
              ? parseInt(this.leftPage.element.page / 2)
              : parseInt((this.rightPage.element.page - 1) / 2);

            let rightP = this.rightPage
              ? parseInt((this.setting.bookPages - this.rightPage.element.page) / 2)
              : 0;
            if (this.app.getCurrentPageIndex() === 0) {
              rightP = 0;
            }
            this.redrawLinesCanvasPagesForTwoPage(leftP, rightP, true);
          } else {
            this.redrawLinesCanvasPagesForTwoPage(0, 0, true);
          }
        }
      }
    }

    update() {
      this.boundsRect = null;
      const t = this.calculateBoundsRect();

      this.update_ThicknesTwoPage();

      this.orientation !== t && ((this.orientation = t), this.app.updateOrientation(t));
    }
    calculateBoundsRect() {
      let t = 'landscape';
      const e = this.getBlockWidth(),
        i = e / 2,
        s = this.getBlockHeight() / 2,
        n = this.setting.width / this.setting.height;
      let h = this.setting.width,
        o = this.setting.height,
        a = i - h;
      return (
        'stretch' === this.setting.size
          ? (e < 2 * this.setting.minWidth &&
              this.app.getSettings().usePortrait &&
              (t = 'portrait'),
            (h = 'portrait' === t ? this.getBlockWidth() : this.getBlockWidth() / 2),
            h > this.setting.maxWidth && (h = this.setting.maxWidth),
            (o = h / n),
            o > this.getBlockHeight() && ((o = this.getBlockHeight()), (h = o * n)),
            (a = 'portrait' === t ? i - h / 2 - h : i - h))
          : e < 2 * h &&
            this.app.getSettings().usePortrait &&
            ((t = 'portrait'), (a = i - h / 2 - h)),
        (this.boundsRect = {
          left: a,
          top: s - o / 2,
          width: 2 * h,
          height: o,
          pageWidth: h,
        }),
        t
      );
    }
    setShadowData(t, e, i, s) {
      if (!this.app.getSettings().drawShadow) return;
      const n = 100 * this.getSettings().maxShadowOpacity;
      let progressParam = i < 30 ? i : i > 70 ? i - 40 : 30;
      this.shadow = {
        pos: t,
        angle: e,
        width: (((3 * this.getRect().pageWidth) / 4) * i) / 100,
        opacity: ((100 - i) * n) / 100 / 100,
        opacityInner: ((100 - progressParam) * n) / 100 / 100,
        direction: s,
        progress: 2 * i,
        showShadowOnMobile: this.getSettings().showShadowOnMobile,
      };
    }
    clearShadow() {
      this.shadow = null;
    }
    getBlockWidth() {
      return this.app.getUI().getDistElement().offsetWidth;
    }
    getBlockHeight() {
      return this.app.getUI().getDistElement().offsetHeight;
    }
    getDirection() {
      return this.direction;
    }
    getDirectionNamed() {
      return this.directionNamed;
    }
    getRect() {
      let rect = (null === this.boundsRect && this.calculateBoundsRect(), this.boundsRect);
      return rect;
    }
    getSettings() {
      return this.app.getSettings();
    }
    getOrientation() {
      return this.orientation;
    }
    setPageRect(t) {
      this.pageRect = t;
    }
    setDirection(t) {
      this.direction = t;
      this.directionNamed = t === 1 ? 'left' : 'right';
    }
    setRightPage(t) {
      null !== t && t.setOrientation(1), (this.rightPage = t);
    }
    setLeftPage(t) {
      null !== t && t.setOrientation(0), (this.leftPage = t);
    }

    setBottomPage(t) {
      null !== t && t !== undefined && t.setOrientation(1 === this.direction ? 0 : 1),
        (this.bottomPage = t);
    }
    setFlippingPage(t) {
      null !== t &&
        t !== undefined &&
        t.setOrientation(0 === this.direction && 'portrait' !== this.orientation ? 0 : 1),
        (this.flippingPage = t);
    }
    setUnderFlippingPage(t) {
      null !== t &&
        t !== undefined &&
        t.setOrientation(0 === this.direction && 'portrait' !== this.orientation ? 1 : 0),
        (this.underFlippingPage = t);
    }
    convertToBook(t) {
      const e = this.getRect();
      return { x: t.x - e.left, y: t.y - e.top };
    }
    isSafari() {
      return this.safari;
    }
    convertToPage(t, e) {
      e || (e = this.direction);
      const i = this.getRect();
      return {
        x: 0 === e ? t.x - i.left - i.width / 2 : i.width / 2 - t.x + i.left,
        y: t.y - i.top,
      };
    }
    convertToGlobal(t, e) {
      if ((e || (e = this.direction), null == t)) return null;
      const i = this.getRect();
      return {
        x: 0 === e ? t.x + i.left + i.width / 2 : i.width / 2 - t.x + i.left,
        y: t.y + i.top,
      };
    }
    convertRectToGlobal(t, e) {
      return (
        e || (e = this.direction),
        {
          topLeft: this.convertToGlobal(t.topLeft, e),
          topRight: this.convertToGlobal(t.topRight, e),
          bottomLeft: this.convertToGlobal(t.bottomLeft, e),
          bottomRight: this.convertToGlobal(t.bottomRight, e),
        }
      );
    }
  }

  class p {
    constructor(t, e, i) {
      (this.touchPoint = null),
        (this.swipeTimeout = 250),
        (this.onResize = () => {
          this.update();
        }),
        (this.onMouseDown = (t) => {
          if (t.which !== 1) {
            return;
          }
          
          if (
            !this.app.isBookZoomed() &&
            !APP.Note.isThereExpandedNoteInArray() &&
            !(t.target.classList && t.target.classList.contains('Note__marker'))
          ) {
            if (this.checkTarget(t.target)) {
              const e = this.getMousePos(t.clientX, t.clientY);
              this.app.startUserTouch(e), t.preventDefault();
            }
          }
        }),
        (this.onTouchStart = (t) => {
          if (!this.app.isBookZoomed()) {
            if (this.checkTarget(t.target) && t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              (this.touchPoint = { point: i, time: Date.now() }),
                setTimeout(() => {
                  null !== this.touchPoint && this.app.startUserTouch(i);
                }, this.swipeTimeout),
                this.app.getSettings().mobileScrollSupport || t.preventDefault();
            }
            if (this.checkTarget(t.target) && t.changedTouches.length >= 2) {
              this.app.setZoom();
            }
          }
        }),
        (this.onMouseUp = (t) => {
          if (!this.app.isBookZoomed()) {
            const e = this.getMousePos(t.clientX, t.clientY);
            this.app.userStop(e);
          }
        }),
        (this.onMouseLeave = (t) => {
          this.onMouseUp(t);
        }),
        (this.onMouseMove = (t) => {
          if (
            !this.app.isBookZoomed() &&
            !APP.Note.isThereExpandedNoteInArray() &&
            !(t.target.classList && t.target.classList.contains('Note__marker'))
          ) {
            const e = this.getMousePos(t.clientX, t.clientY);
            this.app.userMove(e, !1);
          }
        }),
        (this.onTouchMove = (t) => {
          if (!this.app.isBookZoomed()) {
            if (t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              this.app.getSettings().mobileScrollSupport
                ? (null !== this.touchPoint &&
                    (Math.abs(this.touchPoint.point.x - i.x) > 10 ||
                      'read' !== this.app.getState()) &&
                    t.cancelable &&
                    this.app.userMove(i, !0),
                  'read' !== this.app.getState() && t.preventDefault())
                : this.app.userMove(i, !0);
            }
          }
        }),
        (this.onTouchEnd = (t) => {
          if (!this.app.isBookZoomed()) {
            if (t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              let s = !1;
              if (null !== this.touchPoint) {
                const t = i.x - this.touchPoint.point.x,
                  e = Math.abs(i.y - this.touchPoint.point.y);
                Math.abs(t) > this.swipeDistance &&
                  Date.now() - this.touchPoint.time < this.swipeTimeout &&
                  (t > 0
                    ? this.app.flipPrev(
                        this.touchPoint.point.y < this.app.getRender().getRect().height / 4
                          ? 'top'
                          : 'bottom',
                      )
                    : this.app.flipNext(
                        this.touchPoint.point.y < this.app.getRender().getRect().height / 4
                          ? 'top'
                          : 'bottom',
                      ),
                  (s = !0)),
                  (this.touchPoint = null);
              }
              this.app.userStop(i, s);
            }
          } else {
            const e = t.changedTouches[0],
              i = this.getMousePos(e.clientX, e.clientY);
            let s = !1;
            this.app.userStop(i, s);
          }
        }),
        t.classList.add('stf__parent'),
        t.insertAdjacentHTML('afterbegin', '<div class="stf__wrapper"></div>'),
        (this.wrapper = t.querySelector('.stf__wrapper')),
        (this.app = e);
      const s = this.app.getSettings().usePortrait ? 1 : 2;

      i.autoSize && ((t.style.width = '100%'), (t.style.maxWidth = 2 * i.maxWidth + 'px')),
        (t.style.display = 'block'),
        window.addEventListener('resize', this.onResize, !1),
        (this.swipeDistance = i.swipeDistance);
    }
    destroy() {
      this.app.getSettings().useMouseEvents && this.removeHandlers(),
        this.distElement.remove(),
        this.wrapper.remove();
    }
    getDistElement() {
      return this.distElement;
    }
    getWrapper() {
      return this.wrapper;
    }
    setOrientationStyle(t) {
      this.wrapper.classList.remove('--portrait', '--landscape'),
        'portrait' === t
          ? (this.app.getSettings().autoSize &&
              (this.wrapper.style.paddingBottom =
                (this.app.getSettings().height / this.app.getSettings().width) * 100 + '%'),
            this.wrapper.classList.add('--portrait'))
          : (this.app.getSettings().autoSize &&
              (this.wrapper.style.paddingBottom =
                (this.app.getSettings().height / (2 * this.app.getSettings().width)) * 100 + '%'),
            this.wrapper.classList.add('--landscape')),
        this.update();
    }
    removeHandlers() {
      window.removeEventListener('resize', this.onResize),
        this.distElement.removeEventListener('mousedown', this.onMouseDown),
        this.distElement.removeEventListener('touchstart', this.onTouchStart),
        window.removeEventListener('mousemove', this.onMouseMove),
        window.removeEventListener('touchmove', this.onTouchMove),
        window.removeEventListener('mouseup', this.onMouseUp),
        window.removeEventListener('publuuwindowleave', this.onMouseLeave),
        window.removeEventListener('touchend', this.onTouchEnd);
    }
    setHandlers() {
      //        mouseleave
      this.app.getSettings().useMouseEvents &&
        (this.distElement.addEventListener('mousedown', this.onMouseDown),
        this.distElement.addEventListener('touchstart', this.onTouchStart),
        window.addEventListener('mousemove', this.onMouseMove),
        window.addEventListener('touchmove', this.onTouchMove, {
          passive: !this.app.getSettings().mobileScrollSupport,
        }),
        window.addEventListener('mouseup', this.onMouseUp),
        window.addEventListener('publuuwindowleave', this.onMouseLeave),
        window.addEventListener('touchend', this.onTouchEnd));
    }
    getMousePos(t, e) {
      const i = this.distElement.getBoundingClientRect();
      return { x: t - i.left, y: e - i.top };
    }
    checkTarget(t) {
      return (
        !this.app.getSettings().clickEventForward ||
        !['a', 'button'].includes(t.tagName.toLowerCase())
      );
    }
  }
  class c extends p {
    constructor(t, e, i, s) {
      super(t, e, i),
        this.wrapper.insertAdjacentHTML('afterbegin', '<div class="stf__block"></div>'),
        (this.distElement = t.querySelector('.stf__block'));
      for (const t of s) this.distElement.appendChild(t);
      this.setHandlers();
    }
    updateItems(t) {
      this.removeHandlers(), (this.distElement.innerHTML = '');
      for (const e of t) this.distElement.appendChild(e);
      this.setHandlers();
    }
    update() {
      this.app.getRender().update();
    }
  }

  class w extends l {
    constructor(t, e, i) {
      super(t, e),
        (this.contForShadow = null),
        (this.outerShadow = null),
        (this.innerShadow = null),
        (this.underShadow = null),
        (this.extraLeftFliped = null),
        (this.hardShadow = null),
        (this.hardInnerShadow = null),
        (this.canvaPagesRight = null),
        (this.canvaPagesLeft = null),
        (this.element = i),
        this.createShadows();
      this.createBookShadowMarcin();
    }

    drawCanvasPagesForOnePage(pagesOnRight) {
      var widthRight = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;

      document.querySelector('.stf__parent').insertAdjacentHTML(
        'afterbegin',
        `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="0" height="${this.setting.height}" style="left:0px;right: unset;"></canvas>
`,
      );
      this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      this.canvaPagesLeft = document.getElementById('stf__marcinBookPages_left');
      this.canvaPagesLeft.style.display = 'none';

      if (pagesOnRight <= 1) {
        this.canvaPagesRight.style.display = 'none';
      }
      //            var width = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;
      //
      //            document.querySelector('.stf__parent')
      //                    .insertAdjacentHTML("afterbegin",
      //            `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${width}" height="${this.setting.height}" style="right:-${width}px;left: unset;"></canvas>`);
      //            this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      //
      //
      //
      this.redrawLinesCanvasPagesForOnePage(parseInt(pagesOnRight));
      //        }
    }

    drawCanvasPagesForTwoPage(pagesOnLeft, pagesOnRight) {
      var widthRight = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;
      var widthLeft = pagesOnLeft >= 13 ? 13 : pagesOnLeft + 1;

      document.querySelector('.stf__parent').insertAdjacentHTML(
        'afterbegin',
        `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="${widthLeft}" height="${this.setting.height}" style="left:-${widthLeft}px;right: unset;"></canvas>
`,
      );
      this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      this.canvaPagesLeft = document.getElementById('stf__marcinBookPages_left');

      this.redrawLinesCanvasPagesForTwoPage(parseInt(pagesOnLeft), parseInt(pagesOnRight));
    }

    drawCanvasPagesForOnePage_line(ctx, x, y, i, width) {
      var grayColors = ['#cccccc', '#bbbbbb', '#cacaca'];
      ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 3]; //grayColors[Math.floor(Math.random()*grayColors.length)];
      let heightdelta = width / 3 - x / 3 + Math.random();

      ctx.fillRect(0, heightdelta, width - x, this.setting.height - 2 * heightdelta);
    }

    redrawLinesCanvasPagesForTwoPage(pagesOnLeft, pagesOnRight, rebuildSize = false) {
      let maxWidth = 12;
      let multi = 1.25;

      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return;
      }
      if (rebuildSize) {
        if (this.canvaPagesLeft) {
          this.canvaPagesLeft.height = this.setting.height;
        }
        if (this.canvaPagesRight) {
          this.canvaPagesRight.height = this.setting.height;
        }
      }
      if (this.setting.height < 800) {
        maxWidth = 10;
        multi = 1.15;
        if (this.setting.height < 400) {
          maxWidth = 8;
          multi = 1.0;
        }
      }

      var grayColors = ['#cccccc', '#999999', '#bbbbbb', '#999999'];

      var is_left_visible_on_start = false;
      if (this.canvaPagesLeft) {
        is_left_visible_on_start = this.canvaPagesLeft.style.display === 'block';
        this.canvaPagesLeft.style.display = pagesOnLeft > 0 ? 'block' : 'none';

        var widthLeft = parseInt((pagesOnLeft > maxWidth ? maxWidth + 1 : pagesOnLeft + 2) * multi);

        this.canvaPagesLeft.style.left = `-${widthLeft}px`;
        this.canvaPagesLeft.style.width = `${widthLeft}px`;
        this.canvaPagesLeft.width = widthLeft;
        if (this.canvaPagesLeft.getContext) {
          var ctx = this.canvaPagesLeft.getContext('2d');
          ctx.clearRect(0, 0, this.canvaPagesLeft.width, this.canvaPagesLeft.height);

          var x = 0,
            y = 0;
          for (x = 0, i = 0; x < widthLeft; i++) {
            x += multi;
            y += 0.5;
            ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 4];
            let heightdelta = widthLeft / 3 - x / 5;
            let widthdelta = 1 - Math.floor(Math.random() * 10) / 100;
            ctx.fillRect(
              widthLeft,
              heightdelta,
              -(widthLeft - x * widthdelta),
              this.setting.height - 2 * heightdelta,
            );
          }
        }
      }

      this.canvaPagesRight.style.display = pagesOnRight > 0 ? 'block' : 'none';
      var widthRight = parseInt(
        (pagesOnRight > maxWidth ? maxWidth + 1 : pagesOnRight + 2) * multi,
      );
      this.canvaPagesRight.style.right = `-${widthRight}px`;
      this.canvaPagesRight.style.width = `${widthRight}px`;
      this.canvaPagesRight.width = widthRight;
      if (this.canvaPagesRight.getContext) {
        var ctx = this.canvaPagesRight.getContext('2d');
        ctx.clearRect(0, 0, this.canvaPagesRight.width, this.canvaPagesRight.height);

        var x = 0,
          y = 0;
        for (x = 0, i = 0; x < widthRight; i++) {
          x += multi;
          y += 0.5;
          ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 4];
          let heightdelta = widthRight / 3 - x / 5;
          let widthdelta = 1 - Math.floor(Math.random() * 10) / 100;
          ctx.fillRect(
            0,
            heightdelta,
            widthRight - x * widthdelta,
            this.setting.height - 2 * heightdelta,
          );
          //console.log(x);
        }
      }
    }

    redrawLinesCanvasPagesForOnePage(pagesOnRight, rebuildSize = false) {
      let maxWidth = 13;
      // let multi = 1.25;

      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return;
      }
      if (rebuildSize) {
        this.canvaPagesRight.height = this.setting.height;
      }
      if (this.setting.height < 800) {
        maxWidth = 10;
        if (this.setting.height < 400) {
          maxWidth = 8;
        }
      }
      var width = pagesOnRight >= maxWidth ? maxWidth : pagesOnRight + 1;

      this.canvaPagesRight.style.display = pagesOnRight > 0 ? 'block' : 'none';
      var widthRight = parseInt(pagesOnRight > maxWidth ? maxWidth : pagesOnRight);
      this.canvaPagesRight.style.right = `-${widthRight}px`;
      this.canvaPagesRight.style.width = `${widthRight}px`;
      this.canvaPagesRight.width = widthRight;

      if (this.canvaPagesRight.getContext) {
        var ctx = this.canvaPagesRight.getContext('2d');
        ctx.clearRect(0, 0, this.canvaPagesRight.width, this.canvaPagesRight.height);

        var x = 0,
          y = 0;

        for (x = 0, i = 0; i < width; i++) {
          x += 1.0;
          y += 0.5;
          this.drawCanvasPagesForOnePage_line(ctx, x, y, i, width);
        }
      }
    }

    createBookShadowMarcin() {
      document
        .querySelector('.stf__parent')
        .insertAdjacentHTML(
          'afterbegin',
          '<div class="stf__marcinBookShadow doubleWidth" id="stf__marcinBookShadow" style="right:0px;"></div></div>',
        );
      if (!is_mobile()) {
        if (forceOnePage) {
          this.drawCanvasPagesForOnePage(this.setting.bookPages);
        } else {
          this.drawCanvasPagesForTwoPage(this.setting.bookPages, this.setting.bookPages);
        }
      }
    }

    createShadows() {
      this.element.insertAdjacentHTML(
        'beforeend',
        '<div class="marcincrop2" id="marcincrop2"></div>\n<div class="stf__innerShadow"></div>\n<div class="shadows"><div class="stf__outerShadow"></div>\n  <div class="stf__underShadow" id="underShadow" hidden></div>\n<div class="stf__hardShadow"></div>\n             <div class="stf__hardInnerShadow"></div></div><div class="extraLeftFliped"><div class="extraLeftFlipedBg"></div></div>',
      ),
        (this.contForShadow = this.element.querySelector('.shadows')),
        (this.outerShadow = this.element.querySelector('.stf__outerShadow')),
        (this.innerShadow = this.element.querySelector('.stf__innerShadow')),
        (this.underShadow = this.element.querySelector('.stf__underShadow')),
        (this.extraLeftFliped = this.element.querySelector('.extraLeftFliped')),
        (this.hardShadow = this.element.querySelector('.stf__hardShadow')),
        (this.hardInnerShadow = this.element.querySelector('.stf__hardInnerShadow'));
    }
    clearShadow() {
      super.clearShadow(),
        (this.outerShadow.style.cssText = 'display: none'),
        (this.innerShadow.style.cssText = 'display: none'),
        (this.underShadow.style.cssText = 'display: none'),
        (this.extraLeftFliped.style.cssText = 'display: none'),
        (this.hardShadow.style.cssText = 'display: none'),
        (this.hardInnerShadow.style.cssText = 'display: none');
    }

    //pod kartka
    drawOuterShadow(direction, t, angle, globalShadowPos) {
      if (this.underFlippingPage !== null) return;
      //30
      var opacity = 0.5;
      var s = 1 === direction ? 200 : 1; //this.shadow.width
      //   s = 0;

      if (this.shadow.progress > 160) {
        opacity = (1 - (this.shadow.progress - 160) / 40) * opacity;
      }

      1 === direction
        ? this.outerShadow.classList.add('fliped')
        : this.outerShadow.classList.remove('fliped');
      //        width: ${2*this.shadow.width}px;

      this.outerShadow.style.cssText = `
        display: block;  
        height: ${2 * t.height}px;
        transform-origin: ${s}px 100px;
        transform: translate3d(${globalShadowPos.x - s + 0.5}px, ${
        globalShadowPos.y - 100
      }px, 0) rotate(${angle}rad);
        opacity: ${opacity};
                                                                                
      `;
    }

    //cien z lewej pod zaginana kartka
    drawUnderShadow(direction, t, angle, globalShadowPos) {
      //22-23
      let width = '';

      if (this.leftPage === null && direction === 0 && !forceOnePage) {
        return;
      }

      if (this.rightPage === null && direction === 1 && !forceOnePage) {
        return;
      }

      if (this.app.flipController.checkState('fold_corner') && !forceOnePage) {
        return;
      }

      let corner = Math.round(t.height / 2);
      s = direction === 1 ? 0 : 200;
      0 === direction
        ? this.underShadow.classList.add('fliped')
        : this.underShadow.classList.remove('fliped');

      this.underShadow.hidden = false;
      var opacity = 0.25;
      if (forceOnePage) {
        if (direction === 1) {
          if (angle < 2 * Math.PI) {
            return;
          }
          opacity =
            this.shadow.progress < 50
              ? 0.25
              : this.shadow.progress > 130
              ? 0.65
              : this.shadow.progress / 200;
          this.underShadow.parentElement.style.left = `${globalShadowPos.x + 1}px`;
          opacity = 1.0;
          s = 0;
          width = 'width: 100%';
        } else {
          //dir0 -- onepage
          width = `width: ${this.shadow.width}px`;
          s = this.shadow.width;
          opacity = 0.75;
          if (this.shadow.progress > 170) {
            //  opacity = ((225-this.shadow.progress) / 200);
          }
        }
      }

      ///////AJMY TLO TOTAJ ODWROCEONE ZAMIAST CIENIA

      this.underShadow.style.cssText = `
          display: block;
          height: ${
            2 * t.height
          }px;${width};                                                                 
          transform-origin:${s}px ${corner}px;
          transform: translate3d(${globalShadowPos.x - s}px, ${
        globalShadowPos.y - corner
      }px, 0) rotate(${angle}rad);
          opacity: ${opacity};background-size: contain; 
          `;
    }

    drawInnerShadowGoRight(angle, rect) {
      let shadowA = angle - this.flippingPage.state.angle;
      var pageW = rect.pageWidth;
      var width = Math.ceil(rect.pageWidth / 5);
      var toY = '0%';
      var left = 0;
      var bgPos = 'right';
      var rightOrLeft = 'left: 0px;';
      var distT = 0;
      var top = 0;
      var height = '100%';

      this.flippingPage.odblaskDiv && this.flippingPage.odblaskDiv.classList.add('fliped');

      if (this.flippingPage.state.area[1] !== null) {
        distT = this.distBetweenPoints(
          this.flippingPage.state.area[0],
          this.flippingPage.state.area[1],
        );
        left = distT - width;
        rightOrLeft = `left: ${left}px;`;
        height = '150%';
      } else {
        //TODO
        distT = this.distBetweenPoints(
          this.flippingPage.state.area[4],
          this.flippingPage.state.area[3],
        );
        width = distT > width ? width : distT;
        const rPageW = pageW - distT;
        bgPos = 'right';
        var rightOrLeft = `right: ${rPageW}px;`;
        toY = '100%';
      }

      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.cssText = `
         transform-origin: ${width}px ${toY};
        top: ${top}px; bottom: 0px; ${rightOrLeft} display: block;  
        height: ${height};width: ${width}px;background-size: ${width}px;
        transform: rotate(${shadowA}rad); opacity: ${this.drawInnerShadowOpacity()};z-index: 10;`;
      }
    }

    drawInnerShadowGoLeft(angle, rect) {
      let shadowA = angle - this.flippingPage.state.angle;
      var pageW = rect.pageWidth;
      var width = Math.ceil(rect.pageWidth / 5);
      var right = 0;
      var distT = 0;
      var bgPos = 'right';
      var rightOrLeft = 'right: 0px';
      var toY = '0%';
      var height = '100%';
      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.classList.remove('fliped');
      }
      if (this.flippingPage.state.area[1] !== null) {
        distT = this.distBetweenPoints(
          this.flippingPage.state.area[0],
          this.flippingPage.state.area[1],
        );
        right = distT - width;
        rightOrLeft = `right: ${right}px;`;
        height = '150%';
      } else {
        //TODO
        distT = this.distBetweenPoints(
          this.flippingPage.state.area[4],
          this.flippingPage.state.area[3],
        );
        width = distT > width ? width : distT;
        const rPageW = pageW - distT;
        bgPos = 'left';
        var rightOrLeft = `left: ${rPageW}px;`;
        toY = '100%';
      }

      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.cssText = `
         transform-origin: 0% ${toY};
        top: 0px; bottom: 0px; ${rightOrLeft} display: block;  
        height: ${height};width: ${width}px;background-size: ${width}px;
        transform: rotate(${shadowA}rad); opacity: ${this.drawInnerShadowOpacity()};`;
      }
    }

    drawInnerShadowOpacity() {
      var opacity = 1.0;
      if (this.shadow.progress > 140) {
        opacity = (200 - this.shadow.progress) / 60;
      }
      return opacity;
    }

    drawInnerShadow(direction, rect, angle) {
      if (this.getDirection() === 0) {
        //jezeli w lewo i gorny corner to dziala idealnie
        if (forceOnePage) {
        } else {
          this.drawInnerShadowGoRight(angle, rect);
        }
      } else {
        this.drawInnerShadowGoLeft(angle, rect);
      }
    }

    drawInnerShadowSafari() {
      const t = this.getRect(),
        e = 2 * this.shadow.width,
        i = 0 === this.getDirection() ? e : 0,
        s = 0 === this.getDirection() ? 'right' : 'left',
        n = this.convertToGlobal(this.shadow.pos),
        o = this.shadow.angle + (3 * Math.PI) / 2,
        a = [
          this.pageRect.topLeft,
          this.pageRect.topRight,
          this.pageRect.bottomRight,
          this.pageRect.bottomLeft,
        ];
      let r = 'polygon( ';
      for (const t of a) {
        let e =
          1 === this.getDirection()
            ? { x: -t.x + this.shadow.pos.x, y: t.y - this.shadow.pos.y }
            : { x: t.x - this.shadow.pos.x, y: t.y - this.shadow.pos.y };
        (e = h.GetRotatedPoint(e, { x: i, y: 100 }, o)), (r += e.x + 'px ' + e.y + 'px, ');
      }
      (r = r.slice(0, -2)), (r += ')');

      this.innerShadow.style.cssText = `
        display: block;
        z-index: ${(this.getSettings().startZIndex + 10).toString(10)};
        width: ${e}px;
        height: ${2 * t.height}px;
        background: -webkit-linear-gradient(${s},rgba(255, 255, 255, ${
        this.shadow.opacityInner - 0.29
      }) 1%, 
        rgba(255, 255, 255, ${this.shadow.opacityInner}) 5%,
        rgba(0, 0, 0, ${this.shadow.opacityInner - 0.21}) 15%,
        rgba(0, 0, 0, ${this.shadow.opacityInner - 0.24}) 25%,
        transparent);
        transform-origin: ${i}px 100px;
        transform: translate3d(${n.x - i}px, ${n.y - 100}px, 0) rotate(${o}rad);
        -webkit-clip-path: ${r};
        clip-path: ${r};
      `;
    }

    //
    //

    distBetweenPoints(A, B) {
      var a = A.x - B.x;
      var b = A.y - B.y;
      var ab = Math.sqrt(a * a + b * b);
      return ab;
    }

    drawParent__showBookAsTwoPageCentered() {
      document.getElementById('book').style.transform = 'translateX(0%)';
      document.querySelector('.Book__navNextPage.arrows-relative').style.right = `0px`;
      document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
      document.querySelector('.Book__navPrevPage.arrows-relative').style.left = `0px`;
      document.querySelector('.Book__navPrevPage.arrows-relative').style.right = 'unset';

      //shadow tez popraw
      document.getElementById('stf__marcinBookShadow').classList.remove('singleWidth');
      document.getElementById('stf__marcinBookShadow').classList.add('doubleWidth');
      document.getElementById('stf__marcinBookShadow').style.cssText = 'right: 0px';
    }

    drawParent__showBookAsOnePageCentered() {
      document.getElementById('book').style.transform = 'translateX(25%)';
      document.querySelector('.Book__navNextPage.arrows-relative').style.right = `0px`;
      document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
      document.querySelector('.Book__navPrevPage.arrows-relative').style.right = '0px';

      document.getElementById('stf__marcinBookShadow').classList.add('singleWidth');
      document.getElementById('stf__marcinBookShadow').classList.remove('doubleWidth');
      document.getElementById('stf__marcinBookShadow').style.cssText = 'width: 50%; left: 0px; right: unset;';
    }

    drawParent() {
      if ('portrait' !== this.orientation) {
        if (this.flippingPage) {
          if (this.direction === 1) {
            // w lewo
            //left
            if (this.flippingPage.element.classList[1] === '_page_1') {
              //na 1 strone
              document.getElementById('stf__marcinBookShadow').style.display = 'none';
              document.getElementById('stf__marcinBookShadow').style.width = '50%';
              document.getElementById('stf__marcinBookShadow').style.right = '0px';
              document.getElementById('stf__marcinBookShadow').style.left = null;

              x = -25;
              document.getElementById('book').style.transform = 'translateX(' + x + '%)';
              let width = parseInt(document.querySelector('.Book__innerChild').style.width);
              var persent = (width / 100) * 25;
              document.querySelector(
                '.Book__navNextPage.arrows-relative',
              ).style.right = `${persent}px`;
              document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
              document.querySelector('.Book__navPrevPage.arrows-relative').hidden = true;
            }
          } else {
            if (this.leftPage === null) {
              //first page
              //                        alert("animacja w prawo bez 1 strony" );
            }

            if (
              this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}` &&
              this.app.pages.pages.length == 2
            ) {
              document.getElementById('stf__marcinBookShadow').style.display = 'none';
            } else if (
              this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}`
            ) {
              document.getElementById('stf__marcinBookShadow').style.width = '50%';
              document.getElementById('stf__marcinBookShadow').style.left = '0px';
              document.getElementById('stf__marcinBookShadow').style.right = null;
              //                        var x =  0 + (((this.shadow.progress / 2)/100)*25);
              //document.getElementById('book').style.transform = 'translateX('+x+'%)';
              let width = parseInt(document.querySelector('.Book__innerChild').style.width);
              var persent = (width / 100) * 25;
              document.querySelector(
                '.Book__navPrevPage.arrows-relative',
              ).style.left = `${persent}px`;
              document.querySelector('.Book__navPrevPage.arrows-relative').style.right = 'unset';
            } else {
              //alert("animacja w prawo" );
            }
          }
        } else {
          //nie ma biektu FB ale moze jest jako last a to znaczy ze to pierwsza klatka po animacji
          if (this.lastFrameFlippingPage) {
            audio = audioElements[Math.floor(Math.random() * audioElements.length)];
            if (this.direction === 0) {
              if (this.leftPage === null) {
                //scancelowana animacja 1 strny
              } else if (this.rightPage === null) {
                let width = parseInt(document.querySelector('.Book__innerChild').style.width);
                var persent = (width / 100) * 25;
                document.getElementById('book').style.transform = 'translateX(25%)';
                document.querySelector(
                  '.Book__navNextPage.arrows-relative',
                ).style.right = `${persent}px`;
                document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
              } else {
                this.drawParent__showBookAsTwoPageCentered();
              }
            } else {
              //idziemy w lewo
              if (this.leftPage === null) {
                let width = parseInt(document.querySelector('.Book__innerChild').style.width);
                var persent = (width / 100) * 25;
                document.getElementById('book').style.transform = 'translateX(-25%)';
                document.querySelector(
                  '.Book__navPrevPage.arrows-relative',
                ).style.left = `${persent}px`;
                document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
              } else {
                if (this.rightPage == null) {
                  this.drawParent__showBookAsOnePageCentered();
                } 
                else {
                  this.drawParent__showBookAsTwoPageCentered();
                }
              }
            }
          }
        }
      } else {
        if (is_mobile() || forceOnePage) {
          if (this.flippingPage) {
          } else {
            if (this.lastFrameFlippingPage) {
              const refs = [...document.querySelectorAll(`[extraLayer="yes"]`)];
              for (i = 0; i < refs.length; ++i) {
                refs[i].removeAttribute('extraLayer');
              }
            }
          }
        }
      }
    }
    drawLeftPage() {
      //wina bledu 1 strony - left page is set

      'portrait' !== this.orientation &&
        null !== this.leftPage &&
        (1 === this.direction &&
        null !== this.flippingPage &&
        'hard' === this.flippingPage.getDrawingDensity()
          ? ((this.leftPage.getElement().style.zIndex = (
              this.getSettings().startZIndex + 5
            ).toString(10)),
            this.leftPage.setHardDrawingAngle(180 + this.flippingPage.getHardAngle()),
            this.leftPage.draw(this.flippingPage.getDrawingDensity()))
          : this.flippingPage && this.flippingPage.element.classList[1] === '_page_1'
          ? this.leftPage.draw('clipping')
          : this.leftPage.simpleDraw(0));
    }

    drawRightPage() {
      null !== this.rightPage &&
        (0 === this.direction &&
        null !== this.flippingPage &&
        'hard' === this.flippingPage.getDrawingDensity()
          ? ((this.rightPage.getElement().style.zIndex = (
              this.getSettings().startZIndex + 5
            ).toString(10)),
            this.rightPage.setHardDrawingAngle(180 + this.flippingPage.getHardAngle()),
            this.rightPage.draw(this.flippingPage.getDrawingDensity()))
          : this.flippingPage &&
            this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}`
          ? this.rightPage.draw('clipping')
          : this.rightPage.simpleDraw(1));
    }
    drawBottomPage() {
      if (null === this.bottomPage) return;
      this.bottomPage.state.bottomPage = true;

      const t = null != this.flippingPage ? this.flippingPage.getDrawingDensity() : null;
      ('portrait' === this.orientation && 1 === this.direction) ||
        ((this.bottomPage.getElement().style.zIndex = (this.getSettings().startZIndex + 3).toString(
          10,
        )),
        this.bottomPage.draw(t, 'drawBottomPage'));
    }
    correctMarcinShadows() {
      if (this.app.getCurrentPageIndex() == 0) {
        document.querySelector('.stf__marcinBookShadow').classList.remove('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('singleWidth');
        document.querySelector('.stf__marcinBookShadow').style.right = '0px';
        document.querySelector('.stf__marcinBookShadow').style.left = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
      } else if (this.app.getCurrentPageIndex() >= this.app.getPageCount() - 1) {
        document.querySelector('.stf__marcinBookShadow').classList.remove('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('singleWidth');
        document.querySelector('.stf__marcinBookShadow').style.left = '0px';
        document.querySelector('.stf__marcinBookShadow').style.right = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
        document.querySelector('.Book__innerChild').style.transform = 'translateX(25%)';
      } else {
        document.querySelector('.stf__marcinBookShadow').classList.remove('singleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').style.right = '0px';
        document.querySelector('.stf__marcinBookShadow').style.left = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
        document.querySelector('.Book__innerChild').style.transform = 'translateX(0%)';
        document.querySelector('.Book__navPrevPage.arrows-relative').style.left = '0';
        document.querySelector('.Book__navNextPage.arrows-relative').style.right = '0';
      }
    }

    drawFrame() {
      this.clear();
      this.drawParent();
      this.drawLeftPage();
      this.drawRightPage();
      this.drawBottomPage(); // te 4 0.3

      if (this.lastFrameFlippingPage === null && null !== this.flippingPage) {
        let direction = this.getDirection();

        /**
         * STRONY PODSPODEM PO CORNER ANIMATION
         */
        if (!this.app.flipController.checkState('fold_corner')) {
          let lP = this.leftPage ? parseInt(this.leftPage.element.page) : 0;
          let leftP = this.leftPage ? parseInt(this.leftPage.element.page / 2) : 0;
          let rightP = this.rightPage
            ? parseInt((this.setting.bookPages - this.rightPage.element.page) / 2)
            : 0;
        }

        if (forceOnePage && direction === 1) {
          APP.Book.getPage(this.app.getCurrentPageIndex(), function (PageObj) {
            let shadowsDiv = document.querySelector('.extraLeftFliped');
            shadowsDiv.style.display = 'block';
            let extraLeftFlipedBg = document.querySelector('.extraLeftFlipedBg');
            //extraLeftFlipedBg.style.backgroundImage = `url(${PageObj.getCover('p2483')}`;
            extraLeftFlipedBg.style.backgroundColor = `#ffffff`;
          });
        }
      }
      //58-59
      if (this.lastFrameFlippingPage && this.flippingPage === null) {
        document.getElementById('marcincrop2').hidden = true;
      }

      if (null !== this.flippingPage) {
        this.flippingPage.getElement().style.zIndex = 5;
        this.flippingPage.draw(false, 'fp');

        if (null !== this.shadow) {
          let direction = this.getDirection();
          let t = this.getRect();
          let angle = this.shadow.angle + 4.71238898; //3/2 pi
          let globalShadowPos = this.convertToGlobal(this.shadow.pos);

          if (!is_mobile()) {
            if (this.isSafari()) {
              this.drawInnerShadowSafari(); //SAFARI
            } else {
              this.drawInnerShadow(direction, t, angle); //CHROME
            }

            if (this.app.flipController.initialAction === 'fold') {
              this.drawOuterShadow(direction, t, angle, globalShadowPos); //30-31
              this.drawUnderShadow(direction, t, angle, globalShadowPos); //21-24
            }
          }
        }
      } else {
        this.underShadow.parentElement.style.left = `0px`;
      }

      this.lastFrameFlippingPage = this.flippingPage;
    }

    clear() {
      for (const t of this.app.getPageCollection().getPages())
        t !== this.leftPage &&
          t !== this.rightPage &&
          t !== this.flippingPage &&
          t !== this.bottomPage &&
          (t.getElement().style.cssText = 'display: none'),
          t.getTemporaryCopy() !== this.flippingPage && t.hideTemporaryCopy();
    }
    update() {
      super.update(),
        null !== this.rightPage && this.rightPage.setOrientation(1),
        null !== this.leftPage && this.leftPage.setOrientation(0);
    }
  }
  class x {
    constructor() {
      this._default = {
        startPage: 0,
        size: 'fixed',
        width: 0,
        height: 0,
        minWidth: 0,
        maxWidth: 0,
        minHeight: 0,
        maxHeight: 0,
        drawShadow: !0,
        flippingTime: 1e3,
        usePortrait: !0,
        startZIndex: 0,
        autoSize: !0,
        maxShadowOpacity: 1,
        showCover: !1,
        mobileScrollSupport: !0,
        swipeDistance: 30,
        clickEventForward: !0,
        useMouseEvents: !0,
        showShadowOnMobile: true,
      };
    }
    getSettings(t) {
      const e = this._default;
      if ((Object.assign(e, t), 'stretch' !== e.size && 'fixed' !== e.size))
        throw new Error('Invalid size type. Available only "fixed" and "stretch" value');
      if (e.width <= 0 || e.height <= 0) throw new Error('Invalid width or height');
      if (e.flippingTime <= 0) throw new Error('Invalid flipping time');
      return (
        'stretch' === e.size
          ? (e.minWidth <= 0 && (e.minWidth = 100),
            e.maxWidth < e.minWidth && (e.maxWidth = 2e3),
            e.minHeight <= 0 && (e.minHeight = 100),
            e.maxHeight < e.minHeight && (e.maxHeight = 2e3))
          : ((e.minWidth = e.width),
            (e.maxWidth = e.width),
            (e.minHeight = e.height),
            (e.maxHeight = e.height)),
        e
      );
    }
  }
  !(function (t, e) {
    void 0 === e && (e = {});
    var i = e.insertAt;
    if (t && 'undefined' != typeof document) {
      var s = document.head || document.getElementsByTagName('head')[0],
        n = document.createElement('style');
      (n.type = 'text/css'),
        'top' === i && s.firstChild ? s.insertBefore(n, s.firstChild) : s.appendChild(n),
        n.styleSheet ? (n.styleSheet.cssText = t) : n.appendChild(document.createTextNode(t));
    }
  })(
    '.stf__parent {\n  position: relative;\n  display: block;\n  box-sizing: border-box;\n  transform: translateZ(0);\n\n  -ms-touch-action: pan-y;\n  touch-action: pan-y;\n}\n\n.sft__wrapper {\n  position: relative;\n  width: 100%;\n  box-sizing: border-box;\n}\n\n.stf__block {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  box-sizing: border-box;\n  perspective: 2000px;\n z-index: 2;\n}\n\n.stf__item {\n  display: none;\n  position: absolute;\n  }\n\n.stf__outerShadow {\n  position: absolute;\n  left: 0;\n  top: 0; z-index: 10;\n}\n\n.stf__innerShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}\n\n.stf__underShadow {\n  position: absolute;\n  left: 0;\n  z-index:3;\n top: 0;\n}\n\n.stf__hardShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}\n\n.stf__hardInnerShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}',
  );
  (t.PageFlip = class extends (
    class {
      constructor() {
        this.events = new Map();
      }
      on(t, e) {
        return this.events.has(t) ? this.events.get(t).push(e) : this.events.set(t, [e]), this;
      }
      off(t) {
        this.events.delete(t);
      }
      trigger(t, e, i = null) {
        if (this.events.has(t)) for (const s of this.events.get(t)) s({ data: i, object: e });
      }
    }
  ) {
    constructor(t, e) {
      super(),
        (this.isUserTouch = !1),
        (this.isZoomed = false),
        (this.isUserMove = !1),
        (this.setting = null),
        (this.pages = null),
        (this.setting = new x().getSettings(e)),
        (this.block = t);
    }
    destroy() {
      this.ui.destroy(), this.block.remove();
    }
    update() {
      this.render.update(), this.pages.show();
    }

    loadFromHTML(t) {
      (this.ui = new c(this.block, this, this.setting, t)),
        (this.render = new w(this, this.setting, this.ui.getDistElement())),
        (this.flipController = new g(this.render, this)),
        (this.pages = new a(this, this.render, this.ui.getDistElement(), t)),
        this.pages.load(),
        this.render.start(),
        this.pages.show(this.setting.startPage -1),
        setTimeout(() => {
          this.ui.update(),
            this.trigger('init', this, {
              page: this.setting.startPage -1,
              mode: this.render.getOrientation(),
            });
        }, 1);
    }
    updateFromImages(t) {
      const e = this.pages.getCurrentPageIndex();
      this.pages.destroy(),
        (this.pages = new n(this, this.render, t)),
        this.pages.load(),
        this.pages.show(e),
        this.trigger('update', this, {
          page: e,
          mode: this.render.getOrientation(),
        });
    }
    updateFromHtml(t) {
      const e = this.pages.getCurrentPageIndex();
      this.pages.destroy(),
        (this.pages = new a(this, this.render, this.ui.getDistElement(), t)),
        this.pages.load(),
        this.ui.updateItems(t),
        this.pages.show(e),
        this.trigger('update', this, {
          page: e,
          mode: this.render.getOrientation(),
        });
    }
    turnToPrevPage() {
      this.pages.showPrev();
    }
    turnToNextPage() {
      this.pages.showNext();
    }
    turnToPage(t) {
      //never called
      this.pages.show(t);
    }
    showCorner() {
      this.flipController.showCorner({ x: 1116, y: 1 });
    }
    flipNext(t = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipNext(t);
    }
    flipPrev(t = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipPrev(t);
    }
    flip(t, e = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipToPage(t, e);
    }
    updateState(t) {
      this.trigger('changeState', this, t);
    }
    updatePageIndex(t) {
      this.trigger('flip', this, t);
    }
    updateOrientation(t) {
      this.ui.setOrientationStyle(t), this.update(), this.trigger('changeOrientation', this, t);
    }
    getPageCount() {
      return this.pages.getPageCount();
    }
    getCurrentPageIndex() {
      return this.pages.getCurrentPageIndex();
    }
    getPage(t) {
      return this.pages.getPage(t);
    }
    getRender() {
      return this.render;
    }
    getFlipController() {
      return this.flipController;
    }
    getOrientation() {
      return this.render.getOrientation();
    }
    getBoundsRect() {
      return this.render.getRect();
    }
    getSettings() {
      return this.setting;
    }
    getUI() {
      return this.ui;
    }
    getState() {
      return this.flipController.getState();
    }
    getPageCollection() {
      return this.pages;
    }
    setSettings(w, h) {
      let settings = this.setting;
      settings.minHeight = h;
      settings.minWidth = w;
      settings.width = w;
      settings.height = h;
      this.update();
    }
    startUserTouch(t) {
      if (!this.isBookZoomed()) {
        (this.mousePosition = t), (this.isUserTouch = !0), (this.isUserMove = !1);
      }
    }
    userMove(t, e) {
      if (!this.isBookZoomed()) {
        if ('portrait' === this.render.getOrientation()) {
          let bookWidth = document.querySelector('.stf__parent').style.width;
          let paddingWidth = (window.innerWidth - parseFloat(bookWidth)) / 2;
          (this.isUserTouch || e) &&
          this.mousePosition &&
          (this.mousePosition.x < paddingWidth + 50 ||
            this.mousePosition.x > parseFloat(bookWidth) - 50)
            ? this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition))
            : this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition));
        } else {
          this.isUserTouch || e
            ? this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition))
            : '';
        }
      }
    }
    userStop(t, e = !1) {
      if (!this.isBookZoomed()) {

        this.isUserTouch &&
          ((this.isUserTouch = !1), e || (this.isUserMove ? this.flipController.stopMove() : ''));
      } else {
        this.isUserTouch = !1;
      }
    }
    bookZoom(isZoomed) {
      this.isZoomed = isZoomed;
    }
    isBookZoomed() {
      return this.isZoomed;
    }
    setZoom() {
      this.isZoomed = true;
    }
  }),
    Object.defineProperty(t, '__esModule', { value: !0 });
});
