!(function (t, e) {
  'object' == typeof exports && 'undefined' != typeof module
    ? e(exports)
    : 'function' == typeof define && define.amd
    ? define(['exports'], e)
    : e(((t = t || self).StRtl = {}));
})(this, function (t) {
  'use strict';
  // Page
  class e {
    constructor(t, e) {
      (this.state = {
        angle: 0,
        area: [],
        position: { x: 0, y: 0 },
        hardAngle: 0,
        hardDrawingAngle: 0,
        bottomPage: false,
      }),
        (this.odblaskDiv = null),
        (this.odblaskDiv2 = null),
        (this.createdDensity = e),
        (this.nowDrawingDensity = this.createdDensity),
        (this.render = t);   
    }
    setDensity(t) {
      (this.createdDensity = t), (this.nowDrawingDensity = t);
    }
    setTemporaryDensity(density) {
      if (this.nowDrawingDensity === density) {
        return;
      }

      this.element.dataset.density = density;
      this.setDrawingDensity(density);
    }
    restoreOriginalDensity() {
      if (this.nowDrawingDensity === this.getDensity()) {
        return;
      }
      
      this.element.dataset.density = this.getDensity();
      this.setDrawingDensity(this.getDensity());
    }
    setDrawingDensity(t) {
      this.nowDrawingDensity = t;
    }
    setPosition(t, from) {
      this.state.position = t;
    }
    setAngle(t) {
      this.state.angle = t;
    }
    setFlipAngle(t) {
      this.state.flipangle = t;
    }
    setOdblask() {
      if (forceOnePage) {
        this.odblaskDiv = document.querySelector('#marcincrop2 .odblask');
      } else {
        this.odblaskDiv = this.element.querySelector('.odblask');
      }
    }
    setArea(t) {
      this.state.area = t;
    }
    setHardDrawingAngle(t) {
      this.state.hardDrawingAngle = t;
    }
    setHardAngle(t) {
      (this.state.hardAngle = t), (this.state.hardDrawingAngle = t);
    }
    setOrientation(t) {
      this.orientation = t;
    }
    getDrawingDensity() {
      return this.nowDrawingDensity;
    }
    getDensity() {
      return this.createdDensity;
    }
    getHardAngle() {
      return this.state.hardAngle;
    }
  }

  // ImagePage
  class i extends e {
    constructor(t, e, i) {
      super(t, i),
        (this.image = null),
        (this.isLoad = !1),
        (this.loadingAngle = 0),
        (this.image = new Image()),
        (this.image.src = e);
    }
    draw(t) {
      const e = this.render.getContext(),
        i = this.render.convertToGlobal(this.state.position),
        s = this.render.getRect().pageWidth,
        n = this.render.getRect().height;
      e.save(), e.translate(i.x, i.y), e.beginPath();
      for (let t of this.state.area)
        null !== t && ((t = this.render.convertToGlobal(t)), e.lineTo(t.x - i.x, t.y - i.y));
      e.rotate(this.state.angle),
        e.clip(),
        this.isLoad
          ? e.drawImage(this.image, 0, 0, s, n)
          : this.drawLoader(e, { x: 0, y: 0 }, s, n),
        e.restore();
    }
    simpleDraw(t) {
      const e = this.render.getRect(),
        i = this.render.getContext(),
        s = e.pageWidth,
        n = e.height,
        h = 1 === t ? e.left + e.pageWidth : e.left,
        o = e.top;
      this.isLoad ? i.drawImage(this.image, h, o, s, n) : this.drawLoader(i, { x: h, y: o }, s, n);
    }
    drawLoader(t, e, i, s) {
      t.beginPath(),
        (t.strokeStyle = 'rgb(200, 200, 200)'),
        (t.fillStyle = 'rgb(255, 255, 255)'),
        (t.lineWidth = 1),
        t.rect(e.x + 1, e.y + 1, i - 1, s - 1),
        t.stroke(),
        t.fill();
      const n = { x: e.x + i / 2, y: e.y + s / 2 };
      t.beginPath(),
        (t.lineWidth = 10),
        t.arc(n.x, n.y, 20, this.loadingAngle, (3 * Math.PI) / 2 + this.loadingAngle),
        t.stroke(),
        t.closePath(),
        (this.loadingAngle += 0.07),
        this.loadingAngle >= 2 * Math.PI && (this.loadingAngle = 0);
    }
    load() {
      this.isLoad ||
        (this.image.onload = () => {
          this.isLoad = !0;
        });
    }
    newTemporaryCopy() {
      return this;
    }
    getTemporaryCopy() {
      return this;
    }
    hideTemporaryCopy() {}
  }

  // PageCollection
  class s {
    constructor(t, e) {
      (this.pages = []),
        (this.currentPageIndex = 0),
        (this.currentSpreadIndex = 0),
        (this.prevSpreadIndex = null),
        (this.landscapeSpread = []),
        (this.portraitSpread = []),
        (this.render = e),
        (this.app = t),
        (this.currentPageIndex = 0),
        (this.isShowCover = this.app.getSettings().showCover);
    }
    destroy() {
      this.pages = [];
    }
    createSpread() {
      (this.landscapeSpread = []), (this.portraitSpread = []);
      for (let t = 0; t < this.pages.length; t++) this.portraitSpread.push([t]);
      this.portraitSpread = this.portraitSpread.reverse()
      let t = 0;
      const density = this.pages[0].getDensity(); // 'hard'
      this.isShowCover && (this.pages[0].setDensity(density), this.landscapeSpread.push([t]), t++);
      for (let e = t; e < this.pages.length; e += 2)
        e < this.pages.length - 1
          ? this.landscapeSpread.push([e, e + 1])
          : (this.landscapeSpread.push([e]), this.pages[e].setDensity(density));
      this.landscapeSpread = this.landscapeSpread.reverse();
      this.landscapeSpread.forEach(spread => spread.reverse());
    }
    updateDensityByBookMode() {
      const evenNumberOfPages = this.app.setting.bookPages % 2 == 0;
      const hardCoverMode = this.app.setting.hardCoverMode;

      for (let t = 0; t < this.pages.length; t++) {
        if (!hardCoverMode) {
          this.pages[t].element.dataset.density = 'soft';
          this.pages[t].element.classList.add('--soft1');
          this.pages[t].setDensity('soft');

          continue;
        }

        if (this.render.getOrientation() === 'landscape') {
          if (t === this.pages.length - 1 && !evenNumberOfPages) {
            continue;
          }

          if (t === 0 || t === 1 || t === this.pages.length - 1 || (t === this.pages.length - 2 && evenNumberOfPages)) {
            this.pages[t].element.dataset.density = 'hard';
            this.pages[t].element.classList.add('--hard');
            this.pages[t].setDensity('hard');

            continue;
          }
        }

        if (this.render.getOrientation() === 'portrait' || forceOnePage) {
          if (t === 0) { // || t === this.pages.length - 1
            this.pages[t].element.dataset.density = 'hard';
            this.pages[t].element.classList.add('--hard');
            this.pages[t].setDensity('hard');

            continue;
          }
        }

        this.pages[t].element.dataset.density = 'soft';
        this.pages[t].element.classList.add('--soft');
        this.pages[t].setDensity('soft');
      }
    }
    changePagesDensity(density) {
      const evenNumberOfPages = this.app.setting.bookPages % 2 == 0;
      const densityClassName = `--${density}`;

      for (let t = 0; t < this.pages.length; t++) {
        if (this.render.getOrientation() === 'landscape') {
          if (t === this.pages.length - 1 && !evenNumberOfPages) {
            continue;
          }

          if (t === 0 || t === 1 || t === this.pages.length - 1 || (t === this.pages.length - 2 && evenNumberOfPages)) {
            this.pages[t].element.dataset.density = density;
            this.pages[t].element.classList.add(densityClassName);
            this.pages[t].setDensity(density);
 
            continue;
          }
        }

        if (this.render.getOrientation() === 'portrait' || forceOnePage) {
          if (t === 0) { // || t === this.pages.length - 1
            this.pages[t].element.dataset.density = density;
            this.pages[t].element.classList.add(densityClassName);
            this.pages[t].setDensity(density);

            continue;
          }
        }

        this.pages[t].element.dataset.density = 'soft';
        this.pages[t].element.classList.add('--soft');
        this.pages[t].setDensity('soft');
      }
    }
    restorePagesOriginalDensity() {
      for (let i = 0; i < this.pages.length; i++) {
        this.pages[i].restoreOriginalDensity();
      }
    }
    getSpread() {
      return 'landscape' === this.render.getOrientation()
        ? this.landscapeSpread
        : this.portraitSpread;
    }
    getSpreadIndexByPage(t) {
      const e = this.getSpread();
      for (let i = 0; i < e.length; i++) if (t === e[i][0] || t === e[i][1]) return i;
      return null;
    }
    getSpreadBySpreadIndex(i) {
      return this.getSpread()[i];
    }
    getCurrentSpread(initiator = null) {
      const idx = this.currentSpreadIndex !== null && this.currentSpreadIndex !== undefined && initiator !== 'INIT'
        ? this.currentSpreadIndex 
        : (this.app.setting.startPage - 1);

      return this.getSpreadBySpreadIndex(idx);
    }

    isSideSpread(spread, direction) {
      const evenNumberOfPages = this.app.setting.bookPages % 2 == 0;
      const spreads = this.getSpread();
      direction = direction === null ? 1 : direction;

      if (spreads.length === 1) {
        return true;
      }

      const spreadIndex = spreads.findIndex(s => s === spread);

      if (spreadIndex <= 1 && evenNumberOfPages && spreadIndex < spreads.length - 2) {
        return {
          state: true,
          side: 'END'
        };
      }

      if (spreadIndex === (evenNumberOfPages ? 1 : 0) && spreadIndex === spreads.length - 2) {
        if (direction === 0) {
          return {
            state: true,
            side: 'START'
          };
        }

        return {
          state: true,
          side: 'END'
        };
      }

      if (spreadIndex >= spreads.length - 2) {
        return {
          state: true,
          side: 'START'
        };
      }

      return false;
    }
    getPageCount() {
      return this.pages.length;
    }
    getPages() {
      return this.pages;
    }
    getPage(t) {
      if (t >= 0 && t < this.pages.length) return this.pages[t];
      throw new Error('Invalid page number');
    }
    nextBy(t) {
      const e = this.pages.indexOf(t);
      return e < this.pages.length - 1 ? this.pages[e + 1] : null;
    }
    prevBy(t) {
      const e = this.pages.indexOf(t);
      return e > 0 ? this.pages[e - 1] : null;
    }
    getFlippingPage(t, canCreateCopy = true) {
      const spreads = this.getSpread();
      let e = this.currentSpreadIndex;

      if ('portrait' === this.render.getOrientation()) {
        e = (spreads.length - 1) - this.currentSpreadIndex;

        return 0 === t && canCreateCopy ? this.pages[Math.max(0, e - 1)].newTemporaryCopy() : this.pages[Math.min(this.pages.length - 1, e)].newTemporaryCopy();
        // return 0 === t && canCreateCopy ? this.pages[e].newTemporaryCopy() : this.pages[e - 1];
      } else {
        const i = 0 === t ? this.getSpread()[e + 1] : this.getSpread()[e - 1];
        return 1 === i.length || 0 === t ? this.pages[i[0]] : this.pages[i[1]];
      }
    }
    getFlippingSourcePage(destinationPage) {
      return this.render.direction === 0 ? this.nextBy(destinationPage) : this.prevBy(destinationPage);
      // return this.render.direction === 1 ? this.nextBy(destinationPage) : this.prevBy(destinationPage);
    }
    getBottomPage(t) {
      let e = this.currentSpreadIndex;
      if ('portrait' === this.render.getOrientation()) {
        e = this.pages.length - this.currentSpreadIndex - 1;
        return 0 === t ? this.pages[e - 1] : this.pages[e + 1];
      } else {
        const i = 0 === t ? this.getSpread()[e + 1] : this.getSpread()[e - 1];
        return 1 === i.length ? this.pages[i[0]] : 0 === t ? this.pages[i[1]] : this.pages[i[0]];
      }
    }
    getPageByNum(t, spread) {
      if ('landscape' === this.render.getOrientation()) {
        const i = this.getSpread()[spread];
        return 1 === i.length ? this.pages[i[0]] : 0 === t ? this.pages[i[1]] : this.pages[i[0]];
      }
    }
    showNext() {
      this.currentSpreadIndex + 1 < this.getSpread().length &&
        ((this.prevSpreadIndex = this.currentSpreadIndex),
        this.currentSpreadIndex++,
        this.showSpread());
    }
    showPrev() {
      this.currentSpreadIndex > 0 &&
        ((this.prevSpreadIndex = this.currentSpreadIndex),
        this.currentSpreadIndex--,
        this.showSpread());
    }
    getCurrentPageIndex() {
      return this.currentPageIndex;
    }
    show(t = null) {
      if ((null === t && (t = this.currentPageIndex), t < 0 || t >= this.pages.length)) return;
      const e = this.getSpreadIndexByPage(t);

      if (null !== e) {
        this.prevSpreadIndex = e; //this.currentPageIndex;//e;//this.currentPageIndex;//ta zmiana bo ianczje wesjcie na przedostatnia strone nie pozwalalo zmienic na ostatnia

        this.currentSpreadIndex = e;
        this.showSpread();
      }
    }
    getCurrentSpreadIndex() {
      return this.currentSpreadIndex;
    }
    getPrevSpreadIndex() {
      return this.prevSpreadIndex;
    }
    setCurrentSpreadIndex(t) {
      if (!(t >= 0 && t < this.getSpread().length)) throw new Error('Invalid page');
      this.prevSpreadIndex = this.currentSpreadIndex;
      this.currentSpreadIndex = t;
    }
    setPrevSpreadIndex(t) {
      if (!(t >= 0 && t < this.getSpread().length)) throw new Error('Invalid page');
      this.prevSpreadIndex = t;
    }
    showSpreadLandscapeAndLastMarcin() {}
    showSpread() {
      const t = this.getSpread()[this.currentSpreadIndex];
      
      if (this.pages.length === 1) {
        if (forceOnePage) {
          this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]]);
        } else {
          this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(null);
        }
      } else {
        if (2 === t.length) {
          (this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(this.pages[t[1]]))
        } else {
          if (forceOnePage || is_small_desktop_mode() || is_mobile()) {
            if (t[0] === 0) {
              'landscape' === this.render.getOrientation()
              ? (this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(null))
              : (this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]]));
            } else {
              (this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]]));
            }
          } else {
            'landscape' === this.render.getOrientation() && t[0] === this.pages.length - 1
            ? (this.render.setLeftPage(null), this.render.setRightPage(this.pages[t[0]]))
            : (this.render.setLeftPage(this.pages[t[0]]), this.render.setRightPage(null));
          }
        }

        (this.currentPageIndex = Math.min(...t)),
        this.app.updatePageIndex(this.currentPageIndex);
      }
    }
  }

  class n extends s {
    constructor(t, e, i) {
      super(t, e), (this.imagesHref = i);
    }
    load() {
      for (const t of this.imagesHref) {
        const e = new i(this.render, t, 'soft');
        e.load(), this.pages.push(e);
      }
      this.createSpread();
    }
  }
  class h {
    static GetDistanceBetweenTwoPoint(t, e) {
      return null === t || null === e
        ? 1 / 0
        : Math.sqrt(Math.pow(e.x - t.x, 2) + Math.pow(e.y - t.y, 2));
    }
    static GetSegmentLength(t) {
      return h.GetDistanceBetweenTwoPoint(t[0], t[1]);
    }
    static GetAngleBetweenTwoLine(t, e) {
      const i = t[0].y - t[1].y,
        s = e[0].y - e[1].y,
        n = t[1].x - t[0].x,
        h = e[1].x - e[0].x;
      return Math.acos((i * s + n * h) / (Math.sqrt(i * i + n * n) * Math.sqrt(s * s + h * h)));
    }
    static PointInRect(t, e) {
      return null === e
        ? null
        : e.x >= t.left && e.x <= t.width + t.left && e.y >= t.top && e.y <= t.top + t.height
        ? e
        : null;
    }
    static GetRotatedPoint(t, e, i) {
      return {
        x: t.x * Math.cos(i) + t.y * Math.sin(i) + e.x,
        y: t.y * Math.cos(i) - t.x * Math.sin(i) + e.y,
      };
    }
    static LimitPointToCircle(t, e, i) {
      if (h.GetDistanceBetweenTwoPoint(t, i) <= e) return i;
      const s = t.x,
        n = t.y,
        o = i.x,
        a = i.y;
      let r =
        Math.sqrt(
          (Math.pow(e, 2) * Math.pow(s - o, 2)) / (Math.pow(s - o, 2) + Math.pow(n - a, 2)),
        ) + s;
      i.x < 0 && (r *= -1);
      let g = ((r - s) * (n - a)) / (s - o) + n;
      return s - o + n === 0 && (g = e), { x: r, y: g };
    }
    static GetIntersectBetweenTwoSegment(t, e, i) {
      return h.PointInRect(t, h.GetIntersectBeetwenTwoLine(e, i));
    }
    static GetIntersectBeetwenTwoLine(t, e) {
      const i = t[0].y - t[1].y,
        s = e[0].y - e[1].y,
        n = t[1].x - t[0].x,
        h = e[1].x - e[0].x,
        o = t[0].x * t[1].y - t[1].x * t[0].y,
        a = e[0].x * e[1].y - e[1].x * e[0].y,
        r = i * a - s * o,
        g = n * a - h * o,
        l = -(o * h - a * n) / (i * h - s * n),
        d = -(i * a - s * o) / (i * h - s * n);
      if (isFinite(l) && isFinite(d)) return { x: l, y: d };
      if (Math.abs(r - g) < 0.1) throw new Error('Segment included');
      return null;
    }
    static GetCordsFromTwoPoint(t, e) {
      if (forceOnePage) {
        const roznicaX = Math.abs(t.x - e.x);
        var roznicaY = Math.abs(t.y - e.y);
        const n = Math.max(roznicaX, roznicaY);
        const h = [];
        function o(t, e, i, s, n) {
          return e > t ? t + n * (i / s) : e < t ? t - n * (i / s) : t;
        }

        let fullanim = false;
        if (roznicaY <= 1) {
          fullanim = true;
          roznicaY = t.y / -10;
        }
        const roznicaYC = roznicaY;

        for (let a = 1; a <= n; ) {
          if (a >= n / 2 && fullanim) {
            var mult = n / a - 1;
            roznicaY = roznicaYC * mult;
          }
          let y = o(t.y, e.y, roznicaY, n, a);
          h.push({ x: o(t.x, e.x, roznicaX, n, a), y: y }); //-0.25*o
          a += 0.5;
        }

        h.push(e);
        return h;
      } else {
        return this.GetCordsFromTwoPointOld(t, e);
      }
    }

    static GetCordsFromTwoPointOld(t, e) {
      const i = Math.abs(t.x - e.x),
        s = Math.abs(t.y - e.y),
        n = Math.max(i, s),
        h = [t];
      function o(t, e, i, s, n) {
        return e > t ? t + n * (i / s) : e < t ? t - n * (i / s) : t;
      }

      for (let a = 1; a <= n; a += 1) {
        h.push({ x: o(t.x, e.x, i, n, a), y: o(t.y, e.y, s, n, a) });
      }

      return h;
    }
  }

  // HTMLPage
  class o extends e {
    constructor(t, e, i) {
      super(t, i),
        (this.copiedElement = null),
        (this.temporaryCopy = null),
        (this.isLoad = !1),
        (this.element = e),
        this.element.classList.add('stf__item'),
        this.element.classList.add('--' + i);
    }
    newTemporaryCopy() {
      return 'hard' === this.nowDrawingDensity
        ? this
        : (null === this.temporaryCopy &&
            ((this.copiedElement = this.element.cloneNode(!0)),
            this.element.parentElement.appendChild(this.copiedElement),
            (this.temporaryCopy = new o(this.render, this.copiedElement, this.nowDrawingDensity))),
          this.getTemporaryCopy());
    }
    getTemporaryCopy() {
      return this.temporaryCopy;
    }
    hideTemporaryCopy() {
      null !== this.temporaryCopy &&
        (this.copiedElement.remove(), (this.copiedElement = null), (this.temporaryCopy = null));
    }

    isLastPage() {
      // return this.element.page === 1;
      return this.element.page === this.render.setting.bookPages;
    }

    draw(t, warstwa) {
      const isLastPage = this.isLastPage();
      const isFirstPage = this.element.page == 1;

      const density = t || this.nowDrawingDensity;
      const i = this.render.convertToGlobal(this.state.position),
        s = this.render.getRect().pageWidth,
        n = this.render.getRect().height;
      this.element.classList.remove('--simple');
      let left = density === 'clipping' && this.render.getDirection() === 0 ? `${s}px` : '0px';

      if (this.render.getOrientation() == 'portrait' && (forceOnePage || is_mobile() || is_small_desktop_mode())) {
        left = `${0}px`;
      }

      let styles = {
        display: 'block',
        'z-index': this.element.style.zIndex,
        left: left,
        top: '0px',
        width: `${s}px`,
        height: `${n}px`
      };

      // let h = `
      //   display: block;
      //   z-index: ${this.element.style.zIndex};
      //   left: ${left};
      //   top: 0px;
      //   width: ${s}px;
      //   height: ${n}px;
      // `; //w trakcie

      if (this.render.setting.hardCoverMode && this.isSidePage(t)) {
        let top = -this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT / 2;
        let left = density === 'clipping' && this.render.getDirection() === 0 ? s : 0;
        let width = s + this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;
        let height = n + this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT;
        let lastPageOffset = this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;

        if (isLastPage) {
          if ((forceOnePage || this.render.getOrientation() === 'portrait') || (Number(this.render.setting.bookPages) % 2 === 1)) {
            top = 0;
            width = s;
            height = n;
          }
        }

        styles = {
          ...styles,
          left: `${left - (isFirstPage ? lastPageOffset : 0)}px`,
          top: `${top}px`,
          width: `${width}px`,
          height: `${height}px`
        };

        // h = `
        //   display: block;
        //   z-index: ${this.element.style.zIndex};
        //   left: ${left - (isLastPage ? this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : 0)}px;
        //   top: ${top}px;
        //   width: ${width}px;
        //   height: ${height}px;
        // `;
      }

      if ('hard' === density) this.drawHard(styles);
      if ('soft' === density) this.drawSoft(i, styles, warstwa);
      if ('clipping' === density) this.clippingDraw(styles);
    }

    drawSoftCrop_4punkty(op) {
      //CROP DIV - OK

      let pageWidth = this.render.getRect().pageWidth;
      let pageHeight = this.render.getRect().height;
      let przekatna = Math.ceil(Math.sqrt(pageHeight * pageHeight + pageWidth * pageWidth));
      let przesuniecie_pion = pageHeight;
      let trans_x = przekatna - this.state.area[1].x;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      document.getElementById('marcincrop2').style.cssText = `width: ${przekatna}px;height: ${
        2 * przesuniecie_pion + pageHeight
      }px;
            top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x + pageWidth}px, 0px, 0) rotate(${
        this.state.flipangle
      }rad);opacity: 1.0;`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let ab = pageWidth - this.state.area[1].x;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);

      if (this.state.area[0].x > this.state.area[3].x) {
        //dolny prowadzi
        bb = bb * -1;
      }

      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma'); //lewa pozioma
      marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
      marcin_leftPage_insidecrop2.style.transform = `translate3d(${cc}px, ${bb}px, 0) rotate(-${this.state.flipangle}rad)`;
      marcin_leftPage_insidecrop2.style.opacity = op;

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
      marcin_zagiecie.style.height = `${pageHeight}px`;
      marcin_zagiecie.style.width = `${pageWidth}px`;
      marcin_zagiecie.style.transformOrigin = `0% 0%`;
      marcin_zagiecie.style.willChange = `transform`;
      marcin_zagiecie.style.transform = `translate3d(${przekatna - cc}px, ${bb}px, 0) rotate(${
        this.state.flipangle
      }rad)`;
      marcin_zagiecie.style.opacity = op;

      //odblask
      let ciegnoprowadzace = h.GetDistanceBetweenTwoPoint(this.state.area[0], this.state.area[1]);
      let ciegnoawaryjne = 0;
      if (this.state.area[0].x > this.state.area[3].x) {
        //dolny prowadzi
        ciegnoawaryjne = ciegnoprowadzace;
        ciegnoprowadzace = h.GetDistanceBetweenTwoPoint(this.state.area[3], this.state.area[2]);
        let extrah = this.render.getRect().height;
        if (this.odblaskDiv && !is_mobile()) {
          this.odblaskDiv.classList.add('fliped');

          let odblaskw = ciegnoprowadzace;
          let bbb = odblaskw / Math.cos(this.state.flipangle);

          this.odblaskDiv.style.cssText = `
                 transform-origin: ${0}px ${this.render.getRect().height}px;
                left: 0px; display: block; 
                height: ${przekatna + extrah}px;width: ${odblaskw}px;background-size: ${odblaskw}px;
                transform: translate3d(${0}px, -${0}px, 0) rotate(${-this.state
            .flipangle}rad); z-index: 10; ${forceOnePage ? 'display: none;' : ''}`;
        }
      } else {
        let extrah = this.render.getRect().height;
        if (this.odblaskDiv) {
          this.odblaskDiv.classList.add('fliped');

          let odblaskw = ciegnoprowadzace;
          let bbb = odblaskw / Math.cos(this.state.flipangle);
          let opacity = is_mobile() || is_small_desktop_mode() ? `opacity: ${1 - odblaskw / pageWidth + 0.5};` : '';

          this.odblaskDiv.style.cssText = `
                 transform-origin: 0px ${extrah}px;
                left: 0px; display: block; 
                height: ${przekatna + extrah}px;width: ${odblaskw}px;background-size: ${odblaskw}px;
                transform: translate3d(${odblaskw - bbb}px, -${extrah}px, 0) rotate(${-this.state
            .flipangle}rad); z-index: 10; ${forceOnePage ? 'display: none;' : ''} ${opacity}`;
        }
      }
    }

    drawSoftCrop_3punkty_top(op) {
      let pageWidth = this.render.getRect().pageWidth;
      let pageHeight = this.render.getRect().height;
      let przekatna = Math.ceil(Math.sqrt(pageHeight * pageHeight + pageWidth * pageWidth));
      let przesuniecie_pion = 2 * pageHeight;
      let fb_maskh = 2 * przesuniecie_pion + pageHeight;
      let trans_x = przekatna - pageWidth;
      let trans_y = this.state.area[2].y;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      let marcin_crop2 = document.getElementById('marcincrop2');
      marcin_crop2.style.cssText = `width: ${przekatna}px;height: ${fb_maskh}px; 
            top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x + pageWidth}px, ${trans_y}px, 0) rotate(${
        this.state.flipangle
      }rad);`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma');
      let ab = trans_y;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);
      
      if (marcin_leftPage_insidecrop2) {
        marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
        marcin_leftPage_insidecrop2.style.transform = `translate3d(${bb}px, -${cc}px, 0) rotate(-${this.state.flipangle}rad)`;
        marcin_leftPage_insidecrop2.style.opacity = '0';
      }

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      let _ab = pageHeight - trans_y;
      let _cc = Math.abs(Math.cos(this.state.flipangle) * _ab);
      let _bb = Math.abs(Math.sin(this.state.flipangle) * _ab);

      if (marcin_zagiecie) {
        marcin_zagiecie.style.transform = `translate3d(${przekatna + _bb}px, -${
          pageHeight - _cc
        }px, 0) rotate(${this.state.flipangle}rad)`;
        marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
        marcin_zagiecie.style.height = `${pageHeight}px`;
        marcin_zagiecie.style.width = `${pageWidth}px`;
        marcin_zagiecie.style.transformOrigin = `0% 100%`;
        marcin_zagiecie.style.willChange = `transform`;
      }

      let extrah = this.render.getRect().height;
      if (this.odblaskDiv && !is_mobile()) {
        // this.odblaskDiv.classList.add('fliped');
        this.odblaskDiv.style.cssText = `
             transform-origin: 0px ${extrah}px;
            left: 0px; display: block;  
            height: ${przekatna + extrah}px;width: ${bb}px;background-size: ${bb}px;
            transform: translate3d(${0}px, -${extrah}px, 0) rotate(${-this.state
          .flipangle}rad); z-index: 10; ${forceOnePage ? 'display: none;' : ''}`;
      }
    }

    drawSoftCrop_3punkty_bottom(op) {
      let pageWidth = this.render.getRect().pageWidth;
      let pageHeight = this.render.getRect().height;
      let przekatna = Math.ceil(
        Math.sqrt(
          pageHeight * pageHeight +
            pageWidth * pageWidth,
        ),
      );
      let przesuniecie_pion = pageHeight;
      let fb_maskh = 2 * przesuniecie_pion + pageHeight;
      let trans_x = przekatna - pageWidth;
      let trans_y = this.state.area[2].y;

      //modyfikacja kontenera - maski tnacej lewa kartke i zagiecie
      let marcin_crop2 = document.getElementById('marcincrop2');
      marcin_crop2.style.cssText = `width: ${przekatna}px;height: ${fb_maskh}px;top: -${przesuniecie_pion}px;transform-origin: 100% ${przesuniecie_pion}px;
            transform: translate3d(${-trans_x + pageWidth}px, ${trans_y}px, 0) rotate(${
        this.state.flipangle
      }rad);`;

      //MODYFIKACJA LEWEJ STRONY CIETEJ
      let marcin_leftPage_insidecrop2 = document.getElementById('lewapozioma');
      let ab = trans_y;
      let cc = Math.abs(Math.cos(this.state.flipangle) * ab);
      let bb = Math.abs(Math.sin(this.state.flipangle) * ab);
      marcin_leftPage_insidecrop2.style.top = `${przesuniecie_pion}px`;
      marcin_leftPage_insidecrop2.style.transform = `translate3d(-${bb}px, -${cc}px, 0) rotate(-${this.state.flipangle}rad)`;

      //modyfikacja zagiecia
      let marcin_zagiecie = document.getElementById('marcincrop2').firstChild;
      let _ab = pageHeight - trans_y;
      let _cc = Math.abs(Math.cos(this.state.flipangle) * _ab);
      let _bb = Math.abs(Math.sin(this.state.flipangle) * _ab);

      marcin_zagiecie.style.transform = `translate3d(${przekatna - _bb}px, -${
        pageHeight - _cc
      }px, 0) rotate(${this.state.flipangle}rad)`;
      marcin_zagiecie.style.top = `${przesuniecie_pion}px`;
      marcin_zagiecie.style.height = `${pageHeight}px`;
      marcin_zagiecie.style.width = `${pageWidth}px`;
      marcin_zagiecie.style.transformOrigin = `0% 100%`;
      marcin_zagiecie.style.willChange = `transform`;

      //odblask
      let extrah = pageHeight;

      if (this.odblaskDiv && !is_mobile()) {
        this.odblaskDiv.classList.add('fliped');
        this.odblaskDiv.style.cssText = `
             transform-origin: 0px ${pageHeight}px;
            left: 0px; display: block;  
            height: ${przekatna + extrah}px;width: ${_bb}px;background-size: ${_bb}px;
            transform: translate3d(${0}px, ${0}px, 0) rotate(${-this.state
          .flipangle}rad); z-index: 10; ${forceOnePage ? 'display: none;' : ''}`;
      }
    }

    drawSoftCrop( op ) {
      this.setFlipAngle(this.render.shadow.angle + 4.71238898);

      if (this.state.area[1] !== null && this.state.area[3] !== null) {
        //4 punkty prawy dolny rog
        this.drawSoftCrop_4punkty(op);
      } else if (
        this.state.area[2] !== null &&
        this.state.area[3] !== null &&
        this.state.area[4] !== null
      ) {
        //3 punkty prawy dolny rog
        this.drawSoftCrop_3punkty_bottom(op);
      } else {
        this.drawSoftCrop_3punkty_top(op);
      }
    }

    drawSoft_warstwaFlip_clipPathOld(i, op, e, t) {
      this.element.style.cssText =
        e +
        `transform-origin: 0 0; clip-path: ${i};-webkit-clip-path: ${i};${op};` +
        (this.render.isSafari() && 0 === this.state.angle
          ? `transform: translate(${t.x}px, ${t.y}px);`
          : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
    }

    drawSoft_mobile_new(t, e = '', warstwa = '?', portrait = true) {
      var op = 'opacity: 1.0';
      var clip = ``;

      if (warstwa === 'fp') {
        //to tylko przy 1 klatce i tylko forconepage  albo portrait
        if (
          this.element.children &&
          !this.element.getAttribute('extraLayer') &&
          (forceOnePage || portrait)
        ) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());

          if (this.render.getDirection() === 0) {
            document.getElementById('marcincrop2').hidden = false;
            pageNum = pageNum;

            let _this = this;
            APP.Book.getPage(pageNum, function (PageObj) {
              _this.element.setAttribute('extraLayer', 'yes');
              extraLayer.style.cssText = `background-image:url(${PageObj.getCover('p533')});`;
              extraLayer.style.filter = 'blur(0px)';
              extraLayer.style.transform = 'scaleX(1)';
              extraLayer.style.width = '100%';
              extraLayer.style.height = '100%';
              extraLayer.style.top = '0';
              extraLayer.style.left = '0';
              extraLayer.className = 'blured1 --left --single';
              _this.element.appendChild(extraLayer);
              _this.element.appendChild(odblaskExtra);
              _this.element.id = 'marcin_corner';
              document.getElementById('marcincrop2').innerHTML = '';
              document.getElementById('marcincrop2').appendChild(_this.element);
              
              let cloneBottom = _this.render.flippingPage.element.cloneNode();
              cloneBottom.id = 'cloneBottom';
              cloneBottom.classList.add('back');
              cloneBottom.classList.add('--left');

              if (!APP.Book.getBookModelSettings().show_shadow_inside) {
                cloneBottom.classList.add('hideshadow');
              }

              cloneBottom.id = 'lewapozioma';
              cloneBottom.style.zIndex = '3';
              cloneBottom.style.left = 'unset';
              cloneBottom.style.bottom = 'unset';

              if (PageObj.getPage()) {
                cloneBottom.style.backgroundImage = PageObj.getPage().raster.style.backgroundImage;
              }
              document.getElementById('marcincrop2').appendChild(cloneBottom);
              // cloneBottom.appendChild(_this.render.underShadow);
              _this.element.style.display = 'block';
            });
          }
        }

        if (this.render.getDirection() === 0) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;

          let i = `polygon(0 0, ${x1}px 0, ${x2}px ${this.state.area[3] ? '100%' : this.render.getRect().pageWidth + x1 +'px'}, ${x2}px 100%, 0 100%)`; //lewa strona
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej

          let op = (1.0 - (x1 + x2) / 2 / this.render.getRect().pageWidth) * 2;
          // op = `opacity: ${opval}`;
          extraLeftFliped.style.cssText = extraLeftFliped.style.cssText + clip + op;
          extraLeftFliped.style.right = '-100%';

          this.drawSoftCrop(op);
        } else {
          op =
        this.render.shadow.progress > 175 ? `${(200 - this.render.shadow.progress) / 25}` : 1.0;

          if (!this.element.querySelector('.cover-div')) {
            const coverDiv = document.createElement('div');
            coverDiv.className = 'cover-div';
            
            // filter: blur(24px);
            coverDiv.style.cssText = `
              background-repeat: no-repeat; 
              background-size: cover; 
              width: 100%; 
              height: 100%; 
              transform: scaleX(-1); 
              top: 0;
              left: 0;
              position: fixed;`;
              
            this.element.appendChild(coverDiv);
  
            APP.Book.getPage(Number(this.render.app.getCurrentPageIndex()) + 1, function (PageObj) {
              const bgImage = PageObj.getBlured();
              
              coverDiv.style.backgroundImage = `url(${bgImage})`;

              if (bgImage.indexOf('_400.') !== -1) {
                coverDiv.style.width = 'calc(100% + 48px)';
                coverDiv.style.height = 'calc(100% + 48px)';
                coverDiv.style.filter = 'blur(24px)';
                coverDiv.style.top = '-14px';
                coverDiv.style.left = '-14px';
              }
            });
          }
          else{
            this.element.querySelector('.cover-div').style.opacity = op; 
          }

          // if (!this.element.querySelector('.odblask')) {
          //   const odblask = document.createElement('div');
          //   odblask.className = 'odblask';
          //   this.element.appendChild(odblask);
          // }
        }
      }

      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa !== 'fp') {
        if (this.render.getDirection() === 0 && forceOnePage && !is_mobile()) {
          this.element.style.cssText = e + `opacity: ${op}`;
        } else {

          // transform-origin: 0 0; 
          this.element.style.cssText =
            e +
            `opacity: ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
            (this.render.isSafari() && 0 === this.state.angle
              ? `transform: translate(${t.x}px, ${t.y}px);`
              : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
        }
      } else {
        if (this.render.getDirection() === 0 && (forceOnePage || portrait)) {
        
        } else {
          this.drawSoft_warstwaFlip_clipPathOld(i, `opacity: ${op}`, e, t);
          let pageDivThatIschangedToNewOne = document.querySelector(`div.Page[page="${Number(this.render.app.getCurrentPageIndex())+1}"]`);
          if( pageDivThatIschangedToNewOne ){
            pageDivThatIschangedToNewOne.style.opacity = op;
          }
        }
      }
    }

    drawSoft_mobile(t, e = '', warstwa = '?') {
      var op = 'opacity: 1.0';
      var clip = ``;

      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa === 'fp') {
        if (this.element.children && !this.element.getAttribute('extraLayer')) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());
          if (this.render.getDirection() === 0) {
            pageNum = pageNum;
            let _this = this;
            if (!mobile_test_horizontal() || forceOnePage || true) {
              APP.Book.getPage(pageNum, function (PageObj) {
                extraLayer.style.cssText = `background-image:url(${PageObj.getCover('p533')});`;
                _this.element.appendChild(extraLayer);
                _this.element.appendChild(odblaskExtra);
                _this.element.setAttribute('extraLayer', 'yes');
              });
            }
          }
        }

        if (this.render.getDirection() === 0) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let extraLeftFlipedBg = extraLeftFliped.querySelector('.extraLeftFlipedBg');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;
         
          // let i = `polygon(${this.render.getRect().pageWidth - x1}px 0, 100% 0%, 100% 100%, ${
          //   this.render.getRect().pageWidth - x2
          // }px 100%)`; //lewa strona
          // let i = `polygon(0 0, ${x1}px 0, ${x2}px ${this.state.area[3] ? '100%' : this.render.getRect().pageWidth + x1 +'px'}, ${x2}px 100%, 0 100%)`;
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej

          let opval = (1.0 - (x1 + x2) / 2 / this.render.getRect().pageWidth) * 2;
          //op = `opacity: ${opval}`;
          // extraLeftFliped.style.width = this.render.getRect().pageWidth + 'px';
          // extraLeftFliped.style.heigth = '718px';
          // extraLeftFliped.style.right = '50%';
          // extraLeftFliped.style.display = 'block';
          // extraLeftFlipedBg.style.backgroundColor = '#fff';
          // extraLeftFlipedBg.style.opacity = '1';
        }

        this.drawSoft_warstwaFlip_clipPathOld(i, op, e, t);
      } else {
        this.element.style.cssText =
          e +
          `transform-origin: 0 0; ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
          (this.render.isSafari() && 0 === this.state.angle
            ? `transform: translate(${t.x}px, ${t.y}px);`
            : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
      }
    }

    drawSoft_desktop_onepage(t, e, warstwa) {
      //        if( forceOnePage && direction === 1 ){
      var op = 1.0;

      if (warstwa === 'fp') {
        //to tylko przy 1 klatce i tylko forconepage mobiel albo horizontal

        if (
          this.element.children &&
          !this.element.getAttribute('extraLayer') &&
          (forceOnePage || !(is_mobile() && is_horisontalOld()))
        ) {
          let extraLayer = document.createElement('div');
          let odblaskExtra = document.createElement('div');
          odblaskExtra.classList.add('odblask');
          odblaskExtra.classList.add('front');
          odblaskExtra.classList.add('forcedScaleMinus1');

          let pageNum = Number(this.render.app.getCurrentPageIndex());

          if (this.render.getDirection() === 0) {
            document.getElementById('marcincrop2').hidden = false;
            pageNum = pageNum;

            let _this = this;
            APP.Book.getPage(pageNum, function (PageObj) {
              let thisPageObj = document.querySelector(`div.Page[page="${pageNum}"] .back`);
              let compStyles = thisPageObj ? window.getComputedStyle(thisPageObj) : null;
              let thisPageObjBackgroundImage = compStyles ? compStyles.getPropertyValue('background-image') : 'url()';

              _this.element.setAttribute('extraLayer', 'yes');
              extraLayer.style.cssText = `background-image: ${thisPageObjBackgroundImage};`;
              extraLayer.style.filter = 'none';
              extraLayer.style.transform = 'none';
              extraLayer.style.width = '100%';
              extraLayer.style.height = '100%';
              extraLayer.style.top = '0';
              extraLayer.style.left = '0';
              extraLayer.className = 'blured1 --left --single';
              _this.element.appendChild(extraLayer);
              _this.element.appendChild(odblaskExtra);
              _this.element.id = 'marcin_corner';
              document.getElementById('marcincrop2').innerHTML = '';
              document.getElementById('marcincrop2').appendChild(_this.element);

              let cloneBottom = _this.render.flippingPage.element.cloneNode();
              cloneBottom.id = 'cloneBottom';
              cloneBottom.classList.add('back');
              cloneBottom.classList.add('--left');

              if (!APP.Book.getBookModelSettings().show_shadow_inside) {
                cloneBottom.classList.add('hideshadow');
              }

              cloneBottom.id = 'lewapozioma';
              cloneBottom.style.zIndex = '3';
              cloneBottom.style.left = 'unset';
              cloneBottom.style.bottom = 'unset';

              //if there are any hotspots on right page append them to cloneBottom
              var hotspotslayer =
                _this.render.rightPage.element.getElementsByClassName('hotspots-container');
              if (hotspotslayer.length > 0) {
                let clonedHotspotsDiv = hotspotslayer[0].cloneNode(true);
                clonedHotspotsDiv.innerHTML = hotspotslayer[0].innerHTML;
                cloneBottom.appendChild(clonedHotspotsDiv);

                if (clonedHotspotsDiv.childNodes.length) {
                  clonedHotspotsDiv.childNodes.forEach((node) => {
                    if (node.dataset && node.dataset.type == 'video') {
                      if(!!node.querySelector('iframe')){
                        node.querySelector('iframe').src = '';
                      }
                    }
                  });
                }
              }

              if (PageObj.getPage()) {
                cloneBottom.style.backgroundImage = thisPageObjBackgroundImage;
                // cloneBottom.style.backgroundImage = PageObj.getPage().raster.style.backgroundImage;
              }
              document.getElementById('marcincrop2').appendChild(cloneBottom);
              // cloneBottom.appendChild(_this.render.underShadow);
              _this.element.style.display = 'block';
            });
          }
        }

        if (this.render.getDirection() === 0) {
          let extraLeftFliped = document.querySelector('.extraLeftFliped');
          let x1 =
            this.state.area[1] === null ? this.render.getRect().pageWidth : this.state.area[1].x;
          let x2 =
            this.state.area[2] === null ? this.render.getRect().pageWidth : this.state.area[2].x;

          // trzeci punkt do I dla naprawy - ${x2}px ${this.state.area[3] ? '100%' : this.render.getRect().pageWidth + x1 +'px'},  
          let i = `polygon(0 0, ${x1}px 0,  ${x2}px 100%, 0 100%)`; //lewa strona
          var clip = `clip-path: ${i};-webkit-clip-path: ${i};`; //lewa strona extra z pewej
          let avg_ciegno =
            (this.render.getRect().pageWidth - x1 + (this.render.getRect().pageWidth - x2)) / 2;
          // let progress = this.render.getRect().pageWidth / ((x1 + x2) / 2);

          // let opval = (1.0-((x1 + x2)/2)/this.render.getRect().pageWidth);
          op = (avg_ciegno / this.render.getRect().pageWidth) * 1.4;
          extraLeftFliped.style.cssText = extraLeftFliped.style.cssText + clip + op;
          extraLeftFliped.style.right = '-100%';
          
          this.drawSoftCrop( op );
        } else {
          op = this.render.shadow.progress > 175 ? `${(200 - this.render.shadow.progress) / 25}` : 1.0;
       
          if (!this.element.querySelector('.cover-div')) {
            const coverDiv = document.createElement('div');
            coverDiv.className = 'cover-div';
            coverDiv.style.cssText = `
              background-repeat: no-repeat; 
              background-size: cover; 
              width: calc(100% + 48px); 
              height: calc(100% + 48px); 
              transform: scaleX(-1); 
              filter: blur(24px);
              top: -14px;
              left: -14px;
              position: fixed;`;
              
            this.element.appendChild(coverDiv);
  
            APP.Book.getPage(Number(this.render.app.getCurrentPageIndex()) + 1, function (PageObj) {
              coverDiv.style.backgroundImage = `url(${PageObj.getCover('p533')})`;
            });
          } else {
            this.element.querySelector('.cover-div').style.opacity = op; 
          }

          if (!this.element.querySelector('.odblask')) {
            const odblask = document.createElement('div');
            odblask.className = 'odblask';
            this.element.appendChild(odblask);
          }        
        }
      }

      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa !== 'fp') {
        if (this.render.getDirection() === 0 && forceOnePage && !is_mobile()) {
          this.element.style.cssText = e + `opacity: ${op}`;
        } else {
          this.element.style.cssText =
            e +
            `transform-origin: 0 0; opacity: ${op};clip-path: ${i};-webkit-clip-path: ${i};` +
            (this.render.isSafari() && 0 === this.state.angle
              ? `transform: translate(${t.x}px, ${t.y}px);`
              : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);`);
        }
      } else {
        if (this.render.getDirection() === 0 && forceOnePage) {
          
        } else {
          this.drawSoft_warstwaFlip_clipPathOld(i, `opacity: ${op}`, e, t);
          let pageDivThatIschangedToNewOne = document.querySelector(`div.Page[page="${Number(this.render.app.getCurrentPageIndex())+1}"]`);
          if( pageDivThatIschangedToNewOne ){
            pageDivThatIschangedToNewOne.style.opacity = op;
          }
        }
      }
    }

    drawSoft_desktop_old(t, e, warstwa) {
      document.querySelector('.marcincrop2').innerHTML = '';
      document.querySelector('.marcincrop2').hidden = true;
      
      var op = 'opacity: 1.0';
      let i = 'polygon( ';
      for (const t of this.state.area)
        if (null !== t) {
          let ty = t.y - this.state.position.y;
          let e =
            1 === this.render.getDirection()
              ? {
                  x: -t.x + this.state.position.x,
                  y: ty,
                }
              : {
                  x: t.x - this.state.position.x,
                  y: ty,
                };

          e = h.GetRotatedPoint(e, { x: 0, y: 0 }, this.state.angle);
          i += e.x + 'px ' + e.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      if (warstwa === 'fp') {
        if (
          this.element.children &&
          this.odblaskDiv &&
          !this.odblaskDiv.getAttribute('extraLayer')
        ) {
          this.odblaskDiv.setAttribute('extraLayer', 'yes');
        }
      }

      var clip = `clip-path: ${i};-webkit-clip-path: ${i};${op};`;

      this.element.style.cssText =
        e +
        `transform-origin: 0 0; ${clip}` +
        (this.render.isSafari() && 0 === this.state.angle
          ? `transform: translate(${t.x}px, ${t.y}px);`
          : `transform: translate3d(${t.x}px, ${t.y}px, 0) rotate(${this.state.angle}rad);
           `);
    }

    drawSoft(t, commonStyle = {}, warstwa = '?') {
      const styles = this.render.app.convertStylesObjectToString(commonStyle);
      const marcinCrop = document.querySelector('.marcincrop2');

      if (marcinCrop) {
        const pageInside = marcinCrop.querySelector('.page-inside');

        if (pageInside) {
          pageInside.remove();
        }

        marcinCrop.style.cssText = '';
      }

      if (is_mobile()) {
        if (window.innerWidth <= window.innerHeight) {
          this.drawSoft_mobile_new(t, styles, warstwa, window.innerWidth <= window.innerHeight);
        } else {
          //poziom mobile

          if (forceOnePage) {
            this.drawSoft_mobile_new(t, styles, warstwa, window.innerWidth <= window.innerHeight);
          } else {
            this.drawSoft_mobile(t, styles, warstwa);
          }
        }
      } else {
        if (forceOnePage) {
          this.drawSoft_desktop_onepage(t, styles, warstwa);
        } else {
          this.drawSoft_desktop_old(t, styles, warstwa);
        }
      }
    } //end drawSoft

    drawHard(commonStyle = {}) {
      const isFirstPage = this.element.page == 1;
      const pos = this.render.getRect().left + this.render.getRect().width / 2;
      const angle = this.state.hardDrawingAngle;

      let newStyles = {
        ...commonStyle,
        'backface-visibility': 'hidden',
        '-webkit-backface-visibility': 'hidden',
        'clip-path': 'none',
        '-webkit-clip-path': 'none'
      };

      if (this.orientation === 0) {
        newStyles = {
          ...newStyles,
          'transform-origin': `${this.render.getRect().pageWidth + (isFirstPage ? this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : 0)}px 0`,
          transform: `translate3d(0, 0, 0) rotateY(${angle}deg)`,
        };
      } else {
        const transformOrigin = 
          (isFirstPage &&  (forceOnePage || this.render.getOrientation() === 'portrait')) 
            ? `${this.render.getRect().pageWidth + (isFirstPage ? this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : 0)}px 0` 
            : '0 0';

        newStyles = {
          ...newStyles,
          'transform-origin': transformOrigin,
          transform: `translate3d(${pos}px, 0, 0) rotateY(${angle}deg)`
        };
      }

      this.element.style.cssText = this.render.app.convertStylesObjectToString(newStyles);
      
      if (this.nowDrawingDensity === 'hard') {
        if (isFirstPage) {
          this.element.classList.add('hard-mask--left');
        } else {
          this.element.classList.add(this.orientation === 1 ? 'hard-mask--right' : 'hard-mask--left');
        }

        document.querySelector('#main').className = 'book--hard';
      }

      if (!(forceOnePage || this.render.getOrientation() === 'portrait')) {
        return;
      }

      const marcinCrop = document.querySelector('#marcincrop2');
      const opacity = this.getHardMarcinCropOpacityByDirection(this.render.getDirection());

      marcinCrop.removeAttribute('hidden');

      marcinCrop.style.backgroundColor = `#${this.render.hardWrapper.design.color}`;
      marcinCrop.style.width = commonStyle.width;
      marcinCrop.style.height = commonStyle.height;
      marcinCrop.style.top = commonStyle.top;
      marcinCrop.style.left = commonStyle.left;
      marcinCrop.style.zIndex = +(commonStyle.zIndex || 5) - 1;
      marcinCrop.style.borderRadius = '5px 0 0 5px';
      marcinCrop.style.overflow = 'hidden';

      marcinCrop.style.transformOrigin = `${this.render.getRect().pageWidth + (isFirstPage ? this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : 0)}px 0`;
      marcinCrop.style.transform = `translate3d(0, 0, 0) rotateY(${angle}deg)`;
      
      marcinCrop.style.opacity = `${opacity}`;

      this.drawHardPageInside(marcinCrop);
    }

    drawHardPageInside(marcinCrop) {
      let pageInside = marcinCrop.querySelector('div.page-inside');

      if (pageInside) {
        return;
      }

      pageInside = document.createElement('div');
      pageInside.className = 'page-inside';
      pageInside.style.position = 'absolute';
      pageInside.style.width = `${this.render.getRect().pageWidth}px`;
      pageInside.style.height = `${this.render.getRect().height}px`;
      pageInside.style.top = `${this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT / 2}px`;
      pageInside.style.left = `${this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2}px`;
      pageInside.style.backgroundColor = 'rgba(255, 255, 255, .15)';

      marcinCrop.innerHTML = '';
      marcinCrop.appendChild(pageInside);
    }

    getHardMarcinCropOpacityByDirection(direction) {
      const flippingProgress = this.render.app.flipController && this.render.app.flipController.calc && this.render.app.flipController.calc.getFlippingProgress();

      if (!flippingProgress) {
        return 0;
      }

      if (direction === 1) {
        const OPACITY_MIN_BORDER = 60;
        const OPACITY_MAX_BORDER = 95;
        let opacity = 1;

        if (flippingProgress >= OPACITY_MAX_BORDER) {
          opacity = 0;
        } else if (flippingProgress >= OPACITY_MIN_BORDER) {
          opacity = 1 - ((flippingProgress - OPACITY_MIN_BORDER) / (OPACITY_MAX_BORDER - OPACITY_MIN_BORDER)).toFixed(2);
        } else {
          opacity = 1;
        }

        return opacity;
      }

      if (direction === 0) {
        const OPACITY_MIN_BORDER = 5;
        const OPACITY_MAX_BORDER = 40;
        
        let opacity = 0;

        if (flippingProgress >= OPACITY_MAX_BORDER) {
          opacity = 1;
        } else if (flippingProgress >= OPACITY_MIN_BORDER) {
          opacity = 1 - ((flippingProgress - OPACITY_MAX_BORDER) / (OPACITY_MIN_BORDER - OPACITY_MAX_BORDER)).toFixed(2);
        } else {
          opacity = 0;
        }

        return opacity;
      }
    }

    isSidePage(direction) {
      const bookPages = this.render.setting.bookPages;

      if (this.element.page <= 1 || this.element.page >= bookPages) {
        return true;
      }

      if (this.element.page === 2 && direction === 1) {
        return true;
      }

      if (this.element.page === bookPages - 1 && direction === 0) {
        return true;
      }

      return false;
    }

    simpleHardDraw(t) {
      const isSidePage = this.isSidePage(this.element.page);

      const rect = this.render.getRect();
      const isLastPage = this.isLastPage();
      const isFirstPage = this.element.page == 1;
      const left = 1 === t ? rect.left + rect.pageWidth : rect.left;
      let pageWidth = isSidePage ? rect.pageWidth + this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : rect.pageWidth;
      let pageHeight = isSidePage ? rect.height + this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT : rect.height;
      let top = isSidePage ? rect.top - this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT / 2 : rect.top;
      let lastPageOffset = this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;
      
      if ((forceOnePage || this.render.getOrientation() === 'portrait') || (Number(this.render.setting.bookPages) % 2 === 1)) {
        if (isLastPage) {
          pageWidth = rect.pageWidth;
          pageHeight = rect.height;
          top = rect.top;
        }

        if (isFirstPage && this.render.setting.bookPages === 1) {
          lastPageOffset = 0;
        }
      }

      this.element.classList.add('--simple');
      this.element.style.cssText = `
        position: absolute; 
        display: block; 
        height: ${pageHeight}px;
        left: ${left - (isFirstPage ? lastPageOffset : 0)}px;
        top: ${top}px;
        width: ${pageWidth}px;
        z-index: ${ this.render.getSettings().startZIndex + 1 };`;

      if (is_mobile()) {
        document.getElementById('stf__marcinBookShadow').style.cssText = `
          height: ${pageHeight}px; 
          left: ${left - (isFirstPage ? lastPageOffset : 0)}px; 
          top: ${top}px; 
          width: ${pageWidth}px;`;
      }
    }

    simpleDraw(t) {
      //w kazdej klatce
      const e = this.render.getRect(),
        i = e.pageWidth,
        s = e.height,
        n = this.render.app.pages.pages.length == 1 ? 0 : 1 === t ? e.left + e.pageWidth : e.left,
        h = e.top;
      //tu jest bald 1 strony n = 0 zamaist 332

      this.element.classList.add('--simple');
      this.element.style.cssText = `
        position: absolute; 
        display: block; 
        height: ${s}px;
        left: ${n}px;
        top: ${h}px;
        width: ${i}px;
        z-index: ${ this.render.getSettings().startZIndex + 1 };`;

      if (is_mobile()) {
        document.getElementById('stf__marcinBookShadow').style.cssText = `
          height: ${s}px; 
          left: ${n}px; 
          top: ${h}px; 
          width: ${i}px;`;
      }
    }

    clippingDraw(commonStyle = {}) {
      if (forceOnePage) {
        return;
      }

      const styles = this.render.app.convertStylesObjectToString(commonStyle);
      
      let i = 'polygon( ';
      for (const l of this.state.area)
        if (null !== l) {
          i += l.x + 'px ' + l.y + 'px, ';
        }
      (i = i.slice(0, -2)), (i += ')');

      const style = `${styles} ${e} transform-origin: 0 0; clip-path: ${i}; -webkit-clip-path: ${i}`;
      this.element.style.cssText = style;
    }

    getElement() {
      return this.element;
    }
    load() {
      this.isLoad = !0;
    }
    setOrientation(t) {
      super.setOrientation(t);
    }
    setDrawingDensity(t, i = null) {
      this.element.classList.remove('--soft', '--hard'),
        this.element.classList.add('--' + t),
        super.setDrawingDensity(t);
    }
  }

  // HTMLPageCollection
  class a extends s {
    constructor(t, e, i, s) {
      super(t, e), (this.element = i), (this.pagesElement = s);
    }
    load() {
      for (const t of this.pagesElement) {
        const e = new o(this.render, t, 'hard' === t.dataset.density ? 'hard' : 'soft');

        e.load(), this.pages.push(e);
      }

      this.pages[0].element.classList.add('first');
      this.pages[this.pages.length - 1].element.classList.add('last');

      this.createSpread();
    }
  }
  class r {
    constructor(t, e, i, s) {
      (this.direction = t),
        (this.corner = e),
        (this.topIntersectPoint = null),
        (this.sideIntersectPoint = null),
        (this.bottomIntersectPoint = null),
        (this.pageWidth = parseFloat(i, 10)),
        (this.pageHeight = parseFloat(s, 10));
    }
    calc(t) {
      try {
        return (
          (this.position = this.calcAngleAndPosition(t)),
          this.calculateIntersectPoint(this.position),
          !0
        );
      } catch (t) {
        return !1;
      }
    }
    getFlippingClipArea() {
      const t = [];
      let e = !1;
      return (
        t.push(this.rect.topLeft),
        t.push(this.topIntersectPoint),
        null === this.sideIntersectPoint
          ? (e = !0)
          : (t.push(this.sideIntersectPoint), null === this.bottomIntersectPoint && (e = !1)),
        t.push(this.bottomIntersectPoint),
        (e || 'bottom' === this.corner) && t.push(this.rect.bottomLeft),
        t
      );
    }
    getFirstFlippingClipArea() {
      const t = [];
      if ('top' === this.corner) {
        t.push({ x: this.pageWidth - this.topIntersectPoint.x + 1, y: this.topIntersectPoint.y });
        t.push({ x: this.pageWidth + 1, y: 0 });
        t.push({ x: this.pageWidth + 1, y: this.pageHeight });
        if (null !== this.sideIntersectPoint) {
          if (h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10) {
            t.push({ x: 0, y: this.pageHeight });
            t.push({
              x: this.pageWidth - this.sideIntersectPoint.x + 1,
              y: this.sideIntersectPoint.y,
            });
          }
        } else {
          t.push({
            x: this.pageWidth - this.bottomIntersectPoint.x + 1,
            y: this.bottomIntersectPoint.y,
          });
        }
      }

      if ('bottom' === this.corner) {
        t.push({ x: this.pageWidth + 1, y: 0 });
        t.push({ x: this.pageWidth + 1, y: this.pageHeight });
        t.push({
          x: this.pageWidth - this.bottomIntersectPoint.x + 1,
          y: this.bottomIntersectPoint.y,
        });
        if (null !== this.sideIntersectPoint) {
          if (
            h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.bottomIntersectPoint) >= 10
          ) {
            t.push({
              x: this.pageWidth - this.sideIntersectPoint.x + 1,
              y: this.sideIntersectPoint.y,
            });
            t.push({ x: 0, y: 0 });
          }
        } else {
          t.push({ x: this.pageWidth - this.topIntersectPoint.x + 1, y: this.topIntersectPoint.y });
        }
      }
      return t;
    }
    getLastFlippingClipArea() {
      const t = [];
      if ('top' === this.corner) {
        t.push({ x: 0, y: 0 });
        t.push({ x: this.topIntersectPoint.x, y: this.topIntersectPoint.y });
        if (null !== this.sideIntersectPoint) {
          if (h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10) {
            t.push({ x: this.sideIntersectPoint.x, y: this.sideIntersectPoint.y });
            t.push({ x: this.pageWidth, y: this.pageHeight });
          }
        } else {
          t.push({ x: this.bottomIntersectPoint.x, y: this.bottomIntersectPoint.y });
        }
        t.push({ x: 0, y: this.pageHeight });
      }

      if ('bottom' === this.corner) {
        t.push({ x: 0, y: 0 });
        if (null !== this.sideIntersectPoint) {
          if (
            h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.bottomIntersectPoint) >= 10
          ) {
            t.push({ x: this.pageWidth, y: 0 });
            t.push(this.sideIntersectPoint);
          }
        } else {
          t.push(this.topIntersectPoint);
        }
        t.push(this.bottomIntersectPoint);
        t.push({ x: 0, y: this.pageHeight });
      }
      return t;
    }
    getBottomClipArea() {
      const t = [];
      return (
        null !== this.topIntersectPoint
          ? t.push({ x: this.topIntersectPoint.x - 1, y: this.topIntersectPoint.y })
          : '',
        'top' === this.corner
          ? t.push({ x: this.pageWidth, y: 0 })
          : (null !== this.topIntersectPoint && t.push({ x: this.pageWidth, y: 0 }),
            t.push({ x: this.pageWidth, y: this.pageHeight })),
        null !== this.sideIntersectPoint
          ? h.GetDistanceBetweenTwoPoint(this.sideIntersectPoint, this.topIntersectPoint) >= 10 &&
            t.push({ x: this.sideIntersectPoint.x, y: this.sideIntersectPoint.y + 1 })
          : 'top' === this.corner && t.push({ x: this.pageWidth, y: this.pageHeight }),
        null !== this.bottomIntersectPoint
          ? t.push({ x: this.bottomIntersectPoint.x - 1, y: this.bottomIntersectPoint.y })
          : '',
        t
      );
    }
    getAngle() {
      return 0 === this.direction ? -this.angle : this.angle;
    }
    getRect() {
      return this.rect;
    }
    getPosition() {
      return this.position;
    }
    getActiveCorner() {
      return 0 === this.direction ? this.rect.topLeft : this.rect.topRight;
    }
    getDirection() {
      return this.direction;
    }
    getFlippingProgress() {
      return Math.abs(((this.position.x - this.pageWidth) / (2 * this.pageWidth)) * 100);
    }
    getCorner() {
      return this.corner;
    }
    getBottomPagePosition() {
      return 1 === this.direction ? { x: this.pageWidth, y: 0 } : { x: 0, y: 0 };
    }
    getShadowStartPoint() {
      const topIntersectPoint = null !== this.topIntersectPoint ? this.topIntersectPoint : { x: 0, y: 0 };

      return 'top' === this.corner
        ? topIntersectPoint
        : null !== this.sideIntersectPoint
        ? this.sideIntersectPoint
        : topIntersectPoint;
    }
    getShadowAngle() {
      let segmentToShadowLine = this.getSegmentToShadowLine(); 
      segmentToShadowLine = segmentToShadowLine.map(point => point == null ? { x: 0, y: 0 } : point);

      const t = h.GetAngleBetweenTwoLine(segmentToShadowLine, [
        { x: 0, y: 0 },
        { x: this.pageWidth, y: 0 },
      ]);
      return 0 === this.direction ? t : Math.PI - t;
    }
    calcAngleAndPosition(t) {
      let e = t;
      if (
        (this.updateAngleAndGeometry(e),
        (e =
          'top' === this.corner
            ? this.checkPositionAtCenterLine(e, { x: 0, y: 0 }, { x: 0, y: this.pageHeight })
            : this.checkPositionAtCenterLine(e, { x: 0, y: this.pageHeight }, { x: 0, y: 0 })),
        Math.abs(e.x - this.pageWidth) < 1 && Math.abs(e.y) < 1)
      )
        throw new Error('Point is too small');
      return e;
    }
    updateAngleAndGeometry(t) {
      (this.angle = this.calculateAngle(t)), (this.rect = this.getPageRect(t));
    }
    calculateAngle(t) {
      const e = this.pageWidth - t.x + 1,
        i = 'bottom' === this.corner ? this.pageHeight - t.y : t.y;
      let s = 2 * Math.acos(e / Math.sqrt(i * i + e * e));
      i < 0 && (s = -s);
      const n = Math.PI - s;
      if (!isFinite(s) || (n >= 0 && n < 0.003)) throw new Error('The G point is too small');
      return 'bottom' === this.corner && (s = -s), s;
    }
    getPageRect(t) {
      return 'top' === this.corner
        ? this.getRectFromBasePoint(
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
            t,
          )
        : this.getRectFromBasePoint(
            [
              { x: 0, y: -this.pageHeight },
              { x: this.pageWidth, y: -this.pageHeight },
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
            t,
          );
    }
    getRectFromBasePoint(t, e) {
      return {
        topLeft: this.getRotatedPoint(t[0], e),
        topRight: this.getRotatedPoint(t[1], e),
        bottomLeft: this.getRotatedPoint(t[2], e),
        bottomRight: this.getRotatedPoint(t[3], e),
      };
    }
    getRotatedPoint(t, e) {
      return {
        x: t.x * Math.cos(this.angle) + t.y * Math.sin(this.angle) + e.x,
        y: t.y * Math.cos(this.angle) - t.x * Math.sin(this.angle) + e.y,
      };
    }
    calculateIntersectPoint(t) {
      const e = {
        left: -1,
        top: -1,
        width: this.pageWidth + 2,
        height: this.pageHeight + 2,
      };
      'top' === this.corner
        ? ((this.topIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.topRight],
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
          )),
          (this.sideIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.bottomLeft],
            [
              { x: this.pageWidth, y: 0 },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )),
          (this.bottomIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.bottomLeft, this.rect.bottomRight],
            [
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )))
        : ((this.topIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.topLeft, this.rect.topRight],
            [
              { x: 0, y: 0 },
              { x: this.pageWidth, y: 0 },
            ],
          )),
          (this.sideIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [t, this.rect.topLeft],
            [
              { x: this.pageWidth, y: 0 },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )),
          (this.bottomIntersectPoint = h.GetIntersectBetweenTwoSegment(
            e,
            [this.rect.bottomLeft, this.rect.bottomRight],
            [
              { x: 0, y: this.pageHeight },
              { x: this.pageWidth, y: this.pageHeight },
            ],
          )));
    }
    checkPositionAtCenterLine(t, e, i) {
      let s = t;
      const n = h.LimitPointToCircle(e, this.pageWidth, s);
      s !== n && ((s = n), this.updateAngleAndGeometry(s));
      const o = Math.sqrt(Math.pow(this.pageWidth, 2) + Math.pow(this.pageHeight, 2));
      let a = this.rect.bottomRight,
        r = this.rect.topLeft;
      if (
        ('bottom' === this.corner && ((a = this.rect.topRight), (r = this.rect.bottomLeft)),
        a.x <= 0)
      ) {
        const t = h.LimitPointToCircle(i, o, r);
        t !== s && ((s = t), this.updateAngleAndGeometry(s));
      }
      return s;
    }
    getSegmentToShadowLine() {
      const t = this.getShadowStartPoint();
      return [
        t,
        t !== this.sideIntersectPoint && null !== this.sideIntersectPoint
          ? this.sideIntersectPoint
          : this.bottomIntersectPoint,
      ];
    }
  }

  // Flip 
  class g {
    constructor(t, e) {
      (this.flippingPage = null),
        (this.lastFrameFlippingPage = null),
        (this.underFlippingPage = null),
        (this.bottomPage = null),
        (this.calc = null),
        (this.state = 'read'),
        (this.initialAction = ''),
        (this.render = t),
        (this.app = e),
        (this.flipToPageAction = false),
        (this.flipToPageSourceSpreadIndex = null);
    }
    fold(t, l) {
      this.initialAction = 'fold';
      this.setState('user_fold'),
        null === this.calc && this.start(t, l),
        this.do(this.render.convertToPage(t));
      APP.Book.onUserFoldState();
    }
    flip(t) {
      if ((null !== this.calc && this.render.finishAnimation(), !this.start(t))) return;

      const e = this.getBoundsRect();
      this.initialAction = 'flip';
      this.setState('flipping');
      var startX = e.height / 10;
      var i = e.height / 10,
        s = 'bottom' === this.calc.getCorner() ? e.height - i : i,
        n = 'bottom' === this.calc.getCorner() ? e.height : 0; //0
      if (forceOnePage) {
        startX = 0;
        (i = 1),
          (s = 'bottom' === this.calc.getCorner() ? e.height - i : i),
          (n = 'bottom' === this.calc.getCorner() ? e.height : 0); //0
      }

      this.calc.calc({ x: e.pageWidth - startX, y: s }),
        this.animateFlippingTo(
          { x: parseInt(e.pageWidth - startX), y: s },
          { x: -e.pageWidth, y: n },
          !0
        );      
    }
    start(t, l) {
      this.reset();

      let e = this.render.convertToBook(t),
        i = this.getBoundsRect(),
        s = this.getDirectionByPoint(e),
        n = e.y >= i.height / 2 ? 'bottom' : 'top';

      if (l && 'portrait' === this.render.getOrientation()) {
        if (t.x - l.x > 0) {
          s = 1;
        } else {
          s = 0;
        }
      }

      if ((APP.Book.getBookModelSettings().show_right_to_left || true) && this.getState() == 'fold_corner') {
        s = 1 === s ? 0 : 1;
      }
      
      if (!this.checkDirection(s)) return !1;
      
      try {
        if ((APP.Book.getBookModelSettings().show_right_to_left || true) && this.getState() == 'fold_corner') {
          if (this.app.getPageCollection().getFlippingPage(s).element.classList[1] == `_page_${this.app.getPageCollection().pages.length}`) {
            return;
          }
        }
      } catch {
        return !1;
      }

      try {
        if (
          ((this.flippingPage = this.app.getPageCollection().getFlippingPage(s)),
          (this.bottomPage = this.app.getPageCollection().getBottomPage(s)),
          'landscape' === this.render.getOrientation())
        ) {
          if (1 === s) {
            const t = this.app.getPageCollection().prevBy(this.flippingPage); // nextBy

            if (
              null === this.underFlippingPage &&
              this.flippingPage.element.classList[1] ===
                `_page_${APP.Book.getBookModelSettings().show_right_to_left || true ? this.app.getPageCollection().pages.length : 1}`
            ) {
              if (
                this.app.getPageCollection().prevSpreadIndex + 1 ==
                  this.app.getPageCollection().currentSpreadIndex ||
                this.app.getPageCollection().prevSpreadIndex - 1 ==
                  this.app.getPageCollection().currentSpreadIndex
              ) {
                this.underFlippingPage = this.app.getPageCollection().prevBy(this.flippingPage); // prevBy
              } else {
                let page = this.app
                  .getPageCollection()
                  .getPageByNum(s, this.app.getPageCollection().prevSpreadIndex);

                this.underFlippingPage = page;
              }
            }

            null !== t &&
              this.flippingPage.getDensity() !== t.getDensity() &&
              (this.flippingPage.setDrawingDensity(t.getDensity()), t.setDrawingDensity(t.getDensity()));
          } else {
            const t = this.app.getPageCollection().nextBy(this.flippingPage); // prevBy

            if (this.flippingPage.element.classList[1] === '_page_1') {
              this.underFlippingPage = this.app.getPageCollection().nextBy(this.flippingPage); // nextBy
              // this.underFlippingPage = null;
            }
            if (
              this.app.getPageCollection().prevSpreadIndex >
                this.app.getPageCollection().currentSpreadIndex + 1 &&
              this.app.getPageCollection().currentSpreadIndex - 1 === 0
            ) {
              let page = this.app
                .getPageCollection()
                .getPageByNum(1, this.app.getPageCollection().prevSpreadIndex);
              this.underFlippingPage = page;
            }
            if (
              this.app.getPageCollection().prevSpreadIndex ===
                this.app.getPageCollection().landscapeSpread.length - 1 &&
              this.currentPageIndex - 1 === 0
            ) {
              let page = this.app
                .getPageCollection()
                .getPageByNum(1, this.app.getPageCollection().prevSpreadIndex);
              this.underFlippingPage = page;
            }

            null !== t &&
              this.flippingPage.getDensity() !== t.getDensity() &&
              (this.flippingPage.setDrawingDensity(t.getDensity()), t.setDrawingDensity(t.getDensity())); // 'hard' bylo w obu miejscach
          }
        }

        return (
          this.render.setDirection(s),
          (this.calc = new r(s, n, i.pageWidth.toString(10), i.height.toString(10))),
          !0
        );
      } catch (t) {
        return !1;
      }
    }

    do(t) {
      //0.08-0.09 (max: 0.71) 1%

      if (null !== this.calc && this.calc.calc(t)) {
        const t = this.calc.getFlippingProgress();

        if (!this.bottomPage) return;
        this.bottomPage.setArea(this.calc.getBottomClipArea()),
          this.bottomPage.setPosition(this.calc.getBottomPagePosition(), 'bottom'),
          this.bottomPage.setAngle(0),
          this.bottomPage.setHardAngle(0),
          this.flippingPage.setArea(this.calc.getFlippingClipArea()),
          this.flippingPage.setOdblask(),
          this.flippingPage.setPosition(this.calc.getActiveCorner(), 'fpgetActiveCorner'),
          this.flippingPage.setAngle(this.calc.getAngle()),
          this.flippingPage.setFlipAngle(0),
          0 === this.calc.getDirection()
            ? this.flippingPage.setHardAngle((90 * (200 - 2 * t)) / 100)
            : this.flippingPage.setHardAngle((-90 * (200 - 2 * t)) / 100),
          1 === this.calc.getDirection()
            ? null !== this.underFlippingPage
              ? this.underFlippingPage.setArea(this.calc.getFirstFlippingClipArea())
              : ''
            : null !== this.underFlippingPage
            ? this.underFlippingPage.setArea(this.calc.getLastFlippingClipArea())
            : '',
          null !== this.underFlippingPage
            ? this.underFlippingPage.setPosition(this.calc.getBottomPagePosition())
            : '',
          null !== this.underFlippingPage ? this.underFlippingPage.setAngle(0) : '',
          null !== this.underFlippingPage ? this.underFlippingPage.setHardAngle(0) : '',
          this.render.setPageRect(this.calc.getRect()),
          this.render.setBottomPage(this.bottomPage),
          this.render.setFlippingPage(this.flippingPage),
          this.render.setUnderFlippingPage(this.underFlippingPage),
          this.render.setShadowData(
            this.calc.getShadowStartPoint(),
            this.calc.getShadowAngle(),
            t,
            this.calc.getDirection(),
          );

          if (this.render.flippingPage.nowDrawingDensity === 'hard') {
            this.render.thickness.update(t);
            this.render.hardWrapper.update(t);
          } else {
            this.render.thickness.update(t);
          }
        }
    }
    flipToPage(t, e) {
      this.flipToPageAction = true;

      const i = this.app.getPageCollection().getCurrentSpreadIndex(),
        s = this.app.getPageCollection().getSpreadIndexByPage(t);
      this.app.getPageCollection().setPrevSpreadIndex(i);

      this.flipToPageSourceSpreadIndex = i;

      this.render.hardWrapper.updateOnFlippingToPage(i, s, t)

      try {
        s > i && (this.app.getPageCollection().setCurrentSpreadIndex(s - 1), this.flipNext(e)),
          s < i && (this.app.getPageCollection().setCurrentSpreadIndex(s + 1), this.flipPrev(e));
      } catch (t) {}
    }
    flipNext(t) {
      this.flip({
        x: this.render.getRect().left + 2 * this.render.getRect().pageWidth,
        y: 'top' === t ? 1 : this.render.getRect().height - 2,
      });
    }
    flipPrev(t) {
      this.flip({
        x: 10,
        y: 'top' === t ? 1 : this.render.getRect().height - 2,
      });
    }
    stopMove() {
      if (null === this.calc) return;
      const t = this.calc.getPosition(),
        e = this.getBoundsRect(),
        i = 'bottom' === this.calc.getCorner() ? e.height : 0;
      let dist = 0;
      if (this.render.getOrientation() === 'portrait') {
        dist = e.pageWidth / 2 - 50;
      }
      if (t.x <= dist && is_safari()) {
        let audio = document.querySelector('.current-audio');
        if (audio) audio.play();
      }
      t.x <= dist
        ? this.animateFlippingTo(t, { x: -e.pageWidth, y: i }, !0)
        : this.animateFlippingTo(t, { x: e.pageWidth, y: i }, !1);
    }

    showCorner() {
      if (!this.checkState('read', 'fold_corner')) return;

      const e = this.getBoundsRect(),
        i = e.pageWidth,
        s = Math.sqrt(Math.pow(i, 2) + Math.pow(e.height, 2)) / 5,
        n = this.render.convertToBook(t);

      if (null === this.calc) {
        this.setState('fold_corner');
        
        if (!this.start(t)) {
          this.setState('read');
          return;
        }
        
        this.calc.calc({ x: i - 1, y: 1 });
        const s = 70,
          n = 'bottom' === this.calc.getCorner() ? e.height - 1 : 1,
          h = 'bottom' === this.calc.getCorner() ? e.height - s : s;

        this.animateFlippingToCorner({ x: i - 0, y: n }, { x: i - s, y: h - 30 });
      } else {
        this.do(this.render.convertToPage(t));
      }
    }
    /**
     *
     * @param {type} t - pcozatek
     * @param {type} e - kniecz
     * @param {type} i = czy d kolejnej przejsc
     * @param {type} s
     */
    animateFlippingTo(t, e, i, s = !0) {
      const n = h.GetCordsFromTwoPoint(t, e);

      const frames = [];
      for (const t of n) frames.push(() => this.do(t));

      const duration = this.getAnimationDuration(n.length);

      this.render.startAnimation(frames, duration, () => {
        this.flipToPageAction = false;
        // HELPER.showfps( `${window.perfcount} => ${window.perftime / window.perfcount}` );
        if (
          this.flippingPage &&
          this.flippingPage.element.children.length > 0 &&
          this.flippingPage.element.children[0].length > 0
        ) {
          this.flippingPage.element.children[0].children[0].children[1].style.cssText = '';
        }
        
        this.calc &&
          (i &&
            (1 === this.calc.getDirection()
              ? this.app.turnToPrevPage()
              : this.app.turnToNextPage()),
          s &&
            (this.render.setBottomPage(null),
            this.render.setFlippingPage(null),
            this.render.setUnderFlippingPage(null),
            this.render.clearShadow(),
            this.setState('read'),
            this.reset()));
            APP.Book.onReadState();
            
        // Show/Hide arrow after animation on first/last pages.
        const currentPage = APP.Book.getCurrentPage();

        if (currentPage >= 1 && currentPage < (APP.Book.isDoublePage() ? APP.Book.getModel().pages - 1 : APP.Book.getModel().pages)) {
          APP.Book.showHideArrows(currentPage);
        }

        this.render.hardWrapper.show();
        this.render.thickness.update();
        this.render.hardWrapper.update();
        
        this.app.pages.restorePagesOriginalDensity();

        const sourceSpreadIndex = this.app.flipController.flipToPageSourceSpreadIndex;
        const sourceSpread = sourceSpreadIndex ? this.app.pages.getSpreadBySpreadIndex(sourceSpreadIndex) : [];

        sourceSpread.forEach(pageIndex => {
          const page = this.app.pages.pages[pageIndex];

          if (!page || !page.element || !page.element.classList) {
            return;
          }

          this.app.pages.pages[pageIndex].element.classList.remove('action');
          this.app.pages.pages[pageIndex].element.classList.remove('page--bg');
        });

        this.flipToPageSourceSpreadIndex = null;

        // APP.Book.getBookModelSettings().show_book_thickness ? this.xxx() : null;
      });
    }

    xxx() {
      let pageNum = Number(this.app.getCurrentPageIndex());
      if (this.app.setting.bookPage === 1) {
        return;
      }
      if (forceOnePage) {
        let pages_left = this.app.setting.bookPages - (pageNum + 1); //nie pokazujemy ostatnij
        !is_mobile() && this.render.redrawLinesCanvasPagesForOnePage(pages_left);
      } else {
        var newPages = [];

        newPages = [pageNum + 1, pageNum + 2];

        var numbersPagesOnBottom = [
          newPages[1] >= this.app.setting.bookPages ? 0 : newPages[0] / 2 - 1,
          newPages[0] <= 1 ? 0 : parseInt((this.app.setting.bookPages - newPages[1]) / 2),
        ];

        if (APP.Book.getBookModelSettings().show_right_to_left || true) {
          numbersPagesOnBottom = [
            newPages[1] > this.app.setting.bookPages ? 0 : newPages[0] / 2 - 1,
            newPages[0] <= 1 ? 0 : parseInt((this.app.setting.bookPages - newPages[1]) / 2),
          ];

          numbersPagesOnBottom = numbersPagesOnBottom.reverse();
        }

        if (is_vertical() && !forceOnePage && !APP.Book.isDoublePage()) {
          numbersPagesOnBottom[1] = 0;
        }

        !is_mobile() &&
          this.render.redrawLinesCanvasPagesForTwoPage(
            numbersPagesOnBottom[0],
            numbersPagesOnBottom[1],
          );
      }
    }

    animateFlippingToCorner(from, to, firststart = true) {
      const n = h.GetCordsFromTwoPoint(from, to);
      const nback = h.GetCordsFromTwoPoint(to, from);

      const frames = [];
      for (const t of n) {
        frames.push(() => this.do(t));
      }

      var step;
      for (step = 0; step < n.length / 2; step++) {
        frames.push(() => this.do(t));
      }

      for (const t of nback) frames.push(() => this.do(t));
      const duration = 700;
      var self = this;

      this.render.startAnimation(frames, duration, () => {
        if (this.calc) {
          this.render.setBottomPage(null);
          this.render.setFlippingPage(null);
          this.render.setUnderFlippingPage(null);
          this.render.clearShadow();
          this.setState('read');
          this.reset();
        }
      });
    }

    getCalculation() {
      return this.calc;
    }
    getState() {
      return this.state;
    }
    setState(t) {
      this.state !== t && (this.app.updateState(t), (this.state = t));
    }
    getDirectionByPoint(t) {
      const e = this.getBoundsRect();
      if ('portrait' === this.render.getOrientation()) {
        if (t.x - e.pageWidth <= e.width / 5) return 1;
      } else if (t.x < e.width / 2) return 1;
      return 0;
    }
    getAnimationDuration(t) {
      const e = this.app.getSettings().flippingTime;
      var dur = t >= e ? e : (t / e) * e; //1e3

      if (this.flippingPage.nowDrawingDensity === 'hard') {
        return e + 200;
      }

      return e;
    }
    checkDirection(t) {
      if (APP.Book.getBookModelSettings().show_right_to_left || true) {
        return 0 === t
          ? this.app.getCurrentPageIndex() >= 0
          : this.app.getCurrentPageIndex() < this.app.getPageCount() - 1;
      }
      return 0 === t
        ? this.app.getCurrentPageIndex() < this.app.getPageCount() - 1
        : this.app.getCurrentPageIndex() >= 1;
    }
    reset() {
      if (this.flippingPage && this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.display = 'none';
      }

      if (this.app.pages) {
        const sourcePage = this.app.pages.getFlippingSourcePage(this.flippingPage);

        if (sourcePage) {
          sourcePage.element.classList.remove('action');
          sourcePage.element.classList.remove('hard-mask--right');
          sourcePage.element.classList.remove('hard-mask--left');
        }
      }

      if (this.flippingPage && this.flippingPage.element && this.flippingPage.element.classList) {
        this.app.render.hardWrapper.forceRootShadowClass = null;

        this.flippingPage.element.classList.remove('action');
        this.flippingPage.element.classList.remove('hard-mask--right');
        this.flippingPage.element.classList.remove('hard-mask--left');
      }

      (this.calc = null),
        (this.flippingPage = null),
        (this.bottomPage = null),
        (this.underFlippingPage = null);
    }
    getBoundsRect() {
      return this.render.getRect();
    }
    checkState(...t) {
      for (const e of t) if (this.state === e) return !0;
      return !1;
    }
  }
  class l {
    constructor(t, e) {
      (this.leftPage = null),
        (this.rightPage = null),
        (this.flippingPage = null),
        (this.bottomPage = null),
        (this.underFlippingPage = null),
        (this.direction = null),
        (this.directionNamed = null),
        (this.orientation = null),
        (this.shadow = null),
        (this.animation = null),
        (this.pageRect = null),
        (this.boundsRect = null),
        (this.timer = 0),
        (this.safari = !1),
        (this.setting = e),
        (this.app = t),
        (this.testcounter = 0),
        (this.testtime_df = [0, 0, 0, 0, 0]),
        (this.testcount_df = 0),
        (this.outershadow_currentbg_opacity = null),
        (this.outershadow_currentbg_direction = null);
      const i = new RegExp('Version\\/[\\d\\.]+.*Safari/');
      this.safari = null !== i.exec(window.navigator.userAgent);
    }
    showfps(x) {
      document.getElementsByClassName('header__book-name')[0].style.fontSize = '9px';
      document.getElementsByClassName('header__book-name')[0].innerHTML = x;
    }

    render(t) {
      if (null !== this.animation) {
        let e = Math.round((t - this.animation.startedAt) / this.animation.durationFrame);

        if (forceOnePage) {
          let progress =
            (t - this.animation.startedAt + this.animation.durationFrame) / this.animation.duration;
          progress = progress > 1.0 ? 1.0 : progress;
          e = Math.round(Math.sin((progress * Math.PI) / 2) * this.animation.frames.length);
          if (this.animation.frameNum == 0) {
            e = Math.round(0.01 * this.animation.frames.length);
          }
        }

        if (e >= this.animation.frames.length) {
          this.animation.frames[this.animation.frames.length - 1]();
          this.timer = t;
          this.drawFrame();
        }

        this.animation.frameNum++;
        this.testcounter++;
        e < this.animation.frames.length
          ? this.animation.frames[e]() //locked anim
          : (this.animation.onAnimateEnd(),
            (this.animation = null),
            (this.testcounter = 0),
            (document.getElementById('stf__marcinBookShadow').style.display = ''));
      }
      this.timer = t;
      this.drawFrame();
    }
    //

    start() {
      this.update();
      const t = (e) => {
        this.render(e), requestAnimationFrame(t);
      };
      requestAnimationFrame(t);
    }
    startAnimation(frames, e, callback) {
      this.finishAnimation();
      this.animation = {
        frames: frames,
        duration: e,
        durationFrame: e / frames.length,
        onAnimateEnd: callback,
        startedAt: this.timer,
        frameNum: 0,
        frameNumE: 0,
        marcinLastFrame: false,
      };

      this.app.render.hardWrapper.update();
    }

    finishAnimation() {
      null !== this.animation &&
        (this.animation.frames[this.animation.frames.length - 1](),
        null !== this.animation.onAnimateEnd && this.animation.onAnimateEnd()),
        (this.animation = null);
    }
    update_ThicknesTwoPage() {
      if (!is_mobile() && APP.Book.getBookModelSettings().show_book_thickness) {
        if (forceOnePage) {
          // if (this.app.getCurrentPageIndex() + 1 > 1) { // bylo this.app.setting.bookPage > 1
            let pages_left = this.setting.bookPages - this.app.getCurrentPageIndex() - 1;
            this.redrawLinesCanvasPagesForOnePage(
              this.app.getCurrentPageIndex() === 0 ? pages_left : pages_left,
              true,
            );
          // }
        } else {
          if (this.leftPage !== null || this.rightPage !== null) {
            let leftP = this.leftPage
              ? parseInt((this.setting.bookPages - this.leftPage.element.page) / 2) 
              : 0;

            let rightP = this.rightPage
              ? parseInt(this.rightPage.element.page / 2)
              : parseInt((this.leftPage.element.page - 1) / 2);
            if (this.app.getCurrentPageIndex() === 0) {
              leftP = 0;
            }
            if (this.app.getCurrentPageIndex() === this.app.pages.pages.length - 1) {
              rightP = 0;
            }
            // if (APP.Book.getBookModelSettings().show_right_to_left || true) {
              // this.redrawLinesCanvasPagesForTwoPage(rightP, leftP, true);
            // } else {
              this.redrawLinesCanvasPagesForTwoPage(leftP, rightP, true);
            // }
          } else {
            this.redrawLinesCanvasPagesForTwoPage(0, 0, true);
          }
        }
      }
    }

    update() {
      this.boundsRect = null;
      const t = this.calculateBoundsRect();

      // this.update_ThicknesTwoPage();

      this.orientation !== t && ((this.orientation = t), this.app.pages.updateDensityByBookMode(), this.app.updateOrientation(t), this.app.updateRootBookModeClassName());
    }
    calculateBoundsRect() {
      let t = 'landscape';
      const e = this.getBlockWidth(),
        i = e / 2,
        s = this.getBlockHeight() / 2,
        n = this.setting.width / this.setting.height;
      let h = this.setting.width,
        o = this.setting.height,
        a = i - h;
      return (
        'stretch' === this.setting.size
          ? (e < 2 * this.setting.minWidth &&
              this.app.getSettings().usePortrait &&
              (t = 'portrait'),
            (h = 'portrait' === t ? this.getBlockWidth() : this.getBlockWidth() / 2),
            h > this.setting.maxWidth && (h = this.setting.maxWidth),
            (o = h / n),
            o > this.getBlockHeight() && ((o = this.getBlockHeight()), (h = o * n)),
            (a = 'portrait' === t ? i - h / 2 - h : i - h))
          : e < 2 * h &&
            this.app.getSettings().usePortrait &&
            ((t = 'portrait'), (a = i - h / 2 - h)),
        (this.boundsRect = {
          left: a,
          top: s - o / 2,
          width: 2 * h,
          height: o,
          pageWidth: h,
        }),
        t
      );
    }
    setShadowData(t, e, i, s) {
      if (!this.app.getSettings().drawShadow) return;
      const n = 100 * this.getSettings().maxShadowOpacity;
      let progressParam = i < 30 ? i : i > 70 ? i - 40 : 30;
      this.shadow = {
        pos: t,
        angle: e,
        width: (((3 * this.getRect().pageWidth) / 4) * i) / 100,
        opacity: ((100 - i) * n) / 100 / 100,
        opacityInner: ((100 - progressParam) * n) / 100 / 100,
        direction: s,
        progress: 2 * i,
        showShadowOnMobile: this.getSettings().showShadowOnMobile,
      };
    }
    clearShadow() {
      this.shadow = null;
    }
    getBlockWidth() {
      return this.app.getUI().getDistElement().offsetWidth;
    }
    getBlockHeight() {
      return this.app.getUI().getDistElement().offsetHeight;
    }
    getDirection() {
      return this.direction;
    }
    getDirectionNamed() {
      return this.directionNamed;
    }
    getRect() {
      let rect = (null === this.boundsRect && this.calculateBoundsRect(), this.boundsRect);
      return rect;
    }
    getSettings() {
      return this.app.getSettings();
    }
    getOrientation() {
      return this.orientation;
    }
    setPageRect(t) {
      this.pageRect = t;
    }
    setDirection(t) {
      this.direction = t;
      this.directionNamed = t === 1 ? 'left' : 'right';
    }
    setRightPage(t) {
      null !== t && t.setOrientation(1), (this.rightPage = t);
    }
    setLeftPage(t) {
      null !== t && t.setOrientation(0), (this.leftPage = t);
    }

    setBottomPage(t) {
      null !== t && t !== undefined && t.setOrientation(1 === this.direction ? 0 : 1),
        (this.bottomPage = t);
    }
    setFlippingPage(page) {
      if (page !== null && page !== undefined) {
        page.setOrientation(
          this.direction === 0 && this.orientation !== 'portrait'
            ? 0
            : 1
        );

        if (this.app.pages) {
          const sourcePage = this.app.pages.getFlippingSourcePage(page);

          if (sourcePage) {
            sourcePage.element.classList.add('action');
          }
        }

        page.element.classList.add('action');
      }

      this.flippingPage = page;

      // null !== t &&
      //   t !== undefined &&
      //   t.setOrientation(0 === this.direction && 'portrait' !== this.orientation ? 0 : 1),
      //   (this.flippingPage = t);
    }
    setUnderFlippingPage(t) {
      null !== t &&
        t !== undefined &&
        t.setOrientation(0 === this.direction && 'portrait' !== this.orientation ? 1 : 0),
        (this.underFlippingPage = t);
    }
    convertToBook(t) {
      const e = this.getRect();
      return { x: t.x - e.left, y: t.y - e.top };
    }
    isSafari() {
      return this.safari;
    }
    convertToPage(t, e) {
      e || (e = this.direction);
      const i = this.getRect();
      if (forceOnePage || this.orientation == 'portrait') {
        return {
          x: 0 === e ? t.x - i.width / 2 : i.width / 2 - t.x - (i.left + i.pageWidth),
          y: t.y - i.top,
        };
      }
      return {
        x: 0 === e ? t.x - i.left - i.width / 2 : i.width / 2 - t.x + i.left,
        y: t.y - i.top,
      };
    }
    convertToGlobal(t, e) {
      if ((e || (e = this.direction), null == t)) return null;
      const i = this.getRect();
      if (forceOnePage || this.orientation == 'portrait') {
        return {
          x: 0 === e ? t.x + i.width / 2 : i.width / 2 - t.x,
          y: t.y + i.top,
        };
      }
      return {
        x: 0 === e ? t.x + i.left + i.width / 2 : i.width / 2 - t.x + i.left,
        y: t.y + i.top,
      };
    }
    convertRectToGlobal(t, e) {
      return (
        e || (e = this.direction),
        {
          topLeft: this.convertToGlobal(t.topLeft, e),
          topRight: this.convertToGlobal(t.topRight, e),
          bottomLeft: this.convertToGlobal(t.bottomLeft, e),
          bottomRight: this.convertToGlobal(t.bottomRight, e),
        }
      );
    }
  }

  class p {
    constructor(t, e, i) {
      (this.touchPoint = null),
        (this.swipeTimeout = 250),
        (this.onResize = () => {
          this.update();
        }),
        (this.onMouseDown = (t) => {
          if (t.which !== 1) {
            return;
          }
          
          if (
            !this.app.isBookZoomed() &&
            !(APP.Note && APP.Note.isThereExpandedNoteInArray()) &&
            !(t.target.classList && t.target.classList.contains('Note__marker'))
          ) {
            if (this.checkTarget(t.target)) {
              const e = this.getMousePos(t.clientX, t.clientY);
              this.app.startUserTouch(e), t.preventDefault();
            }
          }
        }),
        (this.onTouchStart = (t) => {
          if (!this.app.isBookZoomed()) {
            if (this.checkTarget(t.target) && t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              (this.touchPoint = { point: i, time: Date.now() }),
                setTimeout(() => {
                  null !== this.touchPoint && this.app.startUserTouch(i);
                }, this.swipeTimeout),
                this.app.getSettings().mobileScrollSupport || t.preventDefault();
            }
            if (this.checkTarget(t.target) && t.changedTouches.length >= 2) {
              this.app.setZoom();
            }
          }
        }),
        (this.onMouseUp = (t) => {
          if (!this.app.isBookZoomed()) {
            const e = this.getMousePos(t.clientX, t.clientY);
            this.app.userStop(e);
          }
        }),
        (this.onMouseLeave = (t) => {
          this.onMouseUp(t);
        }),
        (this.onMouseMove = (t) => {
          if (
            !this.app.isBookZoomed() &&
            !(APP.Note && APP.Note.isThereExpandedNoteInArray()) &&
            !(t.target.classList && t.target.classList.contains('Note__marker'))
          ) {
            const e = this.getMousePos(t.clientX, t.clientY);
            this.app.userMove(e, !1);
          }
        }),
        (this.onTouchMove = (t) => {
          if (!this.app.isBookZoomed()) {
            if (t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              this.app.getSettings().mobileScrollSupport
                ? (null !== this.touchPoint &&
                    (Math.abs(this.touchPoint.point.x - i.x) > 10 ||
                      'read' !== this.app.getState()) &&
                    t.cancelable &&
                    this.app.userMove(i, !0),
                  'read' !== this.app.getState() && t.preventDefault())
                : this.app.userMove(i, !0);
            }
          }
        }),
        (this.onTouchEnd = (t) => {
          if (!this.app.isBookZoomed()) {
            if (t.changedTouches.length == 1) {
              const e = t.changedTouches[0],
                i = this.getMousePos(e.clientX, e.clientY);
              let s = !1;
              if (null !== this.touchPoint) {
                const t = i.x - this.touchPoint.point.x,
                  e = Math.abs(i.y - this.touchPoint.point.y);
                Math.abs(t) > this.swipeDistance &&
                  Date.now() - this.touchPoint.time < this.swipeTimeout &&
                  (t > 0
                    ? this.app.flipPrev(
                        this.touchPoint.point.y < this.app.getRender().getRect().height / 4
                          ? 'top'
                          : 'bottom',
                      )
                    : this.app.flipNext(
                        this.touchPoint.point.y < this.app.getRender().getRect().height / 4
                          ? 'top'
                          : 'bottom',
                      ),
                  (s = !0)),
                  (this.touchPoint = null);
              }
              this.app.userStop(i, s);
            }
          } else {
            const e = t.changedTouches[0],
              i = this.getMousePos(e.clientX, e.clientY);
            let s = !1;
            this.app.userStop(i, s);
          }
        }),
        t.classList.add('stf__parent'),
        t.insertAdjacentHTML('afterbegin', '<div class="stf__wrapper"></div>'),
        (this.wrapper = t.querySelector('.stf__wrapper')),
        (this.app = e);
      const s = this.app.getSettings().usePortrait ? 1 : 2;

      i.autoSize && ((t.style.width = '100%'), (t.style.maxWidth = 2 * i.maxWidth + 'px')),
        (t.style.display = 'block'),
        window.addEventListener('resize', this.onResize, !1),
        (this.swipeDistance = i.swipeDistance);
    }
    destroy() {
      this.app.getSettings().useMouseEvents && this.removeHandlers(),
        this.distElement.remove(),
        this.wrapper.remove();
    }
    getDistElement() {
      return this.distElement;
    }
    getWrapper() {
      return this.wrapper;
    }
    setOrientationStyle(t) {
      this.wrapper.classList.remove('--portrait', '--landscape'),
        'portrait' === t
          ? (this.app.getSettings().autoSize &&
              (this.wrapper.style.paddingBottom =
                (this.app.getSettings().height / this.app.getSettings().width) * 100 + '%'),
            this.wrapper.classList.add('--portrait'))
          : (this.app.getSettings().autoSize &&
              (this.wrapper.style.paddingBottom =
                (this.app.getSettings().height / (2 * this.app.getSettings().width)) * 100 + '%'),
            this.wrapper.classList.add('--landscape')),
        this.update();
    }
    removeHandlers() {
      window.removeEventListener('resize', this.onResize),
        this.distElement.removeEventListener('mousedown', this.onMouseDown),
        this.distElement.removeEventListener('touchstart', this.onTouchStart),
        window.removeEventListener('mousemove', this.onMouseMove),
        window.removeEventListener('touchmove', this.onTouchMove),
        window.removeEventListener('mouseup', this.onMouseUp),
        window.removeEventListener('publuuwindowleave', this.onMouseLeave),
        window.removeEventListener('touchend', this.onTouchEnd);
    }
    setHandlers() {
      //        mouseleave
      this.app.getSettings().useMouseEvents &&
        (this.distElement.addEventListener('mousedown', this.onMouseDown),
        this.distElement.addEventListener('touchstart', this.onTouchStart),
        window.addEventListener('mousemove', this.onMouseMove),
        window.addEventListener('touchmove', this.onTouchMove, {
          passive: !this.app.getSettings().mobileScrollSupport,
        }),
        window.addEventListener('mouseup', this.onMouseUp),
        window.addEventListener('publuuwindowleave', this.onMouseLeave),
        window.addEventListener('touchend', this.onTouchEnd));
    }
    getMousePos(t, e) {
      const i = this.distElement.getBoundingClientRect();
      return { x: t - i.left, y: e - i.top };
    }
    checkTarget(t) {
      return (
        !this.app.getSettings().clickEventForward ||
        !['a', 'button'].includes(t.tagName.toLowerCase())
      );
    }
  }
  class c extends p {
    constructor(t, e, i, s) {
      super(t, e, i),
        this.wrapper.insertAdjacentHTML('afterbegin', '<div class="stf__block"></div>'),
        (this.distElement = t.querySelector('.stf__block'));
      for (const t of s) this.distElement.appendChild(t);
      this.setHandlers();
    }
    updateItems(t) {
      this.removeHandlers(), (this.distElement.innerHTML = '');
      for (const e of t) this.distElement.appendChild(e);
      this.setHandlers();
    }
    update() {
      this.app.getRender().update();
    }
  }

  class HardShadow {
    MAX_BACKBONE_WIDTH = 60;
    MIN_BACKBONE_WIDTH = 15;
    DEFAULT_BACKBONE_WIDTH = 30;
    BACKBONE_COEFFICIENT = 2.5;
    COEFFICIENT = 13;

    BOTTOM_SHADOW_OFFSET = 2;

    DYNAMIC_STYLES_ID = 'flipbook-hard-shadow-dynamic-styles';

    constructor(app, render, setting) {
      this.app = app;
      this.render = render;
      this.setting = setting;

      this.dynamicStyles = null;

      this.canvasShadowLayer = null;
      
      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.backboneWidth = 0;
    }

    initialize() {
      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.createDynamicStyles();
      this.drawCanvasShadowLayer();
      this.renderBookShadow();
      this.bindEvents();
    }

    getOffsetLeft() {
      if (APP.Book.getBookModelSettings().show_book_thickness) {
        return this.render.thickness.linesCountLeft;
      }

      return this.render.thickness.DEFAULT_LINES / 2;
    }
    
    getOffsetRight() {
      if (APP.Book.getBookModelSettings().show_book_thickness) {
        return this.render.thickness.linesCountRight;
      }

      return this.render.thickness.DEFAULT_LINES / 2;
    }

    renderBookGradient(position) {
      const ctx = this.canvasShadowLayer.getContext('2d');
      const offsetLeft = this.getOffsetLeft();
      const offsetRight = this.getOffsetRight();

      ctx.shadowColor = 0;
      ctx.shadowOffsetY = 0;

      if (position === 'shadow--left') {
        const e = Math.ceil(this.canvasShadowLayer.width / 2) - Math.ceil(this.backboneWidth / 2) - (offsetLeft - offsetRight)+ 1;
        const s = Math.ceil(this.canvasShadowLayer.width / 2) - offsetLeft - this.setting.width;

        const gradient = ctx.createLinearGradient(e, 0, s, 0);
      
        this.addStopsToBookGradient(gradient);
  
        ctx.fillStyle = gradient;
        ctx.fillRect(e, 0, -this.setting.width, this.canvasShadowLayer.height);
      }

      if (position === 'shadow--right') {
        const e = Math.ceil(this.canvasShadowLayer.width / 2) + Math.ceil(this.backboneWidth / 2) - (offsetLeft - offsetRight) - 1;
        const s = Math.ceil((this.canvasShadowLayer.width - this.render.hardWrapper.WRAPPER_EXTRA_WIDTH) / 2) + Math.ceil(this.backboneWidth / 2) + this.setting.width;

        const gradient = ctx.createLinearGradient(e, 0, s, 0);

        this.addStopsToBookGradient(gradient);
  
        ctx.fillStyle = gradient;
        ctx.fillRect(e, 0, s, this.canvasShadowLayer.height);
      }
    }

    addStopsToBookGradient(gradient) {
      gradient.addColorStop(0, "rgba(0, 0, 0, 0.15)");
      gradient.addColorStop(0.05, "rgba(0, 0, 0, 0)");
      gradient.addColorStop(0.15, "rgba(0, 0, 0, 0.05)");
      gradient.addColorStop(0.5, "rgba(0, 0, 0, 0)");
    }

    renderBookBottomShadow(position) {
      const ctx = this.canvasShadowLayer.getContext('2d');

      let x1 = this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 + this.BOTTOM_SHADOW_OFFSET;
      let x2 = this.canvasShadowLayer.width - this.render.hardWrapper.WRAPPER_EXTRA_WIDTH - this.BOTTOM_SHADOW_OFFSET * 2;

      ctx.clearRect(0, 0, this.canvasShadowLayer.width, this.canvasShadowLayer.height);
      ctx.fillStyle = 'rgba(0, 0, 0, 0.20)';
      ctx.save();
      ctx.shadowColor = '#000';
      ctx.shadowBlur = 7;
      ctx.shadowOffsetY = 1;
      
      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        x1 += this.setting.width;
        x2 = x1 + this.render.hardWrapper.WRAPPER_EXTRA_WIDTH;
      }

      if (position === 'shadow--left') {
        x2 = this.setting.width - this.BOTTOM_SHADOW_OFFSET * 2;
      }
      
      if (position === 'shadow--right') {
        x1 = this.setting.width + this.BOTTOM_SHADOW_OFFSET + this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;
        x2 = this.setting.width - this.BOTTOM_SHADOW_OFFSET;
      }

      ctx.fillRect(
        x1,
        this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT / 2 + this.BOTTOM_SHADOW_OFFSET,
        x2,
        this.canvasShadowLayer.height - this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT - this.BOTTOM_SHADOW_OFFSET * 2
      );

      ctx.restore();
    }

    renderBookBackbone(position) {
      const ctx = this.canvasShadowLayer.getContext('2d');
      const offsetLeft = this.getOffsetLeft();
      const offsetRight = this.getOffsetRight();

      const canvasHalfWidth = Math.ceil(this.canvasShadowLayer.width / 2);
      const thicknessLinesRight = offsetRight;
      const thicknessLinesLeft = offsetLeft;
      const backboneHalfWidth = Math.ceil(this.backboneWidth / 2);
      
      const centerPoint = canvasHalfWidth - backboneHalfWidth - (thicknessLinesLeft - thicknessLinesRight);

      const backbone = ctx.createLinearGradient(centerPoint, 0, centerPoint + this.backboneWidth, 0);
      backbone.addColorStop(0, "rgba(0, 0, 0, 0)");
      backbone.addColorStop(.02, "rgba(0, 0, 0, 0.33)");
      backbone.addColorStop(.5, "rgba(0, 0, 0, 0.20)");
      backbone.addColorStop(.98, "rgba(0, 0, 0, 0.33)");
      backbone.addColorStop(1, "rgba(0, 0, 0, 0)");

      ctx.shadowColor = null;
      ctx.shadowBlur = 0;
      ctx.shadowOffsetY = 0;
      ctx.fillStyle = backbone;

      ctx.fillRect(centerPoint, 0, centerPoint + this.backboneWidth, this.canvasShadowLayer.height);
      ctx.restore();

      if (position === 'shadow--right') {
        let x2 = Math.ceil(this.canvasShadowLayer.width / 2);

        if (forceOnePage || this.render.getOrientation() === 'portrait') {
          x2 -= this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;
        }

        ctx.clearRect(1, 0, x2, this.canvasShadowLayer.height);
      }
      
      if (position === 'shadow--left') {
        ctx.clearRect(Math.ceil(this.canvasShadowLayer.width / 2), 0, centerPoint, this.canvasShadowLayer.height);
      }
    }

    renderBookShadow() {
      if (!this.canvasShadowLayer) {
        return;
      }

      const ctx = this.canvasShadowLayer.getContext('2d');
      const shadowClass = this.render.hardWrapper.getRootShadowClass();
      
      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        ctx.clearRect(0, 0, this.canvasShadowLayer.width, this.canvasShadowLayer.height);
        return;
      }

      this.renderBookBottomShadow(shadowClass);

      if (shadowClass === 'shadow--full') {
        this.renderBookGradient('shadow--right');
        this.renderBookGradient('shadow--left');
      } else {
        this.renderBookGradient(shadowClass);
      }

      this.renderBookBackbone(shadowClass);
    }

    createDynamicStyles() {
      if (this.dynamicStyles) {
        return;
      }

      let dynamicStyles = document.querySelector(`style#${this.DYNAMIC_STYLES_ID}`);

      if (dynamicStyles) {
        this.dynamicStyles = dynamicStyles;
        return;
      }

      dynamicStyles = document.createElement('style');
      dynamicStyles.id = this.DYNAMIC_STYLES_ID;

      document.body.appendChild(dynamicStyles);
      this.dynamicStyles = dynamicStyles;
    }

    updateDynamicStyles() {
      if (!this.dynamicStyles) {
        return;
      }

      this.dynamicStyles.innerHTML = `
        .canvas-layer.shadow{width: ${this.rect.width}px;height: ${this.rect.height}px;top: ${this.rect.top}px;left: ${this.rect.left}px;}
      `;
    }

    drawCanvasShadowLayer() {
      const root = this.app.getRootElement();

      const width = this.rect.width;
      const height = this.rect.height;
      const left = -(this.WRAPPER_EXTRA_WIDTH / 2);
      const top = -(this.WRAPPER_EXTRA_HEIGHT / 2);

      this.canvasShadowLayer = document.createElement('canvas');

      this.canvasShadowLayer.className = 'canvas-layer shadow';
      this.canvasShadowLayer.width = width;
      this.canvasShadowLayer.height = height;

      root.insertAdjacentElement('afterbegin', this.canvasShadowLayer);

      this.backboneWidth = Math.min(
        Math.max(
          this.MIN_BACKBONE_WIDTH, 
          Math.ceil(
            this.setting.bookPages / this.COEFFICIENT
          )
        ), this.MAX_BACKBONE_WIDTH);

      this.canvasShadowLayer.dataset.backboneWidth = this.backboneWidth;

      this.rect = {
        width,
        height,
        top,
        left
      };

      this.update();
    }

    update() {
      if (!this.canvasShadowLayer) {
        return;
      }

      const width = Math.ceil(this.setting.width * 2) + this.render.hardWrapper.WRAPPER_EXTRA_WIDTH;
      const height = this.setting.height + this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT;
      const top = -this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT / 2;
      const left = -this.render.hardWrapper.WRAPPER_EXTRA_WIDTH / 2;
      let backboneWidth = this.render.thickness.calcCanvaMaxLinesCount() * this.BACKBONE_COEFFICIENT;

      backboneWidth = backboneWidth < this.MIN_BACKBONE_WIDTH ? this.MIN_BACKBONE_WIDTH : backboneWidth;

      if (this.backboneWidth !== backboneWidth) {
        this.backboneWidth = backboneWidth;
        this.canvasShadowLayer.dataset.backboneWidth = this.backboneWidth;
      }

      if (this.rect.width !== width || this.rect.height !== height || this.rect.top !== top || this.rect.left !== left) {
        this.canvasShadowLayer.width = width;
        this.canvasShadowLayer.height = height;

        this.rect = {
          width,
          height,
          top,
          left
        };
        
        this.updateDynamicStyles();
      }

      this.renderBookShadow();
    }

    hide() {
      if (!this.setting.hardCoverMode || !this.canvasShadowLayer) {
        return;
      }

      this.canvasShadowLayer.style.opacity = 0;
    }
    
    show() {
      if (!this.setting.hardCoverMode || !this.canvasShadowLayer) {
        return;
      }
  
      this.canvasShadowLayer.style.opacity = 1;
    }

    resizeHandler() {
      this.update();
    }

    bindEvents() {
      window.addEventListener('resize', () => this.resizeHandler());
    }

    unbindEvents() {
      window.removeEventListener('resize', this.resizeHandler);
    }

    clearDynamicStyles() {
      if (!this.dynamicStyles) {
        return;
      }

      this.dynamicStyles.remove();
      this.dynamicStyles = null;
    }

    clear() {
      const ctx = this.canvasShadowLayer.getContext('2d');

      ctx.clearRect(0, 0, this.canvasShadowLayer.width, this.canvasShadowLayer.height)

      this.canvasShadowLayer.width = 0;
      this.canvasShadowLayer.height = 0;
      
      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.backboneWidth = 0;
      this.canvasShadowLayer.remove();
      this.canvasShadowLayer = null;

      this.clearDynamicStyles();
      this.unbindEvents();
    }
  }

  class HardWrapper {
    WRAPPER_EXTRA_WIDTH = is_mobile() ? 16 : 36;
    WRAPPER_EXTRA_HEIGHT = is_mobile() ? 12 : 28;
    BORDER_RADIUS = 5;
    DEFAULT_BACKGROUND = '#fff';
    DYNAMIC_STYLES_ID = 'flipbook-hard-wrapper-dynamic-styles';

    constructor(app, render, setting) {
      this.app = app;
      this.render = render;
      this.setting = setting;

      this.hardShadow = new HardShadow(app, render, setting);

      this.dynamicStyles = null;

      this.design = {
        color: this.setting.hardCoverSettings.color || '#fff',
        borderRadius: 5,
      };

      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.forceRootShadowClass = null;
    }

    initialize() {
      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.createDynamicStyles();
      this.createBookHardWrapper();
      this.bindEvents();

      this.hardShadow.initialize();
    }

    createBookHardWrapper() {
      const root = this.app.getRootElement();     
      root.classList.add('hard');

      this.update('INIT');
    }

    createDynamicStyles() {
      if (this.dynamicStyles) {
        return;
      }

      let dynamicStyles = document.querySelector(`style#${this.DYNAMIC_STYLES_ID}`);

      if (dynamicStyles) {
        this.dynamicStyles = dynamicStyles;
        return;
      }

      dynamicStyles = document.createElement('style');
      dynamicStyles.id = this.DYNAMIC_STYLES_ID;

      document.body.appendChild(dynamicStyles);
      this.dynamicStyles = dynamicStyles;
    }

    updateDynamicStyles() {
      if (!this.dynamicStyles) {
        return;
      }

      const backgroundColor = this.design.color.indexOf('#') === 0 ? this.design.color : `#${this.design.color}`;

      this.dynamicStyles.innerHTML = `
        #book.hard::before,#book.hard::after{width: ${this.rect.width}px;height: ${this.rect.height}px;top: ${this.rect.top}px;left: ${this.rect.left}px;}
        #book.hard::before{background-color: ${backgroundColor};}
        #book.hard.shadow--full::before,#book.hard.shadow--full::after{border-radius: ${this.design.borderRadius}px}
        #book:not(.no-masks).hard.shadow--right::before,#book:not(.no-masks).hard.shadow--right::after{border-radius: 0 ${this.design.borderRadius}px ${this.design.borderRadius}px 0}
        #book:not(.no-masks).hard.shadow--right.book-mode--single.book-dir--rtl::before,#book:not(.no-masks).hard.shadow--right.book-dir--rtl::after{border-radius: ${this.design.borderRadius}px 0 0 ${this.design.borderRadius}px}
        #book:not(.no-masks).hard.shadow--left::before,#book:not(.no-masks).hard.shadow--left::after{border-radius: ${this.design.borderRadius}px 0 0 ${this.design.borderRadius}px}
        #book.hard.no-masks.shadow--right::before, #book.no-masks.hard.shadow--right::after{border-radius: ${this.design.borderRadius}px}
        #book.hard:not(.book-mode--single) .Page:not(.last, .first).page--bg{overflow:visible;}
        #book.hard:not(.book-mode--single) .Page:not(.last, .first).page--bg > div:first-of-type{z-index:2;position:relative;}

        #book.hard .stf__marcinBookShadow{display:none !important;opacity:0;}
        #book.hard.shadow--right .Page:is([data-density="hard"]).page--bg.action::after{background: linear-gradient(rgba(0, 0, 0, 0.16) 0%, rgba(0, 0, 0, 0) 0.3%, rgba(0, 0, 0, 0) 99.7%, rgba(0, 0, 0, 0.16) 100%) repeat scroll 0% 0% / auto padding-box border-box, linear-gradient(to left, rgba(0, 0, 0, 0) 1%, rgba(0, 0, 0, 0.13) 0%, rgba(0, 0, 0, 0) 6%, rgba(0, 0, 0, 0) 99.7%, rgba(0, 0, 0, 0.16) 100%) repeat scroll 0% 0% / auto padding-box border-box, ${backgroundColor} linear-gradient(to left, rgba(0, 0, 0, 0.26) 0%, rgba(0, 0, 0, 0.33) 1%, rgba(0, 0, 0, 0.1) 1%, rgba(0, 0, 0, 0) 2.5%, rgba(0, 0, 0, 0.05) 7%, rgba(0, 0, 0, 0) 50%) repeat scroll 0% 0% / auto padding-box border-box;}
        #book.hard.shadow--left .Page:is([data-density="hard"]).page--bg.action::after{background: linear-gradient(rgba(0, 0, 0, 0.16) 0%, rgba(0, 0, 0, 0) 0.3%, rgba(0, 0, 0, 0) 99.7%, rgba(0, 0, 0, 0.16) 100%) repeat scroll 0% 0% / auto padding-box border-box, linear-gradient(to right, rgba(0, 0, 0, 0) 1%, rgba(0, 0, 0, 0.13) 0%, rgba(0, 0, 0, 0) 6%, rgba(0, 0, 0, 0) 99.7%, rgba(0, 0, 0, 0.16) 100%) repeat scroll 0% 0% / auto padding-box border-box, ${backgroundColor} linear-gradient(to right, rgba(0, 0, 0, 0.26) 0%, rgba(0, 0, 0, 0.33) 1%, rgba(0, 0, 0, 0.1) 1%, rgba(0, 0, 0, 0) 2.5%, rgba(0, 0, 0, 0.05) 7%, rgba(0, 0, 0, 0) 50%) repeat scroll 0% 0% / auto padding-box border-box;}
        
        #book.hard.shadow--right .stf__wrapper.--landscape .Page:not(.last, .first):is([data-density="hard"]).action.page--bg::after{content: '';cursor:default;z-index:1;border-radius:${this.design.borderRadius}px 0 0 ${this.design.borderRadius}px;position:absolute;width: ${this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2}px;height: ${this.rect.height}px;top: ${this.rect.top}px;left: ${-this.WRAPPER_EXTRA_WIDTH / 2}px;box-shadow:-3px 0 3px #868686;}
        #book.hard.shadow--left .stf__wrapper.--landscape .Page:not(.last, .first):is([data-density="hard"]).action.page--bg::after{content: '';cursor:default;z-index:1;border-radius:0 ${this.design.borderRadius}px ${this.design.borderRadius}px 0;position:absolute;width: ${this.rect.width - this.render.thickness.linesCountLeft}px;height: ${this.rect.height}px;top: ${this.rect.top}px;left: ${0}px;box-shadow:3px 0 3px #868686;}

        #book.hard:not(.book-mode--single) .Page:not(.last, .first).page--bg::before{content: '';cursor:default;z-index:2;position:absolute;width: ${this.setting.width + 4}px;height: ${this.setting.height + 4}px;top:-2px;left:-2px;background:linear-gradient(to right, rgba(0, 0, 0, 0.03) 0%, rgba(0, 0, 0, 0.03) 100%) repeat scroll 0% 0% / auto padding-box border-box;}
        
        #main:not(.book--hard) #book.hard.book-mode--single .stf__marcinBookShadow{border-radius: ${this.design.borderRadius}px !important;box-shadow:none !important;}
        #main:not(.book--hard) #book.hard.book-mode--single::before,#main:not(.book--hard) #book.hard.book-mode--single::after{border-radius: ${this.design.borderRadius}px !important;}

        #book.hard.book-mode--single .stf__marcinBookShadow{box-shadow: 0px 0 2px 1px #86868640;-webkit-box-shadow: 0px 0 2px 1px #86868640}
      `;
    }

    updateRootShadowClass(className) {
      const root = this.app.getRootElement();

      Array.from(root.classList).filter(cn => cn.indexOf('shadow--') !== -1).forEach(cn => root.classList.remove(cn));
      root.classList.add(className);
    }

    getRootShadowClass() {
      const root = this.app.getRootElement();
      const shadowClass = Array.from(root.classList).filter(cn => cn.indexOf('shadow--') !== -1);
      
      return !!shadowClass.length ? shadowClass[0] : '';
    }

    updateOnFlippingToPage(currentSpreadIndex, newSpreadIndex, newPageIndex) {
      if (!this.setting.hardCoverMode) {
        return;
      }

      const spreads = this.app.pages.getSpread();
      const currentSpread = this.app.pages.getSpreadBySpreadIndex(currentSpreadIndex);
      const newSpread = this.app.pages.getSpreadBySpreadIndex(newSpreadIndex);
      const currentPageIndex = this.app.pages.getCurrentPageIndex();

      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        this.forceRootShadowClass = null;
        return;
      }

      if (currentSpread.length === newSpread.length) {
        if (currentSpreadIndex === spreads.length - 1 && newSpreadIndex === 0) {
          this.hide();
        }

        if (currentSpreadIndex === 0 && newSpreadIndex === spreads.length - 1) {
          this.hide();
        }

        return;
      }

      // From double spread to first page
      if (newSpreadIndex === 0 && currentSpread.length === 2) {
        this.forceRootShadowClass = 'shadow--right';

        const newPage = this.app.getPageCollection().getPage(currentPageIndex + 1);

        newPage.setTemporaryDensity('hard');

        if (newPage && newPage.element) {
          newPage.element.classList.add('action');
          newPage.element.classList.add('page--bg');
        }
      }

      // From double spread to last single page
      if (newSpreadIndex === spreads.length - 1 && currentSpread.length === 2) {
        this.forceRootShadowClass = 'shadow--left';

        const newPage = this.app.getPageCollection().getPage(currentPageIndex);

        newPage.setTemporaryDensity('hard');

        if (newPage && newPage.element) {
          newPage.element.classList.add('action');
          newPage.element.classList.add('page--bg');
        }
      }

      // From first page to double spread
      if (currentSpreadIndex === 0 && newSpread.length === 2) {
        this.forceRootShadowClass = 'shadow--right';

        const nextSpread = this.app.pages.getSpreadBySpreadIndex(newSpreadIndex);
        const newPage = this.app.getPageCollection().getPage(nextSpread[0]);

        newPage.setTemporaryDensity('hard');

        if (newPage && newPage.element) {
          newPage.element.classList.add('action');
          newPage.element.classList.add('page--bg');
        }
      }

      // From last single page to double spread
      if (currentSpreadIndex === spreads.length - 1 && newSpread.length === 2) {
        this.forceRootShadowClass = 'shadow--left';

        const nextSpread = this.app.pages.getSpreadBySpreadIndex(newSpreadIndex);
        const newPage = this.app.getPageCollection().getPage(nextSpread[1]);

        newPage.setTemporaryDensity('hard');

        if (newPage && newPage.element) {
          newPage.element.classList.add('action');
          newPage.element.classList.add('page--bg');
        }
      }
    }

    update(initiator = null) {
      const direction =  this.render.getDirection();
      const spreads = this.app.pages.getSpread();
      const currentSpread = this.app.pages.getCurrentSpread(initiator);
      const isSideSpread = this.app.pages.isSideSpread(currentSpread, direction);
      const currentRootShadowClass = this.getRootShadowClass();
      const currentRootPageModeClassName = this.app.getRootPageModeClassName();

      let newRootShadowClass = this.forceRootShadowClass || 'shadow--full'; // currentRootShadowClass;
      let width = this.setting.width * 2 + this.WRAPPER_EXTRA_WIDTH;
      let height = this.setting.height + this.WRAPPER_EXTRA_HEIGHT;
      let top = -this.WRAPPER_EXTRA_HEIGHT / 2;
      let left = -this.WRAPPER_EXTRA_WIDTH / 2;

      if (currentSpread.length === 2 && !!!isSideSpread && !this.app.flipController.flipToPageAction) { 
        newRootShadowClass = 'shadow--full';

        width = this.setting.width * 2 + this.WRAPPER_EXTRA_WIDTH;
        left = -this.WRAPPER_EXTRA_WIDTH / 2;
      } if (currentSpread.length === 2 && !!!isSideSpread && this.app.flipController.flipToPageAction && this.forceRootShadowClass) {
        if (this.forceRootShadowClass === 'shadow--right') {
          width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
          left = this.setting.width;
        } else {
          width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
          left = -this.WRAPPER_EXTRA_WIDTH / 2;
        }
      } else {
        if (isSideSpread && isSideSpread.state && isSideSpread.side === 'END') {
          const page = this.render.leftPage || this.app.pages.getFlippingPage(0, false);

          if (page && page.element && page.element.classList) {
            page.element.classList.add('page--bg');

            if (
              page.element.classList.contains('action') || 
              (
                (currentSpread === spreads[0]) &&
                currentRootPageModeClassName !== 'pages-mode--odd'
              )
            ) {
              newRootShadowClass = 'shadow--right';

              width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
              left = this.setting.width;
            }
          }
        }
        
        if (isSideSpread && isSideSpread.state && isSideSpread.side === 'START') {
          const page = this.render.rightPage || this.app.pages.getFlippingPage(1);

          if (page && page.element && page.element.classList) {
            page.element.classList.add('page--bg');
      
            if (page.element.classList.contains('action') || currentSpread === spreads[spreads.length - 1]) {
              newRootShadowClass = 'shadow--left';
  
              width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
              left = -this.WRAPPER_EXTRA_WIDTH / 2;
            }
          }
        }
      }

      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        newRootShadowClass = 'shadow--right';

        width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
        left = -this.WRAPPER_EXTRA_WIDTH / 2; // currentSpread === spreads[spreads.length - 1] ? 0 : -this.WRAPPER_EXTRA_WIDTH / 2;
      }

      if (spreads.length === 1) {
        newRootShadowClass = 'shadow--right';

        width = this.setting.width + this.WRAPPER_EXTRA_WIDTH / 2;
        left = this.setting.width - this.WRAPPER_EXTRA_WIDTH / 2;
      } 

      width += this.render.thickness.getLinesCount();
      left -= this.render.thickness.linesCountLeft;

      if (this.rect.width !== width || this.rect.height !== height || this.rect.top !== top || this.rect.left !== left) {
        this.rect =  {
          width,
          height,
          top,
          left
        };

        this.updateDynamicStyles();
      }

      if (currentRootShadowClass !== newRootShadowClass) {
        this.updateRootShadowClass(newRootShadowClass);
      }

      this.hardShadow.update();
    }

    updateWrapperColor(color) {
      if (!color || color === this.design.color) {
        return;
      }

      this.setting.hardCoverSettings.color = color;
      this.design.color = color;
      this.updateDynamicStyles();
    }

    show() {
      const root = this.app.getRootElement();

      if (!root) {
        return;
      }
      
      root.classList.remove('hide-hard-wrapper')
    }

    hide() {
      const root = this.app.getRootElement();

      if (!root) {
        return;
      }
      
      root.classList.add('hide-hard-wrapper')
    }

    resizeHandler() {
      this.update();
    }

    bindEvents() {
      window.addEventListener('resize', () => this.resizeHandler());
    }

    unbindEvents() {
      window.removeEventListener('resize', this.resizeHandler);
    }

    clearDynamicStyles() {
      if (!this.dynamicStyles) {
        return;
      }

      this.dynamicStyles.remove();
      this.dynamicStyles = null;
    }

    clear() {
      this.design = {
        color: this.setting.hardCoverSettings.color || '#fff',
        borderRadius: 5,
      };

      this.rect = {
        width: 0,
        height: 0,
        top: 0,
        left: 0
      };

      this.hardShadow.clear();
      this.clearDynamicStyles();
      this.unbindEvents();
    }
  }

  class Thickness {
    DEFAULT_LINES = 30;
    MAX_LINES = 30;
    LIMIT = 40;
    COEFFICIENT = 13;
    COLORS = ['#cccccc', '#999999', '#bbbbbb', '#999999'];
    DEFAULT_LINE_COLOR = '#eeeeee';
    DYNAMIC_STYLES_ID = 'flipbook-thickness-dynamic-styles';

    constructor(app, render, setting) {
      this.app = app;
      this.render = render;
      this.setting = setting;
      
      this.canvasPagesRight = null;
      this.canvasPagesLeft = null;

      this.dynamicStyles = null;

      this.linesCountLeft = 0;
      this.linesCountRight = 0;

      this.canvasPagesRightRect = {
        width: 0,
        height: 0,
        left: 'unset',
        right: 0
      };

      this.canvasPagesLeftRect = {
        width: 0,
        height: 0,
        left: 0,
        right: 'unset'
      };

      this.initialize();
    }

    initialize() {
      this.linesCountLeft = 0;
      this.linesCountRight = 0;

      this.setMaxLinesAndLimitByBookWidth();
      this.createDynamicStyles();
      this.createBookShadowMarcin();
      this.bindEvents();
    }

    setMaxLinesAndLimitByBookWidth() {
      const book = this.app.block;

      if (!book) return;

      const bookWidth = book.getBoundingClientRect().width;

      if (bookWidth <= 768) {
        this.MAX_LINES = 16;
        this.LIMIT = 22;
      } else if (bookWidth <= 1200) {
        this.MAX_LINES = 20;
        this.LIMIT = 30;
      } else {
        this.MAX_LINES = 30;
        this.LIMIT = 40;
      }
    }

    getLinesCount() {
      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return 0;
      }

      return (parseInt(this.linesCountLeft, 10) || 0) + (parseInt(this.linesCountRight, 10) || 0);
    }

    createBookShadowMarcin() {
      if (!this.app.getRootElement().querySelector('.stf__marcinBookShadow')) {
        this.app.getRootElement().insertAdjacentHTML(
          'afterbegin',
          '<div class="stf__marcinBookShadow doubleWidth" id="stf__marcinBookShadow" style="right:0px;"></div></div>',
        );

        if (this.setting.bookPages === 1) {
          this.app.getRootElement().querySelector('.stf__marcinBookShadow').hidden = true;
        }
      }

      if (is_mobile()) {
        return;
      }

      if (forceOnePage) {
        this.drawCanvasPagesForOnePage(0); // this.setting.bookPages
      } else {
        this.drawCanvasPagesForTwoPage(0, 0); // this.setting.bookPages, this.setting.bookPages
      }
    }

    drawCanvasPagesForOnePage(widthRight) {
      this.canvasPagesRight = document.querySelector('#stf__marcinBookPages_right');
      this.canvasPagesLeft = document.querySelector('#stf__marcinBookPages_left');

      if (!this.canvasPagesLeft) {
        document.querySelector('.stf__parent').insertAdjacentHTML(
          'afterbegin',
          `
            <canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="0" height="${this.setting.height}" style="left:0px;right: unset;"></canvas>
          `,
        );

        this.canvasPagesLeft = document.querySelector('#stf__marcinBookPages_left');
      }

      if (!this.canvasPagesRight) {
        document.querySelector('.stf__parent').insertAdjacentHTML(
          'afterbegin',
          `
            <canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
          `,
        );

        this.canvasPagesRight = document.querySelector('#stf__marcinBookPages_right');
      }

      this.canvasPagesLeft.style.display = 'none';

      if (widthRight <= 1) {
        this.canvasPagesRight.style.display = 'none';
      }
    }

    drawCanvasPagesForTwoPage(widthRight, widthLeft) {
      this.canvasPagesRight = document.querySelector('#stf__marcinBookPages_right');
      this.canvasPagesLeft = document.querySelector('#stf__marcinBookPages_left');

      if (!this.canvasPagesLeft) {
        document.querySelector('.stf__parent').insertAdjacentHTML(
          'afterbegin',
          `
            <canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="${widthLeft}" height="${this.setting.height}" style="left:-${widthLeft}px;right: unset;"></canvas>
          `,
        );

        this.canvasPagesLeft = document.querySelector('#stf__marcinBookPages_left');
      }

      if (!this.canvasPagesRight) {
        document.querySelector('.stf__parent').insertAdjacentHTML(
          'afterbegin',
          `
            <canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
          `,
        );

        this.canvasPagesRight = document.querySelector('#stf__marcinBookPages_right');
      }
    }

    createDynamicStyles() {
      if (this.dynamicStyles) {
        return;
      }

      let dynamicStyles = document.querySelector(`style#${this.DYNAMIC_STYLES_ID}`);

      if (dynamicStyles) {
        this.dynamicStyles = dynamicStyles;
        return;
      }

      dynamicStyles = document.createElement('style');
      dynamicStyles.id = this.DYNAMIC_STYLES_ID;

      document.body.appendChild(dynamicStyles);
      this.dynamicStyles = dynamicStyles;
    }

    updateDynamicStyles() {
      // this.render.hardWrapper.update();

      if (!this.dynamicStyles) {
        return;
      }
    }

    getCanvaLinesCount(flippingProgress = false) {
      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return [0, 0];
      }

      const bookPages = this.setting.bookPages;
      const direction = this.render.getDirection();
      const currentSpreadIndex = this.app.pages.getCurrentSpreadIndex();
      const currentSpread = this.app.pages.getSpreadBySpreadIndex(currentSpreadIndex);
      const spreadsLength = this.app.pages.getSpread().length;
      const maxLinesCount = this.calcCanvaMaxLinesCount();

      if (!flippingProgress && (currentSpreadIndex === 0 || currentSpreadIndex === spreadsLength - 1)) { // && !forceOnePage
        return [0, 0];
      }

      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        const LINES_LEFT = 0;
        const LINES_RIGHT = Math.max(0, Math.min(maxLinesCount, parseInt(bookPages - currentSpread[0])));

        return [LINES_RIGHT, LINES_LEFT]; // [LINES_LEFT, LINES_RIGHT]
      }

      const newSpreadIndex = direction === 0 ? currentSpreadIndex + 1 : currentSpreadIndex - 1;
      const newPages = this.app.pages.getSpreadBySpreadIndex(currentSpreadIndex);

      if (!newPages || !!!newPages.length) {
        return [0, 0]
      }

      if (currentSpreadIndex === 1 && newSpreadIndex === 0) {
        const LINES_LEFT = 0;
        const LINES_RIGHT = Math.max(0, Math.min(maxLinesCount, parseInt(currentSpread[1])));

        return [LINES_LEFT, LINES_RIGHT];
      }
      
      if (currentSpreadIndex === 0 && newSpreadIndex === 1) {
        const LINES_LEFT = 0;
        const LINES_RIGHT = Math.max(0, Math.min(maxLinesCount, parseInt(currentSpread[0])));

        return [LINES_LEFT, LINES_RIGHT];
      }

      if (newSpreadIndex === spreadsLength - 1) {
        const LINES_LEFT = Math.max(0, Math.min(maxLinesCount, parseInt(bookPages - newPages[0]))); // newPages[0] - 1
        const LINES_RIGHT = 0;

        return [LINES_LEFT, LINES_RIGHT];
      }

      const LINES_LEFT = Math.max(0, Math.min(maxLinesCount, newPages[0] >= bookPages ? 0 : newPages[0] - 1));
      const LINES_RIGHT = Math.max(0, Math.min(maxLinesCount, newPages[1] < 1 ? 0 : parseInt(bookPages - newPages[0])));

      return [LINES_RIGHT, LINES_LEFT]; // [LINES_LEFT, LINES_RIGHT]
    }

    getCanvaLinesCountByFlippingProgress(flippingProgress) {
      const [LINES_LEFT, LINES_RIGHT] = this.getCanvaLinesCount(true);
      const direction = this.render.getDirection();

      const bookPages = this.setting.bookPages;
      const maxLinesCount = this.calcCanvaMaxLinesCount();
      const linesCount = Math.max(0, parseInt(maxLinesCount * flippingProgress / 100));

      const currentSpreadIndex = this.app.pages.getCurrentSpreadIndex();
      const prevSpreadIndex = this.app.pages.getPrevSpreadIndex();
      const spreadsLength = this.app.pages.getSpread().length;
      
      if (direction === 0) {
        if (currentSpreadIndex === 0 || (prevSpreadIndex === 0 && this.app.flipController.flipToPageAction)) {
          if (forceOnePage || this.render.getOrientation() === 'portrait') {
            return [Math.min(LINES_LEFT, linesCount), 0];
          }

          return [0, Math.min(LINES_RIGHT, linesCount)];
        }

        if (this.render.rightPage && this.render.rightPage.element.page === bookPages - 1) {
          return [Math.max(LINES_LEFT, linesCount) - linesCount, 0];
        }

        return [Math.max(0, maxLinesCount - linesCount), Math.min(LINES_RIGHT, linesCount)];
      } else {
        if (currentSpreadIndex === spreadsLength - 1 || (prevSpreadIndex === spreadsLength - 1 && this.app.flipController.flipToPageAction)) {
          return [Math.min(LINES_LEFT, linesCount), 0];
        }

        if (this.app.flipController.flippingPage && +this.app.flipController.flippingPage?.element.getAttribute('page') >= bookPages - 1) {
          if (forceOnePage || this.render.getOrientation() === 'portrait') {
            return [Math.min(LINES_LEFT, linesCount), 0];
          }
        }

        return [Math.min(LINES_LEFT, maxLinesCount - linesCount), maxLinesCount - linesCount];
      }
    }

    calcCanvaMaxLinesCount() {
      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return this.DEFAULT_LINES / 2;
      }

      const bookPages = this.setting.bookPages;

      if (bookPages <= this.MAX_LINES) {
        return bookPages / 2;
      }

      const extraLines = Math.max(0, Math.ceil(bookPages / this.COEFFICIENT));
      const totalLines = Math.min(this.MAX_LINES + extraLines, this.LIMIT);

      return totalLines / 2;
    }

    updateCanvas(canvas, lines) {
      canvas.style.display = lines > 0 ? 'block' : 'none';
      canvas.style[canvas === this.canvasPagesLeft ? 'left' : 'right'] = `-${lines}px`;
      canvas.style.width = `${lines}px`;
      canvas.width = lines;

      const ctx = canvas.getContext('2d');
      ctx.clearRect(0, 0, canvas.width, canvas.height);

      let x = 0;
      let y = 0;

      for (let index = 0; index < lines; index++) {
        x += 1.0;
        y += 0.5;

        const heightDelta = lines / 3 - x / 3;
        const widthDelta = 1 - Math.floor(Math.random() * 10) / 100;
        const posY = heightDelta;
        const width = lines - x * widthDelta;
        const height = this.setting.height - 2 * heightDelta;
        const posX = canvas === this.canvasPagesLeft ? x : 0;

        this.drawCanvasLineAsRect(ctx, posX, posY, width, height, index);
        // this.drawCanvasLineAsLine(ctx, posX, posY, width, height, index);
      }

      // this.render.hardWrapper.update();
    }

    drawCanvasLineAsRect(ctx, x, y, width, height, index) {
      ctx.fillStyle = index % 2 === 1 ? this.DEFAULT_LINE_COLOR : this.COLORS[index % this.COLORS.length]; // grayColors[Math.floor(Math.random()*grayColors.length)];
      ctx.fillRect(x, y, width, height);
    }

    drawCanvasLineAsLine(ctx, x, y, width, height) {
      ctx.beginPath();
      ctx.moveTo(x, y);
      ctx.lineTo(x, height + x);
      ctx.stroke()
    }

    updateCanvasLines(force) {
      const [LINES_LEFT, LINES_RIGHT] = this.getCanvaLinesCount();

      if (
        Number(this.canvasPagesLeft.height) === this.setting.height && 
        Number(this.canvasPagesRight.height) === this.setting.height && 
        this.linesCountLeft === LINES_LEFT && 
        this.linesCountRight === LINES_RIGHT &&
        !force
      ) {
        return;
      }

      this.linesCountLeft = LINES_LEFT;
      this.linesCountRight = LINES_RIGHT;

      if ((Number(this.canvasPagesLeft.width) !== LINES_LEFT || Number(this.canvasPagesLeft.height) !== this.setting.height || force) && this.canvasPagesLeft.getContext) {
        this.canvasPagesLeft.height = this.setting.height;
        this.canvasPagesLeft.style.height = `${this.setting.height}px`;

        this.updateCanvas(this.canvasPagesLeft, LINES_LEFT);
      }
      
      if ((Number(this.canvasPagesRight.width) !== LINES_RIGHT || Number(this.canvasPagesRight.height) !== this.setting.height || force) && this.canvasPagesRight.getContext) {
        this.canvasPagesRight.height = this.setting.height;
        this.canvasPagesRight.style.height = `${this.setting.height}px`;

        this.updateCanvas(this.canvasPagesRight, LINES_RIGHT);
      }

      this.updateDynamicStyles();
    }

    shouldAnimateSoftPage() {
      const direction = this.render.getDirection();
      const bookPages = this.setting.bookPages;

      const currentSpreadIndex = this.app.pages.getCurrentSpreadIndex();
      const prevSpreadIndex = this.app.pages.getPrevSpreadIndex();
      const spreadsLength = this.app.pages.getSpread().length;

      switch (direction) {
        case 0:
          if (currentSpreadIndex === 0 || (prevSpreadIndex === 0 && this.app.flipController.flipToPageAction)) {
            return true;
          }

          if (this.app.flipController.flippingPage && +this.app.flipController.flippingPage.element.getAttribute('page') === 1) {
            return true;
          }
  
          return false;
        case 1:
          if (currentSpreadIndex === (spreadsLength - (forceOnePage ? 1 : 1)) || (prevSpreadIndex === spreadsLength - 1 && this.app.flipController.flipToPageAction)) {
            return true;
          }
  
          if (this.app.flipController.flippingPage && +this.app.flipController.flippingPage.element.getAttribute('page') >= bookPages - 1) {
            return true;
          }

          return false;
        default: 
          return false;
      }
    }

    updateCanvasLinesByFlippingProgress(flippingProgress) {
      if (this.render.flippingPage.nowDrawingDensity !== 'hard' && !this.shouldAnimateSoftPage()) {
        return;
      }

      const [LINES_LEFT, LINES_RIGHT] = this.getCanvaLinesCountByFlippingProgress(flippingProgress);

      if (this.linesCountLeft === LINES_LEFT && this.linesCountRight === LINES_RIGHT) {
        return;
      } 

      this.linesCountLeft = LINES_LEFT;
      this.linesCountRight = LINES_RIGHT;

      this.updateDynamicStyles();

      if (this.canvasPagesLeft.width != LINES_LEFT && this.canvasPagesLeft.getContext) {
        this.updateCanvas(this.canvasPagesLeft, LINES_LEFT);
      }

      if (this.canvasPagesRight.width != LINES_RIGHT && this.canvasPagesRight.getContext) {
        this.updateCanvas(this.canvasPagesRight, LINES_RIGHT);
      }
    }

    update(flippingProgress = null, force = false) {
      if (is_mobile() || !APP.Book.getBookModelSettings().show_book_thickness) {
        if (this.canvasPagesLeft) this.canvasPagesLeft.width = 0;
        if (this.canvasPagesRight) this.canvasPagesRight.width = 0;

        this.render.adjustInnerElements(flippingProgress);

        return;
      }

      if (!this.canvasPagesLeft || !this.canvasPagesRight) {
        return;
      }

      if (flippingProgress) {
        this.updateCanvasLinesByFlippingProgress(flippingProgress);
      } else {
        this.updateCanvasLines(force);
      }

      this.render.adjustInnerElements(flippingProgress);
    }

    resizeHandler() {
      const height = this.setting.height;
      const [LINES_LEFT, LINES_RIGHT] = this.getCanvaLinesCount();
      let shouldUpdateStyles = false;

      this.setMaxLinesAndLimitByBookWidth();

      if (this.canvasPagesLeft && this.canvasPagesLeft.getContext && (Number(this.canvasPagesLeft.height) !== height || this.linesCountLeft !== LINES_LEFT)) {
        this.canvasPagesLeft.height = height;
        this.linesCountLeft = LINES_LEFT;
        shouldUpdateStyles = true;

        this.updateCanvas(this.canvasPagesLeft, this.linesCountLeft);
      }

      if (this.canvasPagesRight && this.canvasPagesRight.getContext && (Number(this.canvasPagesRight.height) !== height || this.linesCountRight !== LINES_RIGHT)) {
        this.canvasPagesRight.height = height;
        this.linesCountRight = LINES_RIGHT;
        shouldUpdateStyles = true;

        this.updateCanvas(this.canvasPagesRight, this.linesCountRight);
      }

      if (shouldUpdateStyles) {
        this.updateDynamicStyles();
      }
    }

    bindEvents() {
      window.addEventListener('resize', () => this.resizeHandler());
    }

    unbindEvents() {
      window.removeEventListener('resize', this.resizeHandler);
    }

    clearDynamicStyles() {
      if (!this.dynamicStyles) {
        return;
      }

      this.dynamicStyles.remove();
      this.dynamicStyles = null;
    }

    clear() {
      this.canvasPagesLeft.remove();
      this.canvasPagesRight.remove();

      this.canvasPagesLeft = null;
      this.canvasPagesRight = null;

      this.linesCountLeft = 0;
      this.linesCountRight = 0;
      
      this.clearDynamicStyles();
      this.unbindEvents();
    }
  }

  class w extends l {
    constructor(t, e, i) {
      super(t, e),
        (this.contForShadow = null),
        (this.outerShadow = null),
        (this.innerShadow = null),
        (this.underShadow = null),
        (this.extraLeftFliped = null),
        (this.hardShadowElement = null),
        (this.hardInnerShadow = null),
        (this.canvasShadowLayer = null),
        (this.element = i);
      
      this.arrowRelativeLeft = null;
      this.arrowRelativeRight = null;

      this.hardWrapper = new HardWrapper(t, this, e);
      this.thickness = new Thickness(t, this, e);

      this.bookWrapper = null;

      this.createShadows();
      this.defineArrows();
    }

    start() {
      super.start();

      this.bookWrapper = document.querySelector('.Book__inner');

      if (this.setting.hardCoverMode) {
        this.hardWrapper.initialize();
      }
    }

    drawCanvasPagesForOnePage(pagesOnRight) {
      var widthRight = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;

      document.querySelector('.stf__parent').insertAdjacentHTML(
        'afterbegin',
        `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="0" height="${this.setting.height}" style="left:0px;right: unset;"></canvas>
`,
      );
      this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      this.canvaPagesLeft = document.getElementById('stf__marcinBookPages_left');
      this.canvaPagesLeft.style.display = 'none';

      if (pagesOnRight <= 1) {
        this.canvaPagesRight.style.display = 'none';
      }
      //            var width = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;
      //
      //            document.querySelector('.stf__parent')
      //                    .insertAdjacentHTML("afterbegin",
      //            `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${width}" height="${this.setting.height}" style="right:-${width}px;left: unset;"></canvas>`);
      //            this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      //
      //
      //
      this.redrawLinesCanvasPagesForOnePage(parseInt(pagesOnRight));
      //        }
    }

    drawCanvasPagesForTwoPage(pagesOnLeft, pagesOnRight) {
      var widthRight = pagesOnRight >= 13 ? 13 : pagesOnRight + 1;
      var widthLeft = pagesOnLeft >= 13 ? 13 : pagesOnLeft + 1;

      document.querySelector('.stf__parent').insertAdjacentHTML(
        'afterbegin',
        `<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_right" width="${widthRight}" height="${this.setting.height}" style="right:-${widthRight}px;left: unset;"></canvas>
<canvas class="stf__marcinBookPages" id="stf__marcinBookPages_left" width="${widthLeft}" height="${this.setting.height}" style="left:-${widthLeft}px;right: unset;"></canvas>
`,
      );
      this.canvaPagesRight = document.getElementById('stf__marcinBookPages_right');
      this.canvaPagesLeft = document.getElementById('stf__marcinBookPages_left');

      this.redrawLinesCanvasPagesForTwoPage(parseInt(pagesOnLeft), parseInt(pagesOnRight));
    }

    drawCanvasPagesForOnePage_line(ctx, x, y, i, width) {
      var grayColors = ['#cccccc', '#bbbbbb', '#cacaca'];
      ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 3]; //grayColors[Math.floor(Math.random()*grayColors.length)];
      let heightdelta = width / 3 - x / 3 + Math.random();

      ctx.fillRect(0, heightdelta, width - x, this.setting.height - 2 * heightdelta);
    }

    redrawLinesCanvasPagesForTwoPage(pagesOnLeft, pagesOnRight, rebuildSize = false) {
      let maxWidth = 12;
      let multi = 1.25;

      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return;
      }
      if (rebuildSize) {
        if (this.canvaPagesLeft) {
          this.canvaPagesLeft.height = this.setting.height;
        }
        if (this.canvaPagesRight) {
          this.canvaPagesRight.height = this.setting.height;
        }
      }
      if (this.setting.height < 800) {
        maxWidth = 10;
        multi = 1.15;
        if (this.setting.height < 400) {
          maxWidth = 8;
          multi = 1.0;
        }
      }

      var grayColors = ['#cccccc', '#999999', '#bbbbbb', '#999999'];

      var is_left_visible_on_start = false;
      if (this.canvaPagesLeft) {
        is_left_visible_on_start = this.canvaPagesLeft.style.display === 'block';
        this.canvaPagesLeft.style.display = pagesOnLeft > 0 ? 'block' : 'none';

        var widthLeft = parseInt((pagesOnLeft > maxWidth ? maxWidth + 1 : pagesOnLeft + 2) * multi);

        this.canvaPagesLeft.style.left = `-${widthLeft}px`;
        this.canvaPagesLeft.style.width = `${widthLeft}px`;
        this.canvaPagesLeft.width = widthLeft;
        if (this.canvaPagesLeft.getContext) {
          var ctx = this.canvaPagesLeft.getContext('2d');
          ctx.clearRect(0, 0, this.canvaPagesLeft.width, this.canvaPagesLeft.height);

          var x = 0,
            y = 0;
          for (x = 0, i = 0; x < widthLeft; i++) {
            x += multi;
            y += 0.5;
            ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 4];
            let heightdelta = widthLeft / 3 - x / 5;
            let widthdelta = 1 - Math.floor(Math.random() * 10) / 100;
            ctx.fillRect(
              widthLeft,
              heightdelta,
              -(widthLeft - x * widthdelta),
              this.setting.height - 2 * heightdelta,
            );
          }
        }
      }

      this.canvaPagesRight.style.display = pagesOnRight > 0 ? 'block' : 'none';
      var widthRight = parseInt(
        (pagesOnRight > maxWidth ? maxWidth + 1 : pagesOnRight + 2) * multi,
      );
      this.canvaPagesRight.style.right = `-${widthRight}px`;
      this.canvaPagesRight.style.left = 'unset';
      this.canvaPagesRight.style.transform = 'rotate(0deg)';
      this.canvaPagesRight.style.width = `${widthRight}px`;
      this.canvaPagesRight.width = widthRight;

      if (this.canvaPagesRight.getContext) {
        var ctx = this.canvaPagesRight.getContext('2d');
        ctx.clearRect(0, 0, this.canvaPagesRight.width, this.canvaPagesRight.height);

        var x = 0,
          y = 0;
        for (x = 0, i = 0; x < widthRight; i++) {
          x += multi;
          y += 0.5;
          ctx.fillStyle = i % 2 === 1 ? '#eeeeee' : grayColors[i % 4];
          let heightdelta = widthRight / 3 - x / 5;
          let widthdelta = 1 - Math.floor(Math.random() * 10) / 100;
          ctx.fillRect(
            0,
            heightdelta,
            widthRight - x * widthdelta,
            this.setting.height - 2 * heightdelta,
          );
        }
      }
    }

    redrawLinesCanvasPagesForOnePage(pagesOnRight, rebuildSize = false) {
      let maxWidth = 13;
      // let multi = 1.25;

      if (!APP.Book.getBookModelSettings().show_book_thickness) {
        return;
      }
      if (rebuildSize) {
        this.canvaPagesRight.height = this.setting.height;
      }
      if (this.setting.height < 800) {
        maxWidth = 10;
        if (this.setting.height < 400) {
          maxWidth = 8;
        }
      }
      var width = pagesOnRight >= maxWidth ? maxWidth : pagesOnRight + 1;

      this.canvaPagesRight.style.display = pagesOnRight > 0 ? 'block' : 'none';
      var widthRight = parseInt(pagesOnRight > maxWidth ? maxWidth : pagesOnRight);
      this.canvaPagesRight.style.right = `-${widthRight}px`;
      this.canvaPagesRight.style.width = `${widthRight}px`;
      this.canvaPagesRight.width = widthRight;

      if (APP.Book.getBookModelSettings().show_right_to_left || true) {
        this.canvaPagesRight.style.left = `-${widthRight}px`;
        this.canvaPagesRight.style.right = 'unset';
        this.canvaPagesRight.style.transform = 'rotate(180deg)';
      }

      if (this.canvaPagesRight.getContext) {
        var ctx = this.canvaPagesRight.getContext('2d');
        ctx.clearRect(0, 0, this.canvaPagesRight.width, this.canvaPagesRight.height);

        var x = 0,
          y = 0;

        for (x = 0, i = 0; i < width; i++) {
          x += 1.0;
          y += 0.5;
          this.drawCanvasPagesForOnePage_line(ctx, x, y, i, width);
        }
      }
    }

    defineArrows() {
      this.arrowRelativeLeft = document.querySelector('.Book__navPrevPage.arrows-relative');
      this.arrowRelativeRight = document.querySelector('.Book__navNextPage.arrows-relative');
    }

    getInnerElementsOffsets(isArrow = true) {
      const INNER_OFFSET = this.setting.hardCoverMode ? this.hardWrapper.WRAPPER_EXTRA_WIDTH / 2 : 0;

      const currentSpreadIndex = this.app.pages.getCurrentSpreadIndex();
      const spreadsLength = this.app.pages.getSpread().length;
      const bookPages = Number(this.setting.bookPages);

      const root = this.app.getRootElement();
      const rootWidth = root.getBoundingClientRect().width;
      // let rootTransform = Math.abs(Number((root.style.transform || '0').replace('translateX(', '').replace('%)', '').replace('px)', '') || 0));
      const rootTransformValue = /[0-9]{1,2}%/.exec(root.style.transform);
      let rootTransform = Math.abs(Number(rootTransformValue && rootTransformValue.length ? rootTransformValue[0].replace('%', '') : 0));

      if (rootTransform !== 25 && rootTransform !== 0) {
        rootTransform = 0;
      }
      
      if (rootTransform === 0 && (currentSpreadIndex === spreadsLength - 1 || (currentSpreadIndex === 0 && bookPages % 2 === 0))) {
        rootTransform = 25;
      }

      const persent = (rootWidth / 100) * rootTransform;

      if (!isArrow) {
        if (forceOnePage || this.getOrientation() === 'portrait') {
          return [-this.thickness.linesCountLeft - INNER_OFFSET, 0];
        }

        if (currentSpreadIndex === 0) {
          return [this.setting.width - this.thickness.linesCountLeft, 0];
        }

        return [-this.thickness.linesCountLeft - INNER_OFFSET, 0];
      }

      if (forceOnePage || this.getOrientation() === 'portrait') {
        return [-this.thickness.linesCountLeft - INNER_OFFSET, 0];
      }

      return [persent - this.thickness.linesCountLeft - INNER_OFFSET, persent - this.thickness.linesCountRight - INNER_OFFSET];
    }

    getInnerCenterOffset() {
      if (!this.setting.hardCoverMode) {
        return 0;
      }

      return 0;

      return -this.thickness.getLinesCount() / 2;

      return Math.abs(this.thickness.linesCountLeft - this.thickness.linesCountRight);

      return this.hardWrapper.WRAPPER_EXTRA_WIDTH / 4 - this.thickness.getLinesCount(); // Math.abs(this.thickness.linesCountLeft - this.thickness.linesCountRight);      
    }

    adjustArrowsOffset(flippingProgress) {
      if (!this.arrowRelativeLeft || !this.arrowRelativeRight) {
        return;
      }

      const OFFSETS = this.getInnerElementsOffsets();

      const direction = this.getDirection();

      const spreads = this.app.pages.getSpread();
      const currentSpreadIndex = this.app.pages.getCurrentSpreadIndex();

      const arrowLeftNewPosition = OFFSETS[0];
      const arrowRightNewPosition = OFFSETS[1];

      const shouldHideLeftArrow = 
        (currentSpreadIndex === 0 && !flippingProgress) || 
        (flippingProgress && currentSpreadIndex === 1 && direction === 1) || 
        (flippingProgress && currentSpreadIndex === 0 && direction === 0);

      const shouldHideRightArrow = 
        (currentSpreadIndex === spreads.length - 1 && !flippingProgress) || 
        (flippingProgress && currentSpreadIndex === spreads.length - 2 && direction === 0) ||
        (flippingProgress && currentSpreadIndex === spreads.length - 1 && direction === 1);

      this.arrowRelativeLeft.style.left = `${arrowLeftNewPosition}px`;
      this.arrowRelativeRight.style.right = `${arrowRightNewPosition}px`;

      this.arrowRelativeLeft.style.visibility = shouldHideLeftArrow ? 'hidden' : 'visible';
      this.arrowRelativeRight.style.visibility = shouldHideRightArrow ? 'hidden' : 'visible';
    }

    adjustInnerButtons() {
      const INNER_ELEMENTS_OFFSET = 38;

      const searchButton = document.querySelector('.search__button');
      const noteBtnBottom = document.querySelector('.note__button');
      const absoluteFullscreenButton = document.querySelector('.absolute-fs-btn');
      
      const OFFSETS = this.getInnerElementsOffsets(false);

      const offsetLeft = OFFSETS[0] - INNER_ELEMENTS_OFFSET;

      if (searchButton) {
        searchButton.style.left = `${offsetLeft}px`;
      }

      if (noteBtnBottom) {
        noteBtnBottom.style.left = `${offsetLeft}px`;
      }

      if (absoluteFullscreenButton) {
        absoluteFullscreenButton.style.left = `${offsetLeft}px`;
      }
    }

    adjustBookWrapperPositionWithThickness() {
      const linesDifference = parseInt(Math.ceil(this.thickness.linesCountLeft - this.thickness.linesCountRight) / 2) || 0;
      
      if (this.bookWrapper) {
        this.bookWrapper.style.marginLeft = `${linesDifference}px`;
      }
    }

    adjustInnerElements(flippingProgress = null) {
      this.adjustArrowsOffset(flippingProgress);
      this.adjustInnerButtons();

      // if (!flippingProgress) {
      //   this.adjustBookWrapperPositionWithThickness();
      // }
    }

    createShadows() {
      this.element.insertAdjacentHTML(
        'beforeend',
        '<div class="marcincrop2" id="marcincrop2"></div>\n<div class="stf__innerShadow"></div>\n<div class="shadows"><div class="stf__outerShadow"></div>\n  <div class="stf__underShadow" id="underShadow" hidden></div>\n<div class="stf__hardShadow"></div>\n             <div class="stf__hardInnerShadow"></div></div><div class="extraLeftFliped"><div class="extraLeftFlipedBg"></div></div>',
      ),
        (this.contForShadow = this.element.querySelector('.shadows')),
        (this.outerShadow = this.element.querySelector('.stf__outerShadow')),
        (this.innerShadow = this.element.querySelector('.stf__innerShadow')),
        (this.underShadow = this.element.querySelector('.stf__underShadow')),
        (this.extraLeftFliped = this.element.querySelector('.extraLeftFliped')),
        (this.hardShadowElement = this.element.querySelector('.stf__hardShadow')),
        (this.hardInnerShadow = this.element.querySelector('.stf__hardInnerShadow'));
    }

    clearShadow() {
      super.clearShadow(),
        (this.outerShadow.style.cssText = 'display: none'),
        (this.innerShadow.style.cssText = 'display: none'),
        (this.underShadow.style.cssText = 'display: none'),
        (this.extraLeftFliped.style.cssText = 'display: none'),
        (this.hardShadowElement.style.cssText = 'display: none'),
        (this.hardInnerShadow.style.cssText = 'display: none');
    }

    //pod kartka
    drawOuterShadow(direction, t, angle, globalShadowPos) {
      if (this.underFlippingPage !== null) return;
      //30
      var opacity = 0.5;
      var s = 1 === direction ? 200 : 1; //this.shadow.width
      //   s = 0;

      if (this.shadow.progress > 160) {
        opacity = (1 - (this.shadow.progress - 160) / 40) * opacity;
      }

      1 === direction
        ? this.outerShadow.classList.add('fliped')
        : this.outerShadow.classList.remove('fliped');
      //        width: ${2*this.shadow.width}px;

      this.outerShadow.style.cssText = `
        display: block;  
        height: ${2 * t.height}px;
        transform-origin: ${s}px 100px;
        transform: translate3d(${globalShadowPos.x - s + 0.5}px, ${
        globalShadowPos.y - 100
      }px, 0) rotate(${angle}rad);
        opacity: ${opacity};
                                                                                
      `;
    }

    //cien z lewej pod zaginana kartka
    drawUnderShadow(direction, t, angle, globalShadowPos) {
      //22-23
      let width = '';

      if (this.leftPage === null && direction === 0 && !forceOnePage) {
        return;
      }

      if (this.rightPage === null && direction === 1 && !forceOnePage) {
        return;
      }

      if (this.app.flipController.checkState('fold_corner') && !forceOnePage) {
        return;
      }

      let corner = Math.round(t.height / 2);
      s = direction === 1 ? 0 : 200;
      0 === direction
        ? this.underShadow.classList.add('fliped')
        : this.underShadow.classList.remove('fliped');

      this.underShadow.hidden = false;
      var opacity = 0.25;
      if (forceOnePage) {
        if (direction === 0) {
          if (angle < 2 * Math.PI) {
            return;
          }
          opacity =
            this.shadow.progress < 50
              ? 0.25
              : this.shadow.progress > 130
              ? 0.65
              : this.shadow.progress / 200;
          width = 'width: 100%';
          this.underShadow.parentElement.style.left = `${globalShadowPos.x + 1}px`;
          opacity = 0.75;
          s = 0;
          width = `width: ${this.shadow.width}px`;
        } else {
          opacity = 0.75;
          s = 0;
          width = `width: ${this.shadow.width}px`;
          //dir0 -- onepage
          // width = `width: ${this.shadow.width}px`;
          // s = this.shadow.width;
          // opacity = 0.75;
           if (this.shadow.progress > 170) {
               opacity = ((225-this.shadow.progress) / 200);
           }
        }
      }

      ///////AJMY TLO TOTAJ ODWROCEONE ZAMIAST CIENIA

      this.underShadow.style.cssText = `
          display: block;
          height: ${
            2 * t.height
          }px;${width};                                                                 
          transform-origin:${s}px ${corner}px;
          transform: translate3d(${globalShadowPos.x - s}px, ${
        globalShadowPos.y - corner
      }px, 0) rotate(${angle}rad);
          opacity: ${opacity};background-size: contain; 
          `;
    }

    drawInnerShadowGoRight(angle, rect) {
      let shadowA = angle - this.flippingPage.state.angle;
      var pageW = rect.pageWidth;
      var width = Math.ceil(rect.pageWidth / 5);
      var toY = '0%';
      var left = 0;
      var bgPos = 'right';
      var rightOrLeft = 'left: 0px;';
      var distT = 0;
      var top = '0px';
      var height = '100%';

      this.flippingPage.odblaskDiv && this.flippingPage.odblaskDiv.classList.add('fliped');

      if (this.flippingPage.state.area[1] !== null) {
        if (this.flippingPage.state.area[0] !== null && this.flippingPage.state.area[0] !== undefined) {
          distT = this.distBetweenPoints(
            this.flippingPage.state.area[0],
            this.flippingPage.state.area[1],
          );
          left = distT - width;
          rightOrLeft = `left: ${left}px;`;
          height = '150%';
        }
      } else {
        //TODO
        if (this.flippingPage.state.area[4] !== null && this.flippingPage.state.area[4] !== undefined) {
          distT = this.distBetweenPoints(
            this.flippingPage.state.area[4],
            this.flippingPage.state.area[3],
          );
          width = distT > width ? width : distT;
          const rPageW = pageW - distT;
          bgPos = 'right';
          var rightOrLeft = `right: ${rPageW}px;`;
          toY = '100%';
          height = '130%';
          top = '-30%';
        }
      }

      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.cssText = `
         transform-origin: ${width}px ${toY};
        top: ${top}; bottom: 0px; ${rightOrLeft} display: block;  
        height: ${height};width: ${width}px;background-size: ${width}px;
        transform: rotate(${shadowA}rad); opacity: ${this.drawInnerShadowOpacity()};`;
      }
    }

    drawInnerShadowGoLeft(angle, rect) {
      let shadowA = angle - this.flippingPage.state.angle;
      var pageW = rect.pageWidth;
      var width = Math.ceil(rect.pageWidth / 5);
      var right = 0;
      var distT = 0;
      var bgPos = 'right';
      var rightOrLeft = 'right: 0px';
      var toY = '0%';
      var top = '0px';
      var height = '100%';
      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.classList.remove('fliped');
      }
      if (this.flippingPage.state.area[1] !== null) {
        if (this.flippingPage.state.area[0] !== null && this.flippingPage.state.area[0] !== undefined) {
          distT = this.distBetweenPoints(
            this.flippingPage.state.area[0],
            this.flippingPage.state.area[1],
          );
          right = distT - width;
          rightOrLeft = `right: ${right}px;`;
          height = '150%';
        }
      } else {
        //TODO
        if (this.flippingPage.state.area[4] !== null && this.flippingPage.state.area[4] !== undefined) {
          distT = this.distBetweenPoints(
            this.flippingPage.state.area[4],
            this.flippingPage.state.area[3],
          );
          width = distT > width ? width : distT;
          const rPageW = pageW - distT;
          bgPos = 'left';
          var rightOrLeft = `left: ${rPageW}px;`;
          toY = '100%';
          height = '130%';
          top = '-30%';
        }
      }

      if (this.flippingPage.odblaskDiv) {
        this.flippingPage.odblaskDiv.style.cssText = `
         transform-origin: 0% ${toY};
        top: ${top}; bottom: 0px; ${rightOrLeft} display: block;  
        height: ${height};width: ${width}px;background-size: ${width}px;
        transform: rotate(${shadowA}rad); opacity: ${this.drawInnerShadowOpacity()};z-index: 10;`;
      }
    }

    drawInnerShadowOpacity() {
      var opacity = 1.0;
      if (this.shadow.progress > 140) {
        opacity = (200 - this.shadow.progress) / 60;
      }
      return opacity;
    }

    drawInnerShadow(direction, rect, angle) {
      if (this.getDirection() === 0) {
        //jezeli w lewo i gorny corner to dziala idealnie
        if (forceOnePage) {
        } else {
          this.drawInnerShadowGoRight(angle, rect);
        }
      } else {
        this.drawInnerShadowGoLeft(angle, rect);
      }
    }

    drawInnerShadowSafari() {
      const t = this.getRect(),
        e = 2 * this.shadow.width,
        i = 0 === this.getDirection() ? e : 0,
        s = 0 === this.getDirection() ? 'right' : 'left',
        n = this.convertToGlobal(this.shadow.pos),
        o = this.shadow.angle + (3 * Math.PI) / 2,
        a = [
          this.pageRect.topLeft,
          this.pageRect.topRight,
          this.pageRect.bottomRight,
          this.pageRect.bottomLeft,
        ];
      let r = 'polygon( ';
      for (const t of a) {
        let e =
          1 === this.getDirection()
            ? { x: -t.x + this.shadow.pos.x, y: t.y - this.shadow.pos.y }
            : { x: t.x - this.shadow.pos.x, y: t.y - this.shadow.pos.y };
        (e = h.GetRotatedPoint(e, { x: i, y: 100 }, o)), (r += e.x + 'px ' + e.y + 'px, ');
      }
      (r = r.slice(0, -2)), (r += ')');

      this.innerShadow.style.cssText = `
        display: block;
        z-index: ${(this.getSettings().startZIndex + 10).toString(10)};
        width: ${e}px;
        height: ${2 * t.height}px;
        background: -webkit-linear-gradient(${s},rgba(255, 255, 255, ${
        this.shadow.opacityInner - 0.29
      }) 1%, 
        rgba(255, 255, 255, ${this.shadow.opacityInner}) 5%,
        rgba(0, 0, 0, ${this.shadow.opacityInner - 0.21}) 15%,
        rgba(0, 0, 0, ${this.shadow.opacityInner - 0.24}) 25%,
        transparent);
        transform-origin: ${i}px 100px;
        transform: translate3d(${n.x - i}px, ${n.y - 100}px, 0) rotate(${o}rad);
        -webkit-clip-path: ${r};
        clip-path: ${r};
      `;
    }

    distBetweenPoints(A, B) {
      var a = A.x - B.x;
      var b = A.y - B.y;
      var ab = Math.sqrt(a * a + b * b);
      return ab;
    }

    

    drawParent__showBookAsTwoPageCentered() {
      // let thickness = [0, 0];

      // if (APP && APP.Book && APP.Book.getThicknessWidth) {
      //   thickness = APP.Book.getThicknessWidth();
      // }

      // // TODO:
      // if (this.app.setting.hardCoverMode) {
      //   thickness = [thickness[0] - this.hardWrapper.WRAPPER_EXTRA_WIDTH / 2, thickness[1] - this.hardWrapper.WRAPPER_EXTRA_WIDTH / 2];
      // }
      
      if (this.setting.hardCoverMode && false) {
        document.getElementById('book').style.transform = `translateX(${this.getInnerCenterOffset()}px)`;
      } else {
        document.getElementById('book').style.transform = 'translateX(0%)';
      }

      // document.querySelector('.Book__navNextPage.arrows-relative').style.right = `${thickness[1]}px`;
      // document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
      // document.querySelector('.Book__navPrevPage.arrows-relative').style.left = `${thickness[0]}px`;
      // document.querySelector('.Book__navPrevPage.arrows-relative').style.right = 'unset';

      //shadow tez popraw
      document.getElementById('stf__marcinBookShadow').classList.remove('singleWidth');
      document.getElementById('stf__marcinBookShadow').classList.add('doubleWidth');
      document.getElementById('stf__marcinBookShadow').style.cssText = 'right: 0px';

      this.adjustInnerElements();
    }

    drawParent__showBookAsOnePageCentered() {
      if (this.setting.hardCoverMode && false) {
        document.getElementById('book').style.transform = `translateX(calc(25% - ${this.getInnerCenterOffset()}px))`;
      } else {
        document.getElementById('book').style.transform = 'translateX(25%)';
      }

      // document.querySelector('.Book__navNextPage.arrows-relative').style.right = `0px`;
      // document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
      // document.querySelector('.Book__navPrevPage.arrows-relative').style.right = '0px';

      document.getElementById('stf__marcinBookShadow').classList.add('singleWidth');
      document.getElementById('stf__marcinBookShadow').classList.remove('doubleWidth');
      document.getElementById('stf__marcinBookShadow').style.cssText = 'width: 50%; left: 0px; right: unset;';

      this.adjustInnerElements();
    }

    drawParent() {
      let x = -25;
      if ('portrait' !== this.orientation) {
        if (this.flippingPage) {
          if (this.direction == 0 && (APP.Book.getBookModelSettings().show_right_to_left || true)) {
            // w lewo
            //left
            if (this.flippingPage.element.classList[1] === '_page_1') {
              //na 1 strone
              document.getElementById('stf__marcinBookShadow').style.display = 'none';
              document.getElementById('stf__marcinBookShadow').style.width = '50%';
              document.getElementById('stf__marcinBookShadow').style.left = '0px';
              document.getElementById('stf__marcinBookShadow').style.right = null;

              x = 25;
              document.getElementById('book').style.transitionDuration = '0s';

              if (this.setting.hardCoverMode && false) {
                document.getElementById('book').style.transform = `translateX(calc(${x}% - ${this.getInnerCenterOffset()}px))`;
              } else {
                document.getElementById('book').style.transform = `translateX(${x}%)`;
              }
              
              const width = parseInt(document.querySelector('.Book__innerChild').style.width);
              const persent = (width / 100) * 25;
              
              // COMMENTED 20250310 FOR DYNAMIC POSITION BY FLIPPING PROGRESS
              // if (!this.setting.hardCoverMode) {
              //   document.querySelector('.Book__navPrevPage.arrows-relative').style.left = `${persent}px`;
              //   document.querySelector('.Book__navPrevPage.arrows-relative').style.right = 'unset';
              //   document.querySelector('.Book__navNextPage.arrows-relative').hidden = true;
              // }

              document.getElementById('book').style.transitionDuration = '.1s';
            }
          } else {
            if (this.leftPage === null) {
              //first page
            }

            if (
              this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}` &&
              this.app.pages.pages.length == 2
            ) {
              document.getElementById('stf__marcinBookShadow').style.right = '0px';
              document.getElementById('stf__marcinBookShadow').style.left = 'unset';
              // document.getElementById('stf__marcinBookShadow').style.display = 'none';
            } else if (
              this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}`
            ) {
              document.getElementById('stf__marcinBookShadow').style.width = '50%';
              document.getElementById('stf__marcinBookShadow').style.right = '0px';
              document.getElementById('stf__marcinBookShadow').style.left = null;

              x = -25;
              document.getElementById('book').style.transitionDuration = '0s';

              if (this.setting.hardCoverMode && false) {
                document.getElementById('book').style.transform = `translateX(calc(${x}% - ${this.getInnerCenterOffset()}px))`;
              } else {
                document.getElementById('book').style.transform = `translateX(${x}%)`;
              }

              const width = parseInt(document.querySelector('.Book__innerChild').style.width);
              const persent = (width / 100) * 25;
              
              // COMMENTED 20250310 FOR DYNAMIC POSITION BY FLIPPING PROGRESS
              // if (!this.setting.hardCoverMode) {
              //   document.querySelector(
              //     '.Book__navNextPage.arrows-relative',
              //   ).style.right = `${persent}px`;
              //   document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
              // }

              document.getElementById('book').style.transitionDuration = '.1s';
            } else {
              //alert("animacja w prawo" );
            }
          }
        } else {
          //nie ma biektu FB ale moze jest jako last a to znaczy ze to pierwsza klatka po animacji
          if (this.lastFrameFlippingPage) {
            audio = audioElements[Math.floor(Math.random() * audioElements.length)];
            if (this.direction === 0) {
              if (this.leftPage === null) {
                //scancelowana animacja 1 strny
              } else if (this.rightPage === null) {
                if (this.setting.hardCoverMode && false) {
                  document.getElementById('book').style.transform = `translateX(calc(25% - ${this.getInnerCenterOffset()}px))`;
                } else {
                  document.getElementById('book').style.transform = 'translateX(25%)';
                }

                // COMMENTED 20250310 FOR DYNAMIC POSITION BY FLIPPING PROGRESS
                // if (!this.setting.hardCoverMode) {
                //   const width = parseInt(document.querySelector('.Book__innerChild').style.width);
                //   const persent = (width / 100) * 25;

                //   document.querySelector('.Book__navNextPage.arrows-relative').style.right = `${persent}px`;
                //   document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
                // }
              } else {
                this.drawParent__showBookAsTwoPageCentered();
              }
            } else {
              //idziemy w lewo
              if (this.leftPage === null) {
                if (!this.setting.hardCoverMode) {
                  const width = parseInt(document.querySelector('.Book__innerChild').style.width);
                  const persent = (width / 100) * 25;

                  if (this.setting.hardCoverMode && false) {
                    document.getElementById('book').style.transform = `translateX(calc(-25% - ${this.getInnerCenterOffset()}px))`;
                  } else {
                    document.getElementById('book').style.transform = 'translateX(-25%)';
                  }

                  document.querySelector('.Book__navPrevPage.arrows-relative').style.left = `${persent}px`;
                  document.querySelector('.Book__navNextPage.arrows-relative').style.left = 'unset';
                }
              } else {
                if (this.rightPage == null) {
                  this.drawParent__showBookAsOnePageCentered();
                } 
                else {
                  this.drawParent__showBookAsTwoPageCentered();
                }
              }
            }
          }
        }
      } else {
        if (is_mobile() || forceOnePage) {
          if (this.flippingPage) {
          } else {
            if (this.lastFrameFlippingPage) {
              const refs = [...document.querySelectorAll(`[extraLayer="yes"]`)];
              for (i = 0; i < refs.length; ++i) {
                refs[i].removeAttribute('extraLayer');
              }
            }
          }
        }
      }
    }
    drawLeftPage() {
      const expectedDirection = (forceOnePage || this.getOrientation() === 'portrait') ? 0 : 1;

      //wina bledu 1 strony - left page is set
      'portrait' !== this.orientation &&
        null !== this.leftPage &&
        (expectedDirection === this.direction &&
        null !== this.flippingPage &&
        'hard' === this.flippingPage.getDrawingDensity()
          ? ((this.leftPage.getElement().style.zIndex = (
              this.getSettings().startZIndex + 5
            ).toString(10)),
            this.leftPage.setHardDrawingAngle(180 + this.flippingPage.getHardAngle()),
            this.leftPage.draw(this.flippingPage.getDrawingDensity(), 'drawLeftPage'))
          : this.flippingPage && this.flippingPage.element.classList[1] === `_page_${this.app.pages.pages.length}`
          ? this.leftPage.draw('clipping')
          : this.getSettings().hardCoverMode && this.leftPage.isSidePage(this.direction)
          ? this.leftPage.simpleHardDraw(0)
          : this.leftPage.simpleDraw(0));
    }

    drawRightPage() {
      const expectedDirection = (forceOnePage || this.getOrientation() === 'portrait') ? 1 : 0;

      null !== this.rightPage &&
        (expectedDirection === this.direction &&
        null !== this.flippingPage &&
        'hard' === this.flippingPage.getDrawingDensity()
          ? ((this.rightPage.getElement().style.zIndex = (
              this.getSettings().startZIndex + 5
            ).toString(10)),
            this.rightPage.setHardDrawingAngle(180 + this.flippingPage.getHardAngle()),
            this.rightPage.draw(this.flippingPage.getDrawingDensity(), 'drawRightPage'))
          : this.flippingPage &&
            this.flippingPage.element.classList[1] === '_page_1'
          ? this.rightPage.draw('clipping')
          : this.getSettings().hardCoverMode && this.rightPage.isSidePage(this.direction)
          ? this.rightPage.simpleHardDraw(1)
          : this.rightPage.simpleDraw(1));
    }
    drawBottomPage() {
      if (null === this.bottomPage) return;
      this.bottomPage.state.bottomPage = true;

      const t = null != this.flippingPage ? this.flippingPage.getDrawingDensity() : null;
      ('portrait' === this.orientation && 0 === this.direction) ||
        ((this.bottomPage.getElement().style.zIndex = (this.getSettings().startZIndex + 3).toString(
          10,
        )),
        this.bottomPage.draw(t, 'drawBottomPage'));
    }
    correctMarcinShadows() {
      if (this.app.getCurrentPageIndex() == 0) {
        document.querySelector('.stf__marcinBookShadow').classList.remove('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('singleWidth');
        document.querySelector('.stf__marcinBookShadow').style.right = '0px';
        document.querySelector('.stf__marcinBookShadow').style.left = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
      } else if (this.app.getCurrentPageIndex() >= this.app.getPageCount() - 1) {
        document.querySelector('.stf__marcinBookShadow').classList.remove('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('singleWidth');
        document.querySelector('.stf__marcinBookShadow').style.left = '0px';
        document.querySelector('.stf__marcinBookShadow').style.right = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
        document.querySelector('.Book__innerChild').style.transform = 'translateX(25%)';
      } else {
        document.querySelector('.stf__marcinBookShadow').classList.remove('singleWidth');
        document.querySelector('.stf__marcinBookShadow').classList.add('doubleWidth');
        document.querySelector('.stf__marcinBookShadow').style.right = '0px';
        document.querySelector('.stf__marcinBookShadow').style.left = null;
        document.querySelector('.stf__marcinBookShadow').style.width = null;
        document.querySelector('.Book__innerChild').style.transform = 'translateX(0%)';
        document.querySelector('.Book__navPrevPage.arrows-relative').style.left = '0';
        document.querySelector('.Book__navNextPage.arrows-relative').style.right = '0';
      }
    }

    drawFrame() {
      this.clear();
      this.drawParent();
      this.drawLeftPage();
      this.drawRightPage();
      this.drawBottomPage(); // te 4 0.3

      if (this.lastFrameFlippingPage === null && null !== this.flippingPage) {
        let direction = this.getDirection();

        /**
         * STRONY PODSPODEM PO CORNER ANIMATION
         */
        if (!this.app.flipController.checkState('fold_corner')) {
          let lP = this.leftPage ? parseInt(this.leftPage.element.page) : 0;
          let leftP = this.leftPage ? parseInt(this.leftPage.element.page / 2) : 0;
          let rightP = this.rightPage
            ? parseInt((this.setting.bookPages - this.rightPage.element.page) / 2)
            : 0;
        }

        if (forceOnePage && direction === 0 && !this.app.setting.hardCoverMode) {
          APP.Book.getPage(this.app.getCurrentPageIndex(), function (PageObj) {
            let shadowsDiv = document.querySelector('.extraLeftFliped');
            shadowsDiv.style.display = 'block';
            let extraLeftFlipedBg = document.querySelector('.extraLeftFlipedBg');
            //extraLeftFlipedBg.style.backgroundImage = `url(${PageObj.getCover('p2483')}`;
            extraLeftFlipedBg.style.backgroundColor = `#ffffff`;
          });
        }
      }
      //58-59
      if (this.lastFrameFlippingPage && this.flippingPage === null) {
        document.querySelector('#main').className = '';

        const marcinCrop = document.getElementById('marcincrop2');

        if (marcinCrop) {
          marcinCrop.style.cssText = '';
          marcinCrop.hidden = true;

          const pageInside = marcinCrop.querySelector('div.page-inside');

          if (pageInside) pageInside.remove();
        }
      }

      if (null !== this.flippingPage) {
        this.flippingPage.getElement().style.zIndex = 5;
        this.flippingPage.draw(false, 'fp');

        if (null !== this.shadow) {
          let direction = this.getDirection();
          let t = this.getRect();
          let angle = this.shadow.angle + 4.71238898; //3/2 pi
          let globalShadowPos = this.convertToGlobal(this.shadow.pos);

          // if ((APP.Book.getBookModelSettings().show_right_to_left || true) && forceOnePage) {
          //   if (direction === 1) {
          //     globalShadowPos.x += 568;
          //   } 
          //   // else {
          //   //   globalShadowPos.x -= 568;
          //   // }
          // } 

          if (this.flippingPage.nowDrawingDensity !== 'hard' && !is_mobile()) {
            if (this.isSafari()) {
              this.drawInnerShadowSafari(); //SAFARI
            } else {
              this.drawInnerShadow(direction, t, angle); //CHROME
            }

            if (this.app.flipController.initialAction === 'fold') {
              this.drawOuterShadow(direction, t, angle, globalShadowPos); //30-31
              this.drawUnderShadow(direction, t, angle, globalShadowPos); //21-24
            }
          }
        }
      } else {
        this.underShadow.parentElement.style.left = `0px`;
      }

      this.lastFrameFlippingPage = this.flippingPage;
    }

    clear() {
      for (const t of this.app.getPageCollection().getPages())
        t !== this.leftPage &&
          t !== this.rightPage &&
          t !== this.flippingPage &&
          t !== this.bottomPage &&
          (t.getElement().style.cssText = 'display: none'),
          t.getTemporaryCopy() !== this.flippingPage && t.hideTemporaryCopy();
    }
    update() {
      super.update(),
        null !== this.rightPage && this.rightPage.setOrientation(1),
        null !== this.leftPage && this.leftPage.setOrientation(0);
    }
  }
  class x {
    constructor() {
      this._default = {
        startPage: 0,
        size: 'fixed',
        width: 0,
        height: 0,
        minWidth: 0,
        maxWidth: 0,
        minHeight: 0,
        maxHeight: 0,
        drawShadow: !0,
        flippingTime: 1e3,
        usePortrait: !0,
        startZIndex: 0,
        autoSize: !0,
        maxShadowOpacity: 1,
        showCover: !1,
        mobileScrollSupport: !0,
        swipeDistance: 30,
        clickEventForward: !0,
        useMouseEvents: !0,
        showShadowOnMobile: true,
        hardCoverMode: false,
        hardCoverSettings: {
          color: '#fff'
        }
      };
    }
    getSettings(t) {
      const e = this._default;
      if ((Object.assign(e, t), 'stretch' !== e.size && 'fixed' !== e.size))
        throw new Error('Invalid size type. Available only "fixed" and "stretch" value');
      if (e.width <= 0 || e.height <= 0) throw new Error('Invalid width or height');
      if (e.flippingTime <= 0) throw new Error('Invalid flipping time');
      return (
        'stretch' === e.size
          ? (e.minWidth <= 0 && (e.minWidth = 100),
            e.maxWidth < e.minWidth && (e.maxWidth = 2e3),
            e.minHeight <= 0 && (e.minHeight = 100),
            e.maxHeight < e.minHeight && (e.maxHeight = 2e3))
          : ((e.minWidth = e.width),
            (e.maxWidth = e.width),
            (e.minHeight = e.height),
            (e.maxHeight = e.height)),
        e
      );
    }
  }
  !(function (t, e) {
    void 0 === e && (e = {});
    var i = e.insertAt;
    if (t && 'undefined' != typeof document) {
      var s = document.head || document.getElementsByTagName('head')[0],
        n = document.createElement('style');
      (n.type = 'text/css'),
        'top' === i && s.firstChild ? s.insertBefore(n, s.firstChild) : s.appendChild(n),
        n.styleSheet ? (n.styleSheet.cssText = t) : n.appendChild(document.createTextNode(t));
    }
  })(
    '.stf__parent {\n  position: relative;\n  display: block;\n  box-sizing: border-box;\n  transform: translateZ(0);\n\n  -ms-touch-action: pan-y;\n  touch-action: pan-y;\n}\n\n.sft__wrapper {\n  position: relative;\n  width: 100%;\n  box-sizing: border-box;\n}\n\n.stf__block {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  box-sizing: border-box;\n  perspective: 2000px;\n z-index: 2;\n}\n\n.stf__item {\n  display: none;\n  position: absolute;\n  }\n\n.stf__outerShadow {\n  position: absolute;\n  left: 0;\n  top: 0; z-index: 10;\n}\n\n.stf__innerShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}\n\n.stf__underShadow {\n  position: absolute;\n  left: 0;\n  z-index:3;\n top: 0;\n}\n\n.stf__hardShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}\n\n.stf__hardInnerShadow {\n  position: absolute;\n  left: 0;\n  top: 0;\n}',
  );
  (t.PageFlip = class extends (
    class {
      constructor() {
        this.events = new Map();
      }
      on(t, e) {
        return this.events.has(t) ? this.events.get(t).push(e) : this.events.set(t, [e]), this;
      }
      off(t) {
        this.events.delete(t);
      }
      trigger(t, e, i = null) {
        if (this.events.has(t)) for (const s of this.events.get(t)) s({ data: i, object: e });
      }
    }
  ) {
    constructor(t, e) {
      super(),
        (this.isUserTouch = !1),
        (this.isZoomed = false),
        (this.isUserMove = !1),
        (this.setting = null),
        (this.pages = null),
        (this.setting = new x().getSettings(e)),
        (this.block = t);
    }
    destroy() {
      this.ui.destroy(), this.block.remove();
    }
    update() {
      this.render.update(), this.pages.show();

      this.updateRootClassNames();

      this.render.hardWrapper.update();
      this.render.thickness.update(null, true);
    }

    loadFromHTML(t) {
      (this.ui = new c(this.block, this, this.setting, t)),
        (this.render = new w(this, this.setting, this.ui.getDistElement())),
        (this.flipController = new g(this.render, this)),
        (this.pages = new a(this, this.render, this.ui.getDistElement(), t)),
        this.pages.load(),
        this.render.start(),

        this.pages.updateDensityByBookMode();
        this.updateRootBookModeClassName();
        
        this.pages.show(this.setting.startPage -1);

        this.render.hardWrapper.update();
        this.render.thickness.update();

        setTimeout(() => {
          this.ui.update(),
            this.trigger('init', this, {
              page: this.setting.startPage -1,
              mode: this.render.getOrientation(),
            });
        }, 1);
    }
    updateFromImages(t) {
      const e = this.pages.getCurrentPageIndex();
      this.pages.destroy(),
        (this.pages = new n(this, this.render, t)),
        this.pages.load(),
        this.pages.show(e),
        this.trigger('update', this, {
          page: e,
          mode: this.render.getOrientation(),
        });
    }
    updateFromHtml(t) {
      const e = this.pages.getCurrentPageIndex();
      this.pages.destroy(),
        (this.pages = new a(this, this.render, this.ui.getDistElement(), t)),
        this.pages.load(),
        this.ui.updateItems(t),
        this.pages.show(e),
        this.trigger('update', this, {
          page: e,
          mode: this.render.getOrientation(),
        });
    }
    turnToPrevPage() {
      this.pages.showPrev();
    }
    turnToNextPage() {
      this.pages.showNext();
    }
    turnToPage(t) {
      //never called
      this.pages.show(t);
    }
    showCorner() {
      this.flipController.showCorner({ x: 1116, y: 1 });
    }
    flipNext(t = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipNext(t);
    }
    flipPrev(t = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipPrev(t);
    }
    flip(t, e = forceOnePage ? 'bottom' : 'top') {
      this.flipController.flipToPage(t, e);
    }
    updateState(t) {
      this.trigger('changeState', this, t);
    }
    updatePageIndex(t) {
      this.trigger('flip', this, t);
    }
    updateOrientation(t) {
      this.ui.setOrientationStyle(t), this.update(), this.trigger('changeOrientation', this, t);
    }
    getPageCount() {
      return this.pages.getPageCount();
    }
    getCurrentPageIndex() {
      return this.pages.getCurrentPageIndex();
    }
    getPage(t) {
      return this.pages.getPage(t);
    }
    getRender() {
      return this.render;
    }
    getFlipController() {
      return this.flipController;
    }
    getOrientation() {
      return this.render.getOrientation();
    }
    getBoundsRect() {
      return this.render.getRect();
    }
    getSettings() {
      return this.setting;
    }
    getUI() {
      return this.ui;
    }
    getState() {
      return this.flipController.getState();
    }
    getPageCollection() {
      return this.pages;
    }
    setSettings(w, h) {
      let settings = this.setting;
      settings.minHeight = h;
      settings.minWidth = w;
      settings.width = w;
      settings.height = h;
      this.update();
    }
    getHardCoverSettings() {
      return {
        hardWrapper: {
          WRAPPER_EXTRA_WIDTH: this.render.hardWrapper.WRAPPER_EXTRA_WIDTH || (is_mobile() ? 16 : 36),
          WRAPPER_EXTRA_HEIGHT: this.render.hardWrapper.WRAPPER_EXTRA_HEIGHT || (is_mobile() ? 12 : 28),
          rect: this.render.hardWrapper.rect,
        }, 
        thickness: {
          linesLeft: this.render.thickness.linesCountLeft,
          linesCountRight: this.render.thickness.linesCountRight,
          totalLines: this.render.thickness.getLinesCount(),
        },
      };
    }
    initializeBookHardCover(data) {
      if (this.setting.hardCoverMode) {
        if (this.render.hardWrapper.design.color !== data.color) {
          this.render.hardWrapper.updateWrapperColor(data.color);
          this.render.hardWrapper.update();

          this.update();
        }

        return;
      }

      this.updateRootClassNames();

      this.render.hardWrapper.initialize();
      this.render.hardWrapper.update();
      this.pages.changePagesDensity('hard');

      this.setting.hardCoverMode = true;

      this.render.adjustInnerElements();
    }
    destroyBookHardCover() {
      if (!this.setting.hardCoverMode) {
        return;
      }
      
      this.updateRootClassNames();

      this.render.hardWrapper.clear();
      this.pages.changePagesDensity('soft');

      this.setting.hardCoverMode = false;

      this.render.adjustInnerElements();
    }
    initializeBookHardCoverThickness() {
      this.render.thickness.initialize();
      this.render.thickness.update();
      this.render.hardWrapper.update();
      this.render.adjustInnerElements();
    }
    destroyBookHardCoverThickness() {
      this.render.thickness.clear();
      this.render.hardWrapper.update();
      this.render.adjustInnerElements();
    }
    updateRootClassNames() {
      const root = this.getRootElement();
      const rootDynamicClassNames = ['--hard', 'hard', 'shadow--right', 'shadow--left'];
      const pageDynamicClassNames = ['--soft', '--hard', 'page--bg', 'no-masks', 'hard-mask--right', 'hard-mask--left'];

      Array.from(root.classList).filter(cls => rootDynamicClassNames.indexOf(cls) !== -1).forEach(cls => root.classList.remove(cls));

      this.pages.pages.forEach(page => {
        Array.from(page.element.classList).filter(cls => pageDynamicClassNames.indexOf(cls) !== -1).forEach(cls => page.element.classList.remove(cls));
      });

      if (this.pages.pages.length === 1) {
        this.getRootElement().classList.add('no-masks');
      } else if (this.pages.pages.length < 3 && !forceOnePage && this.render.getOrientation() !== 'portrait') {
        this.getRootElement().classList.add('no-masks');
      } 

      if (this.pages.pages.length > 1 && (forceOnePage || this.render.getOrientation() === 'portrait')) {
        this.getRootElement().classList.remove('no-masks');
      }

      root.classList.toggle('--hard', this.setting.hardCoverMode);
      root.classList.toggle('hard', this.setting.hardCoverMode);
    }
    startUserTouch(t) {
      if (!this.isBookZoomed()) {
        (this.mousePosition = t), (this.isUserTouch = !0), (this.isUserMove = !1);
      }
    }
    userMove(t, e) {
      if (!this.isBookZoomed()) {
        if ('portrait' === this.render.getOrientation()) {
          let bookWidth = document.querySelector('.stf__parent').style.width;
          let paddingWidth = (window.innerWidth - parseFloat(bookWidth)) / 2;
          (this.isUserTouch || e) &&
          this.mousePosition &&
          (this.mousePosition.x < paddingWidth + 50 ||
            this.mousePosition.x > parseFloat(bookWidth) - 50)
            ? this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition))
            : this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition));
        } else {
          this.isUserTouch || e
            ? this.isUserTouch &&
              h.GetDistanceBetweenTwoPoint(this.mousePosition, t) > 5 &&
              ((this.isUserMove = !0), this.flipController.fold(t, this.mousePosition))
            : '';
        }
      }
    }
    userStop(t, e = !1) {
      if (!this.isBookZoomed()) {

        this.isUserTouch &&
          ((this.isUserTouch = !1), e || (this.isUserMove ? this.flipController.stopMove() : ''));
      } else {
        this.isUserTouch = !1;
      }
    }
    bookZoom(isZoomed) {
      this.isZoomed = isZoomed;

      if (isZoomed) {
        this.render.hardWrapper.hardShadow.hide();
      } else {
        this.render.hardWrapper.hardShadow.show();
      }
    }
    isBookZoomed() {
      return this.isZoomed;
    }
    setZoom() {
      this.isZoomed = true;

      this.render.hardWrapper.hardShadow.hide();
    }
    getRootElement() {
      return document.querySelector('.stf__parent');
    }
    updateRootBookModeClassName() {
      const root = this.getRootElement();

      if (!root) {
        return;
      }

      const BOOK_MODES = {
        DOUBLE: 'book-mode--double', 
        SINGLE: 'book-mode--single'
      };
      const PAGE_MODES = {
        EVEN: 'pages-mode--even',
        ODD: 'pages-mode--odd'
      };

      const currentBookModeClassName = Array.from(root.classList).find(cls => Object.values(BOOK_MODES).indexOf(cls) !== -1);
      const currentPageModeClassName = Array.from(root.classList).find(cls => Object.values(PAGE_MODES).indexOf(cls) !== -1);
      let newBookModeClassName = undefined;
      let newPageModeClassName = undefined;

      if (forceOnePage || this.render.getOrientation() === 'portrait') {
        newBookModeClassName = BOOK_MODES.SINGLE;
      } else {
        newBookModeClassName = BOOK_MODES.DOUBLE;
      }

      if (currentBookModeClassName !== newBookModeClassName) {
        if (currentBookModeClassName) {
          root.classList.remove(currentBookModeClassName);
        }
  
        root.classList.add(newBookModeClassName);
      }

      if (this.setting.bookPages % 2 === 0) {
        newPageModeClassName = PAGE_MODES.EVEN;
      } else {
        newPageModeClassName = PAGE_MODES.ODD;
      }

      if (currentPageModeClassName !== newPageModeClassName) {
        if (currentPageModeClassName) {
          root.classList.remove(currentPageModeClassName);
        }
  
        root.classList.add(newPageModeClassName);
      }

      root.classList.add('book-dir--rtl');
    }
    getRootPageModeClassName() {
      const root = this.getRootElement();

      if (!root) {
        return;
      }
      
      const PAGE_MODES = {
        EVEN: 'pages-mode--even',
        ODD: 'pages-mode--odd'
      };

      const currentPageModeClassName = Array.from(root.classList).find(cls => Object.values(PAGE_MODES).indexOf(cls) !== -1);

      return currentPageModeClassName;
    }
    convertStylesObjectToString(styles) {
      const arr = [];

      Object.entries(styles).forEach(style => {
        arr.push(`${[style[0]]}: ${style[1]}`);
      });

      arr[arr.length - 1] += ';';

      return arr.join('; ');
    }
    signStylesToElement(element, styles) {
      Object.entries(styles).forEach(style => {
        element.style[style[0]] = style[1];
      });
    }
  }),
    Object.defineProperty(t, '__esModule', { value: !0 });
});
