const _t = (key, options) => {
  if (!window.hasOwnProperty('_translations') || !window._translations.hasOwnProperty(key)) {
    return key;
  }

  let translation = window._translations[key];

  if (Array.isArray(options) && options.length > 0) {
    options.forEach(option => translation = translation.replace('{n}', option));
  }

  return translation;
};

const hexToRgb = function (hex) {
  const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

  return result
    ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16),
      }
    : null;
};

const getLoderContent = function (color = null, name = null, logo = null) {
  return `
    ${logo ? logo : ""}
    <div class="loader__image-container">
      <div class="book" ${color ? 'style="--color: ' + color + ';"' : ""}>
        <div class="inner">
          <div class="left"></div>
          <div class="middle"></div>
          <div class="right"></div>
        </div>
        <ul>
          <li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li>
        </ul>
      </div>
    </div>
    <div class="loader__bookname">${name ? name : ""}</div>
    <div class="loader__publuu">
      <a href='https://publuu.com/' class="a__loader__publuu" style="opacity: 0.0">Flipbook - Powered by Publuu.com</a>
    </div>`;
};

const getLoaderLogoContent = function (toplogoImage, title) {
  const img = toplogoImage && toplogoImage.includes('.svg') ? '' : `<img src='${toplogoImage}' alt='${title}' />`;

  return toplogoImage
    ? `<div class='loader__logo-container'>${img}</div>`
    : null;
};

const createLink = (src, attributes, handleLoadCallback = null) => {
  const link = document.createElement("link");

  link.href = src;
  Object.entries(attributes).forEach(([key, value]) => link[key] = value);

  if (handleLoadCallback && typeof(handleLoadCallback) === 'function') {
    link.addEventListener("load", handleLoadCallback, { once: true });
  }

  document.head.appendChild(link);
};

const createScript = (src, attributes, handleLoadCallback = null, sync = true) => {
  const script = document.createElement("script");

  script.src = src;
  Object.entries(attributes).forEach(([key, value]) => script.setAttribute(key, value));

  if (sync) {
    document.body.appendChild(script);

    return new Promise(resolve => script.addEventListener("load", resolve, { once: true }));
  }

  if (handleLoadCallback && typeof(handleLoadCallback) === 'function') {
    script.addEventListener("load", handleLoadCallback, { once: true });
  }

  document.body.appendChild(script);
};

const createLoader = () => {
  const bookLoader = document.createElement('div');
  const bookLoaderWrapper = document.createElement('div');

  bookLoader.className = 'loader app__loader no-animation';
  bookLoaderWrapper.className = 'loader__wrapper';

  if (transparent) {
    const loaderContent = getLoderContent("#3461c9");

    bookLoaderWrapper.insertAdjacentHTML('afterbegin', loaderContent);
    bookLoader.appendChild(bookLoaderWrapper);
    document.body.appendChild(bookLoader);

    // bookLoader.style.color = "#3461c9";
    bookLoader.style.backgroundColor = "transparent";

    if (loaderInfo.hasOwnProperty('color') && loaderInfo.color != '0' && loaderInfo.color.length >= 3) {
      const book = bookLoader.querySelector('.book');

      if (book) {
        book.style = `--color: #${loaderInfo.color}`;
      }
    } 
  } else {
    const logoUrl = loaderInfo.logo;
    const title = decodeURIComponent(loaderInfo.title);
    const logo = getLoaderLogoContent(logoUrl, title);
    const loaderContent = getLoderContent(null, title, logo);
    const rgb = hexToRgb(`#${loaderInfo.backgroundColor}`);
    let theme = 'light';
    
    if (rgb !== null) {
      theme = rgb['r'] * 0.299 + rgb['g'] * 0.587 + rgb['b'] * 0.114 > 186 ? 'light' : 'dark';
    }

    bookLoader.style.color = theme == 'light' ? 'var(--light-color)' : 'var(--dark-color)';
    bookLoader.style.backgroundColor = `#${loaderInfo.backgroundColor}`;
    bookLoaderWrapper.insertAdjacentHTML('afterbegin', loaderContent);

    if (logo) {
      const img = new Image();

      img.addEventListener('load', () => {
        bookLoaderWrapper.querySelector('.loader__logo-container').classList.add('show');
      });

      img.src = logoUrl;
    }
  }

  const HOST = getAssetsHost();
  createLink(getPathWithVersion(`${HOST}assets/css/loader.css`), {
    id: "loader",
    rel: "stylesheet",
    type: "text/css",
  }, () => {
    bookLoader.appendChild(bookLoaderWrapper);
  });

  document.body.appendChild(bookLoader);
};

const createBookStructure = () => {
  const container = document.createElement('div');
  const root = document.createElement('div');
  const main = document.createElement('main');
  const header = document.createElement('header');
  const footer = document.createElement('footer');
  const sidebar = document.createElement('sidebar');
  const sidebarTOC = document.createElement('sidebar');
  const sidebarSearch = document.createElement('sidebar');
  const sidebarWishlist = document.createElement('sidebar');

  container.id = 'container';
  root.id = 'root';
  main.id = 'main';
  header.id = 'header';
  footer.id = 'footer';
  sidebar.id = 'sidebar';
  sidebarTOC.id = 'sidebarTOC';
  sidebarSearch.id = 'sidebarSearch';
  sidebarWishlist.id = 'sidebarWishlist';

  root.setAttribute('hidden', true);

  root.appendChild(header);
  root.appendChild(main);
  root.appendChild(footer);

  container.appendChild(root);
  container.appendChild(sidebar);
  container.appendChild(sidebarTOC);
  container.appendChild(sidebarSearch);
  container.appendChild(sidebarWishlist);

  document.body.insertAdjacentElement('afterbegin', container);
};

const createMain = () => {
  createBookStructure();

  // createMediaViewer();
  createPageAudio();

  createSimpleModal('div', 'spinner-modal', null, '<div class="wrapper"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"><circle cx="50" cy="50" fill="none" stroke="#3461c9" stroke-width="6" r="32" stroke-dasharray="150.79644737231007 52.26548245743669"><animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform></circle></svg></div>', ['hidden']);
  // createSimpleModal('div', 'divForAudioHotspot', null, `<div class="audioClose" onclick="HELPER.closeAudioPlayer()"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 191.2 192" style="enable-background:new 0 0 191.2 192;" xml:space="preserve"><style type="text/css">.st0{display:none;}</style><g><path d="M148.3,7.9L148.3,7.9L95.7,60.5L43,7.9C32.5-2.6,18-2.6,7.5,7.9l0,0C-3,18.4-3,32.9,7.5,43.4L60.1,96L7.5,148.6c-10.5,10.5-10.5,25,0,35.5s25,10.5,35.5,0l0,0l52.6-52.6l52.6,52.6c10.5,10.5,25,10.5,35.5,0l0,0c10.5-10.5,9.2-26.3,0-35.5L131.1,96l52.6-52.6c10.5-10.5,10.5-25,0-35.5C172.6-2,158.8-2.6,148.3,7.9z"/><path class="st0" d="M-114.8-114.4c-115.8,115.8-115.8,305.2,0,420.9s305.2,115.8,420.9,0s115.8-305.2,0-420.9S0.9-230.2-114.8-114.4z M271.2,271.7c-96.7,96.7-254.5,96.7-351.2,0s-96.6-254.6,0-351.3s254.5-96.7,351.2,0S367.9,175,271.2,271.7z"/></g></svg></div>`, ['hidden']);
  createSimpleModal('div', 'protected-modal', 'display: none;', '<div class="protected-modal__container"><div class="protected-modal__header">This document is password protected</div><img src="" alt="Book cover" class="protected-modal__image" /><form class="protected-modal__form"><div class="protected-modal__password"><input class="protected-modal__input" type="password" placeholder="Type your password here"/><button type="button" class="password-view"></button></div><div class="protected-modal__error-message"></div><button type="submit" class="protected-modal__send-btn" id="send-protected">ENTER</button></form></div>');
  createSimpleModal('div', 'product-modal modal modal--product', null, `<div class="modal__container product-modal__container"><div class="modal__close product-modal__close"></div><div class=product-modal__body><div class=product-modal__gallery><div class="product-modal__image__wrapper product-modal__image__wrapper--main"><svg viewBox="14 14 32 32"xmlns=http://www.w3.org/2000/svg xml:space=preserve xmlns:xlink=http://www.w3.org/1999/xlink class="svg-photo svg-photo-1"clip-rule=evenodd fill-rule=evenodd image-rendering=optimizeQuality shape-rendering=geometricPrecision text-rendering=geometricPrecision><style>.svg-photo .symbol{fill:#1f1a17}</style><path d="M21.8341 19.373c0.955691,0 1.82331,0.387743 2.44896,1.0134 0.625654,0.625654 1.01441,1.49327 1.01441,2.44896 0,0.953667 -0.387743,1.82128 -1.01441,2.44693l-0.00202477 0.00202477c-0.625654,0.626666 -1.49226,1.01441 -2.44693,1.01441 -0.955691,0 -1.82331,-0.388756 -2.44896,-1.01441 -0.625654,-0.625654 -1.0134,-1.49327 -1.0134,-2.44896 0,-0.955691 0.387743,-1.82229 1.0134,-2.44795 0.625654,-0.625654 1.49327,-1.01441 2.44896,-1.01441zm-5.47903 -2.74458l19.7364 0c0.519353,0 0.99315,0.212601 1.33331,0.552762 0.340161,0.340161 0.552762,0.813957 0.552762,1.33331l0 2.02882 6.17858 1.7332c0.500118,0.140721 0.898998,0.472784 1.13387,0.892923 0.234873,0.42014 0.30979,0.930382 0.171093,1.42949l0 0.00202477 -4.87969 17.3968c-0.140721,0.500118 -0.472784,0.898998 -0.892923,1.13387 -0.419127,0.234873 -0.930382,0.310802 -1.42949,0.172105l-0.00202477 0 -17.2308 -4.83414 -4.67114 0c-0.519353,0 -0.99315,-0.212601 -1.33331,-0.552762 -0.340161,-0.340161 -0.552762,-0.813957 -0.552762,-1.33331l0 -18.069c0,-0.519353 0.212601,-0.99315 0.552762,-1.33331 0.340161,-0.340161 0.813957,-0.552762 1.33331,-0.552762zm19.7364 1.01238l-19.7364 0c-0.238923,0 -0.45861,0.0992137 -0.616542,0.257146 -0.157932,0.157932 -0.257146,0.37762 -0.257146,0.616542l0 16.4472 4.88374 -7.07961 0.325988 -0.473796 0.427226 0.384706 3.66281 3.29936 4.9779 -8.12945 0.43735 -0.715756 0.429251 0.72183 6.33955 10.6685 0 -12.7115 0 -0.667162 0 -1.74434c0,-0.238923 -0.0992137,-0.45861 -0.257146,-0.616542 -0.157932,-0.157932 -0.37762,-0.257146 -0.616542,-0.257146zm-20.599 19.0804c0.0303715,0.184254 0.119461,0.35231 0.24601,0.478858 0.157932,0.157932 0.37762,0.257146 0.616542,0.257146l1.06199 0 3.67394 0 15.0005 0c0.238923,0 0.45861,-0.0992137 0.616542,-0.257146 0.157932,-0.157932 0.257146,-0.37762 0.257146,-0.616542l0 -0.966828 -6.78197 -11.4116 -4.85742 7.93305 -0.317889 0.518341 -0.451524 -0.405966 -3.68812 -3.32163 -5.37576 7.79233zm28.3903 -13.4728l-5.90524 -1.65626 0 14.9914c0,0.519353 -0.212601,0.99315 -0.552762,1.33331 -0.340161,0.340161 -0.813957,0.552762 -1.33331,0.552762l-11.3276 0 13.7664 3.86225 0 0.00101238c0.228799,0.0637802 0.468734,0.026322 0.664124,-0.0840279 0.19539,-0.109338 0.350285,-0.294604 0.415078,-0.524415l4.87969 -17.3968 0.00101238 0c0.0637802,-0.229811 0.0273344,-0.468734 -0.0830156,-0.664124 -0.109338,-0.19539 -0.294604,-0.350285 -0.524415,-0.415078zm-20.3165 -2.14524c-0.442412,-0.442412 -1.05693,-0.717781 -1.73219,-0.717781 -0.675261,0 -1.28877,0.275369 -1.73219,0.718793 -0.442412,0.442412 -0.717781,1.05592 -0.717781,1.73118 0,0.675261 0.275369,1.28978 0.717781,1.73219 0.443425,0.443425 1.05693,0.718793 1.73219,0.718793 0.677285,0 1.29079,-0.274356 1.73219,-0.716768l0.00202477 -0.00202477c0.442412,-0.4414 0.716768,-1.05592 0.716768,-1.73219 0,-0.675261 -0.275369,-1.28877 -0.718793,-1.73219z"class=symbol fill-rule=nonzero></path></svg></div><div class=product-modal__images></div></div><div class=product-modal__info><div class=product-modal__info__header><span class=product-modal__title></span> <span class=product-modal__status>Product Unavailable</span><div class=product-modal__prices hidden><div class="product-modal__price product-modal__price--old"><span></span> <span></span></div><div class="product-modal__price product-modal__price--new"><span></span> <span></span></div></div><div class=product-modal__controls><a class="product-modal__btn product-modal__btn--website"href=# target=_blank><div class=icon><?xml version="1.0" encoding="utf-8"?><!doctypehtml><svg viewBox="0 0 561.1 560.5"xmlns=http://www.w3.org/2000/svg xml:space=preserve xmlns:xlink=http://www.w3.org/1999/xlink enable-background="new 0 0 561.1 560.5"id=Layer_1 version=1.1 x=0px y=0px><path d="M478.9,82.2C425.9,29.2,355.5,0,280.5,0C205.6,0,135.1,29.2,82.2,82.2S0,205.6,0,280.5c0,74.9,29.2,145.4,82.2,198.4s123.4,82.2,198.4,82.2s145.4-29.2,198.4-82.2c53-53,82.2-123.4,82.2-198.4C561.1,205.6,531.9,135.1,478.9,82.2z M497.9,180h-90.8c-6-33.8-15-64.9-26.8-91.6c-5.3-12.1-11.1-23-17.3-32.7C422.7,77.6,471.3,122.7,497.9,180z M374.6,280.5c0,20.3-1.1,40.3-3.1,59.5H189.6c-2-19.2-3.1-39.1-3.1-59.5c0-20.3,1.1-40.3,3.1-59.5h181.9C373.5,240.3,374.6,260.2,374.6,280.5z M280.5,41c21.7,0,44.3,23.3,62.2,63.9c9.7,21.9,17.3,47.4,22.6,75.1H195.7c5.4-27.7,13-53.2,22.6-75.1C236.2,64.3,258.9,41,280.5,41zM198.1,55.7c-6.2,9.7-12,20.7-17.3,32.7C169,115.1,160,146.2,154,180H63.2C89.8,122.7,138.4,77.6,198.1,55.7z M41,280.5c0-20.5,2.6-40.5,7.5-59.5h99.9c-1.9,19.3-2.9,39.2-2.9,59.5c0,20.2,1,40.2,2.9,59.5H48.5C43.6,321,41,301.1,41,280.5z M63.2,381H154c6,33.8,15,64.9,26.8,91.6c5.3,12.1,11.1,23,17.3,32.7C138.4,483.4,89.8,438.3,63.2,381z M280.5,520 c-21.7,0-44.3-23.3-62.2-63.9c-9.7-21.9-17.3-47.4-22.6-75.1h169.7c-5.4,27.7-13,53.2-22.6,75.1C324.9,496.7,302.2,520,280.5,520z M363,505.4c6.2-9.7,12-20.7,17.3-32.7c11.8-26.7,20.8-57.8,26.8-91.6h90.8C471.3,438.3,422.7,483.4,363,505.4z M412.7,340 c1.9-19.3,2.9-39.2,2.9-59.5c0-20.2-1-40.2-2.9-59.5h99.9c4.9,19,7.5,39,7.5,59.5c0,20.5-2.6,40.5-7.5,59.5H412.7z"/></svg></div><span>Visit Website</span> </a><button class="product-modal__btn product-modal__btn--wishlist"type=button><div class=icon><svg viewBox="0 0 20 18"xmlns=http://www.w3.org/2000/svg fill=none height=18 width=20><path d="M2.3314 9.04738L10 17L17.6686 9.04738C18.5211 8.16332 19 6.96429 19 5.71405C19 3.11055 16.9648 1 14.4543 1C13.2487 1 12.0925 1.49666 11.24 2.38071L10 3.66667L8.75997 2.38071C7.90749 1.49666 6.75128 1 5.54569 1C3.03517 1 1 3.11055 1 5.71405C1 6.96429 1.47892 8.16332 2.3314 9.04738Z"fill=#fff stroke=#363636 stroke-linecap=round stroke-linejoin=round stroke-width=2 /></svg></div><span data-text-add="Add To Wishlist"data-text-remove="Remove From Wishlist">Add To Wishlist</span></button></div><p class=product-modal__description></div><div class=product-modal__info__footer><div class="product-modal__socials__label"><span>Share</span><div class="product-modal__socials__label__icon"><svg width="53" height="54" viewBox="0 0 53 54" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M24.1154 35.7692H6.5769V18.2308H24.1154V5.0769L46.0384 27L24.1154 48.9231V35.7692ZM28.5 16.0384V22.6154H10.9615V31.3846H28.5V37.9615L39.4615 27L28.5 16.0384Z" fill="#363636"/></svg></div></div><ul class=product-modal__socials><li class=product-modal__social><a class=product-modal__social__link href=# target=_blank data-type=facebook></a><li class=product-modal__social><a class=product-modal__social__link href=# target=_blank data-type=linkedin></a><li class=product-modal__social><a class=product-modal__social__link href=# target=_blank data-type=twitter></a><li class=product-modal__social><a class=product-modal__social__link href=# target=_blank data-type=email></a></ul></div></div></div></div>`, ['hidden']);
};

const createSimpleModal = (element = 'div', className, style, body, attrs) => {
  const wrapper = document.createElement(element);

  if (className) wrapper.className = className;
  if (style) wrapper.style = style;
  if (attrs) attrs.forEach(attr => wrapper.setAttribute(attr, true));

  wrapper.innerHTML = body;

  document.querySelector('body').appendChild(wrapper);
};

const createMediaViewer = () => {
  const wrapper = document.createElement('div');

  wrapper.className = 'media-viewer';
  wrapper.setAttribute('hidden', true);
  wrapper.innerHTML = '<div class="media-viewer__content-container"><div class="media-viewer__content"><div class="navigation-left" hidden></div><div class="media-viewer__close modal__close"></div><div class="navigation-right" hidden></div></div></div>';

  document.querySelector('body').appendChild(wrapper);
};

const createPageAudio = () => {
  const audios = [
    {
      src: `${window._config.ROOT_PATH}/assets/audio/v1_1.mp3`,
      type: 'audio/mpeg'
    }, 
    [
      {
        src: `${window._config.ROOT_PATH}/assets/audio/v1_2.ogg`,
        type: 'audio/ogg'
      }, {
        src: `${window._config.ROOT_PATH}/assets/audio/v1_2.ogg`,
        type: 'audio/mpeg'
      }
    ], 
    [
      {
        src: `${window._config.ROOT_PATH}/assets/audio/v1_4.ogg`,
        type: 'audio/ogg'
      }, {
        src: `${window._config.ROOT_PATH}/assets/audio/v1_4.ogg`,
        type: 'audio/mpeg'
      }
    ]
  ];

  const wrapper = document.createElement('div');
  wrapper.className = 'page-flip-audios';
  wrapper.setAttribute('hidden', true);

  audios.forEach(track => {
    if (track[0] != undefined) {
      const audio = document.createElement('audio');

      audio.className = 'flip-audio';
      audio.setAttribute('preload', 'auto');

      track.forEach(tr => {
        const source = document.createElement('source');

        source.setAttribute('src', tr.src);
        source.setAttribute('type', tr.type);

        audio.appendChild(source);
      });

      wrapper.appendChild(audio);
    } else {
      const audio = document.createElement('audio');

      audio.className = 'flip-audio';
      audio.setAttribute('preload', 'auto');
      
      const source = document.createElement('source');

      source.setAttribute('src', track.src);
      source.setAttribute('type', track.type);

      audio.appendChild(source);
      wrapper.appendChild(audio);
    }
  });

  document.querySelector('body').appendChild(wrapper);
};

const getAssetsHost = () => debugMode ? window._config.ROOT_PATH : window._config.PATH_CF_FLIP;

const getPathWithVersion = (path) => {
  const version = window._config ? window._config.VERSION : null;
  if (!version) return path;

  const url = new URL(path);
  url.searchParams.set('v', version);

  return url.toString();
};

const attachStyles = () => {
  const HOST = getAssetsHost();
  const files = ['APP-xs', 'Menu', 'modal'].concat(customizemode ? ['tooltip'] : []);

  files.forEach(file => createLink(getPathWithVersion(`${HOST}assets/css/${file}.css`), {
    id: file,
    rel: "stylesheet",
    type: "text/css",
  }));
};

const attachScripts = async () => {
  const HOST = getAssetsHost();
  const files = Array.from(new Set(['VideoEmbed', 'Layout']
    .concat(customizemode ? ['Search', 'page-flip-hard.browser', 'page-flip-rtl.browser-final'] : [])
    .concat(rightToLeft ? ['page-flip-rtl.browser-final']: ['page-flip-hard.browser'])));

  await createScript(getPathWithVersion(`${HOST}assets/scripts/Helper.js`), {
    id: 'Helper',
    type: "text/javascript",
    crossorigin: "anonymous",
  });

  await createScript(getPathWithVersion(`${HOST}assets/scripts/APP.js`), {
    id: 'APP',
    type: "text/javascript",
    crossorigin: "anonymous",
  });

  await createScript(getPathWithVersion(`${HOST}assets/scripts/Logs.js`), {
    id: 'Logs',
    type: "text/javascript",
    crossorigin: "anonymous",
  });
  
  // await createScript(getPathWithVersion(`${HOST}assets/scripts/hotspots/Gallery.js`), {
  //   id: 'Gallery',
  //   type: "text/javascript",
  //   crossorigin: "anonymous",
  // });

  // APP.checkProtectedEmbed(window.protectedDomainSettings);

  const promises = files.map(file => createScript(getPathWithVersion(`${HOST}assets/scripts/${file}.js`), {
    id: file,
    type: "text/javascript",
    crossorigin: "anonymous",
  }));

  return Promise.all(promises);
};

const initGlobalVariables = () => {
  window.isLandscape = false;
  window.isAndroid = (/android/gi).test(navigator.appVersion);
  window.isIDevice = (/iphone|ipad/gi).test(navigator.appVersion);
  window.isIPhone = (/iphone/gi).test(navigator.appVersion);
  window.iOsHeight = 0;

  window.timingcount = 0;
  window.timingsum = 0;
};

const initGlobalFunctions = () => {
  window.sleep = function (time) {
    return new Promise((resolve) => setTimeout(resolve, time));
  };

  window.showLoginSend = function () {
    window.parent.postMessage({
      'func': 'showLoginSend',
      'message': 'Message text from iframe.'
    }, "*");
  };
};

const initGlobalHandlers = () => {
  document.addEventListener('touchmove', function (event) {
    if (event.scale !== 1) {
      event.preventDefault();
    }
  }, false);

  window.document.addEventListener("visibilitychange", function() {
    if (!window.oLogs) {
      return;
    }

    if (window.document.visibilityState == "hidden") {
      if (oLogs.logs_state_visible === 3) {
        oLogs.logs_state_visible = 2;
      } else {
        oLogs.logs_state_visible = 1;
        oLogs.lastActionTime = Date.now();
      }
    } else {
      oLogs.sleepTime += Date.now() - oLogs.lastActionTime;
      oLogs.logs_state_visible = 3;
    }
  });

  const customizeOrigins = window._config.CUSTOMIZE_ORIGINS;

  window.addEventListener('message', event => {
    const isAccessAllowedFromOrigin = customizeOrigins.some(origin => event.origin === origin);
    
    if (isAccessAllowedFromOrigin) { 
      if (typeof APP != 'undefined') APP.handleFlipBookEditorResponse(event.data);
    } else {
      if (typeof event.data === 'string' || event.data instanceof String) {
        if (event.data.startsWith('puid:')) {
          HELPER.setLocalStorageData("uid",event.data.substring(5),365);
          embeduid = event.data.substring(5);
        }
      }

      return; 
    }
  });
};

const handleLoad = () => {
  if (document.querySelector('.spinner-modal')) {
    document.querySelector('.spinner-modal').removeAttribute('hidden');
  }

  if (document.querySelector('.fs-modal')) {
    document.querySelector('.fs-modal').removeAttribute('hidden');
  }
};

class Idle {
  constructor(params) {
      this.params = params;
      this.isAway = false;
      this.awayTimeout = parseInt(this.params.awayTimeout, 10) || 3000; // Default timeout: 3 seconds
      this.awayTimestamp = 0;
      this.awayTimer = null;
      this.listener = null;

      const onActivity = () => this.onActive();

      // Listen for user activity
      window.addEventListener("click", onActivity);
      window.addEventListener("mousemove", onActivity);
      window.addEventListener("mouseenter", onActivity);
      window.addEventListener("keydown", onActivity);
      window.addEventListener("mousewheel", onActivity);
      window.addEventListener("touchmove", onActivity);
      window.addEventListener("touchstart", onActivity);
  }

  onActive() {
      this.awayTimestamp = new Date().getTime() + this.awayTimeout;

      if (this.isAway) {
          if (this.params.onAwayBack) this.params.onAwayBack();
          this.start();
      }

      this.isAway = false;
      return true;
  }

  start() {
      if (!this.listener) {
          this.listener = () => this.handleVisibilityChange();

          document.addEventListener("visibilitychange", this.listener, false);
          document.addEventListener("webkitvisibilitychange", this.listener, false);
          document.addEventListener("msvisibilitychange", this.listener, false);
      }

      this.awayTimestamp = new Date().getTime() + this.awayTimeout;

      if (this.awayTimer !== null) {
          clearTimeout(this.awayTimer);
      }

      this.awayTimer = window.setTimeout(() => this.checkAway(), this.awayTimeout + 100);
      return this;
  }

  stop() {
      if (this.awayTimer !== null) {
          clearTimeout(this.awayTimer);
      }

      if (this.listener !== null) {
          document.removeEventListener("visibilitychange", this.listener);
          document.removeEventListener("webkitvisibilitychange", this.listener);
          document.removeEventListener("msvisibilitychange", this.listener);
          this.listener = null;
      }

      return this;
  }

  setAwayTimeout(timeout) {
      this.awayTimeout = parseInt(timeout, 10);
      return this;
  }

  checkAway() {
      const currentTime = new Date().getTime();

      if (currentTime < this.awayTimestamp) {
          this.isAway = false;

          this.awayTimer = window.setTimeout(
              () => this.checkAway(),
              this.awayTimestamp - currentTime + 100
          );
      } else {
          if (this.awayTimer !== null) {
              clearTimeout(this.awayTimer);
          }

          this.isAway = true;

          if (this.params.onAway) {
              this.params.onAway();
          }
      }
  }

  handleVisibilityChange() {
      if (document.hidden) {
          if (this.params.onHidden) {
              return this.params.onHidden();
          }
      } else {
          if (this.params.onVisible) {
              return this.params.onVisible();
          }
      }
  }
}

(async function () {
  document.body.innerHTML = '';

  createLoader();
  createMain();
  initGlobalVariables();
  initGlobalFunctions();
  initGlobalHandlers();

  attachStyles();
  await attachScripts();

  handleLoad();

  const idleMonitor = new Idle({
    awayTimeout: 5000, // 5 seconds
    onAway: () => console.log("User is idle."),
    onAwayBack: () => console.log("User is active again."),
    onHidden: () => console.log("Tab is hidden."),
    onVisible: () => console.log("Tab is visible.")
});

// Start monitoring user activity
idleMonitor.start();
}());
