class Boot {
  bookObj;
  self;
  needUpdate;

  constructor(data) {
    self = this;
    this.bookObj = data;
    this.needUpdate = self.botChecker();
  }

  botChecker = async () => {
    const userAgent = navigator.userAgent;
    const robots = new RegExp([
      /bot/,/spider/,/crawl/,
      /APIs-Google/,/AdsBot/,/Googlebot/,
      /mediapartners/,/Google Favicon/,
      /FeedFetcher/,/Google-Read-Aloud/,
      /DuplexWeb-Google/,/googleweblight/,
    ].map((r) => r.source).join("|"),"i");

    if (robots.test(userAgent)) {
      fetch(`${APP.ROOT_PATH}/robots.php`, {
        method: 'POST',
        body: JSON.stringify({
          from: document.location.href,
          navigator: JSON.stringify(userAgent),
        }),
        headers: {
          Accept: 'application/json',
          'Content-Type': 'application/json',
        },
      })
      .then(() => console_log('bot detected, info saved.'))
      .catch(() => 'bot detected, cannot save info.');

      return false;
    }
    
    return true;
  }

  createMediaViewer = () => {
    const wrapper = document.createElement('div')
    wrapper.className = 'media-viewer';
    wrapper.setAttribute('hidden', true);
    wrapper.innerHTML = '<div class="media-viewer__content-container"><div class="media-viewer__content"><div class="navigation-left" hidden></div><div class="media-viewer__close modal__close"></div><div class="navigation-right" hidden></div></div></div>'

    document.querySelector('body').insertAdjacentElement('afterbegin', wrapper);
  }

  createMain = () => {
    const wrapper = document.createElement('div')
    wrapper.id = 'root';
    wrapper.setAttribute('hidden', true);
    
    const header = document.createElement('header');
    header.id = 'header';
    wrapper.appendChild(header);
    const main = document.createElement('main');
    main.id = 'main';
    wrapper.appendChild(main);
    const sidebar = document.createElement('sidebar');
    sidebar.id = 'sidebar';
    sidebar.innerHTML = '<div class="sidebar-header" style="display: none;"><span style="opacity:0.8">Thumbnails</span><div class="sidebar-close"></div></div>';
    wrapper.appendChild(sidebar);
    const sidebarTOC = document.createElement('sidebar');
    sidebarTOC.id = 'sidebarTOC';
    sidebarTOC.innerHTML = '<div class="sidebar-header" style="display: none;"><span style="opacity:0.8">Table of content</span><div class="sidebar-close"></div></div>';
    wrapper.appendChild(sidebarTOC);
    const footer = document.createElement('footer');
    footer.id = 'footer';
    wrapper.appendChild(footer);
    document.querySelector('body').insertAdjacentElement('afterbegin', wrapper);
  }

  createSimpleModal = (element = 'div', className, style, body, attrs) => {
    const wrapper = document.createElement(element);
    if (className) wrapper.className = className;
    if (style) wrapper.style = style;
    if (attrs) attrs.forEach(attr => wrapper.setAttribute(attr, true))
    wrapper.innerHTML = body;

    document.querySelector('body').insertAdjacentElement('afterbegin', wrapper);
  }

  createPageAudio = () => {
    const audios = [{
      src: `${APP.ROOT_PATH}/assets/audio/v1_1.mp3`,
      type: 'audio/mpeg'
    }, [{
      src: `${APP.ROOT_PATH}/assets/audio/v1_2.ogg`,
      type: 'audio/ogg'
    }, {
      src: `${APP.ROOT_PATH}/assets/audio/v1_2.ogg`,
      type: 'audio/mpeg'
    }], [{
      src: `${APP.ROOT_PATH}/assets/audio/v1_4.ogg`,
      type: 'audio/ogg'
    }, {
      src: `${APP.ROOT_PATH}/assets/audio/v1_4.ogg`,
      type: 'audio/mpeg'
    }]]
    const wrapper = document.createElement('div');
    wrapper.className = 'page-flip-audios';
    wrapper.setAttribute('hidden', true);

    audios.forEach(track => {
      if (track[0] != undefined) {
        const audio = document.createElement('audio');
        audio.className = 'flip-audio';
        audio.setAttribute('preload', 'auto');
        track.forEach(tr => {
          const source = document.createElement('source');
          source.setAttribute('src', tr.src);
          source.setAttribute('type', tr.type);
          audio.appendChild(source);
        })
        wrapper.appendChild(audio);
      } else {
        const audio = document.createElement('audio');
        audio.className = 'flip-audio';
        audio.setAttribute('preload', 'auto');
        
        const source = document.createElement('source');
        source.setAttribute('src', track.src);
        source.setAttribute('type', track.type);
        audio.appendChild(source);
        wrapper.appendChild(audio);
      }
    })

    document.querySelector('body').insertAdjacentElement('afterbegin', wrapper);
  }

  render() {
    if (!self.needUpdate) {
      return;
    }

    self.createSimpleModal('div', 'print-modal modal', null, `<div class="print-modal__container"><div class="print-modal__close modal__close"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 595.3 841.9" enable-background="new 0 0 595.3 841.9" xml:space="preserve"><g><path d="M350.3,332.8L350.3,332.8l-52.6,52.6L245,332.8c-10.5-10.5-25-10.5-35.5,0l0,0c-10.5,10.5-10.5,25,0,35.5l52.6,52.6l-52.6,52.6c-10.5,10.5-10.5,25,0,35.5c10.5,10.5,25,10.5,35.5,0l0,0l52.6-52.6l52.6,52.6c10.5,10.5,25,10.5,35.5,0l0,0c10.5-10.5,9.2-26.3,0-35.5l-52.6-52.6l52.6-52.6c10.5-10.5,10.5-25,0-35.5C374.6,322.9,360.8,322.3,350.3,332.8z"/><path d="M87.2,210.5c-115.8,115.8-115.8,305.2,0,420.9s305.2,115.8,420.9,0s115.8-305.2,0-420.9S202.9,94.7,87.2,210.5zM473.2,596.6c-96.7,96.7-254.5,96.7-351.2,0S25.4,342,122,245.3s254.5-96.7,351.2,0S569.9,499.9,473.2,596.6z"/></g></svg></div><div class="print-modal__radio"><div class="print-header"><img src="${APP.ROOT_PATH}/assets/images/ico_print.svg" />Print flipbook</div><div class="print-radios-container"><div class="print-modal__radio-items print-radios-container-left"><div class="print-modal__radio-item print-all"><input type="radio" name="print" id="radio-print-all" value="1" class="radio-btn print-all-radio"><label>Print all pages</label></div><div class="print-modal__radio-item print-current"><input type="radio" id="radio-print-current" name="print"  value="2" class="radio-btn print-current-radio" checked><label>Print current page</label></div><div class="print-modal__radio-item print-range"><input type="radio" name="print" value="3" id="radio-print-range" class="radio-btn print-range-radio"><label>Print Range <input type="text" class="print-range-input" id="print-range-start">-<input type="text" class="print-range-input" id="print-range-end"></label></div><div class="invalid-range-error" hidden>Invalid range!</div><button class="print-modal__print">PRINT</button></div><div class=" print-radios-container-right"><div class="print-radios-container-right-gray"><div class="print-radios-container-right-gray-c" id="print_left_preview"><img id="cover_from" src=""/>Page: <span id="page_start">1</span></div><div class="print-radios-container-right-gray-c" id="print_right_preview"><img id="cover_to" src=""/>Page: <span id="page_end">133</span></div></div></div></div></div></div>`, ['hidden']);

    self.createSimpleModal('div', 'share-modal-mobile modal', null, `<div class="share-modal__container"><div class="print-modal__radio"><div class="share-icons-container"><a target=_blank id="share-modal__fb" href=""><button class="share-modal__fb"></button></a><a target=_blank id="share-modal__linkedin" href=""><button class="share-modal__linkedin"></button></a><a target=_blank id="share-modal__twitter" href=""><button class="share-modal__twitter"></button></a><a target=_blank id="share-modal__mail" href=""><button class="share-modal__mail"></button></a><a target=_blank id="share-modal__download" href=""><button class="share-modal__download"></button></a></div><div class="share-link-container"><div id="share-link-url" class="inputlike">${APP.ROOT_PATH}/315/6770</div><button class="share-modal__copy" onclick="HELPER.copyToClipboard(this, 'share-link-url','Copied')">COPY</button></div></div></div>`, ['hidden']);

    self.createSimpleModal('div', 'share-modal modal', null, `<div class="share-modal__container"><div class="share-modal__close modal__close"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 595.3 841.9" enable-background="new 0 0 595.3 841.9" xml:space="preserve"><g><path d="M350.3,332.8L350.3,332.8l-52.6,52.6L245,332.8c-10.5-10.5-25-10.5-35.5,0l0,0c-10.5,10.5-10.5,25,0,35.5l52.6,52.6l-52.6,52.6c-10.5,10.5-10.5,25,0,35.5c10.5,10.5,25,10.5,35.5,0l0,0l52.6-52.6l52.6,52.6c10.5,10.5,25,10.5,35.5,0l0,0c10.5-10.5,9.2-26.3,0-35.5l-52.6-52.6l52.6-52.6c10.5-10.5,10.5-25,0-35.5C374.6,322.9,360.8,322.3,350.3,332.8z"/><path d="M87.2,210.5c-115.8,115.8-115.8,305.2,0,420.9s305.2,115.8,420.9,0s115.8-305.2,0-420.9S202.9,94.7,87.2,210.5zM473.2,596.6c-96.7,96.7-254.5,96.7-351.2,0S25.4,342,122,245.3s254.5-96.7,351.2,0S569.9,499.9,473.2,596.6z"/></g></svg></div><div class="print-modal__radio"><div class="print-header"><img src="${APP.ROOT_PATH}/assets/images/ico_share2.svg" />Share flipbook</div><div class="share-icons-container"><a target=_blank id="share-modal__fb" href=""><button class="share-modal__fb"></button></a><a target=_blank id="share-modal__linkedin" href=""><button class="share-modal__linkedin"></button></a><a target=_blank id="share-modal__twitter" href=""><button class="share-modal__twitter"></button></a><a target=_blank id="share-modal__mail" href=""><button class="share-modal__mail"></button></a></div><div class="share-link-container"><div class="share-link-msg"><span>Copy this link:</span></div><div id="share-link-url" onclick="HELPER.copyToClipboard(this, 'share-link-url','Copied')" class="inputlike">${APP.ROOT_PATH}/315/6770</div><button class="share-modal__copy" onclick="HELPER.copyToClipboard(this, 'share-link-url','Copied')">COPY</button></div></div></div>`, ['hidden']);

    self.createSimpleModal('div', 'divForAudioHotspot', null, `<div class="audioClose" onclick="HELPER.closeAudioPlayer()"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 191.2 192" style="enable-background:new 0 0 191.2 192;" xml:space="preserve"><style type="text/css">.st0{display:none;}</style><g><path d="M148.3,7.9L148.3,7.9L95.7,60.5L43,7.9C32.5-2.6,18-2.6,7.5,7.9l0,0C-3,18.4-3,32.9,7.5,43.4L60.1,96L7.5,148.6c-10.5,10.5-10.5,25,0,35.5s25,10.5,35.5,0l0,0l52.6-52.6l52.6,52.6c10.5,10.5,25,10.5,35.5,0l0,0c10.5-10.5,9.2-26.3,0-35.5L131.1,96l52.6-52.6c10.5-10.5,10.5-25,0-35.5C172.6-2,158.8-2.6,148.3,7.9z"/><path class="st0" d="M-114.8-114.4c-115.8,115.8-115.8,305.2,0,420.9s305.2,115.8,420.9,0s115.8-305.2,0-420.9S0.9-230.2-114.8-114.4z M271.2,271.7c-96.7,96.7-254.5,96.7-351.2,0s-96.6-254.6,0-351.3s254.5-96.7,351.2,0S367.9,175,271.2,271.7z"/></g></svg></div>`, ['hidden']);

    self.createPageAudio();

    self.createSimpleModal('div', 'lead-modal-mobile modal', null, '<div class="lead-modal__container"><div class="lead-modal-form"><div class="lead-modal-title"></div><div class="lead-modal-input-container"><div class="lead-modal-input"><input type="text" value="" name="input_1" placeholder="E-mail*"/></div><div class="lead-modal-input"><input type="text" value="" name="input_2" placeholder="Phone"/></div></div><div class="lead-modal-privacy"></div><div class="lead-modal-buttons"><button class="lead-modal__submit" onclick="">SUBMIT</button><button class="lead-modal__skip" onclick="">skip ></button></div></div></div>', ['hidden']);

    self.createSimpleModal('div', 'lead-modal modal', null, '<div class="lead-modal__container"><div class="lead-modal-form"><div class="lead-modal-title"></div><div class="lead-modal-input-container"><div class="lead-modal-input"><input type="text" value="" name="input_1" placeholder="E-mail*"/></div><div class="lead-modal-input"><input type="text" value="" name="input_2" placeholder="Phone"/></div></div><div class="lead-modal-privacy"></div><div class="lead-modal-buttons"><button class="lead-modal__submit" onclick="">SUBMIT</button><button class="lead-modal__skip" onclick="">skip ></button></div></div></div>', ['hidden']);

    self.createSimpleModal('div', 'spinner-modal', null, '<div class="wrapper"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"><circle cx="50" cy="50" fill="none" stroke="#3461c9" stroke-width="6" r="32" stroke-dasharray="150.79644737231007 52.26548245743669"><animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform></circle></svg></div>');

    self.createSimpleModal('div', 'fs-modal', null, '<div class="wrapper"><svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M2.8 15.8L0 13v7h7l-2.8-2.8 4.34-4.32-1.42-1.42L2.8 15.8zM17.2 4.2L20 7V0h-7l2.8 2.8-4.34 4.32 1.42 1.42L17.2 4.2zm-1.4 13L13 20h7v-7l-2.8 2.8-4.32-4.34-1.42 1.42 4.33 4.33zM4.2 2.8L7 0H0v7l2.8-2.8 4.32 4.34 1.42-1.42L4.2 2.8z"/></svg><span>Fullscreen</span></div>');

    self.createMain();
    self.createMediaViewer();

    self.createSimpleModal('div', 'protected-modal', 'display: none;', '<div class="protected-modal__container"><div class="protected-modal__header">This document is password protected</div><div class="protected-modal__book-cover"></div><div class="protected-modal__pasword"><input class="protected-modal__input" type="password" placeholder="Type your password here"/><button class="password-view"></button></div><div class="protected-modal__error-message"></div><button class="protected-modal__send-btn" id="send-protected">ENTER</button></div>');

    APP.loadComponent('viewer_scripts', function () {
      APP.loadComponent('Logs', function () {
        APP.loadComponent('Helper', function () {
          APP.loadComponent('VideoEmbed', function () {
            APP.loadComponent('Layout', function () {
              
            });
          });
        });
      });
    });
  }
}