APPonReady.add(function () {
  APP.EMBED = new (function () {
    self = this;

    const ytPlayerKey = 'h';
    const _SUPPORTED_SOURCE_TYPES = ['webm', 'mp4'];

    let players = [];
    let _isVimeoScriptAttached = false;
    let _isYtScriptAttached = false;
    let _videoAutoplayAudio = null;

    this.inializeYoutubePlayer = async (el, options, vars, page, id, callbacks = null) => {
      if (!_isYtScriptAttached) {
        await attachYtScript();
      }

      const waitForContainer = setInterval(() => {
        iframe = document.getElementById(el.id);

        if (iframe) {
          const player = new YT.Player(el.id, Object.assign({}, options, {
            playerVars: Object.assign({}, vars, {
              autoplay: 1,
              mute: !vars.volume && APP.someUserIteraction ? 0 : 1,
              playsinline: 1,
              rel: 0,
              showinfo: 0,
              origin: APP.ROOT_PATH,
              modestbranding: 1,
              loop: 0,
            }),
            events: {
              onReady: (event) => onPlayerReady(event, callbacks),
              onStateChange: (event) => onYoutubePlayerStateChange(event, callbacks),
            },
          }));

          getPlayerObj(player).addEventListener('load', function () {
            getPlayerObj(player).style.opacity = '1.0';
            APP.Book.handleAudioPause();
          });

          players.push({
            playerId: el.id,
            areaId: id,
            player: player,
            type: 'y',
            page: page,
            start: vars.start,
            muted: !!!vars.volume,
            controls: !!vars.controls,
            autoplay: vars.autoplay,
          });

          self.pauseVimeoVideo();
          clearInterval(waitForContainer);
        }
      }, 300);
    };

    this.getPlayerById = (playerId) => {
      const player = players.find((item) => item.playerId == playerId);

      if (!player) return null;

      return player;
    };
    
    this.getPlayerByAreaId = (areaId) => {
      const player = players.find((item) => item.areaId == areaId);

      if (!player) return null;

      return player;
    };

    this.getPlayerState = (playerObj) => {
      if (!playerObj || !playerObj.player) return;

      const playerType = playerObj.type;
      const player = playerObj.player;

      switch (playerType) {
        case 'p':
          return player.paused ? 'PAUSED' : 'PLAYING';
      }
    };

    const getPlayerObj = (player) => {
      if (!player) {
        return null;
      }
      
      if (player.nodeType && player.nodeType === 1 && player.localName === 'video') {
        return player;
      }

      const playerNode = Object.values(player).filter(
        (element) =>
          typeof element == 'object' &&
          element != null &&
          'localName' in element &&
          element.localName === 'iframe',
      );

      if (!playerNode || playerNode.length == 0) {
        return player[ytPlayerKey];
      }

      return playerNode[0];
    };

    this.setPlayerControlSizes = (controlButton, bookSizes = null) => {
      if (!controlButton) return;

      const controlMaxSizes = {
        width: 28,
        height: 28,
        padding: 5,
        left: 6,
        bottom: 6,
      };

      const properties = {
        width: 1.01,
        height: 1.01,
        padding: 0.2,
        left: 0.2,
        bottom: 0.2,
      };

      let hotspotSize = 0;

      if (!bookSizes) {
        bookSizes = APP.Book.getBookSize();
      }

      const width = bookSizes.bookWidth;
      const height = bookSizes.bookHeight;

      if (width && height) {
        if (width < height) {
          hotspotSize = Math.floor((width * 6) / 100);
        } else {
          hotspotSize = Math.floor((height * 6) / 100);
        }
      }

      if (controlButton.dataset && controlButton.dataset.type === 'play') {
        controlButton.style.width = `${hotspotSize * 1.75}px`;
        controlButton.style.height = `${hotspotSize * 1.75}px`;
        controlButton.style.maxWidth = `${hotspotSize * 1.75}px`;
        controlButton.style.maxHeight = `${hotspotSize * 1.75}px`;
        return;
      }

      Object.entries(properties).forEach((property) => {
        const newSize =
          hotspotSize * property[1] > controlMaxSizes[property[0]]
            ? controlMaxSizes[property[0]]
            : hotspotSize * property[1];

        controlButton.style[property[0]] = `${newSize}px`;
      });
    };

    const createPlayerControl = (wrapper, options, controlHandler) => {
      const button = document.createElement('button');
      button.type = 'button';
      button.className = `player__control player__control--${options.controlType}`;
      button.innerHTML = options.icon;
      button.hidden = true;
      button.dataset.type = options.controlType;
      button.addEventListener('click', (e) => {
        e.stopPropagation();

        controlHandler(e, options);
      });

      wrapper.appendChild(button);

      return button;
    };

    const showPlayerControl = (player, options, controlHandler) => {
      const playerNode =
        options.playerType === 'y' || options.playerType === 'p' ? getPlayerObj(player) : player._originalElement;

      if (!playerNode.parentNode) return;

      let controlButton = playerNode.parentNode.querySelector(
        `.player__control--${options.controlType}`,
      );

      if (!controlButton) {
        controlButton = createPlayerControl(playerNode.parentNode, options, controlHandler);
      }

      this.setPlayerControlSizes(controlButton);

      controlButton.removeAttribute('hidden');
    };

    const hidePlayersControls = (controlType) => {
      if (!players || !!!players.length) return;

      players.forEach((obj) => {
        const player = obj.type === 'y' || obj.type === 'p' ? getPlayerObj(obj.player) : obj.player._originalElement;

        if (!player) return;

        const controlButton = player.parentNode.querySelector(`.player__control.player__control--${controlType}`);

        if (!controlButton) return;

        controlButton.hidden = true;
      });
    };

    const changePlayerControlIcon = (player, options, icon) => {
      const playerNode =
        options.playerType === 'y' || options.playerType === 'p' ? getPlayerObj(player) : player._originalElement;

      if (!playerNode.parentNode) return;

      const controlButton = playerNode.parentNode.querySelector(
        `.player__control--${options.controlType}`,
      );

      if (!controlButton) return;

      controlButton.innerHTML = icon;
    };

    function onPlayerReady(event, callbacks = null) {
      if (callbacks && callbacks.hasOwnProperty('READY')) {
        callbacks.READY();
      }

      if (
        !getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'muted') &&
        !getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'controls')
      ) {
        showPlayerControl(
          event.target,
          {
            playerType: 'y',
            controlType: 'audio',
            autoplay: getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay'),
            icon:
              !APP.someUserIteraction ||
              (getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay') &&
                _videoAutoplayAudio === false)
                ? HELPER.playerControlsIcons['audioOff']
                : HELPER.playerControlsIcons['audioOn'],
          },
          (_, options) => {
            if (event.target.isMuted()) {
              event.target.setVolume(100);
              event.target.unMute();
            } else {
              event.target.setVolume(0);
              event.target.mute();
            }

            changePlayerControlIcon(
              event.target,
              options,
              event.target.isMuted()
                ? HELPER.playerControlsIcons['audioOn']
                : HELPER.playerControlsIcons['audioOff'],
            );

            if (options.autoplay) {
              _videoAutoplayAudio = event.target.isMuted();
            }
          },
        );
      }

      event.target.playVideo();
    }

    this.isMediaViewerFullscreen = () => {
      const mediaViewer = document.querySelector('.media-viewer') || document.querySelector('.modal--video');

      if (!mediaViewer) return false;

      const iframe = mediaViewer.querySelector('iframe');

      if (!iframe) return false;

      return Math.abs(iframe.clientHeight - screen.height) <= 5;
    };

    this.isPlayerFullscreen = () => {
      if (!players.length) return false;

      return players.some(
        (p) => Math.abs(getPlayerObj(p.player).clientHeight - screen.height) <= 5,
      );
    };

    this.pauseAllPlayersOnPage = function (page) {
      if (!players || !players.length) return;

      if (Array.isArray(page) && page.length > 0) {
        page.forEach(pageNumber => {
          const pagePlayers = players.filter(player => +player.page === pageNumber);

          pagePlayers.forEach(player => {
            if (player.type == 'y') {
              self.pauseYoutubeVideo(player);
            }
    
            if (player.type == 'v') {
              self.pauseVimeoVideo(player);
            }
    
            if (player.type == 'p') {
              self.pauseUploadedVideo(player);
            }
          });
        });

        return;
      }

      players.forEach((player) => {
        if (player.page != page) return;

        if (player.type == 'y') {
          self.pauseYoutubeVideo(player);
        }

        if (player.type == 'v') {
          self.pauseVimeoVideo(player);
        }

        if (player.type == 'p') {
          self.pauseUploadedVideo(player);
        }
      });
    };

    const pausePlayersExceptCurrent = (currentPlayer, type, pages) => {
      players.forEach((player) => {
        pages.forEach((page) => {
          if (type == 'y') {
            if (
              player.playerId != currentPlayer.id &&
              player.page == page &&
              player.type == 'y' &&
              player.player.getPlayerState() == 1
            ) {
              self.pauseYoutubeVideo(player);
            }
          }
          if (type == 'v') {
            if (
              player.playerId != currentPlayer._originalElement.id &&
              player.page == page &&
              player.type == 'v' &&
              player.player.getPlayed()
            ) {
              self.pauseVimeoVideo(player);
            }
          }
        });
      });
    };

    this.pauseYoutubeVideo = function (player) {
      if (player) {
        player.player.pauseVideo();
        return;
      }

      const embeded = players.filter(
        (item) => item.type == 'y' && item.player && item.player.getPlayerState() == 1,
      );
      embeded.forEach((item) => item.player.pauseVideo());
    };

    this.pauseVimeoVideo = function (player) {
      if (player) {
        player.player.pause();
        return;
      }

      const embeded = players.filter(
        (item) => item.type == 'v' && item.player && item.player.getPlayed(),
      );
      embeded.forEach((item) => item.player.pause());
    };

    function onYoutubePlayerStateChange(event, callbacks = null) {
      if (event.data == YT.PlayerState.PLAYING) {
        pausePlayersExceptCurrent(getPlayerObj(event.target), 'y', getPages());
        self.pauseVimeoVideo();
        self.pauseBackgroundAudio();

        if (callbacks && callbacks.hasOwnProperty('PLAYING')) {
          callbacks.PLAYING();
        }

        let isMuted = !(
          APP.someUserIteraction &&
          !getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'muted')
        );

        if (
          getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay') &&
          _videoAutoplayAudio === false
        ) {
          isMuted = true;
        }

        if (!isMuted) {
          event.target.setVolume(100);
          event.target.unMute();
        } else {
          event.target.setVolume(0);
          event.target.mute();
        }
      }

      if (event.data == YT.PlayerState.ENDED || event.data == YT.PlayerState.PAUSED) {
        setDataToArrayByPlayerId(getPlayerObj(event.target).id, {
          start: event.target.getCurrentTime(),
        });

        setDataToModel();

        if (callbacks && callbacks.hasOwnProperty('PAUSED')) {
          callbacks.PAUSED();
        }
      }
      setTimeout(() => {
        changePlayerControlIcon(
          event.target,
          {
            playerType: 'y',
            controlType: 'audio',
          },
          event.target.isMuted()
            ? HELPER.playerControlsIcons['audioOff']
            : HELPER.playerControlsIcons['audioOn'],
        );
      }, 100);
    }

    this.clearPlayersOnChangePage = function () {
      if (players.length) {
        players.forEach((item) => {
          const player = document.querySelector(`#${item.playerId}`);

          if (player) {
            player.remove();
          }
        });

        setDataToModel(players[0].page);
      }

      players = [];
    };

    this.destroyPlayerByHotspotUId = (hotspotUId) => {
      const playerToDestroyIndex = players.findIndex(player => player.areaId === hotspotUId);

      if (playerToDestroyIndex === -1) return;

      try {
        players[playerToDestroyIndex].player.destroy();
      } catch {}

      players.splice(playerToDestroyIndex, 1);
    };

    function setDataToModel(page = 1) {
      const interactivities = APP.Book.getInteractivities(page);

      if (!interactivities || !interactivities.length) return;

      interactivities.areas.forEach((interactivity) => {
        if (!players || !players.length) return;

        players.forEach(async (player) => {
          if (interactivity.area_number != player.areaId || interactivity.type != 'video') return;

          if (!player.player.getCurrentTime) return;

          if (player.type == 'v') {
            interactivity.data = Object.assign({}, interactivity.data, {
              start: await player.player.getCurrentTime().then((result) => result),
            });
          } else {
            interactivity.data = Object.assign({}, interactivity.data, {
              start: player.player.getCurrentTime(),
            });
          }
        });
      });

      APP.Book.getModel().interactivities = interactivities;
    }

    this.pauseBackgroundAudio = function () {
      APP.Book.handleAudioPause();
    };

    function onVimeoPlayerChangeState(event, eventType, player, callbacks = null) {
      switch (eventType) {
        case 'play':
          self.pauseYoutubeVideo();
          self.pauseBackgroundAudio();
          // APP.Book.pauseAllEmbededVideos();
          pausePlayersExceptCurrent(player, 'v', getPages());
          let isMuted = !(
            APP.someUserIteraction &&
            !getDataFromArrayByPlayerId(player._originalElement.id, 'muted')
          );

          if (
            getDataFromArrayByPlayerId(player._originalElement.id, 'autoplay') &&
            _videoAutoplayAudio === false
          ) {
            isMuted = true;
          }

          player.setMuted(isMuted ? true : false);
          player.setVolume(isMuted ? 0 : 1);

          if (callbacks && callbacks.hasOwnProperty('PLAYING')) {
            callbacks.PLAYING();
          }
          break;

        case 'pause':
          setDataToArrayByPlayerId(player._originalElement.id, {
            start: event.seconds,
          });

          if (callbacks && callbacks.hasOwnProperty('PAUSED')) {
            callbacks.PAUSED();
          }
          break;

        default:
          break;
      }

      setTimeout(() => {
        player.getMuted().then((isMuted) =>
          changePlayerControlIcon(
            player,
            {
              playerType: 'v',
              controlType: 'audio',
            },
            isMuted
              ? HELPER.playerControlsIcons['audioOff']
              : HELPER.playerControlsIcons['audioOn'],
          ),
        );
      }, 100);
    }

    function setDataToArrayByPlayerId(id, data) {
      if (players) {
        players.forEach((player, index) => {
          if (player.playerId != id) return;

          players[index] = Object.assign({}, players[index], data);
        });
      }
    }

    function getDataFromArrayByPlayerId(id, data) {
      let plr = null;

      if (players) {
        players.forEach((player) => {
          if (player.playerId != id) return;

          plr = player;
        });
      }

      if (!plr) return;

      return plr[data];
    }

    function getPages() {
      const pages = [];
      const currentPage = APP.Book.getCurrentPage();
      const pagesLength = APP.Book.getModel().pages;
      const isDoublePage = APP.Book.isDoublePage();

      if (!isDoublePage) {
        return [currentPage];
      }

      if (currentPage == 1 || currentPage == pagesLength) {
        return [currentPage];
      }

      if (currentPage % 2 == 0) {
        pages.push(currentPage);
        pages.push(currentPage + 1);
      } else {
        pages.push(currentPage - 1);
        pages.push(currentPage);
      }

      return pages;
    }

    function attachVimeoScript() {
      const id = 'player-vimeo';
      const script = document.createElement('script');

      script.id = id;
      script.type = 'text/javascript';
      script.src = `${APP.PATH_CF_FLIP}assets/scripts/workers/vimeo/player.js`;
      document.body.insertAdjacentElement('beforeend', script);

      return new Promise((resolve) =>
        script.addEventListener('load', () => {
          _isVimeoScriptAttached = true;
          resolve();
        }),
      );
    }

    function attachYtScript() {
      const id = 'player-yt';
      const scriptUrl = `${APP.PATH_CF_FLIP}assets\/scripts\/workers\/yt\/player.js`;

      try {
        const ttPolicy = window.trustedTypes.createPolicy('youtube-widget-api', {
          createScriptURL: function (x) {
            return x;
          },
        });

        scriptUrl = ttPolicy.createScriptURL(scriptUrl);
      } catch (e) {}

      let YT;
      let YTConfig;
      if (!window['YT']) YT = { loading: 0, loaded: 0 };
      if (!window['YTConfig']) YTConfig = { host: 'https://www.youtube.com' };

      if (!YT.loading) {
        YT.loading = 1;

        const l = [];
        YT.ready = function (f) {
          if (YT.loaded) f();
          else l.push(f);
        };

        window.onYTReady = function () {
          YT.loaded = 1;
          for (let i = 0; i < l.length; i++) {
            try {
              l[i]();
            } catch (e$0) {}
          }
        };

        YT.setConfig = function (c) {
          for (const k in c) if (c.hasOwnProperty(k)) YTConfig[k] = c[k];
        };
      }

      const script = document.createElement('script');
      script.id = id;
      script.type = 'text/javascript';
      script.src = scriptUrl;
      script.async = true;
      document.body.insertAdjacentElement('beforeend', script);

      return new Promise((resolve) =>
        script.addEventListener('load', () => {
          _isYtScriptAttached = true;
          resolve();
        }),
      );
    }

    const onVimeoPlayerReady = (_, player, callbacks = null) => {
      if (callbacks && callbacks.hasOwnProperty('READY')) {
        callbacks.READY();
      }

      if (
        !getDataFromArrayByPlayerId(player._originalElement.id, 'muted') &&
        !getDataFromArrayByPlayerId(player._originalElement.id, 'controls')
      ) {
        showPlayerControl(
          player,
          {
            playerType: 'v',
            controlType: 'audio',
            autoplay: getDataFromArrayByPlayerId(player._originalElement.id, 'autoplay'),
            icon:
              !APP.someUserIteraction ||
              (getDataFromArrayByPlayerId(player._originalElement.id, 'autoplay') &&
                _videoAutoplayAudio === false)
                ? HELPER.playerControlsIcons['audioOff']
                : HELPER.playerControlsIcons['audioOn'],
          },
          (_, options) => {
            player.getMuted().then((isMuted) => {
              if (isMuted) {
                player.setVolume(1);
                player.setMuted(false);
              } else {
                player.setVolume(0);
                player.setMuted(true);
              }

              changePlayerControlIcon(
                player,
                options,
                isMuted
                  ? HELPER.playerControlsIcons['audioOn']
                  : HELPER.playerControlsIcons['audioOff'],
              );

              if (options.autoplay) {
                _videoAutoplayAudio = isMuted;
              }
            });
          },
        );
      }
    };

    this.inializeVimeoPlayer = async (el, options, vars, page, id, callbacks = null) => {
      if (!_isVimeoScriptAttached) {
        await attachVimeoScript();
      }

      const playerOptions = Object.assign({}, options, {
        loop: false,
        autoplay: true,
        autopause: false,
        muted: !vars.volume && APP.someUserIteraction ? false : true,
      });

      const player = new Vimeo.Player(el, playerOptions);

      players.push({
        playerId: el.id,
        areaId: id,
        player: player,
        type: 'v',
        page: page,
        start: vars.start,
        muted: !!!vars.volume,
        controls: !!options.controls,
        autoplay: vars.autoplay,
      });

      player.setCurrentTime(vars.start);
      player.on('loaded', (e) => onVimeoPlayerReady(e, player, callbacks));
      player.on('play', (e) => onVimeoPlayerChangeState(e, 'play', player, callbacks));
      player.on('pause', (e) => onVimeoPlayerChangeState(e, 'pause', player, callbacks));

      self.pauseYoutubeVideo();
    };

    window.players = () => players;

    this.isPlayerAlreadyInitialized = (areaId) => {
      return !!players.find(player => player.areaId === areaId);
    };

    this.hidePlayers = () => {
      if (!players || players.length === 0) return;

      players.forEach(p => {
        const player = getPlayerObj(p.player);

        if (!player) return;

        player.hidden = true;
      });
    };

    const getParentNodeByClassName = (element, parentNodeClassName) => {
      if (!element || !element.parentNode) {
        return null;
      }

      const parentNode = element.parentNode;

      if (parentNode.classList && parentNode.classList.contains(parentNodeClassName)) {
        return parentNode;
      }

      return getParentNodeByClassName(parentNode, parentNodeClassName);
    }
    
    this.adjustPlayersSizes = () => {
      if (!players || players.length === 0) return;

      players.forEach(p => {
        const player = getPlayerObj(p.player);

        if (!player) return;

        const hotspotArea = getParentNodeByClassName(player, 'hotspot-area');

        if (!hotspotArea) return;

        const hotspotAreaSizes = hotspotArea.getBoundingClientRect();

        if (hotspotAreaSizes.width === 0 || hotspotAreaSizes.height === 0) return;

        player.width = Math.ceil(hotspotAreaSizes.width + 1);
        player.height = Math.ceil(hotspotAreaSizes.height + 1);
      });
    };

    this.showPlayers = () => {
      if (!players || players.length === 0) return;

      players.forEach(p => {
        const player = getPlayerObj(p.player);

        if (!player) return;

        player.removeAttribute('hidden');
      });
    };

    this.pauseUploadedVideo = (player) => {
      if (player) {
        player.player.pause();
        return;
      }

      const embeded = players.filter((item) => item.type == 'p' && item.player && !item.player.paused);
      embeded.forEach((item) => item.player.pause());
    };

    this.inializeInternalPlayer = async (el, options, page, id, hotspotArea) => {
      const player = document.createElement('video');
      const videoMime = options.url.split('.').reverse()[0];

      players.push({
        playerId: el.id,
        areaId: id,
        player: player,
        type: 'p',
        page: page,
        loop: options.loop,
        start: options.start,
        muted: options.muted,
        controls: options.controls,
        autoplay: options.autoplay,
        lastControlsInteractionTime: null,
        hotspotArea
      });

      player.id = el.id;
      player.autoplay = true;
      player.controls = options.controls;
      player.muted = options.muted;
      player.loop = options.loop;
      player.controlsList = options.controlslist;
      player.preload = options.preload;
      player.setAttribute('disablePictureInPicture', '');

      if (options.playsinline) player.setAttribute('playsinline', '');
      if (options.webkitPlaysinline) player.setAttribute('webkit-playsinline', '');
      if (options.x5Playsinline) player.setAttribute('x5-playsinline', '');

      if (options.start > 0) player.currentTime = options.start;

      _SUPPORTED_SOURCE_TYPES.forEach(sourceType => {
        if (sourceType === 'webm') return;

        const source = document.createElement('source');

        source.src = options.url.replace(`.${videoMime}`, `.${sourceType}`);
        source.type = `video/${sourceType}`;

        player.appendChild(source);
      });

      if (!options.muted && options.autoplay && !APP.someUserIteraction) {
        player.muted = true;
      }

      player.addEventListener('loadeddata', (event) => {
        player.dataset.initialized = true;

        const isMuted = getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'muted');
        const isControlsEnabled = getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'controls');
        const isAutoplay = getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay');

        if (!isMuted && !isControlsEnabled && isAutoplay) {
          showPlayerControl(
            event.target,
            {
              playerType: 'p',
              controlType: 'audio',
              autoplay: getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay'),
              icon:
                !APP.someUserIteraction ||
                (getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'autoplay') &&
                  _videoAutoplayAudio === false)
                  ? HELPER.playerControlsIcons['audioOff']
                  : HELPER.playerControlsIcons['audioOn'],
            },
            (_, options) => {
              if (event.target.muted) {
                event.target.volume = 1;
                event.target.muted = false;
              } else {
                event.target.volume = 0;
                event.target.muted = true;
              }

              // hidePlayersControls('audio');
  
              changePlayerControlIcon(
                event.target,
                options,
                event.target.muted
                  ? HELPER.playerControlsIcons['audioOff']
                  : HELPER.playerControlsIcons['audioOn'],
              );
  
              if (options.autoplay) {
                _videoAutoplayAudio = event.target.muted;
              }
            },
          );
        }
      });

      player.addEventListener('fullscreenchange', function () {
        const fullscreenEl = 
          document.fullscreenElement ||
          document.webkitFullscreenElement ||
          document.mozFullScreenElement ||
          document.msFullscreenElement;

        this.style.objectFit = !!fullscreenEl ? 'contain' : 'cover';
      });

      player.addEventListener('play', (event) => {
        const playerObj = players.find(p => p.playerId == event.target.id);

        if (playerObj) {
          playerObj.lastControlsInteractionTime = new Date();
        }

        hidePlayersControls('play');

        pausePlayersExceptCurrent(getPlayerObj(event.target), 'p', getPages());
        self.pauseBackgroundAudio();
      });

      player.addEventListener('pause', (event) => {
        const playerObj = players.find(p => p.playerId == event.target.id);

        if (playerObj) {
          playerObj.lastControlsInteractionTime = new Date();
        }

        const isControlsEnabled = getDataFromArrayByPlayerId(getPlayerObj(event.target).id, 'controls');
        
        if (!isControlsEnabled) {
          showPlayerControl(
            event.target,
            {
              playerType: 'p',
              controlType: 'play',
              icon: HELPER.playerControlsIcons['playCircle'],
            },
            (_, options) => {
              event.target.play();

              hidePlayersControls('play');
            },
          );
        }
      });

      el.innerHTML = '';
      el.appendChild(player);
    };

    this.unmuteAutoplayedVideo = () => {
      return;
    };
  })();
});
