APPonReady.add(function () {
  APP.Search = new (function () {
    let _state = {
      prevQuery: '',
      query: ''
    }

    let _settings = {
      minQueryLength: 3,
      requestTimeout: 1000,
      emptyErrorText: APP._t('Sidebar Search No Results')
    }

    let _elements = {
      sidebar: null,
      scrolledElement: null,
      searchWrapper: null,
      searchInput: null,
      searchInfo: null,
      searchList: null,
      searchButton: null,
      searchError: null,
      searchLoader: null,
      clearButton: null,
    }

    let searchResult = null;
    let isRequestSended = false;

    this.initialize = function (sidebar) {
      createElements(sidebar);
      bindEvents();
    }

    this.sidebarShowHandler = function () {
      if (_elements.searchInput) {
        _elements.searchInput.focus();
      }
    }

    this.sidebarHideHandler = function () {
      clearHandler();

      if (_elements.searchInput) {
        _elements.searchInput.blur();
      }
    }

    this.renderSearchResult = function () {
      renderSearchResultOnCurrentPage();
    }

    const createElements = function (sidebar) {
      const ICON_TYPE = 'inline';

      const scrolledElement = document.createElement('div');
      const searchWrapper = document.createElement('form')
      const searchInput = document.createElement('input');
      const searchList = document.createElement('ul')
      const searchButton = document.createElement('button');
      const searchError = document.createElement('span');
      const clearButton = document.createElement('button');
      const searchInfo = document.createElement('span');
      const searchLoader = document.createElement('div');

      scrolledElement.className = 'sidebar-search__scrolled';
      searchList.className = 'sidebar-search__list';
      searchWrapper.className = 'sidebar-search__input-wrapper';
      searchInput.className = 'sidebar-search__input';
      searchButton.className = 'sidebar-search__button';
      searchError.className = 'sidebar-search__error';
      clearButton.className = 'sidebar-search__clear';
      searchInfo.className = 'sidebar-search__info';
      searchLoader.className = 'sidebar-search__loader';

      searchButton.name = APP._t('Sidebar Search Title');
      searchButton.ariaLabel = APP._t('Sidebar Search Title');
      
      clearButton.name = APP._t('Button Clear');
      clearButton.ariaLabel = APP._t('Button Clear');

      searchInput.setAttribute('type', 'text');
      searchInput.setAttribute('placeholder', APP._t('Sidebar Search Enter Query'));
      clearButton.innerText = APP._t('Sidebar Search Clear');
      searchInfo.innerText = APP._t('Sidebar Search Min Symbols', [_settings.minQueryLength]);
      searchLoader.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"><circle cx="50" cy="50" fill="none" stroke="#3461c9" stroke-width="6" r="32" stroke-dasharray="150.79644737231007 52.26548245743669"><animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"/></circle></svg>`

      if (ICON_TYPE === 'inline') {
        searchButton.classList.add(ICON_TYPE);
        searchButton.dataset.type = ICON_TYPE;
        searchButton.innerHTML = HELPER.buttonsIcons.searchIcon;
      } else {
        searchButton.appendChild(document.createElement('div'));
      }

      searchWrapper.appendChild(searchInput);
      searchWrapper.appendChild(searchButton);
      searchWrapper.appendChild(clearButton);
      searchWrapper.appendChild(searchLoader);
      searchWrapper.appendChild(searchInfo);
      scrolledElement.appendChild(searchList);

      sidebar.querySelector('.sidebar__wrapper').appendChild(searchWrapper);
      sidebar.querySelector('.sidebar__wrapper').appendChild(searchError);
      sidebar.querySelector('.sidebar__wrapper').appendChild(scrolledElement);

      _elements = {
        sidebar: sidebar,
        scrolledElement: scrolledElement,
        searchWrapper: searchWrapper,
        searchInput: searchInput,
        searchList: searchList,
        searchButton: searchButton,
        searchError: searchError,
        clearButton: clearButton,
        searchInfo: searchInfo,
        searchLoader: searchLoader
      }

      if (!is_mobile()) {
        HELPER.renderCustomSearchScroll(_elements.sidebar, _elements.scrolledElement);
      }
    }

    const bindEvents = function () {
      _elements.searchButton.addEventListener('click', searchHandler);
      _elements.clearButton.addEventListener('click', clearHandler);
      _elements.searchInput.addEventListener('input', (e) => {
        if (e.target.value.length <= 0) {
          _state.query = '';
          setPrevQueryState('');
          searchResult = null;

          clearResultList();
          
          _elements.clearButton.classList.remove('show');
          _elements.searchInfo.classList.remove('show');
        } else if (e.target.value.length < 3) {
          _elements.clearButton.classList.remove('show');
          _elements.searchInfo.classList.add('show');
          _state.query = '';
          setPrevQueryState('');
        } else {
          lastCharTypedTime = Date.now();
          _elements.clearButton.classList.add('show');
          _elements.searchInfo.classList.remove('show');
          _state.query = e.target.value.replace(/[\s]{2,}/, ' ');

          debouncedHandle();
        }
      });
    }

    const searchHandler = function (e) {
      if (e) e.preventDefault();
      
      if (isRequestSended) {
        isRequestSended = false;
        return;
      }

      isRequestSended = true;

      let value = _state.query;

      if (value.length < _settings.minQueryLength) {
        _elements.searchInfo.classList.add('show');
        return;
      }

      if (getPrevQueryState() == value) {
        return;
      }

      _elements.searchInput.setAttribute('disabled', 'disabled');
      _elements.searchButton.setAttribute('disabled', 'disabled');

      if (_elements.sidebar.querySelector('.sidebar__scrollbar')) {
        _elements.sidebar.querySelector('.sidebar__scrollbar').remove();
      }

      _elements.searchLoader.classList.add('show');

      removeAllMarks();
      removeError();
      clearResultList();

      let { id: issueId, ref_id: refId,  publisher_id: publisherId, is_canva, is_demo, cloudfront, version } = APP.Book.getModel();
      let options = {};
      const bookId = refId || issueId;
      
      if (is_demo == 1) {
        options = {
          ...options,
          demo: 1
        }
      }

      if (is_canva == 1) {
        options = {
          ...options,
          canva: 1
        }
      }

      if (version && version > 0) {
        options = {
          ...options,
          version
        }
      }

      if (cloudfront != null && cloudfront.length > 1) {
        options = {
          ...options,
          cf: cloudfront
        }
      }

      if (!bookId || !publisherId) {
        console_log('SEARCH ERROR');
        createError(APP._t('Sidebar Search Error'));
        return;
      }
      
      const urlParams = new URLSearchParams(options).toString();
      
      fetch(`https://bkmmduyss3zcnnbrhsagn756dm0tqphz.lambda-url.us-east-2.on.aws/${publisherId}/${bookId}/${encodeURI(value)}?${urlParams}`)
        .then(response => response.json())
        .then(data => {
          if (data.message) {
            isRequestSended = false;
            _elements.searchInput.removeAttribute('disabled');
            _elements.searchButton.removeAttribute('disabled');
            _elements.searchLoader.classList.remove('show');

            console_log(data);
            createError(APP._t('Sidebar Search Error'));
            return;
          }

          searchResult = data;
          renderListResults();
          renderSearchResultOnCurrentPage();

          _elements.searchInput.removeAttribute('disabled');
          _elements.searchButton.removeAttribute('disabled');
          _elements.searchLoader.classList.remove('show');
          setPrevQueryState(value);
          isRequestSended = false;
        })
        .catch(err => {
          isRequestSended = false;
          console_log(err);
          // createError(err.message);
        })
    }

    const debouncedHandle = HELPER.debounce(searchHandler, _settings.requestTimeout)

    const clearHandler = function (e) {
      if (e) e.preventDefault();

      if (is_mobile() && e && e.target != _elements.clearButton) {
        return;
      }

      removeAllMarks();
      clearResultList();
      removeError();
      removeEmptyResult();

      searchResult = null;

      _state = {
        prevQuery: '',
        query: ''
      }

      _elements.searchInput.value = '';
      _elements.clearButton.classList.remove('show');
      _elements.searchInfo.classList.remove('show');
      
      if (_elements.sidebar.querySelector('.sidebar__scrollbar')) {
        _elements.sidebar.querySelector('.sidebar__scrollbar').remove();
      }
    }

    const getCurrentPages = function () {
      const currentPage = APP.Book.getCurrentPage();
      const isDoublePage = APP.Book.isDoublePage();
      const bookPages = APP.Book.getModel().pages;
      
      if (currentPage == 1 || !isDoublePage) {
        return [currentPage];
      }
      
      if (currentPage == bookPages) {
        if (bookPages % 2 == 0) {
          return [bookPages];
        } else {
          return [bookPages - 1, bookPages];
        }
      }

      if (currentPage % 2 == 0) {
        return [currentPage, currentPage + 1];
      } else {
        return [currentPage - 1, currentPage];
      }
    }

    const renderSearchResultOnCurrentPage = function () {
      if (!searchResult || searchResult == null || searchResult.length <= 0) {
        return;
      }

      setActiveListItems();
      removeAllMarks();
      const pages = getCurrentPages();

      pages.forEach(page => {
        const currentPageResults = searchResult.filter(result => result.page + 1 == page && result.values.length > 0);
        if (currentPageResults.length > 0) {
          currentPageResults[0].values.forEach(result => {
            const x = result[0] * 100 / currentPageResults[0].width;
            const y = result[1] * 100 / currentPageResults[0].height;
            const width = (result[2] - result[0]) * 100 / currentPageResults[0].width;
            const height = (result[3] - result[1]) * 100 / currentPageResults[0].height;
  
            const mark = document.createElement('div');
            mark.className = 'search-mark';
  
            mark.style.cssText = `width: ${width}%; height: ${height}%; left: ${x}%; top: ${y}%;`;
            document.querySelector(`._page_${page}`).appendChild(mark);
          }); 
        }
      })
    }

    const setActiveListItems = function () {
      const currentPages = getCurrentPages();

      const listItems = _elements.searchList.querySelectorAll('.sidebar-search__item');
 
      if (!listItems || listItems.length <= 0) {
        return;
      }

      listItems.forEach(item => {
        if (currentPages.includes(+item.getAttribute('page'))) item.classList.add('active');
        else item.classList.remove('active');
      })
    }

    const getResultsText = (count) => {
      const lastDigit = count % 10;
      const lastTwoDigits = count % 100;
  
      if (lastTwoDigits >= 12 && lastTwoDigits <= 14) {
        return APP._t('Sidebar Search List Results 5 Text');
      }

      if (count === 1) {
        return APP._t('Sidebar Search List Result Text');
      }

      if (lastDigit >= 2 && lastDigit <= 4 && (lastTwoDigits < 10 || lastTwoDigits > 20)) {
        return APP._t('Sidebar Search List Results 2 Text');
      } 

      return APP._t('Sidebar Search List Results 5 Text');
    };

    const renderListResults = function () {
      if (!searchResult || searchResult == null || searchResult.length <= 0) {
        renderEmptyResult();
        return;
      }

      clearResultList();
      removeEmptyResult();

      searchResult.forEach(result => {
        if ('values' in result && result.values.length > 0) {
          const listItem = document.createElement('li');
          listItem.className = 'sidebar-search__item';
          listItem.setAttribute('page', result.page + 1);
          listItem.addEventListener('click', () => {
            if (APP.Book.isBookZoomed()) {
              APP.Book.scale(0);
              setTimeout(() => {
                APP.Book.setPage(result.page + 1, 'sidebar.click');
                renderSearchResultOnCurrentPage();
                if (is_mobile() || is_small_embed_not_mobile()) {
                  APP.Layout.getSidebarSearch().hide();
                }
              }, 500);
            } else {
              APP.Book.setPage(result.page + 1, 'sidebar.click');
              renderSearchResultOnCurrentPage();
              if (is_mobile() || is_small_embed_not_mobile()) {
                APP.Layout.getSidebarSearch().hide();
              }
            }
          });

          const resultText = getResultsText(result.values.length);
          listItem.innerHTML = APP._t('Sidebar Search List Item', [result.page + 1, result.values.length, resultText]);
          _elements.searchList.appendChild(listItem);
        }
      });

      if (!is_mobile()) {
        HELPER.renderCustomSearchScroll(_elements.sidebar, _elements.scrolledElement);
      }
    }

    const removeAllMarks = function () {
      document.querySelectorAll('.search-mark').forEach(mark => mark.remove());
    }

    const clearResultList = function () {
      const listItems = _elements.searchList.querySelectorAll('.sidebar-search__item');
 
      if (!listItems || listItems.length <= 0) {
        return;
      }

      listItems.forEach(item => item.remove());
    }

    const renderEmptyResult = function () {
      if (_elements.searchList.querySelector('.sidebar-search__empty')) {
        return;
      }

      const emptyWrapper = document.createElement('div');
      const emptyText = document.createElement('span');

      emptyWrapper.className = 'sidebar-search__empty';
      emptyText.innerText = _settings.emptyErrorText;

      emptyWrapper.appendChild(emptyText);
      _elements.searchList.appendChild(emptyWrapper);
    }

    const removeEmptyResult = function () {
      if (!_elements.searchList.querySelector('.sidebar-search__empty')) {
        return;
      }

      _elements.searchList.querySelector('.sidebar-search__empty').remove();
    }

    const createError = function (text) {
      _elements.searchError.innerText = text;
      _elements.searchError.classList.add('show');
    }

    const removeError = function () {
      _elements.searchError.innerText = '';
      _elements.searchError.classList.remove('show');
    }

    const getPrevQueryState = function () {
      return _state.prevQuery.trim().toLocaleLowerCase().replace(/[\s]{2,}/, ' ');
    }

    const setPrevQueryState = function (string) {
      _state.prevQuery = string.trim().toLocaleLowerCase().replace(/[\s]{2,}/, ' ');
    }
  });
});
