"use strict";

var Request = function(url, post, callbacks, fake) {
	var self = this;

	APP.log('Request',arguments);

	var fake = (isset(fake)?fake:false);

	callbacks = (isset(callbacks)?{
		before: (isset(callbacks.before)?callbacks.before:null),
		after: (isset(callbacks.after)?callbacks.after:null),
		success: (isset(callbacks.success)?callbacks.success:null),
		error: (isset(callbacks.error)?callbacks.error:null),
		state: (isset(callbacks.state)?callbacks.state:null)
	}:{
		before: null,
		after: null,
		success: null,
		error: null,
		state: null
	});
	var xhr = null,
		started = false,
		finished = false,
		response;
	this.start = function() {
		if (callbacks.before) callbacks.before();
		if (fake) {
			var inp = document.createElement('script');
			inp.src = url;
			inp.onload = function() {
				response = json_data;
				if (response) {
					if (callbacks.success) callbacks.success(response);
					//APP.log('Request->success', response);
				} else {
					if (callbacks.error) callbacks.error();
					APP.log('Request->error', response);
				}
				if (callbacks.after) callbacks.after();
			};
			document.body.appendChild(inp);
		} else {
			xhr = new XMLHttpRequest();
			if (post!==null) {
				xhr.open('POST', url, true);
				xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				xhr.send(JSON.stringify(post));
			} else {
				xhr.open('GET', url, true);
				xhr.send();
			}
			xhr.onreadystatechange = function() {
				if (callbacks.state) callbacks.state();
				started = true;
				if (this.readyState !== 4) return;
				if (this.status == 200) {
					finished = true;
					response = JSON.parse(this.responseText);
					if (response) {
						if (callbacks.success) callbacks.success(response);
						APP.log('Request->success', response);
					} else {
						if (callbacks.error) callbacks.error();
						APP.log('Request->error', response);
					}
				} else {
					if (callbacks.error) callbacks.error();
					APP.log('Request->error');
				}
				if (callbacks.after) callbacks.after();
			};
		}
	};
	this.stop = function() {
		if (self.is_started()&&!self.is_finished()) {
			xhr.abord();
			xhr = null;
		}
	};
	this.is_started = function () {
		return started;
	};
	this.is_finished = function () {
		return finished;
	};
}
