var Ranger = function (model) {
  var self = this;

  var elements = {},
    min = isset(model.min) ? model.min : 0,
    max = isset(model.max) ? model.max : 100,
    timeout = null;
  this.render = function () {
    if (Object.keys(elements).length) return elements;

    var val = isset(model.value) ? model.value : 0;

    elements.parent = document.createElement('div');
    elements.input = document.createElement('input');

    if (model.isRtl) {
      elements.input.style.direction = 'rtl';
    }

    if (true) {
      //image as bg
      //    elements.input.style.opacity = "1.0";
    }

    elements.point = document.createElement('div');
    elements.point.className = ['Ranger__point', model.showInt ? '__showInt' : ''].join(' ');
    elements.point.innerHTML = '<span></span>';
    elements.pointSpan = elements.point.querySelector('span');
    elements.parent.className = ['Ranger', isset(model.className) ? model.className : null].join(
      ' ',
    );

    elements.input.setAttribute('type', 'range');
    elements.input.setAttribute('id', model.id);
    elements.input.setAttribute('aria-label', APP._t('Page Ranger Label'));
    elements.input.className = 'slider';
    elements.input.ariaLabel = APP._t('Page Ranger Label');
    elements.input.setAttribute('min', min);
    elements.input.setAttribute('max', max);

    elements.input.classList.add(model.theme);

    elements.input.addEventListener('input', function () {
      preChange();
      if (is_function(model.oninput)) {
        model.oninput(parseInt(this.value));
      }
    });
    elements.input.addEventListener('change', function () {
      preChange();
      self.setValue(this.value, true);
    });

    self.setValue(val, true);

    elements.parent.appendChild(elements.input);
    //		elements.parent.appendChild(elements.point);

    APP.loadCSS('Ranger', ['xs']);

    return elements;
  };
  var preChange = function () {
    APP.Book.contextMenuToggle();
      var val = parseInt(elements.input.value),
        slr = max - min,
        sll = min,
        _or = slr / 100,
        _ap = (val - sll) / _or;
      elements.point.style.left = [_ap.toFixed(4), '%'].join('');
      if (model.showInt) elements.pointSpan.innerText = elements.input.value;
    },
    change = function () {
      var val = parseInt(elements.input.value);
      if (is_function(model.onchange)) {
        if (isset(model.timeout)) {
          clearTimeout(timeout);
          timeout = setTimeout(function () {
            model.onchange(parseInt(elements.input.value));
          }, model.timeout);
        } else {
          model.onchange(val);
        }
      }
    };
  this.setValue = function (v, force) {
    if (!elements || !elements.input) return;

    if (!isset(force)) var force = false;
    v = parseInt(v);

    if (!force && v == parseInt(elements.input.value)) return;

    elements.input.value = v;
    elements.input.setAttribute('value', elements.input.value);

    preChange();
    change();
  };
  this.getValue = function () {
    return parseInt(elements.input.value);
  };
  this.getNode = function (node) {
    return elements[node];
  };
  this.updateMax = function (val) {
    model.max = val;
    if (elements && elements.input) {
      elements.input.setAttribute('max', val);
    }
  };
};
