APPonReady.add(function () {
  APP.Products = new (function () {
    let _products = [];
    let _elements = {
      sidebar: null,
      scrolledElement: null,
      productsList: null,
      footer: null,
      emailInput: null,
      submitBtn: null,
      productTemplate: null,
      popup: null,
      popupContainer: null
    };

    let _bookId = null;
    let _publisherId = null;
    let _socialsInitialized = false;
    const _self = this;

    this.initialize = (sidebar) => {
      _bookId = APP.Book.getModel().bookId;
      _publisherId = APP.Book.getModel().publisherId;

      createElements(sidebar);
      bindEvents();
    
      restoreProductsFromLocalStorage();

      if (APP.Book.getInteractivitiesByType('product-info', { 'show_wishlist': [1, true] }, false).length > 0) {
        showWishlistButton();
      }
    }

    this.sidebarShowHandler = () => {
      rerenderWishlist(true);
      changeWishlistButtonClass(true);
      changeSubmitButtonState();

      if (!is_mobile()) {
        HELPER.renderCustomProductScroll(_elements.sidebar, _elements.scrolledElement);
      }
    }

    this.sidebarHideHandler = () => {
      changeWishlistButtonClass(false);
    }

    this.renderProductPopup = (hotspot) => {
      if (!_elements.popup) return;
  
      if (_elements.popup.hasAttribute('data-template')) {
        _elements.popup.removeAttribute('data-template');
      }
  
      resetProductPopup();

      _elements.popup.dataset.hotspotUid = hotspot.uid;
      _elements.popup.querySelector('.product-modal__close').innerHTML = HELPER.buttonsIcons.popupCloseIcon;
      _elements.popup.querySelector('.product-modal__title').innerText = decodeURIComponent(hotspot.name);
      _elements.popup.querySelector('.product-modal__description').innerHTML = HELPER.escapeHtml(hotspot.description);
      
      if (!hotspot.unavailable_product) {
        const currency = hotspot.currency.symbol;
        const isBeginningSymbol = hotspot.currency.symbol_pos === 1 || false;
  
        _elements.popup.querySelector('.product-modal__status').setAttribute('hidden', true);
  
        if (hotspot.show_price && hotspot.price && hotspot.price.length > 0) {
          _elements.popup.querySelector('.product-modal__prices').removeAttribute('hidden');
  
          _elements.popup.querySelector('.product-modal__price--new').innerHTML = isBeginningSymbol ? `<span>${currency}</span><span>${hotspot.price}</span>` : `<span>${hotspot.price}</span><span>${currency}</span>`;
  
          if (hotspot.show_discount_price && hotspot.discount_price && hotspot.discount_price.length > 0) {
            _elements.popup.querySelector('.product-modal__price--new').innerHTML = isBeginningSymbol ? `<span>${currency}</span><span>${hotspot.discount_price}</span>` : `<span>${hotspot.discount_price}</span><span>${currency}</span>`;
  
            _elements.popup.querySelector('.product-modal__price--old').innerHTML = isBeginningSymbol ? `<span>${currency}</span><span>${hotspot.price}</span>` : `<span>${hotspot.price}</span><span>${currency}</span>`;
          }
        } else {
          _elements.popup.querySelector('.product-modal__price--new').innerText = 'No price';
        }      
      } else {
        _elements.popup.querySelector('.product-modal__status').removeAttribute('hidden');
        _elements.popup.querySelector('.product-modal__prices').setAttribute('hidden', true);
      }
  
      if (hotspot.show_website && hotspot.website && hotspot.website.length > 0) {
        let url = HELPER.escapeHtml(hotspot.website);
  
        if (url.indexOf('https://') == -1 && url.indexOf('http://') == -1) {
          url = `https://${url}`;
        }
  
        _elements.popup.querySelector('.product-modal__btn--website').removeAttribute('hidden');
        _elements.popup.querySelector('.product-modal__btn--website').setAttribute('href', url);
      } else {
        _elements.popup.querySelector('.product-modal__btn--website').setAttribute('hidden', true);
      }

      const wishlistButton = _elements.popup.querySelector('.product-modal__btn--wishlist');

      if (hotspot.hasOwnProperty('show_wishlist') && !hotspot.show_wishlist) {
        wishlistButton.setAttribute('hidden', true);
      } else {
        wishlistButton.removeAttribute('hidden');
      }
      
      if (hotspot.hasOwnProperty('display_social_media_icons') && !hotspot.display_social_media_icons) {
        _elements.popup.querySelector('.product-modal__info__footer').setAttribute('hidden', true);
      } else {
        _elements.popup.querySelector('.product-modal__info__footer').removeAttribute('hidden', true);
      }
      
      if (isProductAlreadyInWishlist(hotspot.uid)) {
        wishlistButton.classList.add('active');
        wishlistButton.querySelector('span').innerText = wishlistButton.querySelector('span').dataset.textRemove;
      } else {
        wishlistButton.classList.remove('active');
        wishlistButton.querySelector('span').innerText = wishlistButton.querySelector('span').dataset.textAdd;
      }
  
      renderGallerySlider(hotspot);
      setShareLinks(hotspot);
  
      wishlistButton.dataset.id = hotspot.uid;
      
      showProductPopup();
    }

    this.openProductByUid = (productId) => {
      let product = getProductFromInteractivities(productId);

      if (!APP.Layout.isSidebarRelative()) {
        APP.Book.hideSidebar();
      }

      // APP.Layout.getSidebarWishlist().hide(_self.sidebarHideHandler);

      if (!product || product.length <= 0) {
        const localStorageProducts = getProductsFromLocalStorage();
        if (!localStorageProducts) return;

        const productsIndex = localStorageProducts.findIndex(item => item.bookId == _bookId);
        if (productsIndex == -1) return;

        const productIndex = localStorageProducts[productsIndex].products.findIndex(item => item.id == productId);

        if (productIndex !== -1) {
          product = localStorageProducts[productsIndex].products[productIndex];
          product.isAvailable = false;

          if (APP.Book.getCurrentPage() !== product.page + 1) {
            APP.Book.setPage(product.page + 1, 'product');

            const waitForAnimationEnd = setInterval(() => {
              if (APP.Book.pageFlipGetState() == 'read') {
                clearInterval(waitForAnimationEnd);
                this.renderProductPopup(product.model);
              }
            }, 300);
          }

          return;
        } else {
          renderEmptyProductPopup();
          return;
        }
      } else {
        if (APP.Book.getCurrentPage() !== product.page + 1) {
          APP.Book.setPage(product.page + 1, 'product');
        }

        const waitForAnimationEnd = setInterval(() => {
          if (APP.Book.pageFlipGetState() == 'read') {
            clearInterval(waitForAnimationEnd);
            this.renderProductPopup(product.data);
          }
        }, 300);
      }
    }

    const showWishlistButton = () => {
      const button = document.querySelector('.Book__wishlist');

      if (!button) {
        return;
      }

      button.removeAttribute('hidden');

      if (is_mobile()) {
        APP.Book.setHeaderOffsets();
      }
    };

    const renderEmptyProductPopup = () => {
      if (!_elements.popup) return;
  
      if (_elements.popup.hasAttribute('data-template')) {
        _elements.popup.removeAttribute('data-template');
      }
  
      resetProductPopup();
      
      _elements.popup.querySelector('.product-modal__title').innerText = '';
      _elements.popup.querySelector('.product-modal__description').innerText = APP._t('Product Form Product Undefiend');
      
      _elements.popup.querySelector('.product-modal__status').removeAttribute('hidden');
      _elements.popup.querySelector('.product-modal__prices').setAttribute('hidden', true);
      _elements.popup.querySelector('.product-modal__btn--website').setAttribute('hidden', true);
      _elements.popup.querySelector('.product-modal__socials').setAttribute('hidden', true);

      const wishlistButton = _elements.popup.querySelector('.product-modal__btn--wishlist');
      wishlistButton.classList.remove('active');
      wishlistButton.setAttribute('hidden', true);

      _elements.popup.querySelector('.product-modal__image__wrapper--main').classList.add('placeholder');

      _elements.popup.querySelector('.product-modal__image__wrapper--main').innerHTML = `<svg width="150" height="150" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 300 300" style="enable-background:new 0 0 300 300;" xml:space="preserve"><g id="_x31_48_x2C__Camera_x2C__Image_x2C__Basic_x2C__Ui"><g id="XMLID_5081_"><g id="XMLID_5082_"><path fill="#c6c6c6" d="M149.2,246c-36.8,0-66.6-29.9-66.6-66.6s29.9-66.6,66.6-66.6c36.8,0,66.6,29.9,66.6,66.6 C215.8,215.6,185.9,246,149.2,246z M149.2,126c-29.3,0-53.3,24-53.3,53.3s24,53.3,53.3,53.3c29.3,0,53.3-24,53.3-53.3 S178.5,126,149.2,126z"></path></g><g id="XMLID_5083_"><path fill="#c6c6c6" d="M260.6,284.4H37.7c-17.6,0-32-14.4-32-32V104.7c0-17.6,14.4-32,32-32h30.4l5.3-13.3 c4.8-12.3,16-19.7,29.3-19.7h93.3c12.8,0,24.5,8,29.3,19.7l5.3,13.3h30.4c17.6,0,32,14.4,32,32v147.7 C292.6,270,278.2,284.4,260.6,284.4z M37.7,86c-10.1,0-18.7,8.5-18.7,18.7v147.7c0,10.1,8.5,18.7,18.7,18.7h222.8 c10.1,0,18.7-8.5,18.7-18.7V104.7c0-10.1-8.5-18.7-18.7-18.7h-34.7c-2.7,0-5.3-1.6-6.4-4.3l-6.9-17.6C209.9,57.3,203,53,195.5,53 h-93.3c-7.5,0-13.9,4.3-17.1,11.2l-6.4,17.6c-1.1,2.7-3.2,4.3-6.4,4.3H37.7z"></path></g></g></g></svg>`;
      
      showProductPopup();
    }

    const changeSubmitButtonState = () => {
      const regex = /^[\w\-\.]+@([\w-]+\.)+[\w-]{2,}$/;
      
      if (_products.length > 0 && _elements.emailInput.value.trim().length > 0 && _elements.emailInput.value.match(regex)) {
        _elements.submitBtn.removeAttribute('disabled');
      } else {
        _elements.submitBtn.setAttribute('disabled', true);
      }
    }

    const resetProductPopup = () => {  
      delete _elements.popup.dataset.hotspotUid;

      _elements.popup.querySelector('.product-modal__title').innerText = '';
      _elements.popup.querySelector('.product-modal__status').removeAttribute('hidden');
      _elements.popup.querySelector('.product-modal__prices').setAttribute('hidden', true);
      _elements.popup.querySelector('.product-modal__btn--website').setAttribute('href', '#');
      _elements.popup.querySelector('.product-modal__description').innerText = '';
      Array.from(_elements.popup.querySelectorAll('.product-modal__price')).forEach(item => item.innerText = '');
      _elements.popup.querySelector('.product-modal__image__wrapper--main').innerHTML = '';
      _elements.popup.querySelector('.product-modal__images').innerHTML = '';
    }
  
    const showProductPopup = () => {
      _elements.popup.classList.add('show');
      HELPER.fadeInEffect(_elements.popup, _elements.popupContainer, 200, () => {
        HELPER.sendPostMessageToParent('publuu.viewer.popup.product.open');
      });
    }
  
    const closeProductPopup = () => {
      _elements.popup.classList.remove('show');
      
      HELPER.fadeOutEffect(_elements.popup, _elements.popupContainer, 200, () => {
        resetProductPopup();

        HELPER.sendPostMessageToParent('publuu.viewer.popup.product.close');
        
        if (_elements.popup.handleClose && typeof(_elements.popup.handleClose) === 'function') {
          _elements.popup.handleClose();
        }
      });
    }

    const getProductFromInteractivities = (productId) => {
      const bookInteractivities = APP.Book.getModel().interactivites;
      let product = null;

      if (!Array.isArray(bookInteractivities) || bookInteractivities.length <= 0) {
        return product;
      }

      bookInteractivities.forEach(page => {
        if (product) {
          return;
        }

        if (!page.areas || !Array.isArray(page.areas) || page.areas.length <= 0) {
          return;
        }

        const productIndex = page.areas.findIndex(item => item.type == 'product-info' && item.data.uid == productId);

        if (productIndex !== -1) {
          product = Object.assign(page.areas[productIndex], {
            page: page.page
          });
        }
      })

      return product;
    }

    const addToWishlist = (button) => {
      const hotspotId = button.dataset.id;
      const product = getProductFromInteractivities(hotspotId)

      if (!product || (Array.isArray(product) && product.length <= 0)) {
        return;
      }

      const productModel = getWishlistProductModel(product);
      const productIndex = _products.findIndex(_product => _product.id === productModel.id);

      if (productIndex === -1) {
        _products.push(productModel);
        
        renderProduct(productModel);

        saveProductsToLocalStorage();
        updateIconByQuantity();

        button.classList.add('active');
        button.querySelector('span').innerText = button.querySelector('span').dataset.textRemove;
        button.setAttribute('disabled', true);

        const heartAnimationTimeout = setTimeout(() => {
          button.removeAttribute('disabled');
          clearTimeout(heartAnimationTimeout);
        }, 500);
      } else {
        _products[productIndex].quantity -= 1;
        button.classList.remove('active');
        button.setAttribute('disabled', true);
        button.querySelector('span').innerText = button.querySelector('span').dataset.textAdd;

        setTimeout(() => {
          button.removeAttribute('disabled');
        }, 1000);

        removeFromWishlist(_products[productIndex].id);
        rerenderWishlist(true);
      }

      if (_products.length <= 0) {
        _elements.emptyNotification.removeAttribute('hidden');
      } else {
        _elements.emptyNotification.setAttribute('hidden', true);
      }
    }
  
    const createElements = (sidebar) => {
      _elements.popup = document.querySelector('.product-modal');
      _elements.popupContainer = _elements.popup.querySelector('.product-modal__container');

      _elements.scrolledElement = document.createElement('div');
      _elements.productsList = document.createElement('ul')
      _elements.productTemplate = document.createElement('li');
      _elements.footer = document.createElement('div');
      _elements.emailInput = document.createElement('input');
      _elements.submitBtn = document.createElement('button');
      _elements.status = document.createElement('span');
      _elements.emptyNotification = document.createElement('span');

      _elements.submitBtn.setAttribute('disabled', true);
      _elements.submitBtn.innerHTML = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><path d="M58.7,10.7H5.3C2.4,10.7,0,13.1,0,16v32c0,2.9,2.4,5.3,5.3,5.3h53.3c2.9,0,5.3-2.4,5.3-5.3V16C64,13.1,61.6,10.7,58.7,10.7z M52.3,16L33.1,27.7c-0.5,0.3-1.3,0.3-1.9,0L11.7,16H52.3z M5.3,48V18.4l22.9,13.9c1.1,0.8,2.4,1.1,3.7,1.1c1.3,0,2.7-0.3,3.7-1.1 l22.9-13.9V48H5.3z"/></svg><span>${APP._t('Sidebar Wishlist Button')}</span>`;

      _elements.productTemplate.innerHTML = `<div class="wishlist__item__image__wrapper"><img src="" alt="" class="wishlist__item__image" /><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 300 300" style="enable-background:new 0 0 300 300;" xml:space="preserve"><g id="_x31_48_x2C__Camera_x2C__Image_x2C__Basic_x2C__Ui"><g id="XMLID_5081_"><g id="XMLID_5082_"><path fill="#c6c6c6" d="M149.2,246c-36.8,0-66.6-29.9-66.6-66.6s29.9-66.6,66.6-66.6c36.8,0,66.6,29.9,66.6,66.6 C215.8,215.6,185.9,246,149.2,246z M149.2,126c-29.3,0-53.3,24-53.3,53.3s24,53.3,53.3,53.3c29.3,0,53.3-24,53.3-53.3 S178.5,126,149.2,126z"/></g><g id="XMLID_5083_"><path fill="#c6c6c6" d="M260.6,284.4H37.7c-17.6,0-32-14.4-32-32V104.7c0-17.6,14.4-32,32-32h30.4l5.3-13.3 c4.8-12.3,16-19.7,29.3-19.7h93.3c12.8,0,24.5,8,29.3,19.7l5.3,13.3h30.4c17.6,0,32,14.4,32,32v147.7 C292.6,270,278.2,284.4,260.6,284.4z M37.7,86c-10.1,0-18.7,8.5-18.7,18.7v147.7c0,10.1,8.5,18.7,18.7,18.7h222.8 c10.1,0,18.7-8.5,18.7-18.7V104.7c0-10.1-8.5-18.7-18.7-18.7h-34.7c-2.7,0-5.3-1.6-6.4-4.3l-6.9-17.6C209.9,57.3,203,53,195.5,53 h-93.3c-7.5,0-13.9,4.3-17.1,11.2l-6.4,17.6c-1.1,2.7-3.2,4.3-6.4,4.3H37.7z"/></g></g></g></svg></div><div class="wishlist__item__info"><span class="wishlist__item__name"></span><div class="wishlist__item__controls__wrapper"><span class="wishlist__item__unavailable"></span><div class="wishlist__item__controls"><button type="button" class="wishlist__item__controls__button" data-action="sub"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4 12H20" stroke="#001A72" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg></button><input type="number" min="1" value="1" class="wishlist__item__controls__input"/><button type="button" class="wishlist__item__controls__button" data-action="add"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4 12H20M12 4V20" stroke="#001A72" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg></button></div><div class="wishlist__item__price"><span></span><span></span></div></div></div><div class="wishlist__item__buttons"><button type="button" class="wishlist__item__remove"><svg version="1.1" id="Layer_2_1_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><g><path d="M53.1,8.4h-10c-0.6-4.7-4.4-8.3-9.4-8.3h-3.1c-5,0-8.9,3.6-9.4,8.3H10.9C8.7,8.4,7,10.1,7,12.3l2.5,41.7 c0.3,5.6,5,10,10.6,10h23.6c5.6,0,10.3-4.2,10.8-10L57,12.3C57,10.1,55.3,8.4,53.1,8.4z M30.6,5.6h3.1c1.7,0,3.1,1.1,3.6,2.8H26.7 C27.3,6.7,28.7,5.6,30.6,5.6z M48.9,53.7c-0.3,2.8-2.5,4.7-5.3,4.7H20.1c-2.8,0-5-1.9-5-4.7l-2.2-39.7h38.6L48.9,53.7z"></path><path d="M37.6,27.8v13.9c0,1.7,1.1,2.8,2.8,2.8s2.8-1.1,2.8-2.8V27.8c0-1.7-1.1-2.8-2.8-2.8S37.6,26.2,37.6,27.8z"></path><path d="M23.7,25.1c-1.7,0-2.8,1.1-2.8,2.8v13.9c0,1.7,1.1,2.8,2.8,2.8c1.7,0,2.8-1.1,2.8-2.8V27.8C26.4,26.2,25.3,25.1,23.7,25.1z"></path><path d="M32,22.3c-1.7,0-2.8,1.1-2.8,2.8v19.4c0,1.7,1.1,2.8,2.8,2.8s2.8-1.1,2.8-2.8V25.1C34.8,23.4,33.7,22.3,32,22.3z"></path></g></svg></button></div>`;

      const footerText = document.createElement('p');
      footerText.className = 'sidebar-wishlist__text';
      footerText.innerText = APP._t('Sidebar Wishlist Text');

      _elements.emailInput.className = 'sidebar-wishlist__input--email';
      _elements.emailInput.setAttribute('type', 'text');
      _elements.emailInput.setAttribute('placeholder', APP._t('Sidebar Wishlist Email Placeholder'));

      _elements.submitBtn.className = 'sidebar-wishlist__btn--submit';
      _elements.submitBtn.setAttribute('type', 'button');

      _elements.scrolledElement.className = 'sidebar-wishlist__scrolled';
      _elements.productsList.className = 'sidebar-wishlist__list';
      _elements.productTemplate.className = 'sidebar-wishlist__list__item';
      _elements.footer.className = 'sidebar-wishlist__footer';

      _elements.emptyNotification.className = 'sidebar-wishlist__empty';
      _elements.emptyNotification.innerText = APP._t('Sidebar Wishlist Empty');
      _elements.emptyNotification.setAttribute('hidden', true);
      
      _elements.status.className = 'sidebar-wishlist__status';

      _elements.scrolledElement.appendChild(_elements.emptyNotification);
      _elements.scrolledElement.appendChild(_elements.productsList);
      _elements.footer.appendChild(footerText);
      _elements.footer.appendChild(_elements.emailInput);
      _elements.footer.appendChild(_elements.status);
      _elements.footer.appendChild(_elements.submitBtn);

      sidebar.querySelector('.sidebar__wrapper').appendChild(_elements.scrolledElement);
      sidebar.querySelector('.sidebar__wrapper').appendChild(_elements.footer);

      _elements.sidebar = sidebar;
    }

    const rerenderWishlist = (forceRerender = false) => {
      if (!forceRerender && (!_elements.sidebar.classList || !_elements.sidebar.classList.contains('__active'))) {
        return;
      }

      if (_products.length <= 0) {
        _elements.emptyNotification.removeAttribute('hidden');
      } else {
        _elements.emptyNotification.setAttribute('hidden', true);
      }

      _elements.productsList.innerHTML = '';

      _products.forEach(product => {
        renderProduct(product);
      });

    }

    const restoreProductsFromLocalStorage = () => {
      if (!HELPER.isLocalStorageAvailable()) {
        console.log('Local storage is not available');
        return;
      }

      const localStorageProducts = getProductsFromLocalStorage();

      if (!localStorageProducts) return;

      const productsIndex = localStorageProducts.findIndex(item => item.bookId == _bookId);

      if (productsIndex == -1) return;

      const prepearedProducts = [];

      localStorageProducts[productsIndex].products.forEach(item => {
        const product = getProductFromInteractivities(item.id);
        
        if (product) {
          item.isAvailable = true;
          item.page = product.page;
          item.model.name = product.data.name;
          item.model.description = product.data.description;
          item.model.price = product.data.price;
          item.model.discount_price = product.data.discount_price;
          item.model.unavailable_product = product.data.unavailable_product;
          item.model.show_discount_price = product.data.show_discount_price;
          item.model.show_price = product.data.show_price;
          item.model.show_website = product.data.show_website;
          item.model.currency = product.data.currency;
          item.model.photos = product.data.photos;
          item.model.photos_thumbs = product.data.photos_thumbs;
        } else {
          item.isAvailable = false;
        }

        prepearedProducts.push(item);
      })

      _products = prepearedProducts;

      rerenderWishlist(true);
      updateIconByQuantity();
    }

    const getProductsFromLocalStorage = () => {
      if (!HELPER.isLocalStorageAvailable()) {
        console.log('Local storage is not available');
        return;
      }

      const allIssuesProducts = localStorage.getItem('_products') || false;
      
      if (!allIssuesProducts) {
        return false;
      }

      return JSON.parse(allIssuesProducts);
    }

    const saveProductsToLocalStorage = () => {
      if (!HELPER.isLocalStorageAvailable()) {
        console.log('Local storage is not available');
        return;
      }

      // const bookId = APP.Book.getModel().bookId;
      const localStorageProducts = getProductsFromLocalStorage();

      if (!localStorageProducts) {
        localStorage.setItem('_products', JSON.stringify([{
          bookId: _bookId,
          products: _products
        }]));

        return;
      }

      const productsIndex = localStorageProducts.findIndex(item => item.bookId == _bookId);

      if (productsIndex == -1) {
        localStorageProducts.push({
          bookId: _bookId,
          products: _products
        });

        localStorage.setItem('_products', JSON.stringify(localStorageProducts));
        return;
      }

      localStorageProducts[productsIndex].products = _products;
      localStorage.setItem('_products', JSON.stringify(localStorageProducts));
      return;
    }

    const updateIconByQuantity = () => {
      const productsQuantity = _products.length;
      // const productsQuantity = _products.reduce((acc = 0, item) => acc + item.quantity, 0);
      const wishlistButton = document.querySelector('.Book__wishlist');

      if (productsQuantity == 0) {
        wishlistButton.classList.add('empty-wishlist');
      } else {
        if (wishlistButton) {
          wishlistButton.classList.remove('empty-wishlist');
  
          wishlistButton.dataset.count = productsQuantity > 99 ? '+99' : productsQuantity;
        }
      }
    }

    const setScrolledListHeight = () => {
      if (!_elements.sidebar || !_elements.sidebar.classList || !_elements.sidebar.classList.contains('__active')) {
        return;
      }

      let childrensHeight = 0;
      const maxScrolledElementHeight = _elements.sidebar.querySelector('.sidebar__wrapper').getBoundingClientRect().height - _elements.footer.getBoundingClientRect().height - 90;

      Array.from(_elements.productsList.childNodes).forEach(item => childrensHeight += item.getBoundingClientRect().height);
      
      _elements.productsList.style.height = `${childrensHeight >= maxScrolledElementHeight ? maxScrolledElementHeight : childrensHeight}px`;

      if (_elements.sidebar.querySelector('.sidebar__scrollbar')) {
        if (childrensHeight < maxScrolledElementHeight) {
          _elements.sidebar.querySelector('.sidebar__scrollbar').setAttribute('hidden', true);
        } else {
          _elements.sidebar.querySelector('.sidebar__scrollbar').removeAttribute('hidden');
        }
      }
    }

    const removeFromWishlist = (productId) => {
      const _newProducts = _products.filter(product => product.id != productId);

      _products = _newProducts;

      if (_products.length <= 0) {
        _elements.emptyNotification.removeAttribute('hidden');
      } else {
        _elements.emptyNotification.setAttribute('hidden', true);
      }

      _elements.productsList.querySelector(`.sidebar-wishlist__list__item[data-product-id="${productId}"]`).remove();
      changeSubmitButtonState();
      saveProductsToLocalStorage();
      updateIconByQuantity();

      if (!is_mobile()) {
        HELPER.renderCustomProductScroll(_elements.sidebar, _elements.scrolledElement);
      }
    }

    const changeProductQuantity = (event) => {
      event.preventDefault();

      const action = event.target.dataset.action;
      const productId = event.target.parentNode.dataset.productId;
      const quantityInput = event.target.parentNode.querySelector('.wishlist__item__controls__input');
      const wishlistProduct = getProductById(productId);

      switch (action) {
        case 'sub':
          if (_products[wishlistProduct.index].quantity <= 1) return;

          _products[wishlistProduct.index].quantity -= 1;
          break;

        case 'add':
          _products[wishlistProduct.index].quantity += 1;
          break;
      
        default:
          break;
      }

      quantityInput.value = _products[wishlistProduct.index].quantity;
      updateProductPriceByQuantity(wishlistProduct.product, event.target.parentNode.nextSibling);
    }

    const getWishlistProductModel = (product) => {
      return {
        id: product.data.uid,
        quantity: 1,
        model: product.data,
        page: product.page,
        isAvailable: true
      }
    }

    const isProductAlreadyInWishlist = (productId) => _products.some(item => item.id == productId); 

    const renderProduct = (product) => {
      const productItem = _elements.productTemplate.cloneNode(true);

      productItem.dataset.productId = product.id;
      productItem.querySelector('.wishlist__item__name').innerText = product.model.name;
      productItem.querySelector('.wishlist__item__remove').dataset.productId = product.id;
      productItem.querySelector('.wishlist__item__image').setAttribute('alt', product.model.name);
      productItem.querySelector('.wishlist__item__controls').dataset.productId = product.id;
      productItem.querySelector('.wishlist__item__controls__input').value = product.quantity;

      if (product.model.unavailable_product) {
        productItem.querySelector('.wishlist__item__controls').setAttribute('hidden', true);
        productItem.querySelector('.wishlist__item__price').setAttribute('hidden', true);

        productItem.querySelector('.wishlist__item__unavailable').innerText = APP._t('Product Form Product Unavailable');
        productItem.querySelector('.wishlist__item__unavailable').removeAttribute('hidden');
      } else {
        productItem.querySelector('.wishlist__item__controls').removeAttribute('hidden');
        productItem.querySelector('.wishlist__item__price').removeAttribute('hidden');

        productItem.querySelector('.wishlist__item__unavailable').setAttribute('hidden', true);

        if (product.model.show_price && product.model.price && product.model.price.length > 0) {
          updateProductPriceByQuantity(product, productItem.querySelector('.wishlist__item__price'));
  
          productItem.querySelector('.wishlist__item__price').removeAttribute('hidden');
        } else {
          productItem.querySelector('.wishlist__item__price').setAttribute('hidden', true);
        }
      }

      if (product.isAvailable) {
        if (Array.isArray(product.model.photos) && product.model.photos.filter(item => !!item).length > 0) {
          productItem.querySelector('.wishlist__item__image').setAttribute('src', product.model.photos[0]);
          productItem.querySelector('.wishlist__item__image__wrapper svg').setAttribute('hidden', true);
        } else {
          productItem.querySelector('.wishlist__item__image').setAttribute('hidden', true);
          productItem.querySelector('.wishlist__item__image__wrapper svg').removeAttribute('hidden');
        }
      } else {
        productItem.classList.add('unavailable');
        productItem.querySelector('.wishlist__item__image').setAttribute('src', `${APP.PATH_CF_FLIP}assets/images/icon-not-available.svg`);
        productItem.querySelector('.wishlist__item__image__wrapper svg').setAttribute('hidden', true);

        productItem.querySelector('.wishlist__item__controls').setAttribute('hidden', true);
        productItem.querySelector('.wishlist__item__price').setAttribute('hidden', true);

        productItem.querySelector('.wishlist__item__unavailable').innerText = APP._t('Product Form Product Unavailable');
        productItem.querySelector('.wishlist__item__unavailable').removeAttribute('hidden');
      }

      _elements.productsList.appendChild(productItem);

      bindProductEvents(productItem);
    }

    const getProductById = (productId) => {
      const productIndex = _products.findIndex(product => product.id == productId);

      if (productIndex === -1) return false;

      return {
        index: productIndex,
        product: _products[productIndex]
      }
    }

    const initializeSocials = () => {
      const socialsLinks = _elements.popup.querySelectorAll('.product-modal__social__link');

      if (!socialsLinks.length) {
        return;
      }

      Array.from(socialsLinks).forEach(link => {
        if (!link.dataset || !link.dataset.type) {
          return;
        }

        link.classList.add(`product-modal__social__link--${link.dataset.type}`);
        link.removeAttribute('data-type');
      });

      _socialsInitialized = true;
    };

    const setShareLinks = (product) => {
      const sharedPageIndex =  APP.Book.getCurrentPage();
      
      let shareLink = sharedPageIndex
        ? window.location.href.split('/page/')[0] + `/page/${sharedPageIndex}`
        : window.location.href;

      shareLink += '/product/' + product.uid;

      let fbShareLink = 'https://www.facebook.com/sharer.php?u={share_url}&x=' + Date.now();
      let linkedinShareLink = 'http://www.linkedin.com/shareArticle?mini=true&url={share_url}';
      let twitterShareLink = 'http://twitter.com/share?text=' + product.name + '&url={share_url}';
      let emailShareLink = 'mailto:?subject=Check this product&body=Click this link to open the product page: {share_url}';

      if (!_socialsInitialized) {
        initializeSocials();
      }

      _elements.popup.querySelector('.product-modal__social__link--facebook').href = fbShareLink.replace('{share_url}', shareLink);
      _elements.popup.querySelector('.product-modal__social__link--twitter').href = twitterShareLink.replace('{share_url}', shareLink);
      _elements.popup.querySelector('.product-modal__social__link--linkedin').href = linkedinShareLink.replace('{share_url}', shareLink);
      _elements.popup.querySelector('.product-modal__social__link--email').href = emailShareLink.replace('{share_url}', shareLink);
    }

    const changeWishlistButtonClass = (isOpened) => {
      if (isOpened) {
        document.querySelector('.Book__wishlist').classList.add('sidebar-opened');
      } else {
        document.querySelector('.Book__wishlist').classList.remove('sidebar-opened');
      }
    }

    const clearProducts = () => {
      _products = [];
      _elements.productsList.innerHTML = '';
      saveProductsToLocalStorage();
      updateIconByQuantity();

      _elements.emptyNotification.removeAttribute('hidden');
      if (!is_mobile()) {
        HELPER.renderCustomProductScroll(_elements.sidebar, _elements.scrolledElement);
      }
    }

    const showResponseNotificationStatus = (isSuccess) => {
      let text = APP._t('Sidebar Wishlist Mail Status Success');
      let statusClassName = 'status--success';

      if (!isSuccess) {
        text = APP._t('Sidebar Wishlist Mail Status Bad');
        statusClassName = 'status--bad';
      }

      _elements.status.innerText = text;
      _elements.status.classList.add('active');
      _elements.status.classList.add(statusClassName);

      setTimeout(() => {
        _elements.status.innerText = '';
        _elements.status.classList.remove('active');
        _elements.status.classList.remove(statusClassName);
      }, 2000);
    }

    const sendEmail = async () => {
      const clientEmail = _elements.emailInput.value;
      const data = {
        client_email: clientEmail,
        products: _products
      };

      const response = await fetch(`${APP.API_PUBLUU}/publishers/${_publisherId}/wishlist/${_bookId}`, {
        method: "POST",
        crossorigin: true, 
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(data),
      });

      if (response.status == 200) {
        const result = await response.json();

        if (result.success) {
          _elements.emailInput.value = '';
          _elements.submitBtn.setAttribute('disabled', true);
          // clearProducts();
        } else {
          console.log(result);
        }

        showResponseNotificationStatus(result.success);
      } else {
        console.log(response);
      }
    }

    const updateProductPriceByQuantity = (product, priceElement) => {
      const productPrice = 
        product.model.show_discount_price && product.model.discount_price && product.model.discount_price.length > 0 
          ? product.model.discount_price 
          : (product.model.price && product.model.price.length > 0) 
          ? product.model.price
          : false;

      if (product.model.show_price && productPrice) {
        const newPrice = product.quantity * parseFloat(productPrice);
        const currencySymbol = product.model.currency.symbol;
        
        if (product.model.currency.symbol_pos === 1) {
          priceElement.querySelector('span:first-of-type').innerText = currencySymbol;
          priceElement.querySelector('span:last-of-type').innerText = newPrice;
        } else {
          priceElement.querySelector('span:first-of-type').innerText = newPrice;
          priceElement.querySelector('span:last-of-type').innerText = currencySymbol;
        }

        // priceElement.innerText = isBeginningSymbol(product) ? `${currencySymbol}${newPrice}` : `${newPrice}${currencySymbol}`;

        saveProductsToLocalStorage();
        updateIconByQuantity();
      }
    }
    
    const onPlayerPlayingCallback = () => {
      // Array.from(_elements.popup.querySelectorAll('.product-gallery__arrow')).forEach(item => item.setAttribute('hidden', true));
    }
    
    const onPlayerPausedCallback = () => {
      // Array.from(_elements.popup.querySelectorAll('.product-gallery__arrow')).forEach(item => item.removeAttribute('hidden'));
    }

    const onPlayerReadyCallback = (playButton) => {
      playButton.setAttribute('hidden', '');
    };

    const createVideoPlayer = (playButton, url, iframe, uid) => {
      const currentPage = APP.Book.getCurrentPage();

      APP.EMBED.pauseAllPlayersOnPage(currentPage);

      if (APP.Book.isDoublePage()) {
        APP.EMBED.pauseAllPlayersOnPage(currentPage + 1);
      }

      if (url.includes('youtube.com/') || url.includes('youtu.be/')) {
        const videoId = HELPER.getVideoIdFromUrl(url, 'youtube');
        iframe.id = `player_yt_${Date.now()}`;
        APP.EMBED.inializeYoutubePlayer(iframe, {
          videoId: videoId,
        }, {
          start: 0,
          volume: 100,
          controls: 1
        }, currentPage, uid, {
          'READY': () => onPlayerReadyCallback(playButton),
          'PLAYING': onPlayerPlayingCallback,
          'PAUSED': onPlayerPausedCallback
        })
      }

      if (url.includes('vimeo.com') || url.includes('player.vimeo.com/video')) {
        const videoId = HELPER.getVideoIdFromUrl(url, 'vimeo');
        iframe.id = `player_vm_${Date.now()}`;

        APP.EMBED.inializeVimeoPlayer(iframe, {
          id: videoId,
          controls: 1,
        }, {
          volume: 0,
          start: 0,
        }, currentPage, uid, {
          'READY': () => onPlayerReadyCallback(playButton),
          'PLAYING': onPlayerPlayingCallback,
          'PAUSED': onPlayerPausedCallback
        });      
      }
    }

    const pauseVideoPlayer = (iframe) => {
      if (!iframe) return;

      const player = APP.EMBED.getPlayerById(iframe.id);

      if (!player) return;

      switch (player.type) {
        case 'y':
          APP.EMBED.pauseYoutubeVideo(player);
          break;
        
        case 'v':
          APP.EMBED.pauseVimeoVideo(player);
          break;
        
        case 'p':
          APP.EMBED.pauseUploadedVideo(player);
          break;
      
        default:
          break;
      }
    }

    const prepareHotspotData = (hotspot) => {
      const hotspotData = [];
  
      hotspot.photos.forEach((item, index) => {
        if (item && item.length > 0) {
          hotspotData.push({
            src: item,
            thumb: hotspot.photos_thumbs && hotspot.photos_thumbs.length > index ? hotspot.photos_thumbs[index] : null,
            type: 'IMAGE',
            sizes: null
          });
        }
      });
  
      if (hotspot.video && hotspot.video.value && hotspot.video.value.length > 0) {
        hotspotData.push({
          src: hotspot.video.value,
          thumb: hotspot.video.thumbnail,
          type: 'VIDEO'
        });
      }

      return hotspotData;
    }

    const renderGallerySlider = async (hotspot) => {
      const galleryData = prepareHotspotData(hotspot);

      if (!galleryData.length) {
        _elements.popupContainer.classList.add('product--simple');
        return;
      }

      await HELPER.loadScript(`${APP.ROOT_PATH}assets/scripts/hotspots/Gallery.js?v=${window._config.VERSION}`, {
        id: 'Gallery',
        type: "text/javascript",
        crossorigin: "anonymous",
      });

      _elements.popupContainer.classList.remove('product--simple');

      const galleryElements = {
        mainSliderWrapper: _elements.popup.querySelector('.product-modal__image__wrapper--main'),
        thumbsSliderWrapper: _elements.popup.querySelector('.product-modal__images'),
        controls: null,
      };

      const gallery = new APP.Gallery(galleryElements, galleryData, {
        effect: 'slide',
        loop: false,
        allowTouchMove: true,
        navigation: {
          enabled: false
        },
        pagination: {
          enabled: true
        },
        custom: {
          thumbs: {
            breakpointsResponsive: false,
            THUMB_MAX_WIDTH: 60,
            spaceBetween: 10
          },
          prefix: 'product'
        }
      });

      _elements.popup.handleClose = () => {
        gallery.destroy();

        if (APP.EMBED && APP.EMBED.destroyPlayerByHotspotUId) {
          APP.EMBED.destroyPlayerByHotspotUId(hotspot.uid);
        }
      }
    };

    const bindProductEvents = (productNode) => {
      productNode.querySelector('.wishlist__item__remove').addEventListener('click', (event) => removeFromWishlist(event.target.dataset.productId));

      Array.from(productNode.querySelectorAll('.wishlist__item__controls__button')).forEach(item => item.addEventListener('click', changeProductQuantity));

      productNode.querySelector('.wishlist__item__controls__input').addEventListener('change', (event) => {
        let newQuantity = event.target.value;
        const productId = event.target.parentNode.dataset.productId;
        const wishlistProduct = getProductById(productId);

        if (newQuantity <= 1) newQuantity = 1;

        _products[wishlistProduct.index].quantity = parseInt(newQuantity);
        event.target.value = newQuantity;

        updateProductPriceByQuantity(wishlistProduct.product, event.target.parentNode.nextSibling);
      });

      productNode.querySelector('.wishlist__item__image__wrapper').addEventListener('click' , (event) => {
        const productId = event.target.parentNode && event.target.parentNode.dataset && event.target.parentNode.dataset.productId;

        if (!productId) return;

        _self.openProductByUid(productId);
      });
    }

    const handleGalleryEvents = function (event) {
      const eventData = event.detail;
      const hotspotUid = _elements.popup.dataset.hotspotUid;
      const actualMediaFrame = this.querySelector('iframe.product-gallery__slide__iframe');

      if (eventData.mediaDataObject.type === 'VIDEO' && !actualMediaFrame) {
        const mediaFrame = this.querySelector('.product-gallery__slide__iframe');
        const videoBtn = this.querySelector('.product-gallery__slide__button--play');

        createVideoPlayer(videoBtn, eventData.mediaDataObject.src, mediaFrame, hotspotUid);
      } else {
        if (actualMediaFrame) {
          pauseVideoPlayer(actualMediaFrame);
        }
      }
    };

    const bindEvents = () => {
      _elements.emailInput.addEventListener('input', changeSubmitButtonState);
      _elements.submitBtn.addEventListener('click', sendEmail);

      _elements.popup.querySelector('.product-modal__close').addEventListener('click', closeProductPopup);

      _elements.popup.querySelector('.product-modal__btn--wishlist').addEventListener('click', (event) => addToWishlist(event.target));

      _elements.popup.addEventListener('click', (e) => {
        e.stopPropagation();

        const path = e.path || e.composedPath();
        const isModalBody = path.some(item => item.classList && item.classList.contains('modal__container'))

        if (!isModalBody) {
          closeProductPopup();
        }
      });

      _elements.popup.querySelector('.product-modal__image__wrapper--main').addEventListener('product.gallery.slide.change', handleGalleryEvents);
      _elements.popup.querySelector('.product-modal__image__wrapper--main').addEventListener('product.gallery.video.play', handleGalleryEvents);

      window.addEventListener('beforeunload', () => {
        _elements.popup.querySelector('.product-modal__image__wrapper--main').removeEventListener('product.gallery.slide.change', handleGalleryEvents);
        _elements.popup.querySelector('.product-modal__image__wrapper--main').removeEventListener('product.gallery.video.play', handleGalleryEvents);
      });
    }
  });
});
