APPonReady.add(function () {
  APP.Note = new (function () {
    const self = this;
    let _bookId = null;
    let _notesArray = [];
    let _lastAddedNote = null;
    let _state = 'waiting';
    let _stfBlock = document.querySelector('.stf__block');
    let _bookSizeOriginal = null;
    let _lastSelectedColor = {
      name: 'red',
      value: '#d80c7f'
    };
    let _windowOptions = {
      isMobile: false,
      isEmbed: false,
      width: 0,
      height: 0
    }

    const _colors = [
      {
        name: 'red',
        value: '#d80c7f',
      },
      {
        name: 'orange',
        value: '#f0892d',
      },
      {
        name: 'yellow',
        value: '#dec600',
      },
      {
        name: 'green',
        value: '#4abd2c',
      },
      {
        name: 'blue',
        value: '#37befe',
      },
      {
        name: 'purple',
        value: '#8758fe',
      },
    ];

    const _model = {
      id: null,
      page: null,
      coordinates: {
        x: 50,
        y: 100,
      },
      size: {
        width: 26,
        height: 24,
      },
      fullSize: {
        width: 230,
        height: 155,
      },
      color: null,
      placeholder: APP._t('Note Placeholder'),
      value: '',
      time: () => {
        const today = new Date();
        return `${today.getHours()} : ${today.getMinutes()}`;
      },
      isExpanded: true,
    };

    this.init = function (bookId) {
      _bookId = bookId;
      _notesArray = this.getLocalStorageNotes();
      _windowOptions = {
        isMobile: is_mobile(),
        isEmbed: is_small_embed_not_mobile(),
        width: window.innerWidth,
        height: window.innerHeight
      }

      document.querySelector('body').addEventListener('click', e => {
        const path = e.path || e.composedPath();
        const isNote = path.some(item => item.classList && item.classList.contains('Note__wrapper'))

        if (!isNote && self.isThereExpandedNoteInArray()) {
          this.collapseAllNotes(_lastAddedNote == null ? null : _lastAddedNote);
          if (_lastAddedNote != null) _lastAddedNote = null;
        }
      })
    };

    this.setNoteSizeOnResize = function (w, h) {
      if (!_notesArray || !_notesArray.length) {
        return;
      }
      
      let bookSize = {
        width: w,
        height: h
      }

      if (!w || !h) {
        bookSize = {
          width: APP.Book.getBookSize().bookWidth,
          height: APP.Book.getBookSize().bookHeight
        };
      }

      if (!_bookSizeOriginal) {
        _bookSizeOriginal = {
          width: bookSize.width,
          height: bookSize.height
        }
      }

      let ratio = bookSize.width / ((_bookSizeOriginal && _bookSizeOriginal.width) || bookSize.width);
      const notes = document.querySelectorAll('.Note__wrapper');

      notes.forEach(note => {
        if (ratio > 1) ratio = 1;
        note.style.transform = `scale(${ratio})`;
      });

      if (_notesArray.length) {
        _notesArray.forEach((item) => {
          const note = document.querySelector(`.Note__wrapper-${item.id}`);
          if (note) {
            const marker = note.querySelector('.Note__marker');
            const markerSizes = {
              width: self.convertPxToPercent(parseFloat(marker.style.width), 'width'),
              height: self.convertPxToPercent(parseFloat(marker.style.height), 'height')
            }
            const notePos = {
              x: parseFloat(note.style.left),
              y: parseFloat(note.style.top)
            }

            if (notePos.x + markerSizes.width >= 99) {
              note.style.left = `${99 - markerSizes.width}%`;
            }

            if (notePos.y + markerSizes.height >= 99) {
              note.style.top = `${99 - markerSizes.height}%`;
            }
          }
        })
      }
    };

    this.createNote = function (ctxCoordinates = null, model = this.getModel(), ctxPage = null) {
      model.id = model.id ? model.id : this.getNextModelIndex();
      model.page = ctxPage ? ctxPage : model.page ? model.page : APP.Book.getCurrentPage();
      model.coordinates = ctxCoordinates ? ctxCoordinates : this.getNextCoordinates(model);
      model.color = model.color ? model.color : self.getLastSelectedColor();
      model.placeholder = APP._t('Note Placeholder');

      const currentPage = document.querySelector(`._page_${model.page}`);
      let currentPageHotspotWrapper = currentPage.querySelector('.hotspots-container');
      const noteMarker = document.createElement('div');
      const note = document.createElement('div');

      noteMarker.className = `Note__marker Note--${model.color.name}`;
      noteMarker.innerHTML = `<svg version="1.1" fill="${model.color.value}" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="332.5 218.2 176.7 158.8" enable-background="new 332.5 218.2 176.7 158.8" xml:space="preserve"><path d="M503.2,218.2H338.6c-3.3,0-6.1,2.7-6.1,6.1v114c0,3.3,2.7,6.1,6.1,6.1h117.8l43.2,31.6c1.1,0.8,2.4,1.1,3.6,1.1
     c0.9,0,1.8-0.2,2.7-0.6c2-1,3.3-3.1,3.3-5.3V224.3C509.3,221,506.5,218.3,503.2,218.2z"/><path fill="#FFFFFF" d="M467.8,260.8H374c-4.2,0-7.6-2.7-7.6-6.1c0-3.3,3.4-6.1,7.6-6.1h93.7c4.2,0,7.6,2.7,7.6,6.1S471.9,260.8,467.8,260.8z"/><path fill="#FFFFFF" d="M374,275h93.7c4.2,0,7.6,2.7,7.6,6.1s-3.4,6.1-7.6,6.1H374c-4.2,0-7.6-2.7-7.6-6.1S369.9,275,374,275z"/><path fill="#FFFFFF" d="M374,301.8h93.7c4.2,0,7.6,2.7,7.6,6.1s-3.4,6.1-7.6,6.1H374c-4.2,0-7.6-2.7-7.6-6.1S369.9,301.8,374,301.8z"/></svg>`;

      note.className = `Note__wrapper Note__wrapper-${model.id} Note__show`;

      note.dataset.id = model.id;

      note.style = `top: ${model.coordinates.y}%; left: ${model.coordinates.x}%;`;
      noteMarker.style = `width: ${model.size.width}px; height: ${model.size.height}px;`;

      note.appendChild(noteMarker);
      note.appendChild(self.getBody(model));

      if (!currentPageHotspotWrapper) {
        currentPageHotspotWrapper = document.createElement('div');
        currentPageHotspotWrapper.className = 'hotspots-container';
        
        currentPageHotspotWrapper.appendChild(note);
        currentPage.append(currentPageHotspotWrapper);
      } else {
        currentPageHotspotWrapper.appendChild(note);
      }

      currentPageHotspotWrapper.style.opacity = '1';
      currentPageHotspotWrapper.style.visibility = 'visible';

      this.setHandlers(note, noteMarker);
      if (_notesArray.includes(model)) {
        _notesArray.forEach((item, index) => {
          if (item.id == model.id) {
            const { id: modelId, ...modelAttr } = model;
            _notesArray[index] = {
              id: item.id,
              ...modelAttr,
            };
          }
        });
      } else {
        _notesArray.push(model);
      }
      _lastAddedNote = note.dataset.id;
      this.collapseAllNotes();
      this.saveToLocalStorage();
      self.toggleNote(note);
    };

    this.createNoteByCoordinates = function (eventPath, noteX, noteY) {
      const currentPage = eventPath.find((item) => item.classList && item.classList.contains('Page'));

      const coordinates = self.convertPositionPxToPercent(
        noteX - _model.size.width / 2,
        noteY - _model.size.height / 2,
      );

      this.createNote(coordinates, self.getModel(), currentPage.page);
    };

    this.getBody = function (model) {
      const noteBody = document.createElement('div');
      const noteFooter = document.createElement('div');
      const noteTextarea = document.createElement('textarea');

      noteBody.className = 'Note__body';
      noteFooter.className = 'Note__footer';
      noteTextarea.className = 'Note__textarea';
      noteTextarea.placeholder = model.placeholder;
      noteTextarea.value = model.value;

      noteTextarea.addEventListener('input', (e) => this.setTextareaValue(e, model.id));
      noteBody.appendChild(noteTextarea);
      noteBody.appendChild(this.getFooter(model));

      return noteBody;
    };

    this.getFooter = ({ id, color }) => {
      const _noteFooter = document.createElement('div');
      const _noteFooterList = document.createElement('ul');
      const _noteFooterRemove = document.createElement('button');
      const _noteFooterDone = document.createElement('button');

      _noteFooter.className = 'Note__footer';
      _noteFooterList.className = 'Note__colors';
      _noteFooterRemove.className = 'Note__remove';
      _noteFooterDone.className = 'Note__done';

      if (_colors && _colors.length) {
        _colors.forEach((color) => {
          let _noteColorItemWrapper = document.createElement('li');
          let _noteColorItem = document.createElement('div');
          _noteColorItemWrapper.className = `Note__color-toggle Note__color-${color.name}`;
          _noteColorItem.style = `background-color: ${color.value};`;
  
          _noteColorItemWrapper.addEventListener('click', () => this.setColor(id, color));
          _noteColorItemWrapper.appendChild(_noteColorItem);
          _noteFooterList.appendChild(_noteColorItemWrapper);
        });
      }

      _noteFooterList.querySelector(`.Note__color-${color.name}`).classList.add('selected');

      _noteFooterDone.innerHTML = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" fill="#666" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><g><path d="M32,0C14.4,0,0,14.4,0,32s14.4,32,32,32s32-14.4,32-32S49.6,0,32,0z M32,58.7c-14.7,0-26.7-12-26.7-26.7S17.3,5.3,32,5.3s26.7,12,26.7,26.7S46.7,58.7,32,58.7z"/><path d="M40.8,22.1l-12.3,12l-5.6-5.3c-1.1-1.1-2.7-1.1-3.7,0s-1.1,2.7,0,3.7l6.7,6.4c0.8,0.8,1.6,1.1,2.4,1.1c0.8,0,1.9-0.3,2.4-1.1l13.6-13.1c1.1-1.1,1.1-2.7,0-3.7C43.5,21.1,41.9,21.1,40.8,22.1z"/></g></svg>`;

      // _noteFooterDone.innerHTML = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5 14L8.23309 16.4248C8.66178 16.7463 9.26772 16.6728 9.60705 16.2581L18 6" stroke="#00a703" stroke-width="3" stroke-linecap="round"/></svg>`;

      _noteFooterRemove.innerHTML =
        '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" fill="#666" xml:space="preserve"><g><path d="M53.1,8.4h-10c-0.6-4.7-4.4-8.3-9.4-8.3h-3.1c-5,0-8.9,3.6-9.4,8.3H10.9C8.7,8.4,7,10.1,7,12.3l2.5,41.7c0.3,5.6,5,10,10.6,10h23.6c5.6,0,10.3-4.2,10.8-10L57,12.3C57,10.1,55.3,8.4,53.1,8.4z M30.6,5.6h3.1c1.7,0,3.1,1.1,3.6,2.8H26.7C27.3,6.7,28.7,5.6,30.6,5.6z M48.9,53.7c-0.3,2.8-2.5,4.7-5.3,4.7H20.1c-2.8,0-5-1.9-5-4.7l-2.2-39.7h38.6L48.9,53.7z"/><path d="M37.6,27.8v13.9c0,1.7,1.1,2.8,2.8,2.8s2.8-1.1,2.8-2.8V27.8c0-1.7-1.1-2.8-2.8-2.8S37.6,26.2,37.6,27.8z"/><path d="M23.7,25.1c-1.7,0-2.8,1.1-2.8,2.8v13.9c0,1.7,1.1,2.8,2.8,2.8c1.7,0,2.8-1.1,2.8-2.8V27.8C26.4,26.2,25.3,25.1,23.7,25.1z"/><path d="M32,22.3c-1.7,0-2.8,1.1-2.8,2.8v19.4c0,1.7,1.1,2.8,2.8,2.8s2.8-1.1,2.8-2.8V25.1C34.8,23.4,33.7,22.3,32,22.3z"/></g></svg>';

      _noteFooterRemove.addEventListener('click', () => this.removeNote(id));
      _noteFooterDone.addEventListener('click', () => self.toggleNote(id))

      _noteFooter.appendChild(_noteFooterRemove);
      _noteFooter.appendChild(_noteFooterList);
      _noteFooter.appendChild(_noteFooterDone);

      return _noteFooter;
    };

    this.restoreNotesOnLoadedPage = function (pageIndex) {
      if(!window.HELPER || !HELPER.isLocalStorageAvailable || !HELPER.isLocalStorageAvailable()){
        console_log("LocalStorage is not available");
        return;
      }
      _notesArray = self.getLocalStorageNotes();

      if (_notesArray.length) {
        _notesArray.forEach((item) => {
          if (item.page == pageIndex) {
            self.createNote(item.coordinates, item);
          }
        });
      }
    };

    this.showNotesByDependsOnWidth = function (prevFullscreen = false) {
      let hideNote = false;

      if (!APP.Book.getModel().settings.show_note_button) {
        return;
      }
 
      if ((_windowOptions.isMobile || _windowOptions.isEmbed || _windowOptions.width <= 560 || transparent)) {
        const noteBtnMenu = document.querySelector('.Book__note');
        const noteBtnBottom = document.querySelector('.note__button');

        if (!noteBtnMenu || !noteBtnBottom) {
          return;
        }

        if (!APP.Book.getFullscreenState()) hideNote = true;
        else hideNote = false;

        if (hideNote) {
          noteBtnMenu.setAttribute('hidden', true);
          noteBtnBottom.setAttribute('hidden', true);
        } else {
          noteBtnMenu.removeAttribute('hidden');
          noteBtnBottom.removeAttribute('hidden');
        }
      }


      if (_notesArray && _notesArray.length) {
        _notesArray.forEach(item => {
          const note = document.querySelector(`.Note__wrapper-${item.id}`);
          if (note) {
            if (hideNote) note.setAttribute('hidden', true);
            else note.removeAttribute('hidden');
          }
        })
      }
    }

    this.convertPositionPxToPercent = function (x, y) {
      const pageSize = APP.Book.getBookSize();
      return {
        x: parseFloat(((x * 100) / pageSize.bookWidth).toFixed(5)),
        y: parseFloat(((y * 100) / pageSize.bookHeight).toFixed(5)),
      };
    };

    this.convertPositionPercentToPx = function (x, y) {
      const pageSize = APP.Book.getBookSize();
      return {
        x: parseFloat(((x * pageSize.bookWidth) / 100).toFixed(5)),
        y: parseFloat(((y * pageSize.bookHeight) / 100).toFixed(5)),
      };
    };

    this.convertPxToPercent = function (value, by) {
      const pageSize = APP.Book.getBookSize();
      return parseFloat(
        ((value * 100) / (by === 'width' ? pageSize.bookWidth : pageSize.bookHeight)).toFixed(5),
      );
    };

    this.convertPercentToPx = function (value, by) {
      const pageSize = APP.Book.getBookSize();
      return parseFloat(
        ((value * (by === 'width' ? pageSize.bookWidth : pageSize.bookHeight)) / 100).toFixed(5),
      );
    };

    this.getNextModelIndex = function () {
      if (_notesArray[_notesArray.length - 1] && _notesArray[_notesArray.length - 1].id) {
        return _notesArray[_notesArray.length - 1].id + 1
      } 

      return 1;
    };

    this.getModel = function () {
      return JSON.parse(JSON.stringify(_model));
    };

    this.getNote = function (noteId) {
      if (!_notesArray || !_notesArray.length) {
        return null;
      }

      return _notesArray.filter((item) => item.id === noteId);
    };

    this.setTextareaValue = function (e, noteId) {
      const note = _notesArray.filter((item) => item.id === noteId);
      note.value = e.target.value;

      this.updateNotePropertyInArray(noteId, 'value', e.target.value);
      this.saveToLocalStorage();
    };

    this.removeNote = function (noteId) {
      document.querySelector(`.Note__wrapper-${noteId}`).remove();
      _notesArray = _notesArray.filter((item) => item.id !== noteId);
      this.saveToLocalStorage();
    };

    this.setColor = function (noteId, color) {
      const note = document.querySelector(`.Note__wrapper-${noteId}`);
      note.querySelector('.Note__marker').className = `Note__marker Note--${color.name}`;
      this.setLastSelectedColor(color)

      note
        .querySelectorAll('.Note__color-toggle')
        .forEach((item) => item.classList.remove('selected'));
      note.querySelector(`.Note__color-${color.name}`).classList.add('selected');
      note.querySelector('.Note__marker svg').style = `fill: ${color.value};`;

      this.updateNotePropertyInArray(noteId, 'color', color);
    };

    this.toggleNote = (note) => {
      if (typeof(note) == 'number') {
        note = document.querySelector(`.Note__wrapper-${note}`);
      }

      if (!_notesArray || !_notesArray.length) {
        return;
      }

      const noteModel = _notesArray.filter((item) => item.id == note.dataset.id)[0];
      if (this.isThereExpandedNoteInArray()) {
        _notesArray.forEach((item) => {
          if (item.id != note.dataset.id) {
            const noteWrapper = document.querySelector(`.Note__wrapper-${item.id}`);
            if (
              noteWrapper && noteWrapper.classList.contains('Note__show')
            ) {
              noteWrapper && noteWrapper.classList.remove('Note__show');
              this.updateNotePropertyInArray(item.id, 'isExpanded', false);
            }
          }
        });
      }

      note.querySelector('.Note__body').style = `
        top: ${
          self.convertPercentToPx(noteModel.coordinates.y, 'height') + _model.fullSize.height <=
          _stfBlock.clientHeight
            ? 26
            : -135
        }px;
        left: ${
          self.convertPercentToPx(noteModel.coordinates.x, 'width') - _model.fullSize.width / 2 <=
          0
            ? -self.convertPercentToPx(noteModel.coordinates.x, 'width')
            : self.convertPercentToPx(noteModel.coordinates.x, 'width') +
                _model.fullSize.width / 2 >=
              _stfBlock.clientWidth
            ? -(
                _model.fullSize.width -
                (_stfBlock.clientWidth - self.convertPercentToPx(noteModel.coordinates.x, 'width'))
              )
            : self.convertPercentToPx(noteModel.coordinates.x, 'width') +
                _model.fullSize.width / 2 >=
              (self.getSettingSinglePageMode() ? _stfBlock.clientWidth : _stfBlock.clientWidth / 2)
            ? -(
                _model.fullSize.width -
                ((self.getSettingSinglePageMode()
                  ? _stfBlock.clientWidth
                  : _stfBlock.clientWidth / 2) -
                  self.convertPercentToPx(noteModel.coordinates.x, 'width'))
              )
            : -(_model.fullSize.width - _model.size.width) / 2
        }px;
      `;

      if (note.classList.contains('Note__show')) {
        this.updateNotePropertyInArray(note.dataset.id, 'isExpanded', false);
        note.classList.remove('Note__show');
        self.setState('waiting');
      } else {
        this.updateNotePropertyInArray(note.dataset.id, 'isExpanded', true);
        note.classList.add('Note__show');
        if (note.querySelector('textarea')) {
          note.querySelector('textarea').focus();
        }
        self.setState('writing');
      }
    };

    this.getStfBlock = function () {
      if (!_stfBlock) {
        _stfBlock = document.querySelector('.stf__block');
      }

      return _stfBlock;
    };

    this.saveToLocalStorage = function () {
      if( !HELPER.isLocalStorageAvailable() ){
        console_log("LocalStorage is not available");
        return;
      }
      const data = JSON.parse(localStorage.getItem('_notes'));
      const bookNotes = Object.values(data).find((item) => item.bookId == _bookId);

      if (!bookNotes) {
        data.push({
          bookId: _bookId,
          notes: _notesArray,
        });
      } else {
        Object.values(data).forEach((item) => {
          if (item.bookId == _bookId) {
            item.notes = _notesArray;
            return;
          }
        });
      }
      localStorage.setItem('_notes', JSON.stringify(data));
    };

    this.getLocalStorageNotes = function () {
      if(!window.HELPER || !HELPER.isLocalStorageAvailable || !HELPER.isLocalStorageAvailable()){
        console_log("LocalStorage is not available");
        return;
      }
      
      let data = JSON.parse(localStorage.getItem('_notes'));

      if (!data) {
        data = [];
        localStorage.setItem('_notes', JSON.stringify(data));
        return data;
      }

      const bookNotes = Object.values(data).find((item) => item.bookId == _bookId);

      if (bookNotes) {
        return bookNotes.notes;
      }

      return [];
    };

    this.getNotePropertyInArray = function (noteId, key) {
      const note = _notesArray.filter(item => item.id == noteId);
      if (note) {
        return note[0][key];
      }

      return null;
    }

    this.updateNotePropertyInArray = function (noteId, key, value) {
      if (_notesArray && _notesArray.length) {
        _notesArray.forEach((item) => {
          if (item.id == noteId) {
            item[key] = value;
          }
        });
      }
      this.saveToLocalStorage();
    };

    this.collapseAllNotes = function (noteId = null) {
      if (!_notesArray || !_notesArray.length) {
        return;
      }

      _notesArray.forEach((item) => {
        if (item.id == noteId) {
          return;
        }

        self.setState('waiting');
        item.isExpanded = false;
        const noteWrapper = document.querySelector(`.Note__wrapper-${item.id}`);
        if (noteWrapper && noteWrapper.classList) {
          noteWrapper.classList.remove('Note__show');
        }
      });
    };

    this.isThereExpandedNoteInArray = function () {
      const pages = APP.Book.getCurrentPageForLogs() || [Number(APP.Book.getCurrentPage()) + 1];
      let isExpanded = false;

      if (_notesArray && _notesArray.length) {
        _notesArray.forEach((item) => {
          if (isExpanded) return;
          if (!pages.includes(item.page - 1)) return;
  
          if (item.isExpanded) {
            isExpanded = true;
          }
        });
      }
      return isExpanded;
    };

    this.getNextCoordinates = function (model) {
      const { x: STEP_X, y: STEP_Y } = self.convertPositionPxToPercent(
        _model.size.width + 10,
        _model.size.height + 4,
      );
      const currentPage = document.querySelector(`._page_${APP.Book.getCurrentPage()}`);
      const allNotes = _notesArray.filter((item) => item.page === model.page);

      let coords = self.convertPositionPxToPercent(
        currentPage.clientWidth / 2,
        model.coordinates.y
      );
      const markerSizePercent = {
        x: self.convertPxToPercent(model.size.width, 'width'),
        y: self.convertPxToPercent(model.size.height, 'height'),
      };
      let newCoordinates = coords;

      allNotes.forEach((noteA) => {
        if (
          allNotes.every(
            (note) =>
              parseFloat(note.coordinates.x) <= parseFloat(coords.x - markerSizePercent.x) ||
              parseFloat(note.coordinates.x) >= parseFloat(coords.x + markerSizePercent.x) ||
              parseFloat(note.coordinates.y) <= coords.y - markerSizePercent.y ||
              parseFloat(note.coordinates.y) >= coords.y + markerSizePercent.y,
          )
        ) {
          newCoordinates = coords;
        } else {
          coords.y += STEP_Y;
        }

        if (parseFloat(noteA.coordinates.y) + self.convertPxToPercent(50, 'height') >= 80) {
          if (parseFloat(noteA.coordinates.y) + self.convertPxToPercent(50, 'height') <= (80 + markerSizePercent.y + 1)) {
            coords = {
              x: parseFloat(coords.x + STEP_X),
              y: parseFloat(80 / currentPage.clientHeight) + self.convertPxToPercent(model.coordinates.y, 'height'),
            };
          } 
        }
      });

      return newCoordinates;
    };

    this.setLastSelectedColor = (color) => {
      _lastSelectedColor = color;
    }

    this.getLastSelectedColor = () => {
      return _lastSelectedColor;
    }

    this.getSinglePageState = function () {
      const currentPageIndex = APP.Book.getCurrentPage();
      const pagesLength = APP.Book.getModel().pages;
      const isDoublePage = APP.Book.isDoublePage();
      const isSinglePageMode = APP.Book.getModel().settings.show_single_page_mode;

      if (isSinglePageMode) {
        return true;
      }

      if (isDoublePage) {
        if (
          currentPageIndex == 1 ||
          currentPageIndex == pagesLength - 1 ||
          currentPageIndex == pagesLength
        ) {
          return true;
        }
        return false;
      }
    };

    this.getLastPageState = function () {
      const currentPageIndex = APP.Book.getCurrentPage();
      const pagesLength = APP.Book.getModel().pages;

      return currentPageIndex == pagesLength || currentPageIndex + 1 == pagesLength;
    };

    this.getFirstPageState = function () {
      return APP.Book.getCurrentPage() == 1;
    };

    this.getSettingSinglePageMode = function () {
      return APP.Book.getModel().settings.show_single_page_mode;
    };

    this.isOnlyOnePageInBook = function () {
      return APP.Book.getModel().pages == 1;
    };

    const getBookPagesCount = function () {
      return APP.Book.getModel().pages;
    }
    
    this.getState = function () {
      return _state;
    }

    this.setState = function (state) {
      _state = state;
    }

    this.scaleNote = (ratio) => {
      if (_notesArray && _notesArray.length) {
        _notesArray.forEach(noteObj => {
          const note = document.querySelector(`.Note__wrapper-${noteObj.id}`);
          if (note) {
            note.style.transform = `scale(${parseFloat(1 / ratio)})`;
          } 
        })
      }
    }

    const getBookRatioScale = () => {
      const book = document.querySelector('.Book__inner');
      if (book && book.style.transform) {
        return parseFloat(book.style.transform.split(',')[1]);
      }
      
      return 1;
    }

    this.setHandlers = function (note, noteMarker) {
      let mouseUp = true;
      let isNoteWasExpandedBeforeMove = false;

      if (!_stfBlock) {
        self.getStfBlock();
      }

      noteMarker.addEventListener('click', (e) => this.toggleNote(note));
      noteMarker.addEventListener('mousedown', (e) => {
        e.preventDefault();
        isNoteWasExpandedBeforeMove = self.getNotePropertyInArray(note.dataset.id, 'isExpanded');
        function moveAt(pageX, pageY) {
          const ratio = getBookRatioScale();

          let markerSizeWithRatio = {
            width: (_model.size.width * ratio) / 2,
            height: (_model.size.height * ratio) / 2
          }

          let centerMarkerToMouse = {
            left:
              pageX -
              document.querySelector('.stf__block').getBoundingClientRect().left -
              markerSizeWithRatio.width,
            top:
              pageY -
              document.querySelector('.stf__block').getBoundingClientRect().top -
              markerSizeWithRatio.height,
          };
          let coordsInPercent = {
            left: self.convertPxToPercent(centerMarkerToMouse.left / ratio, 'width'),
            top: self.convertPxToPercent(centerMarkerToMouse.top / ratio, 'height'),
          };
          
          note.classList.remove('Note__show');
          self.updateNotePropertyInArray(note.dataset.id, 'isExpanded', false);

          note.style.top = `${coordsInPercent.top}%`;
          note.style.left = `${
            self.getSettingSinglePageMode() ? coordsInPercent.left : coordsInPercent.left / 2
          }%`;

          if (self.getSettingSinglePageMode()) {
            if (coordsInPercent.left <= 0) {
              note.style.left = `${0}%`;
            }
            if (
              coordsInPercent.left + self.convertPxToPercent(markerSizeWithRatio.width / (ratio >= 2 ? ratio - 1 : 0.5), 'width') >=
              100
            ) {
              note.style.left = `${100 - self.convertPxToPercent(markerSizeWithRatio.width / (ratio >= 2 ? ratio - 1 : 0.5), 'width')}%`;
            }
          } else {
            if (
              coordsInPercent.left <=
              (self.getSinglePageState()
                ? self.getLastPageState() && !self.isOnlyOnePageInBook()
                  ? APP.Book.getCurrentPage() == 1 && getBookPagesCount() == 2
                    ? 100
                    : 0
                  : self.getFirstPageState()
                  ? 100
                  : 50
                : 0)
            ) {
              note.style.left = `${
                self.getSinglePageState()
                  ? self.getLastPageState() && !self.isOnlyOnePageInBook()
                    ? APP.Book.getCurrentPage() == 1 && getBookPagesCount() == 2
                      ? 50
                      : 0
                    : self.getFirstPageState()
                    ? 50
                    : 50
                  : 0
              }%`;
            }
            if (
              coordsInPercent.left + self.convertPxToPercent(markerSizeWithRatio.width / (ratio >= 2 ? ratio - 1 : 0.5), 'width') >=
              (self.getSinglePageState()
                ? self.getLastPageState() && !self.isOnlyOnePageInBook()
                  ? APP.Book.getCurrentPage() == 1 && getBookPagesCount() == 2
                    ? 200
                    : getBookPagesCount() != 2 && getBookPagesCount() % 2 == 1
                      ? 200
                      : 100
                  : 200
                : 200)
            ) {
              note.style.left = `${
                (self.getSinglePageState()
                  ? self.getLastPageState() && !self.isOnlyOnePageInBook()
                    ? APP.Book.getCurrentPage() == 1 && getBookPagesCount() == 2
                      ? 100
                      : getBookPagesCount() != 2 && getBookPagesCount() % 2 == 1
                        ? 100
                        : 50
                    : 100
                  : 100) -
                self.convertPxToPercent(markerSizeWithRatio.width / (ratio >= 2 ? ratio - 1 : 0.5), 'width') / 2
              }%`;
            }
          }

          if (coordsInPercent.top < 0) {
            note.style.top = '0%';
          }
          if (coordsInPercent.top + self.convertPxToPercent(markerSizeWithRatio.height / (ratio >= 2 ? ratio - 1 : 0.5), 'height') >= 100) {
            note.style.top = `${100 - self.convertPxToPercent(markerSizeWithRatio.height / (ratio >= 2 ? ratio - 1 : 0.5), 'height')}%`;
          }
        }

        function onMouseUpFirst() {
          _stfBlock.removeEventListener('mousemove', onMouseMove);
        }

        function onMouseMove(e) {
          e.preventDefault();
          if (mouseUp) {
            noteMarker.removeEventListener('mouseup', onMouseUpFirst);
            noteMarker.addEventListener('mouseup', onMouseUp);
            mouseUp = false;
          }

          if (!note.classList.contains('active')) {
            note.classList.add('active');
          }

          if (APP.Book.isDoublePage()) {
            self.getStfBlock().append(note);
          }

          self.setState('moving');

          moveAt(e.pageX, e.pageY);
        }

        function onMouseUp(e) {
          e.preventDefault();
          const markerSizePercent = {
            width: self.convertPxToPercent(self.getModel().size.width),
            height: self.convertPxToPercent(self.getModel().size.height)
          }
          let currentPageIndex = APP.Book.getCurrentPage();
          let currentPage = document.querySelector(`._page_${currentPageIndex}`);
          let newCoordinates = {
            x: self.getSinglePageState()
              ? self.getLastPageState() && !self.isOnlyOnePageInBook()
                ? APP.Book.getCurrentPage() == 1 && getBookPagesCount() == 2
                  ? parseFloat(note.style.left) - 50
                  : parseFloat(note.style.left)
                : self.getFirstPageState()
                ? parseFloat(note.style.left) - 50
                : parseFloat(note.style.left)
              : parseFloat(note.style.left),
            y: parseFloat(note.style.top),
          };

          if (APP.Book.getModel().settings.show_single_page_mode) {
            newCoordinates = {
              x: parseFloat(note.style.left),
              y: parseFloat(note.style.top),
            };
          }

          if (
            (self.getSinglePageState()
              ? (getBookPagesCount() != 2 && getBookPagesCount() % 2 == 1 && !self.getFirstPageState() && !self.getSettingSinglePageMode())
                ? parseFloat(note.style.left)
                : parseFloat(note.style.left) - 50
              : parseFloat(note.style.left)) >= 50
          ) {
            currentPageIndex = currentPageIndex + 1;
            currentPage = document.querySelector(`._page_${currentPageIndex}`);
            newCoordinates = {
              x: newCoordinates.x - 50,
              y: newCoordinates.y,
            };
          }
          
          if (!APP.Book.getModel().settings.show_single_page_mode) {
            newCoordinates.x = newCoordinates.x * 2;
          }

          if ((newCoordinates.x + markerSizePercent.width >= 99)) {
            newCoordinates.x = 99 - markerSizePercent.width
          }

          if (newCoordinates.y + markerSizePercent.height >= 99) {
            newCoordinates.y = 99 - markerSizePercent.height
          }

          self.updateNotePropertyInArray(note.dataset.id, 'page', currentPageIndex);
          self.updateNotePropertyInArray(note.dataset.id, 'coordinates', {
            x: newCoordinates.x,
            y: newCoordinates.y,
          });
          self.updateNotePropertyInArray(note.dataset.id, 'isExpanded', isNoteWasExpandedBeforeMove);
          if (isNoteWasExpandedBeforeMove) self.toggleNote(note);

          note.style.left = newCoordinates.x + '%';
          note.style.top = newCoordinates.y + '%';

          let currentPageHotspotWrapper = currentPage.querySelector('.hotspots-container');

          if (!currentPageHotspotWrapper) {
            currentPageHotspotWrapper = document.createElement('div');
            currentPageHotspotWrapper.className = 'hotspots-container';
            currentPageHotspotWrapper.append(note);
            document.querySelector(`._page_${currentPageIndex}`).append(currentPageHotspotWrapper);
          } else {
            currentPageHotspotWrapper.append(note);
          }

          currentPageHotspotWrapper.style.opacity = '1';
          currentPageHotspotWrapper.style.visibility = 'visible';

          _stfBlock.removeEventListener('mousemove', onMouseMove);
          noteMarker.removeEventListener('mouseup', onMouseUp);
          mouseUp = true;
          note.classList.remove('active');
          self.setState('waiting');
        }

        _stfBlock.addEventListener('mousemove', onMouseMove);
        noteMarker.addEventListener('mouseup', onMouseUpFirst);
      });

      noteMarker.addEventListener('dragstart', () => {
        return false;
      });
    };
  })();
});
