/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

const Logs = function () {
  this.logs_state_visible = 0; //0 all visible 1 - viewer go backgrund 2 - viewer is in background 3- viewer wakeup from background
  this.lastActionTime = Date.now();

  this.inactiveTime = 0;
  this.boringTime = 0;
  this.bufforTimeMS = 0;
  this.uniqueId = null;
  this.sessionId = false;
  this.startTime = 0;
  this.dlid = 0;
  this.lfid = 0;

  this.isAndroid = /android/gi.test(navigator.appVersion);
  this.isIDevice =
    /iphone|ipad/gi.test(navigator.appVersion) ||
    (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1);
  this.isIPhone = /iphone/gi.test(navigator.appVersion);
  this.isIPad = /ipad/gi.test(navigator.appVersion);
  this.isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
  this.isSafari = navigator.userAgent.toLowerCase().indexOf('safari') > -1;
  const _logsToSend = [];
  let _logToSend = null;
  let _isSending = false;
  let _skipLog = false;
  let _logPingInterval = null;
  let = _isLastLog = false;
  const _logPingIntervalTime = 20000;
  const STORAGE = localStorage;
  const _STORAGE = new Object({ data: null });

  this.bookModel = null;

  this.setLogViewerStart = (_bookModel, startPage) => {
    this.dlid = window.dlid;
    this.bookModel = _bookModel;

    if (!this.uniqueId) {
      this.uniqueId = HELPER.uid();
    }

    if (!this.sessionId) {
      this.sessionId = generateId();
    }
    
    clearUserDataByType('user_dlids');

    checkDlIdTracking();
    checkLfIdTracking();

    if (!Array.isArray(startPage) && isNaN(startPage)) {
      startPage = 0;
    }

    log_set('page_start', startPage, true, 5, null);
  };

  const getDataToSave = (x) => {
    let dataToSave = '';

    if (x == 0) {
      dataToSave = JSON.stringify();
    } else {
      dataToSave = JSON.stringify(x);
    }

    return dataToSave;
  };

  const getLogToSave = (issue_id) => {
    const allStorageData = [_logToSend];
    const dataToSave = getDataToSave(allStorageData);
    const jsonX = JSON.parse(allStorageData);
    
    let log = { app_type: '1', log_type: jsonX.log_type, issue_id: issue_id, extra: dataToSave };

    if (jsonX.area_id > 0) {
      log = {
        app_type: '1',
        log_type: jsonX.log_type,
        issue_id: issue_id,
        extra: dataToSave,
        area_id: jsonX.area_id,
        area_uid: jsonX.hasOwnProperty('area_uid') ? jsonX.area_uid : null
      };
    }

    return log;
  };

  this.log_send_error = (issue_id, publisher_id, log) => {
    return;
    if (APP.countOfSendedErrorLogs >= 5) {
      return;
    }
    
    const _navigator = {};

    for (let i in navigator) {
      _navigator[i] = navigator[i];
    }

    let url = `${APP.LOGS_API}/${publisher_id}/${issue_id}/error`;
    let options = {
      method: 'POST',
      body: JSON.stringify({
        issue_id: issue_id,
        error: log,
        from: document.location.href,
        navigator: JSON.stringify(_navigator),
      }),
    };

    if (!!localErrorLogs) {
      url = '/flip-book/logger.php';
      options = {
        method: 'POST',
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({
          publisher_id,
          issue_id,
          error: log,
          from: document.location.href,
          navigator: JSON.stringify(_navigator),
        }),
      };
    }

    APP.countOfSendedErrorLogs++;

    fetch(url, options)
    .then(response => {
      if (!response.ok) {
        throw new Error('Something went wrong');
      }
    })
    .catch((error) => console.error(error));

    return;
  };

  const createDelayedPingLog = () => {
    if (_logPingInterval) {
      clearDelayedPingLog();
    }

    _logPingInterval = setInterval(() => {
      const previousLog = getPreviousPageLog();

      if (previousLog && Date.now() - previousLog.lifetime < _logPingIntervalTime) {
        return;
      }

      clearDelayedPingLog();
      log_set_ping();
    }, 5000);
  };

  const clearDelayedPingLog = () => {
    clearTimeout(_logPingInterval);
    _logPingInterval = null;
  }

  const getUrl = (issue_id, publisher_id) => `${APP.LOGS_API}/${publisher_id}/${issue_id}/simple`;

  const log_send = (issue_id, publisher_id, recursive = false) => {
    return;

    if (APP.countOfSendedErrorLogs >= 5) {
      return;
    }

    let log = null;

    if (!recursive) {
      log = getLogToSave(issue_id);
      _logsToSend.push(log);

      log_clear();
    } else if (_logsToSend.length > 0) {
      log = _logsToSend[0];
    }

    if(!log || publisher_id == "4712"){
      return;
    }

    if (_isSending && !recursive) {
      return;
    }

    _isSending = true;

    const url = getUrl(issue_id, publisher_id);

    if (_isLastLog) {
      fetch(url, {
        method: 'POST',
        body: JSON.stringify(log),
        keepalive: true
      }).then((response) => {
        if (!response.ok) throw new Error('Something went wrong');
      })
      .catch((error) => console.log(error));
  
      if (is_fireFox() || is_safari()) {
        const time = Date.now();
        while ((Date.now() - time) < 500) { }
        return true;
      } else {
        return true;
      }
    }
    
    fetch(url, {
      method: 'POST',
      body: JSON.stringify(log)
    })
      .then((response) => {
        if (!response.ok) {
          throw new Error('Something went wrong');
        }
      })
      .then(() => {
        log_clear();
        _logsToSend.splice(0, 1);

        if (_logsToSend.length <= 0) {
          _isSending = false;
          createDelayedPingLog();
        } else {
          clearDelayedPingLog();
          log_send(issue_id, publisher_id, true);
        }
      })
      .catch((error) => {
        console.error(error);
        _isSending = false;
        APP.countOfSendedErrorLogs++;
      });

    return;
  };

  this.setMouseMovedTime = () => {
    this.lastActionTime = Date.now();
    this.bufforTimeMS = 1000;
  };

  const log_set_ping = () => log_set('ping', window.APP.Book.getCurrentPageForLogs(), true, 5, null);
  const log_set_end = (pages) => log_set('page_end', pages, true, 5, null);

  this.log_set_page = () => {
    const cPage = window.APP.Book.getCurrentPageForLogs();

    if (!cPage || !Array.isArray(cPage) || cPage[0] < 0) {
      return;
    }

    log_set('page', window.APP.Book.getCurrentPageForLogs(), true, 5, null);
    this.bufforTimeMS = 500;
  };

  this.log_set_area = (type, hotspotModel, hotspotPage = null) => {
    const pageNumber = hotspotPage ? [hotspotPage] : window.APP.Book.getCurrentPageForLogs();

    log_set(type, pageNumber, true, 3, hotspotModel);
    this.bufforTimeMS = 1000;
  };

  const getBookModel = () => this.bookModel && this.bookModel.getModel ? this.bookModel.getModel() : APP.bookModel;
  const waitingPromise = (time = 300) => new Promise(resolve => setTimeout(() => resolve(), time));
  const generateId = () => Date.now().toString(36) + Math.random().toString(36).substr(2);
  const log_clear = () => _logToSend = null;

  const getRememberedDlIdByBookId = (bookId) => {
    const userDlIds = getLocalStorageItems(`_dlid_${this.uniqueId}`);

    if (!userDlIds) {
      return null;
    }

    const userIssueDlIdsIndex = userDlIds.findIndex(userDlId => userDlId.bookId === bookId);

    if (userIssueDlIdsIndex === -1) {
      return null;
    }

    return userDlIds[userIssueDlIdsIndex].dlids || [];
  };

  const getRememberedLf = () => {
    if (!HELPER.isLocalStorageAvailable()) {
      return;
    }

    let leadForms = getLocalStorageItems('leadform');

    if (!leadForms) {
      leadForms = getLocalStorageItems('leadform_safari');
    }

    if (!leadForms) {
      leadForms = getLocalStorageItems('leadform_crosssafari');
    }

    if (!leadForms) {
      return;
    }

    if (new Date() >= new Date(leadForms['expires'])) {
      return;
    }

    let value = leadForms['value'];

    if (value && value.indexOf(',') === 0) {
      value = value.slice(1);
    }

    return value.split(',');
  };

  const getStorageItem = () => {
    if (!!_STORAGE.data) {
      return _STORAGE.data;
    }

    const bookModel = getBookModel();
    const bookId = bookModel.bookId || bookModel.id;

    _STORAGE.data = {
      bookId,
      sessionId: this.sessionId,
      logs: [],
      updatedAt: Date.now()
    };

    return _STORAGE.data;
  }

  const getLocalStorageItems = (name) => {
    try {
      const item = STORAGE.getItem(name);

      if (!item) {
        return null;
      }

      return JSON.parse(item);
    } catch {
      return null;
    }
  };

  const saveDlidToLocalStorage = (dlid) => {
    if (!HELPER.isLocalStorageAvailable()) {
      return;
    }

    const bookModel = getBookModel();
    const bookId = bookModel.bookId || bookModel.id;
    const userDlIds = getLocalStorageItems(`_dlid_${this.uniqueId}`);

    if (!userDlIds) {
      saveLocalStorageItem(`_dlid_${this.uniqueId}`, [{
        bookId,
        dlids: [dlid]
      }]);

      return;
    }

    const userIssueDlIdsIndex = userDlIds.findIndex(userDlId => userDlId.bookId === bookId);

    if (userIssueDlIdsIndex === -1) {
      userDlIds.push({
        bookId,
        dlids: [dlid]
      });

      saveLocalStorageItem(`_dlid_${this.uniqueId}`, userDlIds);
      
      return;
    }

    const newDlIds = userDlIds[userIssueDlIdsIndex].dlids;

    if (!newDlIds.includes(dlid)) {
      newDlIds.push(dlid);
    
      userDlIds[userIssueDlIdsIndex] = {
        bookId,
        dlids: newDlIds
      };

      saveLocalStorageItem(`_dlid_${this.uniqueId}`, userDlIds);
    } else {
      const dlIdIndex = newDlIds.findIndex(item => item === dlid);

      newDlIds.splice(dlIdIndex, 1);
      newDlIds.push(dlid);

      userDlIds[userIssueDlIdsIndex] = {
        bookId,
        dlids: newDlIds
      };

      saveLocalStorageItem(`_dlid_${this.uniqueId}`, userDlIds);
    }
  };

  const checkDlIdTracking = () => {
    if (!HELPER.isLocalStorageAvailable()) {
      return;
    }

    const bookModel = getBookModel();
    const bookId = bookModel.bookId || bookModel.id;

    if (!!window.dlid && window.dlid !== 0) {
      saveDlidToLocalStorage(window.dlid);

      return;
    }

    const rememberedDlId = getRememberedDlIdByBookId(bookId);

    if (!rememberedDlId || rememberedDlId === 0) {
      return;
    }

    if (Array.isArray(rememberedDlId) && rememberedDlId.length <= 0) {
      return;
    }

    if (Array.isArray(rememberedDlId) && rememberedDlId.length > 0) {
      this.dlid = rememberedDlId[rememberedDlId.length - 1];

      return;
    }

    this.dlid = rememberedDlId;
  };

  const checkLfIdTracking = () => {
    if (!HELPER.isLocalStorageAvailable()) {
      return;
    }

    const bookModel = getBookModel();
    const bookId = bookModel.bookId || bookModel.id;

    const rememberedLfId = getRememberedLf();

    if (!rememberedLfId || !Array.isArray(rememberedLfId)) {
      return;
    }

    if (rememberedLfId.includes(bookId.toString())) {
      this.lfid = bookId;
    }
  };

  const getAllLocalStorageItemsByPrefix = (prefix) => {
    try {
      const items = Object.entries(STORAGE).filter(item => item[0].includes(prefix));

      if (!items) {
        return null;
      }

      const formatedItems = items.map(item => {
        return {
          name: item[0],
          value: JSON.parse(item[1])
        }
      });

      return formatedItems;
    } catch {
      return null;
    }
  };

  const removeLocalStorageItem = (name) => {
    try {
      STORAGE.removeItem(name);

      return true;
    } catch {
      return null;
    }
  };

  const clearUserDataByType = (type) => {
    switch (type) {
      case 'user_dlids':
        const userDlIds = getAllLocalStorageItemsByPrefix(`_dlid_`);

        if (!Array.isArray(userDlIds) || userDlIds.length <= 0) {
          return;
        }
    
        userDlIds.forEach(userDlId => {
          if (userDlId.name !== `_dlid_${this.uniqueId}`) {
            removeLocalStorageItem(userDlId.name)
          }
        });

        break;

      default:
        break;
    }
  };

  const saveLocalStorageItem = (name, data) => {
    try {
      STORAGE.setItem(name, JSON.stringify(data));

      return true;
    } catch {
      return false;
    }
  };

  const saveStorageItem = (data) => _STORAGE.data = Object.assign(_STORAGE.data, data);

  const saveLogToStorage = (_log) => {
    const log = Object.assign({}, _log, { id: generateId() });
    const storage = getStorageItem();

    if (!storage.logs.length) {
      saveStorageItem({ logs: [log] });

      return;
    }

    const newLogs = Array.from(storage.logs);
    newLogs.push(log);

    saveStorageItem({ 
      logs: newLogs, 
      updatedAt: Date.now() 
    });
  };

  const getPreviousPageLog = (id = null) => {
    const storage = getStorageItem();

    if (!storage.logs.length) {
      return null;
    }

    if (id) {
      const logIndex = storage.logs.findIndex(log => log.id === id);

      if (logIndex === -1) {
        return null;
      }

      return storage.logs[logIndex];
    }

    const reversedLogs = Array.from(storage.logs).reverse();
    const logIndex = reversedLogs.findIndex(log => log.log_type == 5);

    if (logIndex === -1) {
      return null;
    }

    return reversedLogs[logIndex];
  };

  const getDeltaMs = (currentLog, previousLog) => {
    const timeMs = currentLog['time'] - previousLog['time'];
    let boringMs = currentLog['boringtime'] - previousLog['boringtime'];

    const isFirstPing = currentLog['type'] == 'ping' && previousLog['type'] == 'page';
    const changedPageWithoutBreak = currentLog['type'] == 'page' && (previousLog['type'] == 'page' || previousLog['type'] == 'page_start');
    
    if (isFirstPing) {
      boringMs -= 5 * 1000;
      boringMs = (boringMs < 0) ? 0 : boringMs;
    }
    
    if (changedPageWithoutBreak) {
      boringMs = 0;
    }

    const deltaMs = timeMs - boringMs;
    const suspiciousTimeMs = 1 * 60 * 60 * 1000;

    if (deltaMs >= suspiciousTimeMs) {
      // TODO: LOGS
    }
    
    return deltaMs;
  };

  const compareTwoLogs = (currentLog, previousLog, forceType = null) => {
    const currentLogData = {
      type: currentLog['type'],
      pages: currentLog['page']
    };

    const previousLogData = {
      type: previousLog['type'],
      pages: previousLog['page']
    };

    if (forceType && (currentLogData['type'] !== forceType || previousLogData['type'] !== forceType)) {
      return false;
    }

    return (
      currentLogData['type'] == previousLogData['type'] && 
      Array.isArray(currentLogData['pages']) && currentLogData['pages'].length > 0 &&
      Array.isArray(previousLogData['pages']) && previousLogData['pages'].length > 0 &&
      currentLogData['pages'][0] == previousLogData['pages'][0]
    );
  };

  const calculateTime = (log) => {
    let previousPageLog = getPreviousPageLog();

    if (!previousPageLog) {
      return null;
    }

    const isTheSameLogs = compareTwoLogs(log, previousPageLog, 'page');

    if (isTheSameLogs) {
      _skipLog = true;
      
      return {
        time: 0,
        previousLog: previousPageLog
      };
    }

    if (previousPageLog.type === 'ping') {
      const earlierLog = getPreviousPageLog(previousPageLog.id);
      const changedFromPage = earlierLog['type'] === 'page' || earlierLog['type'] === 'page_start';
      const samePages = (earlierLog['page_l'] === previousPageLog['page_l']) && (earlierLog['page_r'] === previousPageLog['page_r']);

      if (changedFromPage && samePages) {
        const difference = log['time'] - earlierLog['time'];

        if (difference <= 5000) {
          const deltaTime = getDeltaMs(log, previousPageLog);
          const timeToSubtract = -1 * deltaTime;
          previousPageLog = earlierLog;
        }
      }
    }

    const deltaTime = getDeltaMs(log, previousPageLog);

    delete previousPageLog.previous_log;

    return {
      time: deltaTime < 0 ? 0 : deltaTime, 
      previousLog: previousPageLog
    };
  };

  const getHotspotData = (type, hotspotModel) => {
    let data;

    switch (type) {
      case 'link':
        const linkType = hotspotModel.data.type;

        data = linkType === 'page' ? `#page#${hotspotModel.data.value}` : hotspotModel.data.value;
        break;

      case 'gif':
      case 'gallery':
        data = hotspotModel.data[0];
        break;

      case 'video':
      case 'audio':
        data = hotspotModel.data.value;
        break;

      case 'product-info':
        data = {
          uid: hotspotModel.data.uid,
          name: hotspotModel.data.name
        };
        break;
      
      default:
        break;
    }

    return data;
  };

  const log_set = async (type, pagenum, sendnow, log_type, hotspotModel = null) => {
    if (window.disablelogs || false) {
      return;
    }

    if (pagenum === null || typeof pagenum === 'undefined') {
      pagenum = window.APP.Book.getCurrentPageForLogs();
    }

    if (this.boringTime === null) {
      console_log('clear boring');
      this.boringTime = 0;
    }

    if (typeof pagenum === 'undefined') {
      console_log('dont send log with pagesnum undefined');
      return false;
    }

    const now = Date.now();
    const lifetime = now - this.startTime; //czas od startu viewera do teraz
    this.inactiveTime = now - this.lastActionTime; //czas od lastaction
    //od inactiveTime odejmijmy bufor
    this.inactiveTime = this.inactiveTime - this.bufforTimeMS;
    this.bufforTimeMS = 0;

    if (this.inactiveTime < 0) {
      this.inactiveTime = 0;
    }

    //  //browers go bg or tab goes bg save one ping other ignore
    if (this.logs_state_visible == 1) {
      this.logs_state_visible = 2;
      this.lastActionTime = now;
    } else if (this.logs_state_visible == 2) {
      this.logs_state_visible = 2;
      
      createDelayedPingLog();

      return;
    } else if (this.logs_state_visible == 3) {
      this.logs_state_visible = 0;
      this.sleepTime = 0;
    } else {
      this.lastActionTime = now;
    }

    if (this.inactiveTime > 1800000) {
      //1H INACTIVE RESETUJ SESJE
      console_log('restuj');
      window.location.reload();
    }

    if (this.isIDevice || this.isAndroid) {
      this.boringTime = 0;
      this.boringTime += this.sleepTime;
    } else {
      this.boringTime += this.inactiveTime;
    }

    if (this.boringTime == null || isNaN(this.boringTime)) {
      //@todo
      this.boringTime = 0;
    }

    let areaId = 0;
    let areaUId = null;

    if (hotspotModel && hotspotModel.hasOwnProperty('area_number')) {
      areaId = hotspotModel.area_number;
      areaUId = hotspotModel.uid;
    }

    let objtosave = {
      type: type,
      time: now,
      page: pagenum,
      lifetime: lifetime,
      inactivetime: this.inactiveTime,
      boringtime: this.boringTime,
      uid: this.uniqueId,
      link: this.dlid,
      lead: this.lfid,
      log_type: log_type,
      area_id: areaId,
      area_uid: areaUId,
      embed: embedmode,
    };

    let data = calculateTime(objtosave);

    if (!data) {
      data = {
        time: 0,
        previousLog: null
      }
    }

    const model = getBookModel();

    if (!model) {
      return;
    }
    
    objtosave = Object.assign(objtosave, {
      calculated_time: data.time,
      previous_log: (() => {
        if (!data.previousLog || Object.keys(data.previousLog).length <= 0) return data.previousLog;

        return {
          page: data.previousLog.page,
          type: data.previousLog.type
        };
      })(),
      ignored: (type === 'page' || type === 'ping') && data.time < 300,
      sid: this.sessionId,
      plan_id: model.hasOwnProperty('plan_id') ? model.plan_id : -1
    });

    if (!_skipLog) {
      saveLogToStorage(objtosave);
    }

    if (type === 'page' && data.previousLog) {
      objtosave = Object.assign(objtosave, {
        page: data.previousLog.page
      });
    }

    if (type === 'page' || type === 'page_end') {
      objtosave = Object.assign(objtosave, {
        cpage: pagenum
      });
    }

    if (!HELPER.isLocalStorageAvailable()) {
      objtosave = Object.assign(objtosave, {
        ls: false
      });
    }

    if (['link', 'gallery', 'gif', 'video', 'audio', 'product-info'].includes(type) && hotspotModel && hotspotModel.logData) {
      objtosave = Object.assign(objtosave, { data: hotspotModel.logData });
    }

    if (_skipLog) {
      _skipLog = false;

      log_clear();
      return;
    }

    if (objtosave.ignored) {
      await waitingPromise();
      
      const pages = objtosave.hasOwnProperty('cpage') && Array.isArray(objtosave.cpage) ? objtosave.cpage : objtosave.page;

      if (!window.APP.Book.getCurrentPageForLogs() || pages[0] !== window.APP.Book.getCurrentPageForLogs()[0]) {
        return;
      }
    }

    try {
      _logToSend = JSON.stringify(objtosave);

      if (sendnow) {
        log_send(model.id, model.publisher_id);
      }

      return true;
    } catch (e) {
      return false;
    }
  };

  const initialize = () => {
    try {
      window.addEventListener('beforeunload', () => {
        if (!_STORAGE.data || !window.APP || !window.APP.Book || !window.APP.Book.getCurrentPageForLogs) {
          return;
        }

        const pages = window.APP.Book.getCurrentPageForLogs();

        if (!pages) {
          return;
        }

        _isLastLog = true;
        log_set_end(pages);
      }, false);

      this.dlid = window.dlid;
      this.bookModel = getBookModel();
      this.sessionId = generateId();
      this.uniqueId = HELPER.uid();
    } catch (err) {
      console.log(`Error while bounding listener or function calling: ${err}`);
    }
  };

  initialize();
};

const oLogs = new Logs();
