'use strict';

APPonReady.add(function () {
  const SIDEBAR_WIDTH = 320;
  const SIDEBAR_ACTIVE_CLASSNAME = '__active';
  const RELATIVE_SIDEBAR_WIDTH_BORDER = 991;

  APP.Layout = new (function () {
    const self = this;
    let header, footer, sidebar, sidebarTOC, sidebarSearch, sidebarWishlist, main, root;
    
    const showEl = function () {
      this.classList.add(SIDEBAR_ACTIVE_CLASSNAME);
    };

    const hideEl = function (callback = null) {
      this.classList.remove(SIDEBAR_ACTIVE_CLASSNAME);

      if (callback && typeof(callback) === 'function') callback();
      else if (this.hideCallback && typeof(this.hideCallback) === 'function') this.hideCallback();
    };

    const toggleEl = function () {
      this.classList.toggle(SIDEBAR_ACTIVE_CLASSNAME);
    };

    const isActive = function () {
      return this.classList && this.classList.contains(SIDEBAR_ACTIVE_CLASSNAME);
    };

    this.getBody = function () {
      return document.body;
    };

    this.getHeader = function () {
      if (header == null) {
        header = document.getElementById('header');
        header.show = showEl;
        header.hide = hideEl;
        header.toggle = toggleEl;
        header.isActive = isActive;
      }
      return header;
    };

    this.getMain = function () {
      if (main == null) main = document.getElementById('main');
      return main;
    };

    this.getRoot = function () {
      if (root == null) root = document.getElementById('root');
      return root;
    };

    this.getFooter = function () {
      if (footer == null) {
        footer = document.getElementById('footer');
        footer.show = showEl;
        footer.hide = hideEl;
        footer.toggle = toggleEl;
        footer.isActive = isActive;
      }
      return footer;
    };

    this.getSidebar = function () {
      if (sidebar == null) {
        sidebar = document.getElementById('sidebar');
        sidebar.show = showEl;
        sidebar.hide = hideEl;
        sidebar.toggle = toggleEl;
        sidebar.isActive = isActive;
      }
      return sidebar;
    };

    this.getSidebarTOC = function () {
      if (sidebarTOC == null) {
        sidebarTOC = document.getElementById('sidebarTOC');
        sidebarTOC.show = showEl;
        sidebarTOC.hide = hideEl;
        sidebarTOC.toggle = toggleEl;
        sidebarTOC.isActive = isActive;
      }
      return sidebarTOC;
    };

    this.getSidebarSearch = function () {
      if (sidebarSearch == null) {
        sidebarSearch = document.getElementById('sidebarSearch');
        sidebarSearch.show = showEl;
        sidebarSearch.hide = hideEl;
        sidebarSearch.toggle = toggleEl;
        sidebarSearch.isActive = isActive;
      }
      return sidebarSearch;
    };

    this.getSidebarWishlist = function () {
      if (sidebarWishlist == null) {
        sidebarWishlist = document.getElementById('sidebarWishlist');
        sidebarWishlist.show = showEl;
        sidebarWishlist.hide = hideEl;
        sidebarWishlist.toggle = toggleEl;
        sidebarWishlist.isActive = isActive;
      }
      return sidebarWishlist;
    };

    this.isSidebarRelative = () => {
      return window.innerWidth > RELATIVE_SIDEBAR_WIDTH_BORDER;
    };

    this.getRootWidthDependOnSidebarState = () => {
      if ((is_small_embed_not_mobile() && !APP.Book.getFullscreenState()) || is_mobile()) {
        return window.innerWidth;
      }

      const sidebars = [this.getSidebar(), this.getSidebarTOC(), this.getSidebarSearch(), this.getSidebarWishlist()];
      const activeSidebar = sidebars.find(sidebar => isActive.apply(sidebar));

      if (!self.isSidebarRelative()) {
        sidebars.forEach(sidebar => sidebar.classList.add('absolute'));
        return window.innerWidth;
      }

      sidebars.forEach(sidebar => sidebar.classList.remove('absolute'));
      
      if (!activeSidebar) {
        return window.innerWidth;
      }

      const sidebarWidth = activeSidebar.classList && activeSidebar.classList.contains(SIDEBAR_ACTIVE_CLASSNAME) ? activeSidebar.getBoundingClientRect().width : 0;

      return window.innerWidth - sidebarWidth;
    };

    const createSidebar = (sidebar, labelText, sidebarOptions = {}) => {
      const options = Object.assign({
        sidebarInner: true
      }, sidebarOptions);

      const header = document.createElement('div');
      const wrapper = document.createElement('div');

      const sidebarInner = document.createElement('div');
      const label = document.createElement('span');
      const closeButton = document.createElement('button');
      const closeButtonMobile = document.createElement('button');
  
      sidebar.className = 'sidebar';
      wrapper.className = 'sidebar__wrapper';
      header.className = 'sidebar__header';

      sidebarInner.className = 'Book__sidebar';
      label.className = 'sidebar__label';
      closeButton.className = 'sidebar__label__close';
      closeButtonMobile.className = 'sidebar__label__close--mobile';
  
      closeButton.name = APP._t('Button Close');
      closeButton.ariaLabel = APP._t('Button Close');
      closeButtonMobile.name = APP._t('Button Close');
      closeButtonMobile.ariaLabel = APP._t('Button Close');

      label.innerHTML = labelText;
      closeButton.innerHTML = HELPER.buttonsIcons.closeIconFilled;

      if (!self.isSidebarRelative()) {
        sidebar.classList.add('absolute');
      }

      if ((is_mobile() || is_small_embed_not_mobile()) && mobile_test_horizontal()) {
        sidebarInner.classList.add('Book__sidebar--xs-landscape');
      }

      if (is_mobile() || is_small_embed_not_mobile()) {
        sidebar.classList.add('mobile');
        sidebar.style = 'width: 100%; display: flex';
        HELPER.sidebar_setStylesForMobile();

        header.addEventListener('click', APP.Book.hideSidebar);
        // header.addEventListener('click', () => hideEl.apply(sidebar, [hideCallback]));
      } else {
        sidebar.style.width = `${SIDEBAR_WIDTH}px`;
      }

      sidebar.style.background = `#${APP.Book.customizeBookBackgroundColor__getCorrectAvgHex()}FF`;

      header.appendChild(label);
      header.appendChild(closeButton);
      header.appendChild(closeButtonMobile);

      if (options.sidebarInner) {
        wrapper.appendChild(sidebarInner);
      }

      sidebar.appendChild(header);
      sidebar.appendChild(wrapper);

      closeButton.addEventListener('click', APP.Book.hideSidebar);
      closeButtonMobile.addEventListener('click', APP.Book.hideSidebar);
      // closeButton.addEventListener('click', () => hideEl.apply(sidebar, [hideCallback]));
      // closeButtonMobile.addEventListener('click', () => hideEl.apply(sidebar, [hideCallback]));

      return sidebar;
    };

    this.render__createSidebar = function () {
      const sidebarElem = createSidebar(self.getSidebar(), APP._t('Sidebar Thumbnails Title'));

      return sidebarElem;
    };

    this.render_createSidebarWishlist = function () {
      const sidebarElem = createSidebar(self.getSidebarWishlist(), APP._t('Sidebar Wishlist Title'), { sidebarInner: false });

      if (!APP.Products || !APP.Products.initialize) {
        const waitForProductsInit = setInterval(() => {
          if (APP.Products && APP.Products.initialize) {
            clearInterval(waitForProductsInit);
            
            APP.Products.initialize(sidebarElem);
          }
        }, 100);
      } else {
        APP.Products.initialize(sidebarElem);
      }

      sidebarElem.hideCallback = () => {
        if (APP.Products && APP.Products.sidebarHideHandler) {
          APP.Products.sidebarHideHandler();
        }
      };

      return sidebarElem;
    };

    this.render__createSidebarSearch = function () {
      if (document.querySelector('#sidebarSearch .sidebar__wrapper')) {
        return;
      }

      const sidebarElem = createSidebar(self.getSidebarSearch(), APP._t('Sidebar Search Title'), { sidebarInner: false });

      if (!APP.Search || !APP.Search.initialize) {
        const waitForSearchInit = setInterval(() => {
          if (APP.Search && APP.Search.initialize) {
            clearInterval(waitForSearchInit);
            
            APP.Search.initialize(sidebarElem);
          }
        }, 100);
      } else {
        APP.Search.initialize(sidebarElem);
      }

      sidebarElem.hideCallback = () => {
        if (APP.Search && APP.Search.sidebarHideHandler) {
          APP.Search.sidebarHideHandler();
        }
      };

      return sidebarElem;
    };

    const parseTOC = (tocDict) => {
      if (!tocDict || typeof(tocDict) !== 'string') {
        return tocDict;
      }

      try {
        let parsedTOC = tocDict;

        if (tocDict.indexOf('\\"') !== -1) {
          parsedTOC = JSON.parse(tocDict);
        }

        return JSON.parse(parsedTOC);
      } catch (err) {
        console.log(`Error while parsing toc. Error: ${err}`);
        return tocDict;
      }
    };

    this.updateTOC = (tocDict) => {
      const parsedTOC = parseTOC(tocDict);
      const fields = APP.isStringified(parsedTOC);
      
      if (!fields) return;

      if (APP.bookModel.toc != fields) {
        APP.bookModel.toc = fields;
      }
      
      const sidebar = self.getSidebarTOC();
      const sidebarInner = sidebar.querySelector('.Book__sidebar');
      const sidebarWrapper = sidebar.querySelector('.sidebar__wrapper');

      sidebarInner.innerHTML = '';

      if (customizemode && fields.length === 0) {
        const sidebarEmpty = document.createElement('div');
        const sidebarEmptyIcon = HELPER.buttonsIcons.infoIcon;
        const sidebarEmptyText = APP._t('Sidebar Empty Text');
        
        sidebarEmpty.className = 'sidebar__empty';

        sidebarEmpty.innerHTML = `
          ${sidebarEmptyIcon}
          <span>${sidebarEmptyText}</span>
        `;

        sidebarWrapper.appendChild(sidebarEmpty);
      } else {
        if (customizemode && sidebar.querySelector('.sidebar__empty')) {
          sidebar.querySelector('.sidebar__empty').remove();
        }

        toc(fields, sidebarInner);
      }

      createEvent('adjust-scrollbar', {}, true);

      const lastModifiedTocItem = sidebarInner.querySelector('.toc_item[last-modified]');

      if (lastModifiedTocItem) {
        sidebarInner.scroll({
          top: lastModifiedTocItem.offsetTop * (sidebarInner.scrollHeight - sidebarInner.getBoundingClientRect().height),
          behavior: "smooth"
        });
      }
    };

    this.render__createSidebarTOC = function (tocDict) {
      if (!tocDict) return;

      const sidebar = self.getSidebarTOC();

      sidebar.innerHTML = '';

      const sidebarElem = createSidebar(sidebar, APP._t('Sidebar Table Of Content Title'));
      const sidebarInner = sidebarElem.querySelector('.Book__sidebar');

      this.updateTOC(tocDict);

      if (!is_mobile()) {
        HELPER.renderCustomScroll(sidebarElem, sidebarInner);
      }

      return sidebarElem;
    };

    const toc = function (list, parent, prevCounter = 1) {
      const subItemPadding = 13, itemPadding = 26, arrowWidth = 17, headerPadding = itemPadding - arrowWidth;
      let counter = prevCounter;

      if (!list) return;

      list.forEach(field => {
        const tocItem = document.createElement('div');
        tocItem.classList.add('toc_item');
        tocItem.dataset.page = field.page + 1;
        tocItem.innerHTML = `<div class="toc_item__header"><div class="toc_item__header-content"><p>${
          field.title
        }</p><p>${field.page + 1}</p></div></div>`;

        if (field.lastModified) {
          tocItem.setAttribute('last-modified', true);
        }
 
        if (tocItem.getElementsByTagName('p')[0]) {
          tocItem.getElementsByTagName('p')[0].addEventListener('click', () => {
            APP.Book.setPage(field.page + 1, 'sidebar.toc');

            document.querySelectorAll('.toc_item').forEach((item) => {
              if (item.querySelector('.toc_item__header')) {
                item.querySelector('.toc_item__header').classList.remove('toc_item__active');
              }
            });

            if (tocItem.querySelector('.toc_item__header')) {
              tocItem.querySelector('.toc_item__header').classList.add('toc_item__active');
            }
  
            if (is_mobile() || is_small_embed_not_mobile()) {
              self.getSidebarTOC().hide();
            }
          });
        }

        parent.append(tocItem);

        let tocItemPadding = counter == 1 ? itemPadding : (counter * subItemPadding);
        tocItem.querySelectorAll('.toc_item__header').forEach(item => item.style.paddingLeft = `${tocItemPadding}px`);
 
        if (field.items && field.items.length) {
          tocItem.querySelectorAll('.toc_item__header').forEach(item => item.style.paddingLeft = `${counter * headerPadding}px`);
          let tocItemWrapper = document.createElement('div');
          tocItemWrapper.classList.add('toc_item__wrapper');
          counter++;
          toc(field.items, tocItemWrapper, counter)
          counter = counter > 0 ? counter - 1 : 0;
          
          tocItem
          .querySelector('.toc_item__header .toc_item__header-content')
          .insertAdjacentHTML(
            'afterbegin',
            '<div class="toc_item__arrow"><svg viewBox="0 0 24 24" class="icon svg-icon svg-fill" focusable="false" xmlns="http://www.w3.org/2000/svg"><path d="M15 12L15.7071 11.2929L16.4142 12L15.7071 12.7071L15 12ZM9.70711 5.29289L15.7071 11.2929L14.2929 12.7071L8.29289 6.70711L9.70711 5.29289ZM15.7071 12.7071L9.70711 18.7071L8.29289 17.2929L14.2929 11.2929L15.7071 12.7071Z" /></svg><div>',
          );
          
          tocItem.querySelector('.toc_item__arrow').addEventListener('click', () => {
            tocItem.classList.toggle('toc_item__expanded')
          })
          
          if (field.expanded) {
            tocItem.classList.add('toc_item__expanded');
          }

          tocItem.append(tocItemWrapper);
        }
      });
    };

    this.setTocItemActiveByPageNum = (pageNum) => {
      const pages = Number(APP.Book.getModel().pages);
      let pageNumbers = [];
      let isEpxanded = false;

      document.querySelectorAll('.toc_item').forEach((item) => {
        if (item.querySelector('.toc_item__header')) {
          item.querySelector('.toc_item__header').classList.remove('toc_item__active');
        }
      });

      if (!is_mobile() && !is_small_embed_not_mobile() && APP.Book.isDoublePage()) {
        if (pageNum <= 1) {
          pageNumbers.push(1)
        } else if (pageNum >= pages) {
          if (pages % 2 == 0) {
            pageNumbers.push(pages);
          } else {
            pageNumbers.push(pages - 1, pages);
          }
        } else {
          if (pageNum % 2 == 0) {
            pageNumbers.push(pageNum, pageNum + 1);
          } else {
            pageNumbers.push(pageNum - 1, pageNum);
          }
        }
      }

      if (pageNumbers && pageNumbers.length) {
        pageNumbers.forEach(page => {
          const tocItem = document.querySelector(`.toc_item[data-page="${page}"]`);

          if (tocItem) {
            if (tocItem.parentNode.classList && tocItem.parentNode.classList.contains('toc_item__wrapper')) {
              tocItem.parentNode.parentNode.classList.add('toc_item__expanded');
              isEpxanded = true;
            } else {
              if (!isEpxanded) {
                document.querySelectorAll('.toc_item__expanded').forEach((item) => {
                  item.classList.remove('toc_item__expanded');
                });
              }
            }
            if (tocItem.querySelector('.toc_item__header')) {
              tocItem.querySelector('.toc_item__header').classList.add('toc_item__active');
            }
          }
        })
      }

      const sidebar = self.getSidebarTOC();
      const activeTocItem = sidebar.querySelector('.toc_item__active');

      if (sidebar.isActive() && activeTocItem) {
        const sidebarInner = sidebar.querySelector('.Book__sidebar');

        sidebarInner.scroll({
          top: activeTocItem.offsetTop,
          behavior: "smooth"
        });
      }
    };

    const renderAccessDeniedPopup = function () {
      const _main = self.getMain();
      const wrapper = document.createElement('div');
      const imageWrapper = document.createElement('div');
      const image = document.createElement('img');
      const content = document.createElement('div');

      image.src = 'https://publuu.com/flip-book/assets/images/secured4.svg';
      image.alt = 'Access Denied';
      content.innerHTML = `
        <h1 class="not-found__title">${APP._t('Access Denied Title')}</h1>
        <p class="not-found__text"><b>${APP._t('Access Denied Subtitle')}</b></p>
        <p class="not-found__text" style="display:">${APP._t('Access Denied Text')}</p>
      `;

      wrapper.className = 'not-found__body';
      imageWrapper.className = 'not-found__image';
      content.className = 'not-found__content';

      imageWrapper.appendChild(image);
      wrapper.appendChild(imageWrapper);
      wrapper.appendChild(content);
      _main.appendChild(wrapper);
      _main.style.visibility = 'visible';
      _main.classList.add('access-denied');
    };

    const bodyClassList = function () {
      self.getBody().classList[is_vertical() ? 'add' : 'remove']('is_vertical');
      self.getBody().classList[is_horisontal() ? 'add' : 'remove']('is_horisontal');
      self.getBody().classList[is_mobile() ? 'add' : 'remove']('is_mobile');
      self.getBody().classList[is_desktop() ? 'add' : 'remove']('is_desktop');
      self.getBody().classList[is_small_embed_not_mobile() ? 'add' : 'remove']('is_embed');
    };

    window.addEventListener('resize', bodyClassList);
    bodyClassList();

    self.getFooter().addEventListener('click', function () {
      self.getFooter().toggle();
    });

    self.getMain().addEventListener('click', function () {
      if (self.isSidebarRelative()) return;

      self.getSidebar().hide();
      self.getSidebarTOC().hide();
      self.getSidebarSearch().hide();
      self.getSidebarWishlist().hide();
      self.getFooter().hide();
    });

    if (APP && APP.accessAllowed !== null && !APP.accessAllowed) {
      document.querySelector('.loader').classList.add('roothidden');
      renderAccessDeniedPopup()
      return;
    } else {
      const bookOptions = Object.assign(APP.bookModel, {
        bookId: bookId,
        publisherId: publisherId
      });

      APP.loadComponent('Page_curl', function () {
        if ((parseInt(rtlChange) == 1 && parseInt(customizemode) == 1 && parseInt(rightToLeft) === 1) || parseInt(rightToLeft) === 1) {
          APP.loadComponent('Book_curl-rtl', function () {
            APP.loadComponent('Notes', function () {
              APP.Book = new BookRtl(bookOptions);
              APP.Note.init(bookId);
            });
          });
        } else {
          APP.loadComponent('Book_curl', function () {
            APP.loadComponent('Notes', function () {
              APP.Book = new Book(bookOptions);
              APP.Note.init(bookId);
            });
          });
        }
      });
    }
  })();
});
