/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

window.HELPER = new (function () {
  const self = this;
  const leadFormErrors = [];

  this.uid = function (sendby = 'no') {
    if (embedmode && false) {
      return embeduid;
    } else {
      var _uid = HELPER.getLocalStorageData('uid', 'value');
      if (_uid && _uid.length > 0) {
        HELPER.setLocalStorageData('uid', _uid, 365); //refresh time
        return _uid;
      }
      var uid = Date.now().toString(36) + Math.random().toString(36).substr(2);
      HELPER.setLocalStorageData('uid', uid, 365);
      return uid;
    }
  };
  
  this.getBgSizeByResolution = function(isVideo = false) {
    if (is_mobile()) {
      return 'mobile';
    }

    const IMG_RES = [768, 1024, 1280, 1536, 1920];
    const VIDEO_RES = [1080];

    const resolutions = isVideo ? VIDEO_RES : IMG_RES;
    const newResolution = resolutions.find(item => {
      if (isVideo) {
        return window.innerHeight <= item ? item : null;
      }

      return window.innerWidth <= item ? item : null;
    });

    if (!newResolution && isVideo) {
      return null;
    }

    if (!newResolution) {
      return resolutions[resolutions.length - 1];
    }

    return newResolution;
  };

  this.setBgUrlWithResolution = function(url, resolution) {
    const splitedUrl = url.split(/(.[a-z]+)$/);
    
    return `${splitedUrl[0]}_${resolution}${splitedUrl[1]}`;
  };

  this.isLocalStorageAvailable = function() {
    const test = 'test';
    try {
      localStorage.setItem(test, test);
      localStorage.removeItem(test);
      return true;
    } catch(e) {
      return false;
    }
  };

  let thumbsOriginalSize = {
    w: 0,
    h: 0
  };

  this.copyToClipboard = function (elem, elementSelector, noticeThatCopied) {
    var inputDiv = document.querySelector(`.${elementSelector}`);
    var startinnerhtml = inputDiv.innerHTML;

    if (startinnerhtml === noticeThatCopied) {
      //ignore copy if copied
      return;
    }
    setTimeout(function () {
      document.querySelector(`.${elementSelector}`).innerHTML = startinnerhtml;
      elem.classList.remove('noticed');
    }, 2000);

    if (typeof (navigator.clipboard) == 'undefined' || !window.isSecureContext) {
      var textArea = document.createElement("textarea");
      textArea.value = startinnerhtml;
      textArea.style.position = "fixed";
      textArea.style.opacity = 0;
      document.body.appendChild(textArea);
      textArea.focus();
      textArea.select(); 
      document.execCommand('copy');
      document.body.removeChild(textArea);
    } else {
      navigator.clipboard.writeText(startinnerhtml).then(
        function () {
          console_log('copied');
          /* clipboard successfully set */
        },
        function () {
          /* clipboard write failed */
          var textarea = document.createElement('textarea');
          textarea.textContent = startinnerhtml;
          document.body.appendChild(textarea);
  
          var selection = document.getSelection();
          var range = document.createRange();
  
          range.selectNode(textarea);
          selection.removeAllRanges();
          selection.addRange(range);
  
          if (navigator.userAgent.match(/ipad|ipod|iphone/i)) {
            var el = textarea;
            var editable = el.contentEditable;
            var readOnly = el.readOnly;
            el.contentEditable = 'true';
            el.readOnly = 'false';
            var range = document.createRange();
            range.selectNodeContents(el);
            var sel = window.getSelection();
            sel.removeAllRanges();
            sel.addRange(range);
            el.setSelectionRange(0, 999999);
            el.contentEditable = editable;
            el.readOnly = readOnly;
            document.execCommand('copy');
          } else {
            document.execCommand('copy');
          }
  
          selection.removeAllRanges();
  
          document.body.removeChild(textarea);
        },
      );
    }

    if (noticeThatCopied) {
      inputDiv.innerHTML = `<span>${noticeThatCopied}</span>`;
      elem.classList.add('noticed');
    }
  };

  this.closeAudioPlayer = function () {
    const divForAudio = document.querySelector('div.divForAudioHotspot');

    divForAudio.hidden = true;
    document.querySelector('audio.audio_hotspot').remove();
  };

  this.setThumbSizeAndCountMobile = function (w, h) {
    const bookSidebar = document.querySelector('#sidebar .Book__sidebar');
    
    if (!bookSidebar) {
      return;
    }

    const bookSidebarStyle = getComputedStyle(bookSidebar);
    const thumbs = bookSidebar.querySelectorAll('.thumbnail-item');
    let maxCols = 6, minCols = 2;
    let thumbsInRow = bookSidebarStyle.getPropertyValue('--thumbs-in-row') || maxCols;
    let thumbSize = thumbsOriginalSize;

    if (!bookSidebar || !thumbs.length) return;

    if (w && h) {
      thumbsOriginalSize = { w, h };
      thumbSize = thumbsOriginalSize;
    }

    if (APP.Book.isDoublePage()) {
      thumbSize = {
        w: thumbSize.w * 2,
        h: thumbSize.h
      }
    }

    thumbsInRow = parseInt(window.innerWidth / thumbSize.w) - 1;
    bookSidebar.style = `--thumbs-in-row: ${thumbsInRow <= minCols ? minCols : thumbsInRow > maxCols ? maxCols : thumbsInRow}`;
    bookSidebar.style.pointerEvents = 'all';

    // if (is_small_embed_not_mobile()) {
    //   bookSidebar.style.height = `${bookSidebar.parentNode.getBoundingClientRect().height}px`;
    // }

    if (APP.Book.isDoublePage()) { 
      let thumbsCount = parseInt(window.innerWidth / thumbsOriginalSize.w) - (thumbsInRow == 1 ? 1 : minCols);
      thumbsCount = (thumbsCount * thumbsOriginalSize.w + (20 * thumbsCount / 2) + 50) > window.innerWidth ? parseInt((thumbsCount - 1) / 2) : parseInt(thumbsCount / 2);
      const newWidth = ((window.innerWidth - (20 * thumbsCount) - 50) / thumbsCount) / 2;
      const ratio = Math.abs(thumbsOriginalSize.w - newWidth) * 100 / thumbsOriginalSize.w;
      const newHeight = thumbsOriginalSize.h + ratio * thumbsOriginalSize.h / 100;

      thumbs.forEach(item => {
        const thumbChildren = item.querySelectorAll('.thumb');
        
        if (thumbChildren && thumbChildren.length) {
          thumbChildren.forEach(child => {
            if (!child.getAttribute('data-page')) {
              child.style.width = `${newWidth}px`;
              child.style.height = `${newHeight}px`;
            }
          })
        }
        
        if (thumbChildren.length > 1) {
          thumbChildren[1].style.cssText = '';
        }
      })
    }
  }

  this.renderFocusPage = function (currentPage, prevPage) {
    if (!!prevPage) {
      if (prevPage == '1') {
        document
          .querySelector(
            `.Book__sidebar > div.thumbnail-item.bookSpread-1 > div.thumb .thumb-img-div .right-thumbnail`,
          )
          .classList.remove('thumbnail-focus', 'thumbnail-focus-borderleft');
      } else {
        if (is_horisontal()) {
          document
            .querySelector(
              `.Book__sidebar > div.thumbnail-item.bookSpread-${prevPage} > div.thumb .thumb-img-div .left-thumbnail`,
            )
            .classList.remove('thumbnail-focus');
        } else {
          document
            .querySelector(
              `.Book__sidebar > div.thumbnail-item.bookSpread-${prevPage} > div.thumb .thumb-img-div .right-thumbnail`,
            )
            .classList.remove('thumbnail-focus-borderleft');
        }
        document
          .querySelector(
            `.Book__sidebar > div.thumbnail-item.bookSpread-${prevPage} > div.thumb .thumb-img-div .right-thumbnail`,
          )
          .classList.remove('thumbnail-focus');
      }
    }

    if (currentPage == '1') {
      document
        .querySelector(
          `.Book__sidebar > div.thumbnail-item.bookSpread-1 > div.thumb .thumb-img-div .right-thumbnail`,
        )
        .classList.add('thumbnail-focus', 'thumbnail-focus-borderleft');
    } else {
      if (is_horisontal()) {
        document
          .querySelector(
            `.Book__sidebar > div.thumbnail-item.bookSpread-${currentPage} > div.thumb .thumb-img-div .left-thumbnail`,
          )
          .classList.add('thumbnail-focus');
      } else {
        document
          .querySelector(
            `.Book__sidebar > div.thumbnail-item.bookSpread-${currentPage} > div.thumb .thumb-img-div .right-thumbnail`,
          )
          .classList.add('thumbnail-focus-borderleft');
      }
      document
        .querySelector(
          `.Book__sidebar > div.thumbnail-item.bookSpread-${currentPage} > div.thumb .thumb-img-div .right-thumbnail`,
        )
        .classList.add('thumbnail-focus');
    }
    return currentPage;
  };

  this.testLeadToShow = function (bookModel, currentPage) {
    if (customizemode) return;

    const leadData = HELPER.getLocalStorageData('leadform', 'value');

    if (leadData && leadData.includes(bookModel.id) && !customizemode) return;
    if (bookModel.settings.lead_form_submited && !customizemode) return;

    const settings = bookModel.settings;

    if (!settings.lead_form_enabled) return;
      
    const pagelead = parseInt(settings.lead_form_page);
    let warunekstrony = currentPage >= pagelead;

    if (!warunekstrony) {
      if (!forceOnePage) {
        if (
          is_horisontal() &&
          currentPage !== 1 &&
          currentPage !== bookModel.pages &&
          !settings.showSinglePageMode
        ) {
          warunekstrony = currentPage + 1 >= pagelead;
        }
      }
    }

    if (warunekstrony) {
      APP.Book.showLeadFormModal();
    }
  };

  const createValidationError = (obj, errorType) => {
    const errorIndex = leadFormErrors.findIndex(item => item.element == obj);

    obj.classList.add('invalid')

    if (errorIndex === -1) {
      leadFormErrors.push({
        element: obj,
        errorType
      });

      return;
    }

    leadFormErrors[errorIndex].errorType = errorType;
  };

  const removeValidationError = (obj) => {
    const errorIndex = leadFormErrors.findIndex(item => item.element == obj);

    if (errorIndex === -1) return false;

    leadFormErrors.splice(errorIndex, 1);
    obj.classList.remove('invalid');

    return true;
  };

  const validateLeadFormFields = function (obj, errorElement) {
    const type = obj.dataset && obj.dataset.hasOwnProperty('type') ? obj.dataset.type : 'text';
    const REGEX = {
      email: /^[\w\-\.]+@([\w-]+\.)+[\w-]{2,}$/,
      phone: /^[+]{0,1}[0-9-\s()]+$/
    };

    if (!!obj.required && !obj.value.length) {
      createValidationError(obj, 'required');
      errorElement.textContent = APP._t('Lead Form Validation Required');
    } else if (!!obj.value.length && !obj.value.match(REGEX[type])) {
      createValidationError(obj, 'regex');
      errorElement.textContent = APP._t('Lead Form Validation Format');
    } else {
      removeValidationError(obj);
      errorElement.textContent = '';
    }

    return !leadFormErrors.length;
  };

  const getLeadFormModalName = () => {
    return is_mobile() ? '.lead-modal-mobile' : '.lead-modal';
  };

  const getLeadFormFields = (fileds) => {
    const defaultFields = [{
      'name': 'E-mail',
      'type': 'email',
      'required': true
    }, {
      'name': 'Phone Number',
      'type': 'phone', 
      'required':false
    }];

    try {
      if (fileds) return JSON.parse(fileds);

      return defaultFields;
    } catch (err) {
      console.log(`Error while parsing lead form data: ${err}`);
      return defaultFields;
    }
  };

  const createLeadFormModal = (modalName) => {
    let modal = document.querySelector(modalName);

    if (modal && !('template' in modal.dataset)) {
      return modal;
    }

    if (!modal) {
      modal = document.createElement('div');
      document.body.appendChild(modal);
    }

    modal.removeAttribute('data-template');
    modal.className = `${modalName.slice(1)} modal`;

    const container = document.createElement('div');

    container.className = `lead-modal__container modal__container`;
    container.innerHTML = `<div class="lead-modal-form"><div class="lead-modal-title"></div><div class="lead-modal-input-container"><div class="lead-modal-input"><input type="text" value="" name="input_1" placeholder="E-mail*"/></div><div class="lead-modal-input"><input type="text" value="" name="input_2" placeholder="Phone"/></div></div><div class="lead-modal-privacy"></div><div class="lead-modal-buttons"><button class="lead-modal__submit">${APP._t('Lead Form Submit')}</button><button class="lead-modal__skip">${APP._t('Lead Form Skip')}</button></div></div>`;

    if (modalName !== '.lead-modal-mobile') {
      container.insertAdjacentHTML('afterbegin', `<div class="lead-modal__image__wrapper"><img src="${APP.PATH_CF_FLIP}assets/images/lead/lead_bg.svg" class="lead-modal__image" alt="Lead form"></div>`);
    }

    if (customizemode) {
      const tooltip = document.createElement('div');
      
      tooltip.className = 'lead-modal-tooltip';
      tooltip.innerHTML = `<span>${APP._t('Lead Form Tooltip')}</span>`;
      
      container.querySelector('.lead-modal-buttons').appendChild(tooltip);
    }

    modal.appendChild(container);

    return modal;
  };

  this.prepareLeadForm = function (
    bookModel,
    _currentPage,
    trigeredByCustomize = false,
    trigeredBySetPage = false,
    extradata = false,
  ) {
    return;
    const modalName = getLeadFormModalName();
    const leadData = HELPER.getLocalStorageData('leadform', 'value');

    if (leadData && leadData.includes(bookModel.id) && !customizemode) {
      return;
    }

    if (bookModel.settings.lead_form_submited && !customizemode) {
      return;
    }

    if (!bookModel.settings.lead_form_enabled && !customizemode) {
      return;
    }

    const leadmodal = createLeadFormModal(modalName);
    const closeLeadModal = document.querySelector(`${modalName} .lead-modal__skip`);

    if (closeLeadModal) {
      closeLeadModal.addEventListener('click', function (e) {
        if (customizemode) {
          return;
        }

        if (HELPER.lead_send(bookModel, true)) {
          HELPER.hideLeadModal();
        }
      });
    }

    const submitLeadModal = document.querySelector(`${modalName} .lead-modal__submit`);
    if (submitLeadModal) {
      submitLeadModal.addEventListener('click', function (e) {
        if (this.disabled || customizemode) {
          return;
        } else {
          HELPER.lead_send(bookModel, false);
        }
      });
    }

    const settings = bookModel.settings;
    let haveRequiredForms = false;

    if (settings.lead_form_enabled && (!customizemode || trigeredByCustomize)) {
      // const leadmodal = document.querySelector('.lead-modal');
      let pagelead = parseInt(settings.lead_form_page);

      if ((leadmodal) || trigeredByCustomize) {
        document.querySelector(`${modalName} .lead-modal-input-container`).innerHTML = '';

        const fields = getLeadFormFields(bookModel.settings.lead_form_fields);

        if (fields.length > 0) {
          Array.prototype.forEach.call(fields, function (field) {
            const div = document.createElement('div');
            const errorElement = document.createElement('span');
            const input = document.createElement('input');
            const name = field['name'] ? field['name'] : '';

            div.className = 'lead-modal-input';
            errorElement.className = 'lead-modal-input-error';
            
            input.type = 'text';
            input.dataset.type = field.hasOwnProperty('type') && !!field['type'].length ? field['type'] : 'text';
            input.value = '';
            input.name = field['name'] ? field['name'] : '';
            input.placeholder = `${name} ${field['required'] ? '*' : ''}`;
            input.required = field['required'];
            
            if (field['required']) {
              haveRequiredForms = true;
            }

            input.addEventListener('input', (event) => {
              const target = event.target;

              if (!validateLeadFormFields(target, errorElement)) {
                document.querySelector(`${modalName} .lead-modal__submit`).disabled = true;
                return;
              } 

              const invalidinputs = document.querySelectorAll(
                `${modalName} .lead-modal-input input:required:invalid`,
              );

              if (invalidinputs.length > 0) {
                document.querySelector(`${modalName} .lead-modal__submit`).disabled = true;
              } else {
                document.querySelector(`${modalName} .lead-modal__submit`).disabled = false;
              }
            });

            div.appendChild(input);
            div.appendChild(errorElement);
            document.querySelector(`${modalName} .lead-modal-input-container`).appendChild(div);
          });
        }

        document.querySelector(`${modalName} .lead-modal-title`).innerHTML =
          typeof(settings.lead_form_caption) === 'string' 
            ? settings.lead_form_caption 
            : APP._t('Lead Form Caption Default');

        document.querySelector(`${modalName} .lead-modal__skip`).hidden =
          !settings.lead_form_allow_skip;
        
          if (haveRequiredForms) {
          document.querySelector(`${modalName} .lead-modal__submit`).disabled = true;
        }
        
        document.querySelector(`${modalName} .lead-modal__submit`).innerText = APP._t('Lead Form Submit');
        document.querySelector(`${modalName} .lead-modal__skip`).innerText = APP._t('Lead Form Skip');

        if (document.querySelector(`${modalName} .lead-modal-tooltip`)) {
          document.querySelector(`${modalName} .lead-modal-tooltip`).innerText = APP._t('Lead Form Tooltip');
        }

        if (settings.hasOwnProperty('lead_form_image_enabled') && !settings.lead_form_image_enabled) {
          document.querySelector(`${modalName} .lead-modal__container`).classList.add('lead-modal__container--simple');
        }
        
        let privacy = '';

        if (settings.lead_form_custom_policy && settings.lead_form_custom_policy_link !== '') {
          privacy = APP._t('Lead Form Privacy With Link', [settings.lead_form_custom_policy_link, 'https://publuu.com/privacy-statement/']);
        } else {
          privacy = APP._t('Lead Form Privacy', ['https://publuu.com/privacy-statement/']);
        }

        document.querySelector(`${modalName} .lead-modal-privacy`).innerHTML = privacy;

        console_log('LEAD FILLED');
      }
    }
  };

  //new
  this.pathToNoTxtImg = function (pageModel, size = is_mobile() ? 1200 : 1600) {
    var time_pat = Date.parse(pageModel.Book.getModel().published_at);
    if (isNaN(time_pat)) {
      time_pat = Date.parse(pageModel.Book.getModel().published_at.replace(/-/g, '/'));
    }
    
    if( pageModel.Book.getModel().is_demo === "1" || pageModel.Book.getModel().is_demo === 1 ){
      return `${APP.PATH_CLOUDFRONT_DEMO}/jpgs6/notxt/demo_${pageModel.model.page}_${size}.webp`;
    }

    if (pageModel.Book.getModel().cloudfront) {
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `/${pageModel.model.version}` : '';
      
      var rasterBackground = `${pageModel.Book.getModel().cloudfront}/${
        pageModel.model.publisherId
      }/${pageModel.model.bookId}${version}/notxt/${pageModel.model.bookId}_${
        pageModel.model.page
      }_${size}.webp`;
      
      //nova canva - wszyscy publishers 4001 
      if( !!parseInt(pageModel.Book.getModel().is_canva) 
        && 
        ( 
        pageModel.Book.getModel().cloudfront === "https://d37z9m6j5ll98s.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d32a0o2cdxgyed.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d1uiew9hysv4w7.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d2yzdrigfuozes.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d3h1nb5bjihg9w.cloudfront.net")
        )
      {
        rasterBackground = `${pageModel.Book.getModel().cloudfront}/4001/${pageModel.model.bookId}/notxt/${pageModel.model.bookId}_${
          pageModel.model.page
        }_${size}.webp`;
      }
      
      return rasterBackground;
    } else {
      return '';
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `&version=${pageModel.model.version}` : '';
      //todo classic
      return `${APP.PATH_V2IMAGE}?iid=${pageModel.model.bookId}&pid=${
        pageModel.model.publisherId
      }&page=${pageModel.model.page}&size=${size}&hidetext=1&webp=${
        pageModel.Book.useWebP() ? 1 : 0
      }${version}`;
    }
  };

  this.getSizeOfTxtImg2 = function (pageModel = null) {
    let size = 800;

    var bookHeight = pageModel ? pageModel.Book.getBookSize().bookHeight : APP.Book.getBookSize().bookHeight;
    var sizes = [800, 1200, 1600];

    if (is_retina()) {
      size = 1600;

      // size = bookHeight < 500 ? sizes[0] : sizes[2];
      if (bookHeight * 2 < 1000) {
        size = 800;
      } else if (bookHeight * 2 < 1400) {
        size = 1200;
      }
    } else {
      size = bookHeight < 800 ? sizes[0] : sizes[1];
    }

    return size;
  };

  this.pathToTxtImg2 = function (pageModel, size = false, second_try = false) {
    let ext = "webp";
    let time_pat = Date.parse(pageModel.Book.getModel().published_at);

    if (!size) {
      size = self.getSizeOfTxtImg2(pageModel);
    }
    
    if (second_try) {
      ext = "jpg";
    }

    if (isNaN(time_pat)) {
      time_pat = Date.parse(pageModel.Book.getModel().published_at.replace(/-/g, '/'));
    }
    
    if( pageModel.Book.getModel().is_demo === "1" || pageModel.Book.getModel().is_demo === 1 ){
      return `${APP.PATH_CLOUDFRONT_DEMO}/jpgs6/txt/demo_${pageModel.model.page}_${size}.${ext}`;
    }

    if (pageModel.Book.getModel().cloudfront_txt) {
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `/${pageModel.model.version}` : '';
      var rasterBackground = `${pageModel.Book.getModel().cloudfront_txt}/${
        pageModel.model.publisherId
      }/${pageModel.model.bookId}${version}/txt/${pageModel.model.bookId}_${
        pageModel.model.page
      }_${size}.${ext}`;
      //nova canva - wszyscy publishers 4001 
      
      if( !!parseInt(pageModel.Book.getModel().is_canva) 
        && 
        ( 
        pageModel.Book.getModel().cloudfront === "https://d37z9m6j5ll98s.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d32a0o2cdxgyed.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d1uiew9hysv4w7.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d2yzdrigfuozes.cloudfront.net"  ||
        pageModel.Book.getModel().cloudfront === "https://d3h1nb5bjihg9w.cloudfront.net"  ||
        pageModel.Book.getModel().cloudfront === "https://d3h1nb5bjihg9w.cloudfront.net"
        )
        
        )
      {
        rasterBackground = `${pageModel.Book.getModel().cloudfront_txt}/4001/${pageModel.model.bookId}/txt/${pageModel.model.bookId}_${
            pageModel.model.page
          }_${size}.${ext}`;
      }
      
      return rasterBackground;
    } else {
      return '';
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `&version=${pageModel.model.version}` : '';
      //todo classic
      var x = `${APP.PATH_V2IMAGE}?iid=${pageModel.model.bookId}&pid=${
        pageModel.model.publisherId
      }&page=${pageModel.model.page}&size=${size}&hidetext=0&webp=${
        pageModel.Book.useWebP() ? 1 : 0
      }${version}`;
      return x;
    }
  };
  
  //STATIC request for image
  this.getPageImageWithTxtUrl = function (page, size = 400) {
    const _bookModel = APP.Book.getModel();
    const publisherId = Boolean(parseInt(_bookModel.is_canva)) ? 4001 : _bookModel.publisher_id;
    var time_pat = Date.parse(APP.Book.publishedAt);
    
    if (isNaN(time_pat)) {
      time_pat = Date.parse(_bookModel.published_at.replace(/-/g, '/'));
    }
    
    if( _bookModel.is_demo === "1" || _bookModel.is_demo === 1 ){
      return `${APP.PATH_CLOUDFRONT_DEMO}/jpgs6/txt/demo_${page}_${size}.webp`;
    }
    
    if (!!_bookModel.cloudfront_txt) {
      var ext = APP.Book.useWebP() ? 'webp' : 'jpg';
      let version = Number(_bookModel.version) && Number(_bookModel.version) > 0 ? `/${_bookModel.version}` : '';
      var path = `${_bookModel.cloudfront_txt}/${publisherId}/${_bookModel.id}${version}/txt/${_bookModel.id}_${page}_${size}.${ext}`;
      return path;
    } else {
      return '';
      const WEBP = `&webp=${APP.Book.useWebP() ? 1 : 0}`;
      let version = Number(_bookModel.version) && Number(_bookModel.version) > 0 ? `&version=${_bookModel.version}` : '';

      return (
        APP.PATH_V2IMAGE +
        `?thumb=1&size=${size}&hidetext=0&iid=${_bookModel.id}&page=${page}&pid=${
          _bookModel.publisher_id
        }${is_retina() ? '&retina' : ''}${version}${WEBP}`
      );
    }
  };

  this.pathToSvg = function (pageModel) {
    var time_pat = Date.parse(pageModel.Book.getModel().published_at);
    if (isNaN(time_pat)) {
      time_pat = Date.parse(pageModel.Book.getModel().published_at.replace(/-/g, '/'));
    }

    if( pageModel.Book.getModel().is_demo === "1" || pageModel.Book.getModel().is_demo === 1 ){
      return `${APP.PATH_CLOUDFRONT_DEMO}/jpgs6/svg/demo_${pageModel.model.page}.svg`;
    }
    
    if (pageModel.Book.getModel().cloudfront) {
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `/${pageModel.model.version}` : '';
      
      var rasterBackground = `${pageModel.Book.getModel().cloudfront}/${
        pageModel.model.publisherId
      }/${pageModel.model.bookId}${version}/svg/${pageModel.model.bookId}_${
        pageModel.model.page
      }.svg`;
      
      //nova canva - wszyscy publishers 4001 
      if( !!parseInt(pageModel.Book.getModel().is_canva) 
        && 
        ( 
        pageModel.Book.getModel().cloudfront === "https://d37z9m6j5ll98s.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d32a0o2cdxgyed.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d1uiew9hysv4w7.cloudfront.net"  || 
        pageModel.Book.getModel().cloudfront === "https://d2yzdrigfuozes.cloudfront.net"  ||
        pageModel.Book.getModel().cloudfront === "https://d3h1nb5bjihg9w.cloudfront.net"
        )
        )
      {
        rasterBackground = `${pageModel.Book.getModel().cloudfront}/4001/${pageModel.model.bookId}/svg/${pageModel.model.bookId}_${
          pageModel.model.page
        }.svg`;
      }
      
      
      return rasterBackground;
    } else {
      let version = Number(pageModel.model.version) && Number(pageModel.model.version) > 0 ? `&v=${pageModel.model.version}` : '';
      //todo classic
      return `${APP.PATH_V2SVG}?iid=${pageModel.model.bookId}&pid=${pageModel.model.publisherId}&page=${pageModel.model.page}${version}`;
    }
  };

  this.setLocalStorageData = function (name, value, days) {
    if( !HELPER.isLocalStorageAvailable() ){
        console_log("LocalStorage is not available");
        return;
      }
      
    var expires = '';
    if (days) {
      var date = new Date();
      date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);
      expires = date.toUTCString();
    }

    let newData = {
      
      value: value || '',
      expires: expires,
      path: '/',
      secure: true,
    };

    if (name === 'leadform') {
      const localItem = JSON.parse(localStorage.getItem(name));
      if (localItem) {
        newData = {
          value: !!localItem.value ? localItem.value + value : value,
          expires: expires,
          path: '/',
          secure: true,
        };
      }
    }

    localStorage.setItem(
      name,
      JSON.stringify({
        ...newData,
        sameSite: 'None',
      }),
    );

    localStorage.setItem(
      `${name}_crosssafari`,
      JSON.stringify({
        ...newData,
        crossSite: 'None',
      }),
    );

    localStorage.setItem(`${name}_safari`, JSON.stringify(newData));
  };

  this.getLocalStorageData = function (cname, key = null) {
    if( !this.isLocalStorageAvailable() ){
      console_log("LocalStorage is not available");
      return false;
    }
    
    let decodedStorage = JSON.parse(localStorage.getItem(cname));

    if (!decodedStorage) {
      return null;
    }
    
    if (!key) {
      return decodedStorage;
    }

    return decodedStorage[key] || '';
  };

  this.getLocalStorageProducts = (bookId) => {
    const books = self.getLocalStorageData('_products');

    if (!books) {
      return false;
    }

    const currentBook = books.find(item => item.bookId == bookId);

    if (!currentBook) {
      return false;
    }

    if (!currentBook.hasOwnProperty('products') || !Array.isArray(currentBook.products) || !!!currentBook.products.length) {
      return false;
    }
    
    return currentBook.products;
  };

  this.sidebar_setStylesForEmbedFullscreen = function (fullscreenState) {
    const sidebarsSelectors = ['#sidebar', '#sidebarTOC', '#sidebarSearch', '#sidebarWishlist'];

    sidebarsSelectors.forEach(sidebarsSelector => {
      const sidebar = document.querySelector(sidebarsSelector);

      if (!sidebar) return;

      // sidebar.style.top = fullscreenState ? '45px' : '0px';
      sidebar.style.width = fullscreenState ? '320px' : '100%';

      const sidebarHeader = sidebar.querySelector('.sidebar__header');

      if (!sidebarHeader) return;

      // sidebarHeader.style.display = fullscreenState ? 'none' : 'flex';
    });
  };

  this.sidebar_setStylesForMobile = function () {
    const sidebarsSelectors = ['#sidebar', '#sidebarTOC', '#sidebarSearch', '#sidebarWishlist'];

    sidebarsSelectors.forEach(sidebarsSelector => {
      const sidebar = document.querySelector(sidebarsSelector);

      if (!sidebar) return;

      sidebar.style.top = '0px';
      sidebar.style.width = (!embedmode || is_small_embed_not_mobile()) ? '100%' : '0px';

      const sidebarHeader = sidebar.querySelector('.sidebar__header');

      if (!sidebarHeader) return;

      sidebarHeader.style.display = 'flex';
      sidebarHeader.style.fontSize = '17px';
      sidebarHeader.style.background = 'rgba(0,0,0,0.1)';
    });
  };

  this.getThumbDiv = function (w, h, value, className, thumbInConverting = false) {
    if (thumbInConverting) {
      return `
      <div class="thumb pageNumb-${value.getPageNumber()}" style="height: ${h}"> 
          <div class="thumb-img-div"  style="width: ${w}; height: ${h};">
              <img class="thumb-img" style="width: ${w}; height: ${h};object-fit: contain;" loading="lazy" pagenum='${value.getPageNumber()}' 
                pageReady='true' src='../../../assets/images/thumb_ph.png'/>
              <div class="thumbX" style="width: ${w}; height: ${h};"></div>
          </div>
          <div class="thumbnail-number">${value.getPageNumber()}</div>
      </div>`;
    }

    var i = new Image();
    const classPlace = `.thumb.pageNumb-${value.getPageNumber()} .thumb-img-div .thumbX`;

    i.onload = function () {
      document.querySelector(classPlace).classList.add(className);
      createEvent('adjust-scrollbar', {}, true);
    };
    let _src = value.getCoverThumb();
    i.src = value.getCoverThumb();
    return `
            <div class="thumb pageNumb-${value.getPageNumber()}" style="height: ${h}"> 
                <div class="thumb-img-div"  style="width: ${w}; height: ${h};">
                    <img class="thumb-img" style="width: ${w}; height: ${h};object-fit: contain;" loading="lazy" pagenum='${value.getPageNumber()}' 
                      pageReady='true' src='${value.getCoverThumb()}'/>
                    <div class="thumbX" style="width: ${w}; height: ${h};"></div>
                </div>
                <div class="thumbnail-number">${value.getPageNumber()}</div>
            </div>`;
  };

  this.arrow =
    '<svg version="1.1" id="Layer_2" xmlns="http://www.w3.org/2000/svg" \n\
xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 700 700" style="enable-background:new 0 0 700 700;" xml:space="preserve">\n\
<style type="text/css">.arrow{stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:15.1181;}</style><g id="g2193" transform="translate(-19.843749,257.14192)">\n\
<path id="path1803-1-2" class="arrow" d="M218.5,95.1c63.7,93.1,127.5,186.3,191.2,279.4"/><path id="path1805-1-8" class="arrow" d="M218.5,95.1l191.2-279.8"/></g></svg>';

  this.headerLogoDefault = window.location.href.includes('pdf-flipbook.com')
    ? `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" alt="Create flipbook with Online Flipbook Maker"
	 viewBox="0 0 610.1 157.5"  xml:space="preserve" style="enable-background:new 0 0 610.1 157.5; height: 100%;max-width:100%;opacity:0.8;">
    <style type="text/css">
	.st_logo{fill:currentColor;}
</style>
<path d="M109,34l-0.5-0.1v-5.4c0-5.7-3.9-10.2-9.1-10.4H99v-0.5C98.9,11.8,94.3,7,88.4,6.9c-1.1,0-2.2,0.2-3.3,0.6L36.7,24.1
	c-4.4,1.6-7.3,5.9-7.1,10.6v86.7c-0.1,1.9,0.4,3.9,1.3,5.6c1.7,3.7,4.9,6.4,8.8,7.6l49.6,14.2c1.3,0.4,2.6,0.6,4,0.6
	c5.3,0,10.2-3,12.7-7.7l0.1-0.3h1.4c5.5,0.1,10-4.2,10.1-9.7c0-0.1,0-0.3,0-0.4V45.5C117.5,40.6,113.9,35.8,109,34z M86.3,11
	c0.7-0.2,1.4-0.4,2.1-0.4c3.9,0.2,7,3.4,7,7.3v0.5l-43.7,4.4L86.3,11z M98.3,21.8c3.6-0.4,6.2,2.7,6.2,6.7v4.6l-54.4-6.6L98.3,21.8z
	 M103.5,135c0.1,5.9-4.6,10.7-10.5,10.8c0,0-0.1,0-0.1,0c-1,0-2-0.1-2.9-0.4l-49.7-14.2c-4.6-1.3-7.9-5.6-7.9-10.4V35.3
	c0-3,2.4-5.4,5.4-5.4c0.5,0,0.9,0.1,1.4,0.2L73,44.3L52.5,59.9c-2.4,1.9-3.9,4.7-4.2,7.7c-0.3,3,0.8,6,3,8.2l52,51.7v7.5L103.5,135z
	 M76,46.8l25.4,73.1L54.3,73.2c-1.4-1.4-2.2-3.4-2.1-5.4c0.1-2,1.1-3.9,2.7-5.1L76,46.8z M113.5,131.5c0.2,3.3-2.4,6.2-5.7,6.4
	l-0.6,0.1l0.1-0.6c0.1-0.8,0.2-1.5,0.2-2.3v-8c0-0.4-0.1-0.9-0.2-1.3L78.6,43.2c0-0.1,0-0.1-0.1-0.1l0,0c0-0.1-0.1-0.1-0.1-0.2
	l-0.1-0.1c-0.1-0.1-0.1-0.2-0.2-0.3l-0.2-0.2l-0.1-0.1c-0.1,0-0.1-0.1-0.2-0.1L77.5,42L48.7,29.9l57,6.9c4.4,0.6,7.6,4.3,7.7,8.7v86
	L113.5,131.5z" class='st_logo'/>
<path d="M195.4,55.9c-1.1-1.5-2.5-2.8-4.2-3.7c-1.6-0.8-3.5-1.3-5.3-1.3c-1.2,0-2.4,0.1-3.6,0.4c-1.1,0.3-2.1,0.6-3.1,1.1
	c-0.9,0.5-1.8,1.1-2.7,1.7c-0.8,0.7-1.6,1.4-2.3,2.2l-0.6,0.7l-1.1-3.9c-0.3-1.1-1.2-1.8-2.3-1.8h-6.7v50h11V86.1l0.6,0.7
	c1,0.9,2.1,1.7,3.3,2.2c1.6,0.6,3.2,0.8,4.9,0.8c2.3,0,4.5-0.5,6.5-1.5c1.9-1,3.6-2.4,5-4.1c1.5-1.8,2.6-3.9,3.3-6.2
	c0.8-2.6,1.2-5.2,1.2-7.9c0-2.8-0.3-5.5-1-8.2C197.7,59.8,196.7,57.8,195.4,55.9z M187.8,75.6c-0.3,1.3-0.9,2.6-1.6,3.8
	c-0.6,0.9-1.5,1.7-2.5,2.2c-1,0.5-2,0.7-3.1,0.7c-1.2,0-2.3-0.2-3.4-0.6c-1.1-0.5-2.1-1.2-2.8-2.2l0.1-0.1V62.7l-0.1-0.1
	c0.5-0.6,0.9-1.1,1.4-1.6c0.5-0.5,1.1-0.9,1.7-1.2c0.6-0.3,1.3-0.6,2-0.7c0.8-0.2,1.6-0.3,2.4-0.3c0.9,0,1.9,0.2,2.7,0.6
	c0.9,0.5,1.6,1.2,2.1,2c0.6,1.1,1.1,2.3,1.3,3.5c0.3,1.7,0.5,3.5,0.5,5.2C188.5,72,188.2,73.8,187.8,75.6L187.8,75.6z" class='st_logo'/>
<path d="M229.5,54.6l-0.8-0.7c-1.1-0.9-2.3-1.6-3.6-2.2c-1.5-0.6-3.2-0.9-4.8-0.8c-4.5,0-8.8,2-11.5,5.6c-1.5,1.8-2.6,3.9-3.3,6.2
	c-0.8,2.5-1.2,5.2-1.2,7.8c-0.1,2.8,0.3,5.5,1,8.2c0.6,2.2,1.5,4.2,2.8,6c1.1,1.5,2.5,2.8,4.2,3.7c1.6,0.8,3.5,1.3,5.3,1.3
	c1.2,0,2.4-0.1,3.5-0.4c1.1-0.2,2.1-0.6,3-1.1c0.9-0.5,1.8-1,2.6-1.7c0.8-0.7,1.6-1.4,2.4-2.2l0.6-0.6l1.1,3.8
	c0.3,1,1.2,1.7,2.3,1.6h7.1v-55h-11v20.5L229.5,54.6z M229.5,78l-0.1,0.1c-0.5,0.6-1,1.1-1.6,1.6c-0.5,0.5-1.1,0.9-1.7,1.2
	c-0.6,0.3-1.3,0.6-2,0.7c-0.8,0.2-1.6,0.3-2.4,0.3c-0.9,0-1.9-0.2-2.7-0.6c-0.9-0.5-1.6-1.2-2.1-2c-0.6-1.1-1.1-2.3-1.3-3.5
	c-0.3-1.7-0.5-3.5-0.5-5.2c0-1.9,0.2-3.7,0.6-5.5c0.3-1.3,0.9-2.6,1.6-3.8c0.6-0.9,1.5-1.7,2.5-2.2c2.1-0.9,4.4-0.9,6.5-0.1
	c1.2,0.4,2.2,1.2,3,2.1l0.1,0.1V78H229.5z" class='st_logo'/>
<path d="M266.6,35c-2.1-0.1-4.3,0.3-6.3,1c-1.7,0.6-3.3,1.6-4.7,2.8c-1.3,1.2-2.3,2.7-3,4.4c-0.7,1.8-1.1,3.8-1.1,5.8v3.2h-5v3.5
	c-0.1,0.5,0.1,1.1,0.5,1.5c0.5,0.4,1.1,0.7,1.7,0.8l2.8,0.6v30.6h11v-31h8v-6h-9v-2.8c0-1.1,0.2-2.2,0.6-3.3
	c0.3-0.8,0.7-1.6,1.4-2.2c0.6-0.6,1.4-1,2.2-1.2c0.9-0.2,1.9-0.3,2.8-0.3c0.3,0,0.6,0,0.9-0.1c0.3-0.1,0.5-0.2,0.8-0.3
	c0.2-0.1,0.4-0.3,0.5-0.5c0.1-0.2,0.2-0.5,0.2-0.7l0.2-5.2c-0.7-0.2-1.3-0.3-2-0.4C268.3,35.1,267.4,35,266.6,35z"  class='st_logo'/>
<rect x="275.5" y="63.2" width="19" height="8" class='st_logo'/>
<path d="M321.5,35c-2.1-0.1-4.3,0.3-6.3,1c-1.7,0.6-3.3,1.6-4.7,2.8c-1.3,1.2-2.3,2.7-3,4.4c-0.7,1.8-1.1,3.8-1.1,5.8v3.2h-5v3.5
	c0,0.7,0,1.1,0.4,1.5c0.5,0.4,1.1,0.7,1.8,0.8l2.8,0.6v30.6h11v-31h8v-6h-9v-2.8c0-1.1,0.2-2.2,0.5-3.3c0.3-0.8,0.7-1.6,1.4-2.2
	c0.6-0.6,1.4-1,2.2-1.2c0.9-0.2,1.9-0.3,2.8-0.3c0.3,0,0.6,0,0.9-0.1c0.3-0.1,0.5-0.2,0.8-0.3c0.2-0.1,0.4-0.3,0.5-0.5
	c0.1-0.2,0.2-0.5,0.2-0.7l0.2-5.2c-0.7-0.2-1.3-0.3-2-0.4C323.1,35.1,322.3,35,321.5,35z" class='st_logo'/>
<rect x="333.5" y="34.2" width="10" height="55" class='st_logo'/>
<rect x="353.5" y="51.2" width="10" height="38" class='st_logo'/>
<path d="M363,36.2c-0.6-0.6-1.3-1-2.1-1.3c-0.8-0.3-1.6-0.5-2.5-0.5c-0.8,0-1.6,0.2-2.4,0.5c-0.7,0.3-1.4,0.8-2,1.3
	c-0.6,0.6-1.1,1.3-1.4,2c-0.3,0.8-0.5,1.6-0.5,2.4c0,0.8,0.2,1.6,0.5,2.4c0.3,0.7,0.8,1.4,1.4,2c1.9,1.8,4.6,2.3,7,1.3
	c0.8-0.3,1.5-0.8,2.1-1.3c0.6-0.6,1.1-1.2,1.4-2c0.7-1.5,0.7-3.3,0-4.8C364.1,37.5,363.6,36.8,363,36.2z"  class='st_logo'/>
<path d="M405.4,55.9c-1.1-1.5-2.5-2.8-4.2-3.7c-1.6-0.8-3.5-1.3-5.3-1.3c-1.2,0-2.4,0.1-3.6,0.4c-1.1,0.3-2.1,0.6-3.1,1.1
	c-0.9,0.5-1.8,1.1-2.7,1.7c-0.8,0.7-1.6,1.4-2.3,2.2l-0.6,0.7l-1.1-3.9c-0.3-1.1-1.2-1.8-2.3-1.8h-6.7v50h11V86.1l0.6,0.7
	c1,0.9,2.2,1.7,3.4,2.2c1.6,0.6,3.2,0.8,4.9,0.8c2.3,0,4.5-0.5,6.5-1.5c1.9-1,3.6-2.4,5-4.1c1.5-1.8,2.6-3.9,3.3-6.2
	c0.8-2.6,1.2-5.2,1.2-7.9c0-2.8-0.3-5.5-1-8.2C407.7,59.8,406.7,57.7,405.4,55.9z M397.8,75.6c-0.3,1.3-0.9,2.6-1.6,3.8
	c-0.6,0.9-1.5,1.7-2.5,2.2c-1,0.5-2,0.7-3.1,0.7c-1.2,0-2.3-0.2-3.4-0.6c-1.1-0.5-2.1-1.2-2.8-2.2l0.1-0.1V62.7l-0.1-0.1
	c0.5-0.6,0.9-1.1,1.4-1.6c0.5-0.5,1.1-0.9,1.7-1.2c0.6-0.3,1.3-0.6,2-0.7c0.8-0.2,1.6-0.3,2.4-0.3c0.9,0,1.9,0.2,2.7,0.6
	c0.9,0.5,1.6,1.2,2.1,2c0.6,1.1,1.1,2.3,1.3,3.5c0.3,1.7,0.5,3.5,0.5,5.2C398.5,72,398.2,73.8,397.8,75.6L397.8,75.6z"  class='st_logo'/>
<path d="M448.1,56c-1.2-1.5-2.7-2.8-4.4-3.7c-1.8-0.9-3.7-1.3-5.7-1.3c-2,0-3.9,0.4-5.7,1.2c-1.8,0.9-3.4,2-4.8,3.3l-1,0.8V34.2h-10
	v55h6.9c0.5,0,1-0.1,1.5-0.4c0.4-0.4,0.7-0.9,0.8-1.4l0.6-2.9l0.7,0.7c0.5,0.6,1.2,1.3,1.8,1.8c0.6,0.5,1.3,1,2,1.4
	c0.8,0.4,1.6,0.7,2.4,0.9c1,0.2,2,0.3,3,0.3c4.5,0.1,8.7-1.9,11.4-5.5c1.5-1.9,2.6-4.1,3.3-6.4c0.8-2.7,1.2-5.5,1.2-8.3
	c0-2.6-0.3-5.2-1-7.7C450.4,59.7,449.4,57.8,448.1,56z M440.5,75.6c-0.3,1.4-0.8,2.7-1.6,3.8c-0.7,0.9-1.6,1.7-2.6,2.2
	c-1,0.4-2.1,0.7-3.2,0.7c-1.1,0-2.2-0.2-3.3-0.6c-1.2-0.4-2.3-1.2-3.1-2.2l-0.2-0.1V62.7l0.2-0.1c0.9-1.1,2-2.1,3.3-2.8
	c1.2-0.7,2.6-1.1,4-1c1.1,0,2.1,0.2,3.1,0.6c0.9,0.4,1.7,1.1,2.3,2c0.6,1.1,1.1,2.3,1.3,3.5c0.3,1.6,0.4,3.3,0.4,5
	C441.1,71.8,440.9,73.8,440.5,75.6z"  class='st_logo'/>
<path d="M489.9,56.2c-1.7-1.7-3.8-3-6-3.8c-2.5-0.9-5.1-1.3-7.8-1.3c-2.7,0-5.4,0.4-7.9,1.3c-2.3,0.9-4.3,2.2-6.1,3.8
	c-1.7,1.7-3,3.7-3.9,6c-1.9,5.2-1.9,10.9,0,16.1c1.7,4.6,5.4,8.3,10,10c5.1,1.9,10.6,1.9,15.7,0c2.3-0.9,4.3-2.2,6-3.9
	c1.7-1.7,3.1-3.8,3.9-6.1c1-2.6,1.4-5.3,1.4-8.1c0-2.7-0.4-5.4-1.4-8C492.9,60,491.5,58,489.9,56.2z M482.3,79.2c-1.3,2-3.4,3-6.3,3
	c-2.5,0.2-4.9-1-6.4-3c-1.3-1.9-2-4.9-2-8.8s0.7-6.8,2-8.8c2.9-3.5,8.1-4,11.6-1.1c0.4,0.3,0.8,0.7,1.1,1.1c1.3,1.9,2,4.9,2,8.8
	S483.6,77.2,482.3,79.2L482.3,79.2z"  class='st_logo'/>
<path d="M505.3,84.5c1.7,1.7,3.8,3.1,6.1,3.9c5.1,1.9,10.6,1.9,15.7,0c2.3-0.9,4.3-2.2,6-3.9c1.7-1.7,3.1-3.8,3.9-6.1
	c1-2.6,1.4-5.3,1.4-8.1c0-2.7-0.4-5.4-1.4-8c-0.8-2.3-2.2-4.3-3.9-6c-1.7-1.7-3.8-3-6-3.8c-2.5-0.9-5.1-1.3-7.8-1.3
	c-2.7,0-5.4,0.4-7.9,1.3c-2.3,0.9-4.3,2.2-6.1,3.8c-1.7,1.7-3,3.7-3.9,6c-1.9,5.2-1.9,10.9,0,16.1C502.3,80.7,503.6,82.8,505.3,84.5
	z M512.8,61.6c2.9-3.5,8.1-4,11.6-1.1c0.4,0.3,0.8,0.7,1.1,1.1c1.3,1.9,2,4.9,2,8.8s-0.7,6.8-2,8.8s-3.4,3-6.3,3
	c-2.5,0.2-4.9-1-6.4-3c-1.3-1.9-2-4.9-2-8.8S511.5,63.5,512.8,61.6z"  class='st_logo'/>
<path d="M555.5,72.2h2.8c0.6,0,1.3,0.1,1.9,0.3c0.6,0.3,1,0.8,1.3,1.4l7.3,13.6c0.3,0.6,0.7,1,1.3,1.3c0.6,0.3,1.3,0.4,2,0.4h9.5
	l-10.4-17.7c-0.4-0.7-0.8-1.3-1.3-1.8c-0.4-0.5-0.9-1-1.5-1.4l-0.6-0.4l0.6-0.4c1.2-0.8,2.3-1.9,3.2-3.1l9.4-13.1h-9.5
	c-0.7,0.1-1.4,0.3-2,0.6c-0.6,0.4-1,0.8-1.4,1.4l-7.3,10.9c-0.3,0.6-0.8,1.1-1.3,1.5c-0.6,0.4-1.2,0.7-1.9,0.7h-2.1v-32h-10v55h10
	V72.2z"  class='st_logo'/>
<path d="M493.1,117.2c-0.2-0.3-0.6-0.5-0.9-0.6c-0.3-0.2-0.7-0.2-1.1-0.2c-0.4,0-0.7,0.1-1.1,0.2c-0.7,0.3-1.2,0.8-1.5,1.5
	c-0.3,0.7-0.3,1.5,0,2.2c0.1,0.3,0.3,0.7,0.6,0.9c0.2,0.3,0.5,0.5,0.9,0.6c0.7,0.3,1.5,0.3,2.2,0c0.7-0.3,1.2-0.8,1.5-1.5
	c0.3-0.7,0.3-1.5,0-2.2C493.6,117.8,493.4,117.5,493.1,117.2z"  class='st_logo'/>
<path d="M513.3,117c-0.3,0.2-0.7,0.5-1.1,0.8c-0.5,0.4-1.1,0.6-1.7,0.8c-0.8,0.3-1.7,0.4-2.6,0.4c-1,0-2-0.2-2.9-0.6
	c-0.9-0.4-1.6-1-2.2-1.8c-0.6-0.9-1.1-1.9-1.4-2.9c-0.3-1.2-0.5-2.5-0.5-3.8c0-1.2,0.1-2.5,0.4-3.7c0.3-1,0.8-2,1.4-2.9
	c0.6-0.8,1.4-1.4,2.3-1.9c1-0.4,2-0.6,3.1-0.6c0.8,0,1.6,0.1,2.3,0.3c0.6,0.2,1.1,0.4,1.6,0.7c0.4,0.2,0.8,0.5,1.1,0.6
	c0.3,0.2,0.6,0.3,0.9,0.2l0.4-0.4l1.1-1.5c-0.9-0.8-2-1.5-3.1-2c-1.4-0.5-3-0.8-4.5-0.8c-1.6,0-3.3,0.3-4.8,0.9
	c-1.3,0.6-2.5,1.4-3.5,2.5c-1,1.1-1.7,2.4-2.1,3.8c-0.5,1.6-0.7,3.2-0.7,4.9c0,1.8,0.3,3.5,0.8,5.2c0.5,1.4,1.2,2.7,2.2,3.8
	c0.9,1,2,1.8,3.3,2.3c1.3,0.5,2.7,0.8,4.1,0.8c0.8,0,1.7-0.1,2.5-0.2c0.8-0.1,1.6-0.3,2.4-0.6c0.8-0.3,1.5-0.7,2.2-1.2
	c0.6-0.4,1.1-0.9,1.6-1.4l-1.2-1.6C514.4,116.7,513.7,116.7,513.3,117z"  class='st_logo'/>
<path d="M537.7,101.1c-1-1-2.3-1.8-3.6-2.4c-1.5-0.6-3.1-0.9-4.7-0.8c-1.6,0-3.2,0.3-4.7,0.8c-1.3,0.6-2.6,1.4-3.6,2.4
	c-1.1,1.1-1.8,2.4-2.3,3.8c-1.1,3.3-1.1,6.9,0,10.2c0.5,1.4,1.2,2.7,2.3,3.8c1,1,2.3,1.8,3.6,2.4c1.5,0.6,3.1,0.9,4.7,0.8
	c1.6,0,3.2-0.3,4.7-0.8c1.3-0.6,2.6-1.4,3.6-2.4c1-1.1,1.8-2.4,2.3-3.8c1.1-3.3,1.1-6.9,0-10.2C539.5,103.5,538.8,102.2,537.7,101.1
	z M534.8,116.6c-1.3,1.6-3.2,2.5-5.3,2.4c-2.1,0.1-4.1-0.8-5.4-2.4c-1.2-2-1.8-4.3-1.7-6.6c-0.1-2.4,0.5-4.7,1.7-6.7
	c1.3-1.6,3.3-2.5,5.4-2.4c2.1-0.2,4.1,0.7,5.3,2.4c1.2,2,1.8,4.3,1.7,6.7C536.6,112.3,536,114.6,534.8,116.6z"  class='st_logo'/>
<path d="M576.3,100.1c-0.7-0.7-1.6-1.3-2.5-1.7c-1.1-0.4-2.2-0.6-3.3-0.6c-1.5,0-3,0.4-4.4,1.1c-0.6,0.4-1.3,0.9-1.8,1.4
	c-0.5,0.6-1,1.3-1.3,2l-0.5,1.2l-0.4-1.3c-0.2-0.7-0.5-1.3-0.9-1.9c-0.3-0.5-0.7-1-1.2-1.4c-0.5-0.4-1-0.7-1.6-0.9
	c-1.3-0.4-2.6-0.4-3.9-0.1c-0.6,0.2-1.2,0.4-1.7,0.7c-0.5,0.3-1,0.6-1.5,1c-0.5,0.4-0.9,0.9-1.3,1.4l-0.7,0.8l-0.5-3.2
	c-0.1-0.4-0.4-0.6-0.8-0.6h-2.5v23h4v-17.2l0.2-0.1c0.7-0.8,1.5-1.5,2.4-2.1c0.9-0.5,1.9-0.8,2.9-0.8c1.3-0.1,2.5,0.4,3.4,1.4
	c0.8,0.9,1,2.4,1,4.3v14.7h5v-14.6c-0.1-0.8,0-1.6,0.2-2.4c0.2-0.7,0.6-1.3,1-1.8c0.4-0.5,1-0.9,1.6-1.1c0.6-0.2,1.3-0.4,2-0.4
	c1.4-0.1,2.8,0.5,3.8,1.5c0.9,1.2,1.4,2.7,1.4,4.2v14.6h4v-14.6c0-1.3-0.2-2.6-0.6-3.8C577.5,101.8,577,100.9,576.3,100.1z"  class='st_logo'/>
</svg>`
    : `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" alt="Create flipbook with Online Flipbook Maker"
	 viewBox="0 0 788 176" style="enable-background:new 0 0 788 176;height: 100%;max-width:100%;opacity:0.8;" xml:space="preserve">
<style type="text/css">
	.st_logo{fill:currentColor;}
</style>
<g>
	<path class="st_logo" d="M375.6,57.3c-11.2,0-21.2,5.8-27.2,14.5V60h-5.3v96h5.3v-49c5.9,8.7,15.9,14.5,27.2,14.5
		c17.8,0,32.2-14.4,32.2-32.2S393.4,57.3,375.6,57.3z M375.9,116.4c-14.9,0-26.9-12.1-26.9-26.9s12.1-26.9,26.9-26.9
		s26.9,12.1,26.9,26.9S390.8,116.4,375.9,116.4z"/>
	<path class="st_logo" d="M538.7,57.3c-11.2,0-21.2,5.8-27.2,14.5V23.1h-5.3v96h5.3v-12.2c5.9,8.7,15.9,14.5,27.2,14.5
		c17.8,0,32.2-14.4,32.2-32.2S556.5,57.3,538.7,57.3z M539,116.4c-14.9,0-26.9-12.1-26.9-26.9s12.1-26.9,26.9-26.9
		s26.9,12.1,26.9,26.9S553.9,116.4,539,116.4z"/>
	<rect x="590.5" y="23.2" class="st_logo" width="5.3" height="96"/>
	<path class="st_logo" d="M758.9,60v26.4c0,11.4-1.6,18.1-5.9,22.6c-6.1,6.2-14.1,7.6-20,7.6s-14.4-1.4-20.4-7.6
		c-4.3-4.5-6.4-11.2-6.4-22.6V60h-5.3v26.4c0,12.8,2.6,20.6,8,26.2c5.8,6,14.3,9.2,24.1,9.2h0.2c9.8-0.1,17.8-3.2,23.5-9.2
		c6.7-7,7.3-17.2,7.3-26.2V60H758.9z"/>
	<path class="st_logo" d="M674.6,86.4L674.6,86.4c0.1,11.4-1.5,18.1-5.8,22.6c-6.1,6.2-14.1,7.6-20,7.6s-14.4-1.4-20.4-7.6
		c-4.3-4.5-6.4-11.2-6.4-22.6V60h-5.3v26.4c0,12.8,2.6,20.6,8,26.2c5.8,6,14.3,9.2,24.1,9.2h0.2c9.8-0.1,17.8-3.2,23.5-9.2
		c6.7-7,7.3-17.2,7.3-26.2V60h-5.3v26.4H674.6z"/>
	<path class="st_logo" d="M481.3,86.4L481.3,86.4c0.1,11.4-1.5,18.1-5.8,22.6c-6.1,6.2-14.1,7.6-20,7.6s-14.4-1.4-20.4-7.6
		c-4.3-4.5-6.4-11.2-6.4-22.6V60h-5.3v26.4c0,12.8,2.6,20.6,8,26.2c5.8,6,14.3,9.2,24.1,9.2h0.2c9.8-0.1,17.8-3.2,23.5-9.2
		c6.7-7,7.3-17.2,7.3-26.2V60h-5.3L481.3,86.4L481.3,86.4z"/>
	<path class="st_logo" d="M40.2,93.2c-0.9-0.9-2.1-1.6-3.6-2c-1.4-0.5-3.2-0.8-5.1-0.8h-9.7v28.9h5.9v-9.9h3.8c1.9,0,3.6-0.2,5-0.7
		s2.6-1.1,3.6-2c0.9-0.9,1.6-1.8,2.1-3s0.7-2.5,0.7-3.9c0-1.3-0.2-2.6-0.7-3.7S41.1,94,40.2,93.2z M35.7,103.5
		c-0.9,0.9-2.2,1.3-4.1,1.3h-3.9v-9.9h3.8c0.9,0,1.7,0.2,2.4,0.4c0.7,0.2,1.2,0.6,1.7,1c0.5,0.4,0.8,0.9,1,1.5
		c0.2,0.6,0.3,1.2,0.3,1.9C37,101.3,36.5,102.6,35.7,103.5z"/>
	<path class="st_logo" d="M72.9,94.4c-1.3-1.3-2.8-2.4-4.7-3.1c-1.8-0.7-3.8-1.1-6.1-1.1s-4.2,0.4-6.1,1.1c-1.8,0.7-3.4,1.8-4.7,3.1
		c-1.3,1.3-2.3,2.9-3,4.7c-0.7,1.8-1.1,3.7-1.1,5.9s0.3,4.1,1.1,5.9s1.7,3.4,3,4.7c1.3,1.3,2.8,2.4,4.7,3.1c1.8,0.7,3.8,1.1,6.1,1.1
		s4.2-0.4,6.1-1.1c1.8-0.7,3.4-1.8,4.7-3.1c1.3-1.3,2.3-2.9,3-4.7s1.1-3.7,1.1-5.9c0-2.1-0.3-4-1.1-5.9
		C75.2,97.3,74.1,95.8,72.9,94.4z M70.2,109c-0.4,1.2-1,2.2-1.7,3c-0.7,0.9-1.6,1.4-2.7,1.9s-2.3,0.7-3.6,0.7
		c-1.4,0-2.6-0.2-3.6-0.7c-1.1-0.5-2-1.1-2.8-1.9c-0.7-0.9-1.3-1.8-1.7-3s-0.6-2.6-0.6-4.1s0.2-2.9,0.6-4.1s1-2.2,1.7-3.1
		s1.6-1.5,2.8-1.9c1.1-0.5,2.3-0.7,3.6-0.7c1.4,0,2.6,0.2,3.6,0.7c1.1,0.5,2,1.1,2.7,1.9s1.3,1.8,1.7,3.1c0.4,1.2,0.6,2.6,0.6,4.1
		C70.8,106.5,70.6,107.9,70.2,109z"/>
	<path class="st_logo" d="M116.2,90.8c-0.3,0.3-0.6,0.7-0.7,1L111,108c-0.1,0.4-0.2,0.9-0.3,1.4s-0.2,1.1-0.3,1.6
		c-0.1-0.5-0.2-1.1-0.4-1.6c-0.1-0.5-0.3-1-0.4-1.4l-5.2-16.2c-0.1-0.4-0.4-0.9-0.7-1.1c-0.3-0.3-0.7-0.5-1.2-0.5h-1.8
		c-0.5,0-0.9,0.3-1.2,0.5c-0.3,0.3-0.6,0.7-0.7,1l-5.2,16.2c-0.1,0.5-0.3,0.9-0.5,1.4s-0.3,1.1-0.4,1.6c-0.1-0.6-0.2-1.1-0.3-1.6
		s-0.2-1-0.3-1.4l-4.5-16.2c-0.1-0.4-0.3-0.9-0.7-1.1c-0.3-0.3-0.8-0.5-1.3-0.5h-5l8.9,28.9h5.4l6-18.8c0.1-0.3,0.2-0.5,0.3-0.9
		c0.1-0.3,0.2-0.7,0.3-1c0.1,0.3,0.1,0.7,0.3,1c0.1,0.3,0.2,0.5,0.3,0.8l5.9,18.8h5.4l8.9-28.9h-4.7C117,90.3,116.6,90.6,116.2,90.8
		z"/>
	<polygon class="st_logo" points="128.6,119.2 147.1,119.2 147.1,114.6 134.6,114.6 134.6,107.4 144.4,107.4 144.4,102.8 134.6,102.8 
		134.6,94.9 147.1,94.9 147.1,90.3 128.6,90.3 	"/>
	<path class="st_logo" d="M171,107.9c-0.3-0.3-0.7-0.5-1.1-0.8c1-0.3,1.8-0.8,2.6-1.3c0.7-0.5,1.4-1.2,1.9-1.8c0.5-0.7,0.9-1.5,1.2-2.4
		s0.4-1.8,0.4-2.7c0-1.2-0.2-2.4-0.7-3.4c-0.4-1.1-1.1-1.9-2-2.6s-2.1-1.4-3.5-1.8s-3.2-0.7-5.2-0.7h-9.3v28.9h5.9v-10.5h2.3
		c0.5,0,0.9-0.1,1.2,0.1c0.3,0.1,0.5,0.3,0.7,0.7l5.5,8.7c0.5,0.8,1.2,1.1,2.2,1.1h5.4l-6.7-10.3C171.6,108.5,171.3,108.3,171,107.9
		z M168.8,102.8c-0.5,0.5-1.1,0.7-1.7,1c-0.7,0.3-1.5,0.3-2.5,0.3h-3.4v-9.2h3.4c1.8,0,3.2,0.5,4.1,1.2c0.9,0.7,1.4,1.8,1.4,3.2
		c0,0.7-0.1,1.3-0.3,1.9C169.6,101.9,169.3,102.4,168.8,102.8z"/>
	<polygon class="st_logo" points="185.6,119.2 204,119.2 204,114.6 191.5,114.6 191.5,107.4 201.3,107.4 201.3,102.8 191.5,102.8 
		191.5,94.9 204,94.9 204,90.3 185.6,90.3 	"/>
	<path class="st_logo" d="M233.6,94.6c-1.3-1.2-2.8-2.4-4.7-3.1c-1.8-0.7-3.8-1.2-6.1-1.2h-11.2v28.9h11.2c2.2,0,4.2-0.3,6.1-1
		c1.8-0.7,3.4-1.6,4.7-3c1.3-1.2,2.3-2.8,3-4.5s1.1-3.7,1.1-5.8c0-2.1-0.3-4-1.1-5.8C235.9,97.4,234.9,95.9,233.6,94.6z M231,109
		c-0.4,1.2-1,2.2-1.7,3.1s-1.6,1.4-2.7,1.9c-1.1,0.5-2.3,0.7-3.6,0.7h-5.4V95h5.3c1.4,0,2.6,0.4,3.6,0.9c1.1,0.5,2,1.2,2.7,2
		s1.3,1.9,1.7,3.1s0.6,2.6,0.6,4.1C231.6,106.5,231.4,107.9,231,109z"/>
	<path class="st_logo" d="M267.5,104.5c0.9-0.3,1.6-0.7,2.2-1.1c0.6-0.5,1.2-0.9,1.6-1.4s0.7-1.1,0.9-1.7c0.2-0.6,0.3-1.2,0.3-1.9
		c0-1.2-0.2-2.2-0.6-3.2s-1.1-1.8-1.9-2.4c-0.9-0.7-2-1.3-3.4-1.6c-1.4-0.4-3-0.7-4.9-0.7H251v28.9h11.6c1.7,0,3.2-0.1,4.5-0.6
		s2.4-1,3.4-1.8c0.9-0.8,1.6-1.6,2-2.7c0.5-1.1,0.7-2.2,0.7-3.4C273.3,107.5,271.4,105.4,267.5,104.5z M257,94.9h4.7
		c0.9,0,1.6,0.1,2.2,0.3c0.6,0.2,1.1,0.4,1.5,0.7c0.4,0.3,0.7,0.7,0.9,1.2c0.2,0.5,0.3,1.1,0.3,1.8s-0.1,1.3-0.3,1.8
		c-0.2,0.5-0.6,0.9-1,1.2c-0.5,0.3-1,0.5-1.6,0.7c-0.7,0.1-1.4,0.2-2.2,0.2H257V94.9z M267.1,112.2c-0.1,0.5-0.4,0.9-0.8,1.3
		s-0.9,0.6-1.4,0.9c-0.6,0.3-1.4,0.3-2.4,0.3H257v-7.9h5.5c0.9,0,1.6,0.2,2.3,0.3c0.6,0.2,1.1,0.5,1.5,0.8s0.7,0.7,0.9,1.2
		s0.3,1,0.3,1.6C267.4,111.2,267.3,111.7,267.1,112.2z"/>
	<path class="st_logo" d="M295.8,90.8c-0.3,0.3-0.5,0.7-0.7,1l-4.7,9.1c-0.6,1.2-1.1,2.3-1.5,3.3c-0.2-0.5-0.4-1.1-0.7-1.6
		c-0.3-0.5-0.5-1.1-0.9-1.7l-4.7-9.1c-0.2-0.4-0.5-0.9-0.7-1.1c-0.3-0.3-0.7-0.5-1.2-0.5h-5.3l9.9,18v10.9h5.9v-10.9l11.1-18H297
		C296.6,90.3,296.1,90.6,295.8,90.8z"/>
</g>
</svg>
`;
  this.headerLogoDefaultMobile = `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" alt="Create flipbook with Online Flipbook Maker"
	 viewBox="0 0 475.2 268.9" style="enable-background:new 0 0 475.2 268.9;height: 100%;max-width:100%;opacity:0.8;" xml:space="preserve">
<style type="text/css">
	
	.st9{fill:currentColor;stroke:currentColor;stroke-width:6;stroke-miterlimit:10;}
	.st10{fill:none;}
	.st11{enable-background:new    ;}
	.st12{fill:currentColor;}
	.st13{display:none;fill:none;stroke:#676868;stroke-width:6;stroke-miterlimit:10;}
</style>
<g id="Layer_2_1_">
	<g>
		<path class="st9" d="M70,131.2c-11.4,0-21.3,5.8-27.3,14.6v-11.9h-5.3v96.9h5.3v-49.5c6,8.8,15.9,14.6,27.3,14.6
			c17.9,0,32.5-14.6,32.5-32.5S87.9,131.2,70,131.2z M70.1,190.7c-15,0-27.2-12.2-27.2-27.2c0-15,12.3-27.1,27.2-27.1
			s27.2,12.2,27.2,27.2C97.3,178.6,85.1,190.7,70.1,190.7z"/>
		<path class="st9" d="M234.6,131.2c-11.4,0-21.3,5.8-27.3,14.6V96.7h-5.3v96.9h5.3v-12.3c6,8.8,15.9,14.6,27.3,14.6
			c17.9,0,32.5-14.6,32.5-32.5S252.5,131.2,234.6,131.2z M234.6,190.7c-15,0-27.2-12.2-27.2-27.2c0-15,12.2-27.2,27.2-27.2
			c14.9,0,27.2,12.2,27.2,27.2C261.8,178.5,249.7,190.7,234.6,190.7z"/>
		<rect x="286.9" y="96.7" class="st9" width="5.3" height="96.9"/>
		<path class="st9" d="M456.8,133.8v26.6c0,11.4-1.8,18.3-6.1,22.8c-6.1,6.3-14.3,7.7-20.3,7.7s-14.4-1.4-20.4-7.7
			c-4.4-4.5-6.4-11.4-6.4-22.8v-26.6h-5.3v26.6c0,12.9,2.4,20.8,7.8,26.4c5.8,6.1,14.3,9.3,24.2,9.3h0.2l0,0
			c9.9-0.1,18.1-3.3,23.9-9.3c6.7-7.1,7.6-17.3,7.6-26.4v-26.6H456.8z"/>
		<path class="st9" d="M371.9,160.4c0,11.4-1.8,18.3-6.1,22.8c-6.1,6.3-14.3,7.7-20.3,7.7s-14.4-1.4-20.4-7.7
			c-4.4-4.5-6.4-11.4-6.4-22.8v-26.6h-5.3v26.6c0,12.9,2.4,20.8,7.8,26.4c5.8,6.1,14.3,9.3,24.2,9.3h0.2l0,0
			c9.9-0.1,18.1-3.3,23.9-9.3c6.7-7.1,7.6-17.3,7.6-26.4v-26.6h-5.3L371.9,160.4L371.9,160.4z"/>
		<path class="st9" d="M176.8,160.4c0,11.4-1.8,18.3-6.1,22.8c-6.1,6.3-14.3,7.7-20.3,7.7s-14.4-1.4-20.4-7.7
			c-4.4-4.5-6.4-11.4-6.4-22.8v-26.6h-5.3v26.6c0,12.9,2.4,20.8,7.8,26.4c5.8,6.1,14.3,9.3,24.2,9.3h0.2l0,0
			c9.9-0.1,18.1-3.3,23.9-9.3c6.7-7.1,7.6-17.3,7.6-26.4v-26.6h-5.3L176.8,160.4L176.8,160.4z"/>
	</g>
	<rect x="21.8" y="32.8" class="st10" width="372.6" height="65.3"/>
	<g class="st11">
		<path class="st12" d="M42.9,23.8c3.2,0,5.9,0.4,8.3,1.1c2.3,0.7,4.3,1.8,5.8,3.1c1.5,1.3,2.7,3,3.4,4.9c0.7,1.9,1.1,4,1.1,6.3
			s-0.4,4.5-1.2,6.4c-0.8,1.9-2,3.6-3.6,5c-1.6,1.4-3.5,2.5-5.8,3.3c-2.3,0.8-5,1.2-8.1,1.2h-7.7v18.3h-7.3V23.8H42.9z M42.9,49.3
			c1.9,0,3.5-0.2,4.9-0.7c1.4-0.5,2.6-1.2,3.6-2.1c1-0.9,1.7-1.9,2.2-3.2c0.5-1.2,0.7-2.6,0.7-4.1c0-3-0.9-5.4-2.8-7.1
			c-1.9-1.7-4.7-2.6-8.5-2.6h-7.7v19.7H42.9z"/>
		<path class="st12" d="M81.5,37.8c2.6,0,4.9,0.4,7,1.3c2.1,0.8,3.9,2,5.3,3.6c1.5,1.6,2.6,3.5,3.4,5.7s1.2,4.7,1.2,7.5
			s-0.4,5.3-1.2,7.5c-0.8,2.2-1.9,4.1-3.4,5.7c-1.5,1.6-3.2,2.8-5.3,3.6c-2.1,0.8-4.4,1.3-7,1.3c-2.6,0-4.9-0.4-7-1.3
			c-2.1-0.8-3.9-2-5.3-3.6c-1.5-1.6-2.6-3.5-3.4-5.7c-0.8-2.2-1.2-4.7-1.2-7.5s0.4-5.2,1.2-7.5c0.8-2.2,1.9-4.1,3.4-5.7
			c1.5-1.6,3.2-2.8,5.3-3.6C76.5,38.2,78.9,37.8,81.5,37.8z M81.5,68.6c3.3,0,5.8-1.1,7.4-3.3c1.6-2.2,2.4-5.4,2.4-9.4
			c0-4-0.8-7.2-2.4-9.4c-1.6-2.2-4.1-3.4-7.4-3.4c-3.4,0-5.9,1.1-7.5,3.4s-2.5,5.4-2.5,9.4c0,4,0.8,7.2,2.5,9.4
			C75.6,67.5,78.1,68.6,81.5,68.6z"/>
		<path class="st12" d="M154,38.3l-11.3,35.1h-5.4c-0.6,0-1.1-0.4-1.3-1.3l-7.4-22.8c-0.2-0.6-0.3-1.1-0.5-1.7s-0.3-1.1-0.4-1.7
			c-0.2,1.2-0.5,2.4-0.9,3.5l-7.5,22.8c-0.2,0.9-0.7,1.3-1.5,1.3h-5.1l-11.3-35.1h5.3c0.5,0,1,0.1,1.3,0.4c0.4,0.3,0.6,0.6,0.7,1
			l6.3,21.5c0.2,0.9,0.4,1.7,0.6,2.6c0.2,0.8,0.3,1.7,0.4,2.5c0.2-0.8,0.4-1.7,0.7-2.5c0.2-0.8,0.5-1.7,0.7-2.6l7-21.7
			c0.1-0.4,0.3-0.7,0.7-0.9c0.3-0.2,0.7-0.4,1.2-0.4h2.9c0.5,0,0.9,0.1,1.3,0.4c0.3,0.2,0.6,0.6,0.7,0.9l6.8,21.7
			c0.3,0.9,0.5,1.7,0.7,2.6c0.2,0.8,0.4,1.7,0.6,2.5c0.1-0.8,0.3-1.7,0.5-2.5c0.2-0.8,0.4-1.7,0.6-2.6l6.4-21.5
			c0.1-0.4,0.4-0.7,0.7-1c0.4-0.3,0.8-0.4,1.2-0.4H154z"/>
		<path class="st12" d="M188,68.4c-0.8,1-1.8,1.8-2.9,2.5c-1.1,0.7-2.2,1.3-3.5,1.7c-1.2,0.4-2.5,0.8-3.8,1s-2.6,0.3-3.8,0.3
			c-2.4,0-4.7-0.4-6.7-1.2c-2.1-0.8-3.8-2-5.3-3.6c-1.5-1.6-2.7-3.5-3.5-5.9c-0.8-2.3-1.3-5-1.3-8.1c0-2.4,0.4-4.7,1.1-6.8
			c0.8-2.1,1.8-3.9,3.3-5.5c1.4-1.6,3.1-2.8,5.2-3.7c2-0.9,4.3-1.3,6.9-1.3c2.1,0,4.1,0.4,5.9,1.1c1.8,0.7,3.4,1.7,4.7,3.1
			s2.3,3,3.1,4.9c0.7,2,1.1,4.2,1.1,6.7c0,1-0.1,1.7-0.3,2.1c-0.2,0.4-0.7,0.5-1.3,0.5h-23c0.1,2.1,0.4,3.9,0.9,5.5
			c0.5,1.6,1.3,2.8,2.2,3.9c0.9,1,2,1.8,3.3,2.3c1.3,0.5,2.7,0.8,4.3,0.8c1.5,0,2.8-0.2,3.9-0.5s2-0.7,2.8-1.1
			c0.8-0.4,1.5-0.8,2-1.1s1-0.5,1.4-0.5c0.6,0,1,0.2,1.3,0.6L188,68.4z M182.5,51.9c0-1.3-0.2-2.6-0.6-3.7c-0.4-1.1-0.9-2.1-1.7-2.9
			s-1.6-1.5-2.7-1.9s-2.3-0.7-3.7-0.7c-2.8,0-5.1,0.8-6.7,2.5c-1.6,1.6-2.7,3.9-3.1,6.8H182.5z"/>
		<path class="st12" d="M202.1,45c1.1-2.3,2.5-4.1,4.1-5.4c1.6-1.3,3.5-2,5.7-2c0.8,0,1.5,0.1,2.2,0.3c0.7,0.2,1.3,0.4,1.8,0.8
			l-0.4,5.1c-0.2,0.6-0.5,0.9-1.1,0.9c-0.3,0-0.8-0.1-1.4-0.2c-0.6-0.1-1.3-0.2-2.1-0.2c-1.1,0-2,0.2-2.9,0.5s-1.6,0.8-2.2,1.4
			c-0.7,0.6-1.2,1.4-1.7,2.2c-0.5,0.9-1,1.9-1.4,3v21.9h-6.7V38.3h3.9c0.7,0,1.2,0.1,1.5,0.4c0.3,0.3,0.5,0.7,0.6,1.4L202.1,45z"/>
		<path class="st12" d="M248.5,68.4c-0.8,1-1.8,1.8-2.9,2.5s-2.2,1.3-3.5,1.7c-1.2,0.4-2.5,0.8-3.8,1c-1.3,0.2-2.6,0.3-3.8,0.3
			c-2.4,0-4.7-0.4-6.7-1.2c-2.1-0.8-3.8-2-5.3-3.6c-1.5-1.6-2.7-3.5-3.5-5.9c-0.8-2.3-1.3-5-1.3-8.1c0-2.4,0.4-4.7,1.1-6.8
			s1.8-3.9,3.3-5.5c1.4-1.6,3.1-2.8,5.2-3.7c2-0.9,4.3-1.3,6.9-1.3c2.1,0,4.1,0.4,5.9,1.1c1.8,0.7,3.4,1.7,4.7,3.1
			c1.3,1.3,2.3,3,3.1,4.9c0.7,2,1.1,4.2,1.1,6.7c0,1-0.1,1.7-0.3,2.1c-0.2,0.4-0.7,0.5-1.3,0.5h-23c0.1,2.1,0.4,3.9,0.9,5.5
			c0.5,1.6,1.3,2.8,2.2,3.9c0.9,1,2,1.8,3.3,2.3c1.3,0.5,2.7,0.8,4.3,0.8c1.5,0,2.8-0.2,3.9-0.5c1.1-0.3,2-0.7,2.8-1.1
			c0.8-0.4,1.5-0.8,2-1.1c0.5-0.3,1-0.5,1.4-0.5c0.6,0,1,0.2,1.3,0.6L248.5,68.4z M243,51.9c0-1.3-0.2-2.6-0.6-3.7
			c-0.4-1.1-0.9-2.1-1.7-2.9s-1.6-1.5-2.7-1.9c-1.1-0.5-2.3-0.7-3.7-0.7c-2.8,0-5.1,0.8-6.7,2.5s-2.7,3.9-3.1,6.8H243z"/>
		<path class="st12" d="M285.7,22.4v50.9h-4.1c-0.9,0-1.5-0.4-1.8-1.3l-0.6-4c-1.5,1.8-3.2,3.2-5.1,4.3s-4.1,1.6-6.6,1.6
			c-2,0-3.8-0.4-5.4-1.2c-1.6-0.8-3-1.9-4.2-3.4c-1.2-1.5-2-3.4-2.7-5.6c-0.6-2.2-0.9-4.8-0.9-7.7c0-2.6,0.3-5,1-7.2
			c0.7-2.2,1.7-4.2,3-5.8c1.3-1.6,2.9-2.9,4.8-3.8c1.9-0.9,4-1.4,6.3-1.4c2.1,0,3.9,0.3,5.4,1c1.5,0.7,2.8,1.7,4,2.9V22.4H285.7z
			 M278.9,46.8c-1.1-1.4-2.3-2.5-3.6-3s-2.7-0.9-4.3-0.9c-3.1,0-5.5,1.1-7.2,3.3c-1.7,2.2-2.5,5.5-2.5,9.7c0,2.2,0.2,4.1,0.6,5.7
			c0.4,1.6,0.9,2.9,1.7,3.9c0.7,1,1.6,1.7,2.7,2.2s2.3,0.7,3.6,0.7c2,0,3.6-0.4,5.1-1.3c1.4-0.9,2.8-2.1,4-3.7V46.8z"/>
		<path class="st12" d="M319.2,43.1c1.4-1.6,3.1-2.9,4.9-3.9c1.8-1,3.9-1.5,6.3-1.5c2,0,3.9,0.4,5.5,1.2c1.6,0.8,3,1.9,4.2,3.4
			c1.1,1.5,2,3.3,2.7,5.4s0.9,4.5,0.9,7.2c0,2.8-0.4,5.4-1.1,7.7c-0.7,2.3-1.7,4.3-3,6c-1.3,1.7-2.9,2.9-4.7,3.8
			c-1.9,0.9-4,1.4-6.3,1.4c-1.1,0-2.2-0.1-3.1-0.3s-1.8-0.5-2.6-0.9c-0.8-0.4-1.5-0.9-2.2-1.5c-0.7-0.6-1.3-1.3-1.9-2l-0.3,2.9
			c-0.2,0.9-0.8,1.4-1.7,1.4h-4.3V22.4h6.7V43.1z M319.2,64.7c1.1,1.4,2.3,2.5,3.6,3s2.7,0.9,4.2,0.9c3.1,0,5.5-1.1,7.2-3.3
			c1.7-2.2,2.5-5.6,2.5-10.1c0-4.2-0.7-7.2-2.2-9.2c-1.5-1.9-3.6-2.9-6.3-2.9c-1.9,0-3.6,0.4-5,1.3s-2.7,2.1-4,3.7V64.7z"/>
		<path class="st12" d="M381,38.3l-19.5,45.2c-0.2,0.5-0.5,0.9-0.8,1.2c-0.3,0.3-0.9,0.4-1.5,0.4h-5l6.4-14l-14.4-32.8h5.9
			c0.6,0,1,0.1,1.3,0.4c0.3,0.3,0.6,0.6,0.7,0.9l8.9,21c0.2,0.5,0.4,1.1,0.5,1.6c0.2,0.5,0.3,1.1,0.4,1.6c0.2-0.6,0.3-1.1,0.5-1.6
			c0.2-0.5,0.4-1.1,0.6-1.6l8.6-21c0.2-0.4,0.4-0.7,0.8-1c0.3-0.3,0.7-0.4,1.2-0.4H381z"/>
	</g>
	<line class="st13" x1="-3.9" y1="31.9" x2="-4.6" y2="258.5"/>
</g>
</svg>
`;

  this.bookLoaderDiv = function (logo, name) {
    let loader = `${logo}<div class="loader__image-container">
            <div class="book">
                <div class="inner"><div class="left"></div><div class="middle"></div><div class="right"></div></div>
                <ul><li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                </ul>
              </div></div><h1 class="loader__bookname">${name}</h1>
<div class="loader__publuu"><a href='https://publuu.com/' class="a__loader__publuu" style="opacity: 0.0">Flipbook - Powered by Publuu.com</a></div>`;
    return loader;
  };

  this.bookLoaderDiv_LogoImageDiv = function (bookModel) {
    let img = HELPER.bookLoaderDiv_LogoImage(bookModel);
    return bookModel.settings.toplogo_image
      ? `<div class='loader__logo-container'>${img}</div>`
      : '';
  };

  this.bookLoaderDiv_LogoImage = function (bookModel) {
    if (bookModel.settings.toplogo_image && bookModel.settings.toplogo_image.includes('.svg')) {
      return ``;
      return `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 660 227" style="enable-background:new 0 0 660 227;" xml:space="preserve">
<style type="text/css">
	.st_loader{fill:currentColor;stroke-width:3;stroke:currentColor;}
</style>
<g>
	<path class="st_loader" d="M60.1,62.9C43,62.9,28,71.7,19,85V67h-8v146h8v-74.5c9,13.3,24,22.1,41.1,22.1c27,0,48.9-21.9,48.9-48.9
		S87,62.9,60.1,62.9z M60.2,152.7c-22.6,0-40.9-18.4-40.9-40.9s18.4-40.9,40.9-40.9s40.9,18.4,40.9,40.9S82.8,152.7,60.2,152.7z"/>
	<path class="st_loader" d="M308.1,62.9C291,62.9,276,71.7,267,85V11h-8v146h8v-18.5c9,13.3,24,22.1,41.1,22.1c27,0,48.9-21.9,48.9-48.9
		S335,62.9,308.1,62.9z M308.2,152.7c-22.6,0-40.9-18.4-40.9-40.9s18.4-40.9,40.9-40.9s40.9,18.4,40.9,40.9S330.8,152.7,308.2,152.7
		z"/>
	<rect x="387" y="11" class="st_loader" width="8" height="146"/>
	<path class="st_loader" d="M643,67v40.1c0,17.3-2.6,27.5-9.1,34.3c-9.2,9.5-21.6,11.6-30.5,11.6c-9,0-21.7-2.1-30.8-11.6
		c-6.6-6.9-9.6-17.1-9.6-34.3V67h-8v40.1c0,19.4,3.6,31.3,11.8,39.8c8.8,9.1,21.5,14,36.5,14h0.3l0,0c14.9-0.1,27.2-4.9,36-14
		c10.2-10.6,11.4-26.1,11.4-39.8V67H643z"/>
	<path class="st_loader" d="M515,107.1c0,17.3-2.6,27.5-9.1,34.3c-9.2,9.5-21.6,11.6-30.5,11.6c-9,0-21.7-2.1-30.8-11.6
		c-6.6-6.9-9.6-17.1-9.6-34.3V67h-8v40.1c0,19.4,3.6,31.3,11.8,39.8c8.8,9.1,21.5,14,36.5,14h0.3l0,0c14.9-0.1,27.2-4.9,36-14
		c10.2-10.6,11.4-26.1,11.4-39.8V67h-8L515,107.1L515,107.1z"/>
	<path class="st_loader" d="M221,107.1c0,17.3-2.6,27.5-9.1,34.3c-9.2,9.5-21.6,11.6-30.5,11.6c-9,0-21.7-2.1-30.8-11.6
		c-6.6-6.9-9.6-17.1-9.6-34.3V67h-8v40.1c0,19.4,3.6,31.3,11.8,39.8c8.8,9.1,21.5,14,36.5,14h0.3l0,0c14.9-0.1,27.2-4.9,36-14
		c10.2-10.6,11.4-26.1,11.4-39.8V67h-8V107.1z"/>
</g>
</svg>`;
    } else {
      return `<img src='${bookModel.settings.toplogo_image}' alt='${bookModel.name}'/>`;
    }
  };

  this.calculateAspectRatioFit = (srcWidth, srcHeight, maxWidth, maxHeight) => {
    const ratio = Math.min(maxWidth / srcWidth, maxHeight / srcHeight);

    return { width: srcWidth * ratio, height: srcHeight * ratio };
  }

  this.fadeInEffect = (modalOverlay, modalContent, duration, callbackFn = null) => {
    const _duration = modalContent ? 50 : 0;

    if (modalOverlay.classList.contains('showed')) return;

    modalOverlay.style.opacity = 0;

    if (modalContent) {
      modalContent.style.opacity = 0;
    }

    modalOverlay.removeAttribute('hidden');

    setTimeout(() => {
      modalOverlay.style.opacity = 1;

      setTimeout(() => {
        if (modalContent) {
          modalContent.style.opacity = 1;
        }
        
        modalOverlay.classList.add('showed');

        if (callbackFn && typeof(callbackFn) === 'function') {
          callbackFn();
        }
      }, duration);
    }, _duration);
  };

  this.fadeOutEffect = (modalOverlay, modalContent, duration, callbackFn = null) => {
    const _duration = modalContent ? 100 : 0;

    if (!modalOverlay.classList.contains('showed')) return;

    if (modalContent) {
      modalContent.style.opacity = 0;
    }

    setTimeout(() => {
      modalOverlay.style.opacity = 0;
      setTimeout(() => {
        modalOverlay.hidden = true;
        modalOverlay.classList.remove('showed');

        if (callbackFn && typeof(callbackFn) === 'function') {
          callbackFn();
        }
      }, duration);
    }, _duration);
  };

  this.setParametrToUrlIfNotExists = (url, parametr) => {
    if (url.includes(`${parametr}=`)) {
      url = url.replace(`${parametr}=0`, `${parametr}=1`, url)
        
      if (!url.includes('?')) {
        url = url.replace('&', '?', url);
      }
    } else {
      if (url.includes('?')) {
        url += `&${parametr}=1`;
      } else {
        url = url.split('&');
        
        let newUrl = url[0] + `?${parametr}=1`;
        url[0] = newUrl;
        url = url.join('&'); 
      }
    }
    return url;
  }

  this.getVideoIdFromUrl = (url, origin) => {
    let videoId = '';

    if (origin == 'youtube') {
      if (url.includes('watch?v=')) {
        url = url.split('watch?v=')[1];
        videoId = url.split('?')[0];
      } else if (url.includes('/shorts/')) {
        url = url.split('/shorts/');
        videoId = url[1].split('?')[0];
      } else if (url.includes('.be/')) {
        url = url.split('.be/');
        videoId = url[1].split('?')[0];
      }
    }

    if (origin == 'vimeo') {
      if (url.includes('/video/')) {
        url = url.split('/video/')[1];
        videoId = url.split('?')[0];
      } else if (url.includes('.com/')) {
        url = url.split('.com/')[1];
        videoId = url.split('?')[0];
      }
    }

    if (url.includes('&')) {
      videoId = videoId.split('&')[0];
    }

    return videoId;
  }

  const createScrollBar = (initialScrollPercent, sidebarBackground) => {
    const scrollBarTrack = document.createElement('div');
    const scrollBarInner = document.createElement('div');

    scrollBarTrack.className = 'sidebar__scrollbar scrollbar__track';
    scrollBarInner.className = 'scrollbar__inner';

    scrollBarInner.style.height = `${initialScrollPercent}%`;
    scrollBarTrack.style.backgroundColor = sidebarBackground;

    if (initialScrollPercent >= 100) {
      scrollBarInner.style.height = '100%';
      scrollBarTrack.style.display = 'none';
    }

    scrollBarTrack.append(scrollBarInner);

    return scrollBarTrack;
  };

  this.renderCustomSearchScroll = function (sidebar, scrolledElement) {
    if (!sidebar) {
      return;
    }

    if (sidebar.querySelector('.sidebar__scrollbar')) {
      sidebar.querySelector('.sidebar__scrollbar').remove();
    }
    
    const sidebarScrolledElement = scrolledElement.querySelector('.sidebar-search__list');
    const initialScrollPercent = (sidebarScrolledElement.getBoundingClientRect().height / sidebarScrolledElement.scrollHeight) * 100;

    const scrollTrack = createScrollBar(initialScrollPercent, sidebar.style.background);

    scrolledElement.insertAdjacentElement('afterbegin', scrollTrack);

    setHandlersToScrollBar(scrollTrack.querySelector('.scrollbar__inner'), sidebar, sidebarScrolledElement, true);
  }

  this.renderCustomProductScroll = function (sidebar, scrolledElement) {
    if (!sidebar) {
      return;
    }

    if (sidebar.querySelector('.sidebar__scrollbar')) {
      sidebar.querySelector('.sidebar__scrollbar').remove();
    }

    const sidebarScrolledElement = scrolledElement.querySelector('.sidebar-wishlist__list');
    const initialScrollPercent = (sidebarScrolledElement.getBoundingClientRect().height / sidebarScrolledElement.scrollHeight) * 100;

    const scrollTrack = createScrollBar(initialScrollPercent, sidebar.style.background);

    scrolledElement.insertAdjacentElement('afterbegin', scrollTrack);

    setHandlersToScrollBar(scrollTrack.querySelector('.scrollbar__inner'), sidebar, sidebarScrolledElement, true);
  };

  this.renderCustomScroll = function (sidebar) {
    if (!sidebar || sidebar.querySelector('.sidebar__scrollbar')) {
      return;
    }

    const sidebarWrapper = sidebar.querySelector('.sidebar__wrapper');
    const sidebarScrolledElement = sidebar.querySelector('.Book__sidebar');

    const initialScrollPercent = (sidebarScrolledElement.getBoundingClientRect().height / sidebarScrolledElement.scrollHeight) * 100;
    const scrollTrack = createScrollBar(initialScrollPercent, sidebar.style.background);

    sidebarWrapper.insertAdjacentElement('afterbegin', scrollTrack);

    setHandlersToScrollBar(scrollTrack.querySelector('.scrollbar__inner'), sidebar, sidebarScrolledElement, true);
  };

  const getScrollbarTransformStyles = function (scrollbar) {
    const style = window.getComputedStyle(scrollbar);
    const matrix = new WebKitCSSMatrix(style.transform);

    return matrix.m42;
  };

  const setHandlersToScrollBar = function (scrollbar, sidebar, scrolledElement, isMouseUp = true) {
    const isSearchSidebar = sidebar.id == 'sidebarSearch';
    const isWishlistSidebar = sidebar.id == 'sidebarWishlist';

    let mouseUp = isMouseUp;
    let isRanger = false;
    let scrolledElementOffsetTop = 0;
    
    if (isSearchSidebar) {
      scrolledElementOffsetTop = scrolledElement.getBoundingClientRect().top;
    } else if (isWishlistSidebar) {
      const footer = sidebar.querySelector('.sidebar-wishlist__footer');
      const footerHeight = footer.getBoundingClientRect().height + 10;
      scrolledElementOffsetTop = scrolledElement.getBoundingClientRect().top + footerHeight;
    }

    let sidebarClientHeight = sidebar.getBoundingClientRect().height;
    let srollbarInnerHeight = (parseFloat(scrollbar.style.height) * sidebarClientHeight) / 100;
    let lastCoordinateY = 0, diff = 0;
    // let SCROLL_OFFSET_MIN = 5, SCROLL_OFFSET_MAX = scrolledElement.getBoundingClientRect().height - srollbarInnerHeight - 5;

    const adjustScrollBar = (isFullScreenChange = false) => {
      if (!scrolledElement) {
        return;
      }

      sidebarClientHeight = sidebar.getBoundingClientRect().height;

      if (scrolledElement.scrollHeight > scrolledElement.getBoundingClientRect().height) {
        srollbarInnerHeight = scrolledElement.getBoundingClientRect().height / scrolledElement.scrollHeight * 100;
        scrollbar.style.height = srollbarInnerHeight + '%';

        const scrollTop = isFullScreenChange ? 0 : scrolledElement.scrollTop;
        const offset = (scrollTop / (scrolledElement.scrollHeight - scrolledElement.getBoundingClientRect().height));
        const newPos = (offset * (100 - parseFloat(scrollbar.style.height))) * scrolledElement.getBoundingClientRect().height / 100;

        scrollbar.style.transform = `translateY(${newPos}px)`;

        if (isFullScreenChange) {
          scrolledElement.scroll({
            top: 0 * (scrolledElement.scrollHeight - scrolledElement.getBoundingClientRect().height)
          });
        }

        // SCROLL_OFFSET_MAX = scrolledElement.getBoundingClientRect().height - srollbarInnerHeight - 5;

        scrollbar.parentNode.style.display = 'block';
      } else {
        scrollbar.parentNode.style.display = 'none';
      }
    };

    window.addEventListener('resize', () => {
      adjustScrollBar();
    });

    window.addEventListener('adjust-scrollbar', (event) => {
      const isFullScreenChange = event.detail && event.detail.hasOwnProperty('fullScreenChange') && !!event.detail.fullScreenChange;
      adjustScrollBar(isFullScreenChange);
    });

    scrolledElement.addEventListener('scroll', (event) => {
      if (!mouseUp) {
        return;
      }

      const scrolledElementHeight = scrolledElement.getBoundingClientRect().height;
      const offset = (event.target.scrollTop / (scrolledElement.scrollHeight - scrolledElementHeight));

      let newPos = (offset * (100 - parseFloat(scrollbar.style.height))) * scrolledElementHeight / 100;

      // newPos = Math.max(newPos, SCROLL_OFFSET_MIN);
      // newPos = Math.min(newPos, SCROLL_OFFSET_MAX);

      scrollbar.style.transform = `translateY(${newPos}px)`;
    });

    scrollbar.addEventListener('mousedown', (event) => {
      event.preventDefault();

      mouseUp = false;

      const sidebarTop = sidebar.getBoundingClientRect().top;
      const scrollbarTop = getScrollbarTransformStyles(scrollbar);

      diff = event.pageY - scrollbarTop - sidebarTop;
      scrolledElement.style.pointerEvents = 'none';
      scrollbar.parentNode.classList.add('active');
    });

    window.addEventListener('mousemove', (event) => {
      const path = event.path || event.composedPath();
      let isSidebar = false;

      if (path && path.length) {
        isSidebar = path.some(item => item.classList && item.classList.contains('sidebar__wrapper'))
      }

      if (isSidebar || !mouseUp) {
        event.preventDefault();
      }
      
      if (mouseUp) return;

      const sidebarOffsetTop = sidebar.getBoundingClientRect().top;
      const scrolledElementHeight = scrolledElement.getBoundingClientRect().height;
      const srollbarInnerHeight = (parseFloat(scrollbar.style.height) * scrolledElementHeight) / 100;
      let scrollbarTop = getScrollbarTransformStyles(scrollbar) || event.pageY;

      lastCoordinateY = event.pageY - sidebarOffsetTop;

      let newPos = (scrollbarTop + (lastCoordinateY - scrollbarTop)) - diff;
      const percent = newPos / (scrolledElementHeight - srollbarInnerHeight);

      newPos = percent >= 1 ? scrolledElementHeight - srollbarInnerHeight : newPos;
      newPos = percent <= 0 ? 0 : newPos;
      // newPos = newPos <= SCROLL_OFFSET_MIN ? SCROLL_OFFSET_MIN : newPos;
      // newPos = newPos >= SCROLL_OFFSET_MAX ? SCROLL_OFFSET_MAX : newPos;

      scrollbar.style.transform = `translateY(${newPos}px)`;

      scrolledElement.scroll({
        top: percent * (scrolledElement.scrollHeight - scrolledElementHeight)
      });

      if (event.pageY <= sidebarOffsetTop || event.pageY >= window.innerHeight) {
        mouseUp = true;
      }
    });

    window.addEventListener('mousedown', (event) => {
      const path = event.path || event.composedPath();
      isRanger = path.some(item => (item.classList && item.classList.contains('Ranger')) || item.localName === 'audio');
    });

    window.addEventListener('mouseup', (event) => {
      if (isRanger) {
        isRanger = false;
        return false;
      }

      event.preventDefault();

      mouseUp = true;
      scrolledElement.style.pointerEvents = 'all';
      scrollbar.parentNode.classList.remove('active');
    });
  };

  this.debugLine = (...args) => {
    let debugLine = document.querySelector('#debug-line');

    if (!debugLine) {
      debugLine = document.createElement('div');
      debugLine.id = 'debug-line';
      debugLine.style = `
        position: fixed;
        bottom: 10px;
        left: 0;
        right: 0;
        background: red;
        color: #fff;
        font-size: 12px;
        font-weight: bold;
        z-index: 99999999;
        width: 100%;
        padding: 10px;
      `;

      document.body.appendChild(debugLine);
    }

    debugLine.textContent = args.join(', ');
  };  

  this.getHotspotMediaUrl = function (url) {
    let newUrl = APP.CMS_PUBLUU_CF + '/cms';
    if (url.includes('http')) {
      newUrl = url;
    } else {
      newUrl += url;
    }

    return newUrl;
  }

  this.cryptString = function (text) {
    const salt = navigator.productSub.toString();
    const textToChars = (text) => text.split("").map((c) => c.charCodeAt(0));
    const byteHex = (n) => ("0" + Number(n).toString(16)).substr(-2);
    const applySaltToChar = (code) => textToChars(salt).reduce((a, b) => a ^ b, code);
  
    return text
      .split("")
      .map(textToChars)
      .map(applySaltToChar)
      .map(byteHex)
      .join("");
  };

  this.escapeHtml = function(text) {
    if (!text || typeof(text) != 'string') {
      return text;
    }

    text = text.replaceAll('<br />', '[br]').replaceAll('<br/>', '[br]');

    const map = {
      '&': '&',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#039;'
    };
    
    let textnew = text.replace(/[&<>"']/g, function(m) { return map[m]; });
    textnew = textnew.replaceAll('[br]', '<br />');

    return textnew;
  };

  this.getNestedValueByPath = (obj, path) => {
    if (!obj || !path) return null;

    const splitedPath = Array.isArray(path) ? path : path.split('.');

    if (splitedPath.length === 0) return null;

    try {
      return splitedPath.reduce((acc, key) => acc[key], obj);
    } catch {
      return null;
    }
  };

  this.waitingPromise = (time = 300) => new Promise(resolve => setTimeout(resolve, time));

  this.sendPostMessageToParent = (data) => {
    const isEmbed = is_embed();

    if (!isEmbed.embed) return;
    if (isEmbed.url === document.location.href) return;

    const referrerUrl = new URL(isEmbed.url);

    if (referrerUrl.origin !== 'https://publuu.com') return;

    window.parent.postMessage({ data }, '*');
  };

  this.loadScript = (src, attributes) => {
    if (!!document.querySelector(`script#${attributes.id}`)) return;

    return new Promise((resolve, reject) => {
      const script = document.createElement('script');

      script.src = src;

      Object.entries(attributes).forEach(([key, value]) => script.setAttribute(key, value));

      document.body.appendChild(script);

      script.addEventListener('load', resolve, { once: true });
      script.addEventListener('error', reject, { once: true });
    });
  };

  this.debounce = function (func, wait) {
    let timeout;

    return function(...args) {
      clearTimeout(timeout);
      timeout = setTimeout(() => func.apply(this, args), wait);
    };
  };

  this.buttonsIcons = {
    alertIcon: `<svg viewBox="0 0 33 33"xmlns=http://www.w3.org/2000/svg fill=none height=33 width=33><path d="M20.6746 4.19368C19.4316 3.51095 18.0068 3.125 16.5 3.125C12.0765 3.125 8.36039 6.45108 7.8719 10.8475L7.52567 13.9636C7.44751 14.667 7.41395 14.9615 7.35747 15.2457C7.23964 15.8386 7.0455 16.4138 6.77989 16.9568C6.65259 17.2171 6.50081 17.4717 6.13666 18.0786L5.0849 19.8315L5.04739 19.894L5.04737 19.8941C4.67677 20.5116 4.34233 21.0688 4.14811 21.5371C3.9446 22.0278 3.77585 22.6982 4.15079 23.3604C4.52573 24.0226 5.18736 24.2228 5.71285 24.3008C6.21437 24.3752 6.86429 24.3751 7.58448 24.375H7.5845L7.65738 24.375H25.3426L25.4155 24.375H25.4155C26.1357 24.3751 26.7856 24.3752 27.2871 24.3008C27.8126 24.2228 28.4743 24.0226 28.8492 23.3604C29.2242 22.6982 29.0554 22.0278 28.8519 21.5371C28.6577 21.0688 28.3232 20.5115 27.9526 19.894L27.9151 19.8315L26.8633 18.0786C26.4992 17.4717 26.3474 17.2171 26.2201 16.9568C25.9545 16.4138 25.7604 15.8386 25.6425 15.2457C25.5861 14.9615 25.5525 14.667 25.4743 13.9636L25.4734 13.9549C25.2364 13.9847 24.995 14 24.75 14C24.3028 14 23.8675 13.9489 23.4497 13.8524L23.4866 14.1844L23.4918 14.2319V14.2319C23.5632 14.8742 23.6058 15.2575 23.6809 15.6356C23.8324 16.3979 24.082 17.1373 24.4235 17.8355C24.5928 18.1818 24.7913 18.5125 25.1237 19.0666L25.1238 19.0666L25.1484 19.1076L26.2001 20.8605C26.6204 21.561 26.8742 21.9891 27.0045 22.3033L27.0112 22.3197L26.9936 22.3224C26.6572 22.3723 26.1595 22.375 25.3426 22.375H7.65738C6.84049 22.375 6.34284 22.3723 6.00636 22.3224L5.9888 22.3197L5.99554 22.3033C6.12585 21.9891 6.3796 21.561 6.79989 20.8605L7.85164 19.1076L7.8762 19.0666C8.20872 18.5125 8.40714 18.1818 8.57651 17.8355C8.918 17.1373 9.16761 16.3979 9.31911 15.6356C9.39424 15.2575 9.43682 14.8742 9.50816 14.2319L9.51344 14.1844L9.85967 11.0684C10.2356 7.68481 13.0956 5.125 16.5 5.125C17.5842 5.125 18.6132 5.38462 19.5243 5.8478C19.809 5.2294 20.2003 4.67019 20.6746 4.19368ZM23.0396 6.09645C22.4612 6.55649 22.0723 7.2447 22.0091 8.02495C22.4918 8.72735 22.8447 9.52885 23.0312 10.3968C23.502 10.7743 24.0997 11 24.75 11C24.8831 11 25.0139 10.9905 25.142 10.9723L25.1281 10.8475C24.9258 9.02687 24.17 7.38978 23.0396 6.09645ZM27.0716 22.5126C27.0714 22.5125 27.0711 22.5099 27.0709 22.5053C27.0717 22.5104 27.0717 22.5127 27.0716 22.5126ZM27.201 22.2755C27.2051 22.2732 27.2075 22.2722 27.2076 22.2723C27.2078 22.2724 27.2058 22.2735 27.201 22.2755ZM5.79235 22.2723C5.79253 22.2722 5.7949 22.2732 5.79895 22.2755C5.7942 22.2735 5.79217 22.2724 5.79235 22.2723ZM5.92907 22.5053C5.92895 22.5099 5.92857 22.5125 5.92841 22.5126C5.92825 22.5127 5.92832 22.5104 5.92907 22.5053Z"clip-rule=evenodd fill=#3461C9 fill-rule=evenodd /><path d="M12.5156 24.2889C12.7506 25.6046 13.2685 26.7672 13.9889 27.5964C14.7093 28.4256 15.5919 28.875 16.5 28.875C17.4081 28.875 18.2907 28.4256 19.0111 27.5964C19.7315 26.7672 20.2494 25.6046 20.4844 24.2889"stroke=#3461C9 stroke-linecap=round stroke-width=2 /><circle cx=24.75 cy=8.25 fill=#3461C9 r=3.25 stroke=#3461C9 /></svg>`,
    sliderControlArrowLeft: `<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><g><path d="M30.2501 33.6966L18.4251 21.8716L30.2501 10.0283L27.6651 7.44334L13.2368 21.8716L27.6651 36.3L30.2501 33.6966Z" fill="#fff"/></g></svg>`,
    sliderControlArrowRight: `<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><g><path d="M13.75 10.3034L25.575 22.1284L13.75 33.9717L16.335 36.5567L30.7633 22.1284L16.335 7.70003L13.75 10.3034Z" fill="#fff"/></g></svg>`,
    popupCloseIcon: `<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g><path d="M17.9466 16L25.3333 23.3867V25.3333H23.3866L16 17.9467L8.61329 25.3333H6.66663V23.3867L14.0533 16L6.66663 8.61332V6.66666H8.61329L16 14.0533L23.3866 6.66666H25.3333V8.61332L17.9466 16Z" fill="#000"/></g></svg>`,
    closeIconFilled: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_2_1_" x="0px" y="0px" viewBox="12.5 12.5 60.1 60.1" enable-background="new 12.5 12.5 60.1 60.1" xml:space="preserve"><path display="none" d="M68.1,12.5H17c-2.5,0-4.5,2-4.5,4.5v51.1c0,2.5,2,4.5,4.5,4.5h51.1c2.5,0,4.5-2,4.5-4.5V16.5  C72.3,14.2,70.3,12.5,68.1,12.5z M32.5,17.4h35V54h-35V17.4z M27.5,67.6H17.4V17.5h10.1V67.6z"/><path d="M21.3,21.3C9.5,33,9.5,52,21.3,63.8s30.8,11.7,42.5,0s11.7-30.8,0-42.5S33,9.5,21.3,21.3z M56.6,28.4c1,1,1,2.6,0,3.6  L46.1,42.5L56.6,53c1,1,1,2.6,0,3.6l0,0c-1,1-2.6,1-3.6,0L42.5,46.1L32,56.6c-1,1-2.6,1-3.6,0l0,0c-1-1-1-2.6,0-3.6l10.5-10.5  L28.4,32c-1-1-1-2.6,0-3.6l0,0c1-1,2.6-1,3.6,0l10.5,10.5L53,28.4C54,27.4,55.6,27.4,56.6,28.4L56.6,28.4z"/></svg>`,
    closeIcon: `<svg width="595" height="596" viewBox="0 0 595 596" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M350.3 209.8L297.7 262.4L245 209.8C234.5 199.3 220 199.3 209.5 209.8C199 220.3 199 234.8 209.5 245.3L262.1 297.9L209.5 350.5C199 361 199 375.5 209.5 386C220 396.5 234.5 396.5 245 386L297.6 333.4L350.2 386C360.7 396.5 375.2 396.5 385.7 386C396.2 375.5 394.9 359.7 385.7 350.5L333.1 297.9L385.7 245.3C396.2 234.8 396.2 220.3 385.7 209.8C374.6 199.9 360.8 199.3 350.3 209.8Z" fill="black"/><path d="M87.2 87.5C-28.6 203.3 -28.6 392.7 87.2 508.4C203 624.1 392.4 624.2 508.1 508.4C623.8 392.6 623.9 203.2 508.1 87.5C392.3 -28.2 202.9 -28.3 87.2 87.5ZM473.2 473.6C376.5 570.3 218.7 570.3 122 473.6C25.3 376.9 25.4 219 122 122.3C218.6 25.6 376.5 25.6 473.2 122.3C569.9 219 569.9 376.9 473.2 473.6Z" fill="black"/></svg>`,
    tocIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 462.4 463" style="enable-background:new 0 0 462.4 463;" xml:space="preserve"><style type="text/css">.st3{stroke:#000000;stroke-width:9;}.st1{stroke:#000000;stroke-width:13;}</style><g id="TOC"><g><path class="st3" d="M41.2,324.8c-2.4,0-5.1-0.9-7.3-2.3c-4.6-3.2-7.3-9-7.3-15V155.1c0-6.1,2.7-11.9,7.3-15 c4.6-3.2,9.9-3.2,14.5,0l110.8,76c4.6,3.2,7.3,9,7.3,15s-2.7,11.9-7.3,15L48.5,322.2C46.3,323.9,43.6,324.8,41.2,324.8z M55.7,185.2v92.2l67.1-46L55.7,185.2z"/></g><g><path class="st1" d="M441,43.3H21.2c-8.1,0-14.5-7.8-14.5-17.3S13.2,8.6,21.2,8.6h419.7c8.1,0,14.5,7.8,14.5,17.3 S448.9,43.3,441,43.3z"/></g><g><path class="st1" d="M441,145.9H216.3c-8.1,0-14.5-7.8-14.5-17.3s6.6-17.3,14.5-17.3h224.5c8.1,0,14.5,7.8,14.5,17.3 S448.9,145.9,441,145.9z"/></g><g><path class="st1" d="M441,248.8H216.3c-8.1,0-14.5-7.8-14.5-17.3s6.6-17.3,14.5-17.3h224.5c8.1,0,14.5,7.8,14.5,17.3 S448.9,248.8,441,248.8z"/></g><g><path class="st1" d="M441,351.4H216.3c-8.1,0-14.5-7.8-14.5-17.3s6.6-17.3,14.5-17.3h224.5c8.1,0,14.5,7.8,14.5,17.3 C455.5,343.6,448.9,351.4,441,351.4z"/></g><g><path class="st1" d="M441,454H21.2c-8.1,0-14.5-7.8-14.5-17.3s6.6-17.3,14.5-17.3h419.7c8.1,0,14.5,7.8,14.5,17.3 C455.5,446.2,448.9,454,441,454z"/></g></g></svg>`,
    thumbnailIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 462.4 463" style="enable-background:new 0 0 462.4 463;" xml:space="preserve"><style type="text/css">.st6{stroke:none;stroke-width:13;stroke-miterlimit:10;}</style><g id="Layer_3"><g id="Thumb"><path class="st6" d="M194.6,8.9L20.3,8.6c-7,0-12.5,5.5-12.5,12.5L7.5,195.2c0,7,5.5,12.5,12.5,12.5l174.3,0.3 c7,0,12.5-5.5,12.5-12.5l0.3-174.1C207.1,14.4,201.6,8.9,194.6,8.9z M181.8,183l-149.5-0.2l0.2-149.3l149.6,0.3L181.8,183z"/><path class="st6" d="M194.4,254.9H20.1c-7,0-12.5,5.5-12.5,12.5v174.1c0,7,5.5,12.5,12.5,12.5h174.3c7,0,12.5-5.5,12.5-12.5V267.4 C206.9,260.4,201.3,254.9,194.4,254.9z M181.9,429H32.6V279.8H182V429H181.9z"/><path class="st6" d="M440.7,254.9H266.5c-7,0-12.5,5.5-12.5,12.5v174.1c0,7,5.5,12.5,12.5,12.5h174.3c7,0,12.5-5.5,12.5-12.5 V267.4C453.2,260.4,447.7,254.9,440.7,254.9z M428.3,429H278.9V279.8h149.4V429z"/><path class="st6" d="M441,8.8H266.6c-7,0-12.5,5.5-12.5,12.5v174.1c0,7,5.5,12.5,12.5,12.5h174.3c7,0,12.5-5.5,12.5-12.5V21.3 C453.4,14.3,447.9,8.8,441,8.8z M428.5,182.9H279V33.7h149.5L428.5,182.9L428.5,182.9z"/></g></g></svg>`,
    shareIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 462.4 463" style="enable-background:new 0 0 462.4 463;" xml:space="preserve"><style type="text/css">.st0-share{fill:none;stroke:#3461c9;stroke-width:40;stroke-miterlimit:10;}</style><ellipse transform="matrix(0.7071 -0.7071 0.7071 0.7071 -157.4812 379.2068)" class="st0-share" cx="379" cy="379.7" rx="61.7" ry="61.7"/><circle class="st0-share" cx="82.8" cy="231.5" r="61.7"/><ellipse transform="matrix(0.7071 -0.7071 0.7071 0.7071 52.0346 292.4226)" class="st0-share" cx="379" cy="83.4" rx="61.7" ry="61.7"/><g><line class="st0-share" x1="138.1" y1="202" x2="327.4" y2="107.4"/><line class="st0-share" x1="327.4" y1="355.6" x2="138.1" y2="261.1"/></g></svg>`,
    downloadIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 461.1 460.8" style="enable-background:new 0 0 461.1 460.8;" xml:space="preserve"><style type="text/css">.st0-download{fill:none;stroke:#000000;stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;}</style><g><polyline class="st0-download" points="20.8,341.8 20.8,440.1 440.4,440.1 440.4,341.8"/><g><line class="st0-download" x1="230.6" y1="325.8" x2="230.6" y2="20.5"/><line class="st0-download" x1="230.6" y1="325.8" x2="174.9" y2="270.1"/><line class="st0-download" x1="230.6" y1="325.8" x2="286.3" y2="270.1"/></g></g></svg>`,
    soundOnIcon: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.2 593.65"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_2" data-name="Layer 2"><path d="M351,2.25a24.57,24.57,0,0,0-26.2,3.6l-186,158.2H24.5A24.54,24.54,0,0,0,0,188.55v216.6a24.54,24.54,0,0,0,24.5,24.5H138.9l186,158.2a24.73,24.73,0,0,0,15.9,5.8,23.43,23.43,0,0,0,10.3-2.3,24.42,24.42,0,0,0,14.2-22.2V24.55A24.72,24.72,0,0,0,351,2.25Zm-34.8,514L172.4,393.85v-45.4a24.5,24.5,0,0,0-49,0v32.2H49V213.05h74.4v32.2a24.5,24.5,0,0,0,49,0v-45.4L316.2,77.55Z" class="iconpath"/><path d="M495.2,296.25A109,109,0,0,0,431,197a24.51,24.51,0,0,0-20.1,44.7,59.88,59.88,0,0,1,0,109.2,24.54,24.54,0,0,0,10.1,46.9,23.78,23.78,0,0,0,10-2.2A109.08,109.08,0,0,0,495.2,296.25Z" class="iconpath"/><path d="M560.2,163.35a275.81,275.81,0,0,0-92.3-97.3,24.5,24.5,0,1,0-26.2,41.4,224.8,224.8,0,0,1,0,379.8,24.5,24.5,0,0,0,13.1,45.2,24.26,24.26,0,0,0,13.1-3.8,276.65,276.65,0,0,0,92.3-97.3,274,274,0,0,0,0-268Z" class="iconpath"/></g></g></svg>`,
    soundOffIcon: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.1 593.65"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_2" data-name="Layer 2"><path class="iconpath" d="M570.9,17.75a24.38,24.38,0,0,0-34.6,0L480,74.05q-5.85-4.2-12-8.1a24.5,24.5,0,1,0-26.2,41.4c1,.6,2,1.3,3,2l-79.5,79.5V24.45a24.49,24.49,0,0,0-40.4-18.6l-186,158.2H24.5A24.54,24.54,0,0,0,0,188.55v216.6a24.54,24.54,0,0,0,24.5,24.5h99.8L12.7,541.25a24.47,24.47,0,1,0,34.6,34.6L570.9,52.35A24.38,24.38,0,0,0,570.9,17.75ZM316.2,237.65,172.4,381.55v-33.1a24.5,24.5,0,0,0-49,0v32.2H49V213h74.4v32.2a24.5,24.5,0,0,0,49,0v-45.4L316.2,77.45Z"/><path class="iconpath" d="M495.3,296.15a109.42,109.42,0,0,0-27.3-72.1l-34.8,34.8a59.8,59.8,0,0,1-22.2,91.9,24.54,24.54,0,0,0,10.1,46.9,23.46,23.46,0,0,0,10-2.2A109.14,109.14,0,0,0,495.3,296.15Z"/><path class="iconpath" d="M316.2,516.15l-75.9-64.5-34.8,34.8,119.3,101.4a24.73,24.73,0,0,0,15.9,5.8,23.43,23.43,0,0,0,10.3-2.3,24.42,24.42,0,0,0,14.2-22.2V326.75l-49,49Z"/><path class="iconpath" d="M560.2,163.25c-3.7-6.5-7.6-12.9-11.8-19.1L513,179.55a225.14,225.14,0,0,1-71.4,307.6,24.5,24.5,0,0,0,13.1,45.2,24.26,24.26,0,0,0,13.1-3.8,276.65,276.65,0,0,0,92.3-97.3,274.36,274.36,0,0,0,.1-268Z"/></g></g></svg>`,
    printIcon: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 58.9 64.1"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_1" data-name="Layer 1"><style xmlns="http://www.w3.org/2000/svg" type="text/css">.iconpath-print{stroke:none !important;stroke-width:2;stroke-linejoin:round;}</style><path class="iconpath-print" d="M56.1,13.3H53.4V2.7A2.57,2.57,0,0,0,50.7,0H8.1A2.57,2.57,0,0,0,5.4,2.7V13.4H2.7A2.57,2.57,0,0,0,0,16.1V37.4a2.57,2.57,0,0,0,2.7,2.7H5.4V61.4a2.57,2.57,0,0,0,2.7,2.7H50.8a2.57,2.57,0,0,0,2.7-2.7V40h2.7a2.57,2.57,0,0,0,2.7-2.7V16A2.77,2.77,0,0,0,56.1,13.3Zm-45.4-8H48v8H10.7ZM48.1,58.7H10.7V40H48V58.7Zm5.3-24H5.4v-16h48Z"/><path class="iconpath-print" d="M18.7,48H40a2.7,2.7,0,1,0,0-5.4H18.7A2.57,2.57,0,0,0,16,45.3,2.63,2.63,0,0,0,18.7,48Z"/><path class="iconpath-print" d="M18.7,56H40a2.7,2.7,0,1,0,0-5.4H18.7A2.57,2.57,0,0,0,16,53.3,2.63,2.63,0,0,0,18.7,56Z"/><circle class="iconpath-print" cx="48.1" cy="24" r="2.7"/></g></g></svg>`,
    zoomInIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><g><path d="M62.6,52.1L47.9,37.3c-1.9-1.9-5.1-1.9-7,0l0,0l-2.4-2.4c6.4-8.3,5.9-20.6-1.9-28.3c-4-4.3-9.4-6.4-15.2-6.4l0,0c-5.6,0-11,2.1-15.2,6.4c-8.3,8.3-8.3,21.9,0,30.2c4.3,4,9.6,6.1,15.2,6.1c4.8,0,9.4-1.6,13.1-4.5l2.4,2.4l0,0c-1.9,1.9-1.9,5.1,0,7l14.7,14.7c1.1,1.1,2.1,1.3,3.5,1.3s2.7-0.5,3.5-1.3l3.7-3.7l0,0C64.5,57.1,64.5,53.9,62.6,52.1z M21.5,37.6c-4.3,0-8.3-1.6-11.2-4.8c-6.1-6.1-6.1-16.6,0-22.7c2.9-2.9,7-4.5,11.2-4.5s8.3,1.6,11.2,4.8c6.1,6.1,6.1,16.6,0,22.7C29.7,36,25.7,37.6,21.5,37.6z M55.4,58.7L41.2,44.6l3.2-3.2l14.2,14.2L55.4,58.7z"/><path d="M26.8,18.9h-2.7v-2.7c0-1.6-1.1-2.7-2.7-2.7c-1.6,0-2.7,1.1-2.7,2.7v2.7h-2.7c-1.6,0-2.7,1.1-2.7,2.7s1.1,2.7,2.7,2.7h2.7v2.7c0,1.6,1.1,2.7,2.7,2.7s2.7-1.1,2.7-2.7v-2.7h2.7c1.6,0,2.7-1.1,2.7-2.7C29.5,20,28.4,18.9,26.8,18.9z"/></g></svg>`,
    zoomOutIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><g><path d="M62.6,51.8L47.9,37.1c-0.8-1.1-2.1-1.3-3.5-1.3l0,0c-1.3,0-2.7,0.5-3.5,1.3l0,0l-2.4-2.4c6.4-8.3,5.9-20.6-1.9-28.4c-4.3-4-9.6-6.2-15.3-6.2s-11,2.1-15.3,6.2C2.1,10.6,0,15.9,0,21.6s2.1,11,6.2,15.3c4.3,4,9.9,6.2,15.3,6.2c4.5,0,9.4-1.6,13.1-4.5l2.4,2.4l0,0c-1.1,1.1-1.3,2.1-1.3,3.5c0,1.3,0.5,2.7,1.3,3.5l14.7,14.7c1.1,1.1,2.1,1.3,3.5,1.3c1.3,0,2.4-0.5,3.5-1.3l3.7-3.7C64.5,56.9,64.5,53.9,62.6,51.8z M10.2,32.8c-3.2-2.9-4.8-7-4.8-11.2s1.6-8.3,4.8-11.2s7-4.8,11.2-4.8s8.3,1.6,11.2,4.8c6.2,6.2,6.2,16.3,0,22.7S16.3,39.2,10.2,32.8z M55.1,58.8L40.9,44.6l3.2-3.2l14.2,14.2L55.1,58.8z"/><path d="M26.8,18.9H16.1c-1.6,0-2.7,1.1-2.7,2.7c0,1.6,1.1,2.7,2.7,2.7h10.7c1.6,0,2.7-1.1,2.7-2.7C29.4,20,28.4,18.9,26.8,18.9z"/></g></svg>`,
    noteOutlineIcon: `<svg xmlns="http://www.w3.org/2000/svg" width="150" height="122" stroke-width="2" viewBox="0 0 150 122" fill="none"><path d="M145.375 0.400024H5.02511C2.47816 0.400024 0.400391 2.4778 0.400391 5.02475V92.2242C0.400391 94.7711 2.47816 96.8489 5.02511 96.8489H109.517L142.627 120.978C143.432 121.581 144.37 121.849 145.375 121.849C146.113 121.849 146.783 121.648 147.453 121.38C148.995 120.576 150 118.967 150 117.224V5.02475C150 2.4778 147.922 0.400024 145.375 0.400024ZM140.751 108.176L113.807 88.5378C113.002 87.9346 112.064 87.6665 111.059 87.6665H9.64984V9.64947H140.684V108.176H140.751Z" fill="black" stroke="black"/><path d="M24.7976 53.2156H40.8835V69.3016C40.8835 71.8486 42.9613 73.9263 45.5083 73.9263C48.0552 73.9263 50.133 71.8486 50.133 69.3016V53.2156H66.219C68.7659 53.2156 70.8437 51.1379 70.8437 48.5909C70.8437 46.044 68.7659 43.9662 66.219 43.9662H50.133V27.8802C50.133 25.3333 48.0552 23.2555 45.5083 23.2555C42.9613 23.2555 40.8835 25.3333 40.8835 27.8802V43.9662H24.7976C22.2506 43.9662 20.1729 46.044 20.1729 48.5909C20.1729 51.1379 22.2506 53.2156 24.7976 53.2156Z" fill="black" stroke="black"/><path d="M86.7956 53.0816H119.236C121.783 53.0816 123.86 51.0038 123.86 48.4569C123.86 45.9099 121.783 43.8322 119.236 43.8322H86.7956C84.2487 43.8322 82.1709 45.9099 82.1709 48.4569C82.1709 51.0038 84.2487 53.0816 86.7956 53.0816Z" fill="black" stroke="black"/><path d="M86.7956 32.9071H119.236C121.783 32.9071 123.86 30.8293 123.86 28.2824C123.86 25.7354 121.783 23.6577 119.236 23.6577H86.7956C84.2487 23.6577 82.1709 25.7354 82.1709 28.2824C82.1709 30.8963 84.2487 32.9071 86.7956 32.9071Z" fill="black" stroke="black"/><path d="M86.7956 73.5242H119.236C121.783 73.5242 123.86 71.4464 123.86 68.8995C123.86 66.3525 121.783 64.2748 119.236 64.2748H86.7956C84.2487 64.2748 82.1709 66.3525 82.1709 68.8995C82.1709 71.4464 84.2487 73.5242 86.7956 73.5242Z" fill="black" stroke="black"/></svg>`,
    noteFillIcon: `<svg viewBox="0 0 224 182" fill="00000066" xmlns="http://www.w3.org/2000/svg"><path d="M0.600098 7.39999V174.7C0.600098 177.3 2.10009 179.7 4.40009 180.8C5.40009 181.3 6.50009 181.5 7.50009 181.5C8.90009 181.5 10.4001 181.1 11.6001 180.2L60.9001 144.2H216.6C220.4 144.2 223.5 141.1 223.5 137.3V7.3C223.5 3.5 220.4 0.399994 216.6 0.399994H7.40009C3.60009 0.499994 0.600098 3.59999 0.600098 7.39999ZM118.5 72.4C118.5 68.6 121.6 65.5 125.4 65.5H149.4V41.5C149.4 37.7 152.5 34.6 156.3 34.6C160.1 34.6 163.2 37.7 163.2 41.5V65.5H187.2C191 65.5 194.1 68.6 194.1 72.4C194.1 76.2 191 79.3 187.2 79.3H163.2V103.3C163.2 107.1 160.1 110.2 156.3 110.2C152.5 110.2 149.4 107.1 149.4 103.3V79.3H125.4C121.6 79.2 118.5 76.2 118.5 72.4ZM39.5001 102.6C39.5001 98.8 42.6001 95.7 46.4001 95.7H94.7001C98.5001 95.7 101.6 98.8 101.6 102.6C101.6 106.4 98.5001 109.5 94.7001 109.5H46.4001C42.5001 109.5 39.5001 106.4 39.5001 102.6ZM39.5001 72.1C39.5001 68.3 42.6001 65.2 46.4001 65.2H94.7001C98.5001 65.2 101.6 68.3 101.6 72.1C101.6 75.9 98.5001 79 94.7001 79H46.4001C42.5001 79 39.5001 75.9 39.5001 72.1ZM39.5001 42.1C39.5001 38.3 42.6001 35.2 46.4001 35.2H94.7001C98.5001 35.2 101.6 38.3 101.6 42.1C101.6 45.9 98.5001 49 94.7001 49H46.4001C42.5001 49 39.5001 45.9 39.5001 42.1Z"></path></svg>`,
    wishlistIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_2_1_" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><path d="M31.8,61.1c-1.6,0-3.2-0.5-4.3-1.9l-22-23.6C-0.3,29.5-1.7,20.2,2,12.7c3.2-6.1,9-9.8,15.7-9.8c4.5,0,9.3,1.9,12.8,5.6  l1.3,1.3l1.3-1.3c3.5-3.7,8-5.6,12.8-5.6l0,0c4.8,0,9.3,1.9,12.8,5.6C62.2,12,64,16.7,64,21.8s-1.9,9.8-5,13.3L37.2,58.4  c-0.7,0.8-1.5,1.4-2.4,1.9C33.8,60.8,32.8,61.1,31.8,61.1L31.8,61.1z M31.6,55.5c0.3,0.3,0.3,0.3,0.3,0.3c0.3,0,0.5-0.4,0.7-0.7  l22.1-23.8c2.4-2.7,3.7-6.1,3.7-9.6c0-3.7-1.3-7.2-3.7-9.6c-2.4-2.7-5.6-4-9-4l0,0c-3.5,0-6.6,1.3-9,4l-5,5.3l-5-5.3  c-2.4-2.4-5.6-3.7-8.8-3.7c-5,0.1-9,2.7-11.4,7C3.9,20.7,5,27.6,9.3,32.1L31.6,55.5z"/></svg>`,
    searchIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><path d="M62.9,56.5L45.9,42.7c7.2-9.9,6.1-23.7-2.7-32.5C38.4,5.3,32,2.7,25.3,2.7S12.3,5.3,7.5,10.1S0,21.3,0,28s2.7,13.1,7.5,17.9c5.1,5.1,11.5,7.5,17.9,7.5c6.1,0,12.3-2.1,17.1-6.7l17.3,14.1c0.5,0.5,1.1,0.5,1.6,0.5c0.8,0,1.6-0.3,2.1-1.1C64.3,59.2,64.3,57.6,62.9,56.5z M25.3,48c-5.3,0-10.4-2.1-14.1-5.9C7.5,38.4,5.3,33.3,5.3,28s2.1-10.4,5.9-14.1S20,8,25.3,8s10.4,2.1,14.1,5.9s5.9,8.8,5.9,14.1s-2.1,10.4-5.9,14.1C35.7,45.9,30.7,48,25.3,48z"/></svg>`,
    fullscreenModalIcon: `<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M2.8 15.8L0 13v7h7l-2.8-2.8 4.34-4.32-1.42-1.42L2.8 15.8zM17.2 4.2L20 7V0h-7l2.8 2.8-4.34 4.32 1.42 1.42L17.2 4.2zm-1.4 13L13 20h7v-7l-2.8 2.8-4.32-4.34-1.42 1.42 4.33 4.33zM4.2 2.8L7 0H0v7l2.8-2.8 4.32 4.34 1.42-1.42L4.2 2.8z"/></svg>`,
    fullscreenOnIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><path d="M61.3,21.3c1.6,0,2.7-1.1,2.7-2.7v-16C64,1.1,62.9,0,61.3,0h-16c-1.6,0-2.7,1.1-2.7,2.7s1.1,2.7,2.7,2.7h9.6L32,28.3L9.1,5.3h9.6c1.6,0,2.7-1.1,2.7-2.7S20.3,0,18.7,0h-16C2.4,0,1.9,0,1.6,0.3C1.1,0.5,0.5,1.1,0.3,1.6C0,1.9,0,2.4,0,2.7v16c0,1.6,1.1,2.7,2.7,2.7s2.7-1.1,2.7-2.7V9.1L28.3,32L5.3,54.9v-9.6c0-1.6-1.1-2.7-2.7-2.7S0,43.7,0,45.3v16C0,62.9,1.1,64,2.7,64h16c1.6,0,2.7-1.1,2.7-2.7c0-1.6-1.1-2.7-2.7-2.7H9.1L32,35.7l22.9,22.9h-9.6c-1.6,0-2.7,1.1-2.7,2.7c0,1.6,1.1,2.7,2.7,2.7h16c1.6,0,2.7-1.1,2.7-2.7v-16c0-1.6-1.1-2.7-2.7-2.7c-1.6,0-2.7,1.1-2.7,2.7v9.6L35.7,32L58.7,9.1v9.6C58.7,20.3,59.7,21.3,61.3,21.3z"/></svg>`,
    fullscreenOffIcon: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.34 595.34"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_1" data-name="Layer 1"><path d="M7.13,41.71,130.83,166h-89a25.27,25.27,0,0,0-25.4,25.2c.1,14.8,10.3,24.1,25.1,24.1h148.8c2.8,0,7.4,0,10.2-2.8,4.7-1.9,10.2-7.4,12.1-12.1,2.8-2.8,2.8-7.4,2.8-10.2V41.51a25.21,25.21,0,0,0-24.7-25.3c-15.1-.2-25.5,10.1-25.5,25.1v89.3L41.73,7.11a24.36,24.36,0,0,0-34.8.4l-.2.2A24.39,24.39,0,0,0,7.13,41.71Z"/><path d="M42.23,429.41h89.1L7.13,553.51a24.36,24.36,0,0,0-.9,33.5l.2.2a24.44,24.44,0,0,0,35.3,1l125-124.4v89a25.27,25.27,0,0,0,25.2,25.4c14.8-.1,24.1-10.3,24.1-25.1V404.31a25.05,25.05,0,0,0-25.1-25.1H42c-15,0-25.3,10.4-25.1,25.5A25.21,25.21,0,0,0,42.23,429.41Z"/><path d="M403.93,216.71h148.6a25.21,25.21,0,0,0,25.3-24.7c.2-15.1-10.1-25.5-25.1-25.5h-89.3l124.8-124.8a24.31,24.31,0,0,0-1.1-35.4l-.2-.2a24.31,24.31,0,0,0-33.3,1l-125.5,125V43a24.5,24.5,0,0,0-24.3-24.5c-14.8.1-25,10.3-25,25.1v148.8C378.83,206.51,389,216.71,403.93,216.71Z"/><path d="M403.43,577a25.14,25.14,0,0,0,24.7-25.3v-89.1l125.6,125.6a24.33,24.33,0,0,0,34.1.3h0a24.33,24.33,0,0,0,.3-34.7l-125.5-125.6h89.1a25.21,25.21,0,0,0,25.3-24.7c.2-15.1-10.1-25.5-25.1-25.5H403.13a25.05,25.05,0,0,0-25.1,25.1v148.8C378,566.91,388.43,577.21,403.43,577Z"/></g></g></svg>`,
    previewBackIcon: `<svg version="1.1" id="Layer_2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 700 700" style="enable-background:new 0 0 700 700;" xml:space="preserve"><style type="text/css">.arrow{stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:15.1181;}</style><g id="g2193" transform="translate(-19.843749,257.14192)"><path id="path1803-1-2" class="arrow" d="M218.5,95.1c63.7,93.1,127.5,186.3,191.2,279.4"></path><path id="path1805-1-8" class="arrow" d="M218.5,95.1l191.2-279.8"></path></g></svg>`,
    autoFlipPlayIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 320.2 320.2" style="enable-background:new 0 0 320.2 320.2;" xml:space="preserve"><g><path d="M259.5,158.8c-0.3-7-3.2-13.6-8.3-18.5l-2.4-2.4L130.6,72.7l-4.5-2.3h-5.1l-0.4,0c-7,0.3-13.6,3.1-18.5,8   c-5,4.9-7.9,11.5-8.1,18.7l0,125.6l0,0.4c0.3,7,3.1,13.6,8,18.5c4.9,5,11.5,7.9,18.6,8.1l5.5,0l6.1-3.1l0.3-0.3   c5-2.8,22-12.4,41.5-23.2l0.4-0.2c74.2-41.3,74.9-41.8,76.8-43.7l0.2-0.1c0.3-0.3,0.7-0.7,1.1-1.2   C257.2,172.8,259.8,166,259.5,158.8z M230.3,159.7c-10.6,6.1-42,23.6-69.4,38.8l-0.2,0.1c-22.5,12.5-33.4,18.5-39,21.7V99.8   L230.3,159.7z"/><path d="M160.1,0C71.8,0,0,71.8,0,160.1c0,88.3,71.8,160.1,160.1,160.1c88.3,0,160.1-71.8,160.1-160.1C320.2,71.8,248.4,0,160.1,0z    M160.1,294.2C86.2,294.2,26,234,26,160.1C26,86.2,86.2,26,160.1,26c73.9,0,134.1,60.2,134.1,134.1   C294.2,234,234,294.2,160.1,294.2z"/></g></svg>`,
    autoFlipPauseIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 320.2 320.2" style="enable-background:new 0 0 320.2 320.2;" xml:space="preserve"><path d="M160.1,0C71.8,0,0,71.8,0,160.1s71.8,160.1,160.1,160.1c88.3,0,160.1-71.8,160.1-160.1S248.4,0,160.1,0z M142.5,224.8h-37  V95.4h37V224.8z M214.7,224.8h-37V95.4h37V224.8z"/></svg>`,
    infoIcon: `<svg version="1.1" id="Layer_2_1_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="67.5 35 120 70" enable-background="new 67.5 35 120 70" xml:space="preserve" style="transform: rotate(180deg);"><path display="none" d="M157.7,35.4H97.5c-3,0-5.3,2.3-5.3,5.3V101c0,3,2.3,5.3,5.3,5.3h60.2c3,0,5.3-2.3,5.3-5.3V40.2 C162.7,37.5,160.3,35.4,157.7,35.4z M115.7,41.3H157v43.1h-41.3V41.3z M109.8,100.4H98v-59h11.9V100.4z"></path><g><path d="M128.6,78.9c2,0,3.6-1.6,3.6-3.6l0-24.6c0-2-1.6-3.6-3.6-3.6c-1,0-1.9,0.4-2.5,1.1c-0.7,0.7-1,1.6-1,2.5l0,24.6 C125,77.3,126.6,78.9,128.6,78.9z"></path><path d="M128.6,84.1c-2.8,0-5.1,2.3-5.1,5.1c0,2.8,2.3,5.1,5.1,5.1c2.8,0,5.1-2.3,5.1-5.1C133.7,86.4,131.4,84.1,128.6,84.1z"></path><path d="M128.6,30.9c-22,0-39.9,17.9-39.9,39.9s17.9,39.9,39.9,39.9c22,0,39.9-17.9,39.9-39.9S150.6,30.9,128.6,30.9z M128.6,104.2 c-18.4,0-33.4-15-33.4-33.4c0-18.4,15-33.4,33.4-33.4s33.4,15,33.4,33.4C162,89.2,147,104.2,128.6,104.2z"></path></g></svg>`,
    loaderIcon: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"><circle cx="50" cy="50" fill="none" stroke="#3461c9" stroke-width="6" r="32" stroke-dasharray="150.79644737231007 52.26548245743669"></circle></svg>`,
    galleryFullscreenIcon: `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><path d="M5.4,5.3h13.3c1.5,0,2.7-1.2,2.7-2.7C21.4,1,20.3,0,18.7,0h-16C2.4,0,1.9,0,1.6,0.3C1.1,0.5,0.5,1.1,0.3,1.6C0,1.9,0,2.4,0,2.7v16c0,1.5,1.2,2.7,2.7,2.7c1.6,0,2.7-1.1,2.7-2.7V9.1V5.3z"></path><path d="M58.7,5.4v13.3c0,1.5,1.2,2.7,2.7,2.7c1.6,0,2.6-1.1,2.6-2.7v-16c0-0.3,0-0.8-0.3-1.1c-0.2-0.5-0.8-1.1-1.3-1.3C62.1,0,61.6,0,61.3,0h-16c-1.5,0-2.7,1.2-2.7,2.7c0,1.6,1.1,2.7,2.7,2.7h9.6H58.7z"></path><path d="M58.6,58.7H45.3c-1.5,0-2.7,1.2-2.7,2.7c0,1.6,1.1,2.6,2.7,2.6h16c0.3,0,0.8,0,1.1-0.3c0.5-0.2,1.1-0.8,1.3-1.3c0.3-0.3,0.3-0.8,0.3-1.1v-16c0-1.5-1.2-2.7-2.7-2.7c-1.6,0-2.7,1.1-2.7,2.7v9.6V58.7z"></path><path d="M5.3,58.6V45.3c0-1.5-1.2-2.7-2.7-2.7C1,42.6,0,43.7,0,45.3v16c0,0.3,0,0.8,0.3,1.1c0.2,0.5,0.8,1.1,1.3,1.3C1.9,64,2.4,64,2.7,64h16c1.5,0,2.7-1.2,2.7-2.7c0-1.6-1.1-2.7-2.7-2.7H9.1L5.3,58.6L5.3,58.6z"></path></svg>`
  };

  this.playerControlsIcons = {
    playCircle: `<svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 64 64"><defs><style>.cls-1{fill:#00000080; stroke: #fff;}.cls-1,.cls-2{stroke:#ffffff;stroke-miterlimit:10;stroke-width:2px;}.cls-2{fill:none;}</style></defs><circle class="cls-1" style="" cx="32" cy="32" r="31"/><g id="ico_5" data-name="ico 5"><path class="cls-2" d="M24.1,45.4a2.36,2.36,0,0,1-1.6-.7h0a2.36,2.36,0,0,1-.7-1.6V21.3a2.36,2.36,0,0,1,.7-1.6h0a2.36,2.36,0,0,1,1.6-.7h.3l.2.1L44.9,30.3l.1.1.1.1a2.23,2.23,0,0,1,.1,3.2l-.1.1h0c-.2.2-20.4,11.4-20.5,11.5l-.2.1Z" transform="translate(0 0)"/></g></svg>`,
    play: `<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.79167 57C8.53495 56.958 7.34208 56.4361 6.45833 55.5417C5.56386 54.6579 5.04198 53.465 5 52.2083V6.79167C5.04198 5.53496 5.56386 4.34209 6.45833 3.45833C7.34208 2.56387 8.53495 2.04198 9.79167 2H10.4167L10.8333 2.20833L53.125 25.5417L53.3333 25.75L53.5417 25.9583C54.015 26.3971 54.3926 26.9289 54.6508 27.5205C54.909 28.112 55.0423 28.7504 55.0423 29.3958C55.0423 30.0412 54.909 30.6797 54.6508 31.2712C54.3926 31.8627 54.015 32.3945 53.5417 32.8333C53.125 33.25 11.0417 56.5833 10.8333 56.7917L10.4167 57H9.79167Z" stroke="white" stroke-width="4" stroke-miterlimit="10"/></svg>`,
    audio: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.1 593.65"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_2" data-name="Layer 2"><path  d="M570.9,17.75a24.38,24.38,0,0,0-34.6,0L480,74.05q-5.85-4.2-12-8.1a24.5,24.5,0,1,0-26.2,41.4c1,.6,2,1.3,3,2l-79.5,79.5V24.45a24.49,24.49,0,0,0-40.4-18.6l-186,158.2H24.5A24.54,24.54,0,0,0,0,188.55v216.6a24.54,24.54,0,0,0,24.5,24.5h99.8L12.7,541.25a24.47,24.47,0,1,0,34.6,34.6L570.9,52.35A24.38,24.38,0,0,0,570.9,17.75ZM316.2,237.65,172.4,381.55v-33.1a24.5,24.5,0,0,0-49,0v32.2H49V213h74.4v32.2a24.5,24.5,0,0,0,49,0v-45.4L316.2,77.45Z"/><path  d="M495.3,296.15a109.42,109.42,0,0,0-27.3-72.1l-34.8,34.8a59.8,59.8,0,0,1-22.2,91.9,24.54,24.54,0,0,0,10.1,46.9,23.46,23.46,0,0,0,10-2.2A109.14,109.14,0,0,0,495.3,296.15Z"/><path  d="M316.2,516.15l-75.9-64.5-34.8,34.8,119.3,101.4a24.73,24.73,0,0,0,15.9,5.8,23.43,23.43,0,0,0,10.3-2.3,24.42,24.42,0,0,0,14.2-22.2V326.75l-49,49Z"/><path  d="M560.2,163.25c-3.7-6.5-7.6-12.9-11.8-19.1L513,179.55a225.14,225.14,0,0,1-71.4,307.6,24.5,24.5,0,0,0,13.1,45.2,24.26,24.26,0,0,0,13.1-3.8,276.65,276.65,0,0,0,92.3-97.3,274.36,274.36,0,0,0,.1-268Z"/></g></g></svg>`,
    audioOn: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.2 593.65"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_2" data-name="Layer 2"><path d="M351,2.25a24.57,24.57,0,0,0-26.2,3.6l-186,158.2H24.5A24.54,24.54,0,0,0,0,188.55v216.6a24.54,24.54,0,0,0,24.5,24.5H138.9l186,158.2a24.73,24.73,0,0,0,15.9,5.8,23.43,23.43,0,0,0,10.3-2.3,24.42,24.42,0,0,0,14.2-22.2V24.55A24.72,24.72,0,0,0,351,2.25Zm-34.8,514L172.4,393.85v-45.4a24.5,24.5,0,0,0-49,0v32.2H49V213.05h74.4v32.2a24.5,24.5,0,0,0,49,0v-45.4L316.2,77.55Z" /><path d="M495.2,296.25A109,109,0,0,0,431,197a24.51,24.51,0,0,0-20.1,44.7,59.88,59.88,0,0,1,0,109.2,24.54,24.54,0,0,0,10.1,46.9,23.78,23.78,0,0,0,10-2.2A109.08,109.08,0,0,0,495.2,296.25Z" /><path d="M560.2,163.35a275.81,275.81,0,0,0-92.3-97.3,24.5,24.5,0,1,0-26.2,41.4,224.8,224.8,0,0,1,0,379.8,24.5,24.5,0,0,0,13.1,45.2,24.26,24.26,0,0,0,13.1-3.8,276.65,276.65,0,0,0,92.3-97.3,274,274,0,0,0,0-268Z" /></g></g></svg>`,
    audioOff: `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.1 593.65"><g id="Warstwa_2" data-name="Warstwa 2"><g id="Layer_2" data-name="Layer 2"><path  d="M570.9,17.75a24.38,24.38,0,0,0-34.6,0L480,74.05q-5.85-4.2-12-8.1a24.5,24.5,0,1,0-26.2,41.4c1,.6,2,1.3,3,2l-79.5,79.5V24.45a24.49,24.49,0,0,0-40.4-18.6l-186,158.2H24.5A24.54,24.54,0,0,0,0,188.55v216.6a24.54,24.54,0,0,0,24.5,24.5h99.8L12.7,541.25a24.47,24.47,0,1,0,34.6,34.6L570.9,52.35A24.38,24.38,0,0,0,570.9,17.75ZM316.2,237.65,172.4,381.55v-33.1a24.5,24.5,0,0,0-49,0v32.2H49V213h74.4v32.2a24.5,24.5,0,0,0,49,0v-45.4L316.2,77.45Z"/><path  d="M495.3,296.15a109.42,109.42,0,0,0-27.3-72.1l-34.8,34.8a59.8,59.8,0,0,1-22.2,91.9,24.54,24.54,0,0,0,10.1,46.9,23.46,23.46,0,0,0,10-2.2A109.14,109.14,0,0,0,495.3,296.15Z"/><path  d="M316.2,516.15l-75.9-64.5-34.8,34.8,119.3,101.4a24.73,24.73,0,0,0,15.9,5.8,23.43,23.43,0,0,0,10.3-2.3,24.42,24.42,0,0,0,14.2-22.2V326.75l-49,49Z"/><path  d="M560.2,163.25c-3.7-6.5-7.6-12.9-11.8-19.1L513,179.55a225.14,225.14,0,0,1-71.4,307.6,24.5,24.5,0,0,0,13.1,45.2,24.26,24.26,0,0,0,13.1-3.8,276.65,276.65,0,0,0,92.3-97.3,274.36,274.36,0,0,0,.1-268Z"/></g></g></svg>`,
  };
})();
