APPonReady.add(function () {
  APP.AudioPlayer = new (function () {
    self = this;
    let _player = null;
    
    const _soundIcons = {
      max: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.15838 13.9306C2.44537 12.7423 2.44537 11.2577 3.15838 10.0694V10.0694C3.37596 9.70674 3.73641 9.45272 4.1511 9.36978L5.84413 9.03117C5.94499 9.011 6.03591 8.95691 6.10176 8.87788L8.17085 6.39498C9.3534 4.97592 9.94468 4.26638 10.4723 4.45742C11 4.64846 11 5.57207 11 7.41928L11 16.5807C11 18.4279 11 19.3515 10.4723 19.5426C9.94468 19.7336 9.3534 19.0241 8.17085 17.605L6.10176 15.1221C6.03591 15.0431 5.94499 14.989 5.84413 14.9688L4.1511 14.6302C3.73641 14.5473 3.37596 14.2933 3.15838 13.9306V13.9306Z" stroke="#97E1AD" stroke-width="2"/><path d="M15.5355 8.46447C16.4684 9.39732 16.9948 10.6611 17 11.9803C17.0052 13.2996 16.4888 14.5674 15.5633 15.5076" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/><path d="M19.6569 6.34314C21.1494 7.83572 21.9916 9.85769 21.9999 11.9685C22.0083 14.0793 21.182 16.1078 19.7012 17.6121" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/></svg>',
      min: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.15838 13.9306C2.44537 12.7423 2.44537 11.2577 3.15838 10.0694V10.0694C3.37596 9.70674 3.73641 9.45272 4.1511 9.36978L5.84413 9.03117C5.94499 9.011 6.03591 8.95691 6.10176 8.87788L8.17085 6.39498C9.3534 4.97592 9.94468 4.26638 10.4723 4.45742C11 4.64846 11 5.57207 11 7.41928L11 16.5807C11 18.4279 11 19.3515 10.4723 19.5426C9.94468 19.7336 9.3534 19.0241 8.17085 17.605L6.10176 15.1221C6.03591 15.0431 5.94499 14.989 5.84413 14.9688L4.1511 14.6302C3.73641 14.5473 3.37596 14.2933 3.15838 13.9306V13.9306Z" stroke="#97E1AD" stroke-width="2"/><path d="M15.5355 8.46447C16.4684 9.39732 16.9948 10.6611 17 11.9803C17.0052 13.2996 16.4888 14.5674 15.5633 15.5076" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/></svg>',
      mute: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.15838 13.9306C2.44537 12.7423 2.44537 11.2577 3.15838 10.0694V10.0694C3.37596 9.70674 3.73641 9.45272 4.1511 9.36978L5.84413 9.03117C5.94499 9.011 6.03591 8.95691 6.10176 8.87788L8.17085 6.39498C9.3534 4.97592 9.94468 4.26638 10.4723 4.45742C11 4.64846 11 5.57207 11 7.41928L11 16.5807C11 18.4279 11 19.3515 10.4723 19.5426C9.94468 19.7336 9.3534 19.0241 8.17085 17.605L6.10176 15.1221C6.03591 15.0431 5.94499 14.989 5.84413 14.9688L4.1511 14.6302C3.73641 14.5473 3.37596 14.2933 3.15838 13.9306V13.9306Z" stroke="#97E1AD" stroke-width="2"/><path d="M15 15L21 9" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/><path d="M21 15L15 9" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/></svg>',
    };
    
    const _stateIcons = {
      play: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.2111 11.1056L9.73666 7.86833C8.93878 7.46939 8 8.04958 8 8.94164V15.0584C8 15.9504 8.93878 16.5306 9.73666 16.1317L16.2111 12.8944C16.9482 12.5259 16.9482 11.4741 16.2111 11.1056Z" stroke="#97E1AD" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
      pause: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="6" y="5" width="4" height="14" rx="1" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/><rect x="14" y="5" width="4" height="14" rx="1" stroke="#97E1AD" stroke-width="2" stroke-linecap="round"/></svg>',
      close: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9 9L15 15" stroke="#CCD2E3" stroke-width="2" stroke-linecap="round"/><path d="M15 9L9 15" stroke="#CCD2E3" stroke-width="2" stroke-linecap="round"/></svg>'
    };
    
    const _elementsSizes = {
      wrapper: 430,
      audioInfo: 285,
      audioProgress: 200,
      audioInner: 15,
      volumeWrapper: 80,
      volumeProgress: 60,
      volumeInner: 15
    };
    
    let _initialState = {
      state: 'pause',
      prevState: null,
      volume: 20,
      muted: false,
      autoplay: true,
      color: '#97E1AD',
      position: {
        x: 50,
        y: 5
      }
    };
    
    this.Init = function (model) {
      if (_player && _player.audio) {
        return;
      }
      
      _initialState = {
        ..._initialState,
        autoplay: true,//APP.someUserIteractions
      };
    
      createPlayer(model.value);
    };
    
    const createPlayer = function (data) {
      const mainWrapper = document.querySelector('.Book__inner');
      const wrapper = document.createElement('div');
      const audio = new Audio(data);  
    
      wrapper.className = 'wrapper';
      audio.className = 'audio';

      _player = {
        ..._player,
        ..._initialState,
        wrapper: wrapper,
        audio: audio,
        mainWrapper: mainWrapper,
        ...getSettings()
      };
    
      createControls(wrapper);
      setHandlers();
    
      wrapper.style = `top: ${_player.position.y}%; left: ${_player.position.x}%;`;
      wrapper.appendChild(audio);
      mainWrapper.appendChild(wrapper);
      mainWrapper.removeAttribute('hidden');
    };
    
    const createControls = function (wrapper) {
      const playBtn = document.createElement('div');
      const soundBtn = document.createElement('div');
      const closeBtn = document.createElement('div');
    
      const soundBtnWrapper = document.createElement('div');
      const soundProgressWrapper = document.createElement('div');
      const progressWrapper = document.createElement('div');
    
      const currentTime = document.createElement('span');
      const durationTime = document.createElement('span');
    
      const progressBar = document.createElement('div');
      const progressBarInner = document.createElement('div');
      const soundProgressBar = document.createElement('div');
      const soundProgressBarInner = document.createElement('div');

      const moveBtn = document.createElement('div');
      moveBtn.appendChild(document.createElement('div'));
      moveBtn.appendChild(document.createElement('div'));
      moveBtn.appendChild(document.createElement('div'));
    
      playBtn.className = 'audio__control audio__control--play';
      soundBtn.className = 'audio__control audio__control--sound';
      closeBtn.className = 'audio__control audio__control--close';
    
      currentTime.className = 'audio__time';
      durationTime.className = 'audio__time';
    
      progressBar.className = 'audio__progress';
      progressBarInner.className = 'audio__progress__inner';
    
      soundProgressWrapper.className = 'audio__sound__progress__wrapper';
      soundProgressBar.className = 'audio__sound__progress';
      soundProgressBarInner.className = 'audio__sound__inner';
    
      progressWrapper.className = 'audio__info'
      soundBtnWrapper.className = 'audio__sound__wrapper';

      moveBtn.className = 'audio__move-btn';
    
      closeBtn.innerHTML = _stateIcons.close;
      currentTime.innerText = '0:00';
      durationTime.innerText = '0:00';
    
      progressBar.appendChild(progressBarInner);
      soundProgressBar.appendChild(soundProgressBarInner);
      soundProgressWrapper.appendChild(soundProgressBar);
    
      progressWrapper.appendChild(currentTime);
      progressWrapper.appendChild(progressBar);
      progressWrapper.appendChild(durationTime);
      soundBtnWrapper.appendChild(soundBtn);
      soundBtnWrapper.appendChild(soundProgressWrapper);
    
      _player = {
        ..._player,
        closeBtn: closeBtn,
        playBtn: playBtn,
        soundBtn: soundBtn,
        currentTimeEl: currentTime,
        durationTimeEl: durationTime,
        progressBar: progressBar,
        progressInner: progressBarInner,
        progressWrapper: progressWrapper,
        soundProgressWrapper: soundProgressWrapper,
        soundProgressBar: soundProgressBar,
        soundProgressInner: soundProgressBarInner,
        moveBtn: moveBtn
      }
    
      setSoundIconByLevel();
      setStateIcon();
      setVolume();
      
      wrapper.appendChild(playBtn);
      wrapper.appendChild(progressWrapper);
      wrapper.appendChild(soundBtnWrapper);
      wrapper.appendChild(closeBtn);

      if (!is_mobile()) {
        wrapper.appendChild(moveBtn);
      }
    }
    
    const setSoundIconByLevel = function (value = null) {
      const volume = value || _player.volume;
    
      if (volume > 50) {
        _player.soundBtn.innerHTML = _soundIcons.max;
      }
    
      if (volume < 50) {
        _player.soundBtn.innerHTML = _soundIcons.min;
      }
    
      if (volume <= 0 || _player.muted) {
        _player.soundBtn.innerHTML = _soundIcons.mute;
      }
    }
    
    const setStateIcon = function () {
      if (_player.state == 'play') {
        _player.playBtn.innerHTML = _stateIcons.pause;
      }
    
      if(_player.state == 'pause') {
        _player.playBtn.innerHTML = _stateIcons.play;
      }
    }
    
    const setHandlers = function () { 
      let isMouseDown = false;
      let isVolumeMouseDown = false;
      let isMoveMouseDown = false;

      _player.moveBtn.addEventListener('mousedown', () => {
        isMoveMouseDown = true;
      })

      _player.mainWrapper.addEventListener('mousemove', (e) => {
        if (!isMoveMouseDown) {
          return;
        }

        let newPosX = e.clientX - _elementsSizes.wrapper / 2 + 5;
        let newPosY = e.clientY - 35;
        
        const maxX = window.innerWidth - 10;
        const minX = _elementsSizes.wrapper;
        const maxY = window.innerHeight - 50 - 15;
        const minY = 50 + 35;

        if (e.clientX <= minX) {
          newPosX = minX / 2 + 5;
        }

        if (e.clientX >= maxX) {
          newPosX = maxX - _elementsSizes.wrapper / 2 + 5;
        }

        if (e.clientY <= minY) {
          newPosY = minY - 35;
        }

        if (e.clientY >= maxY) {
          newPosY = maxY - 35;
        }

        const newPosXPercent = parseFloat(parseFloat(newPosX * 100 / window.innerWidth).toFixed(2));
        const newPosYPercent = parseFloat(parseFloat(newPosY * 100 / window.innerHeight).toFixed(2));

        _player.wrapper.style = `top: ${newPosYPercent}%; left: ${newPosXPercent}%`;
        _player.position.x = newPosXPercent;
        _player.position.y = newPosYPercent;
      });

      new Array('mouseup', 'mouseleave').forEach(evt => {
        _player.mainWrapper.addEventListener(evt, () => {
          if (!isMoveMouseDown) {
            return;
          }

          isMoveMouseDown = false;
          updateSettings();
        });
      });
    
      _player.closeBtn.addEventListener('click', closePlayer);
      _player.audio.addEventListener('loadedmetadata', audioOnLoad);
    
      _player.audio.addEventListener('play', () => changeState('play'));
      _player.audio.addEventListener('pause', () => changeState('pause'));
    
      _player.audio.addEventListener('timeupdate', update);
    
      _player.soundBtn.addEventListener('click', () => {
        let prevMuteState = _player.muted;
    
        _player.muted = !_player.muted;
        setVolume(null, false, prevMuteState);
      });
    
      _player.playBtn.addEventListener('click', () => {
        if (_player.state == 'play') {
          changeState('pause');
        } else if (_player.state == 'pause') {
          changeState('play');
        }
      })
    
      _player.progressBar.addEventListener('click', (e) => {
        if (e.target == _player.progressInner) {
          return;
        }
    
        const percent = e.offsetX * 100 / _elementsSizes.audioProgress;
        const newTime = percent * _player.audio.duration / 100;
        setCurrentTime(newTime);
      })
    
      _player.soundProgressBar.addEventListener('click', (e) => {
        if (e.target == _player.soundProgressInner) {
          return;
        }
    
        const newVolume = (_elementsSizes.volumeProgress - e.offsetY) * 100 / _elementsSizes.volumeProgress;
        setVolume(newVolume);
      })
    
      new Array('mousedown', 'touchstart').forEach(evt => {
        _player.progressInner.addEventListener(evt, () => {
          isMouseDown = true;
          _player.progressInner.style.pointerEvents = 'none';
        })
      });

      new Array('mousemove', 'touchmove').forEach(evt => {
        _player.progressWrapper.addEventListener(evt, (e) => {
          if (!isMouseDown) {
            return;
          }

          let offsetX = e.offsetX;

          if (is_mobile()) {
            offsetX = e.touches[0].clientX - _player.wrapper.getBoundingClientRect().x - 50;
          }
          
          if (_player.progressInner.style.pointerEvents == 'all') {
            _player.progressInner.style.pointerEvents = 'none';
          }

          if (!_player.prevState && _player.state != _player.prevState) {
            _player.prevState = _player.state;
          }
          changeState('pause');
      
          const newPos = offsetX - parseFloat(_elementsSizes.audioInner / 2) - (e.target != _player.progressBar ? (_player.currentTimeEl.getBoundingClientRect().width + 15) : 0);
          const maxPos = _elementsSizes.audioProgress - parseFloat(_elementsSizes.audioInner / 2);
          const minPos = -(parseFloat(_elementsSizes.audioInner / 2));
          const progress = newPos * 100 / _elementsSizes.audioProgress;
      
          if (newPos >= maxPos) {
            _player.progressInner.style.left = `${maxPos}px`;
          } else if (newPos <= minPos) {
            _player.progressInner.style.left = `${minPos}px`;
          } else {
            _player.progressInner.style.left = `${newPos}px`;
          }
      
          _player.progressBar.style.background = `linear-gradient(to right, ${_initialState.color} 0%, ${_initialState.color} ${progress}%, rgba(215, 215, 215, 0.5) ${progress}%, rgba(215, 215, 215, 0.5) 100%)`;
        });
      });
    
      new Array('mouseup', 'mouseleave', 'touchend').forEach(evt => {
        _player.progressWrapper.addEventListener(evt, (e) => {
          _player.progressInner.style.pointerEvents = 'all';
          if (!isMouseDown) {
            return;
          }
      
          const timePercent = (parseInt(_player.progressInner.style.left) + parseFloat(_elementsSizes.audioInner / 2)) * 100 / _elementsSizes.audioProgress;
          const audioPercent = timePercent * _player.audio.duration / 100;
    
          setCurrentTime(audioPercent);
          changeState(_player.prevState);
          update();
    
          _player.prevState = null;
          isMouseDown = false;
        })
      });
    
      new Array('mousedown', 'touchstart').forEach(evt => {
        _player.soundProgressInner.addEventListener(evt, (e) => {
          isVolumeMouseDown = true;
          _player.soundProgressInner.style.pointerEvents = 'none';
        })
      });

      new Array('mousemove', 'touchmove').forEach(evt => {
        _player.soundProgressWrapper.addEventListener(evt, (e) => {
          if (!isVolumeMouseDown) {
            return;
          }

          let offsetY = e.offsetY;

          if (is_mobile()) {
            offsetY = e.touches[0].clientY - _player.soundProgressWrapper.getBoundingClientRect().y - 10;
          }
      
          if (_player.soundProgressInner.style.pointerEvents == 'all') {
            _player.soundProgressInner.style.pointerEvents = 'none';
          }
      
          const newPos = offsetY - parseFloat(_elementsSizes.volumeInner / 2) + (e.target != _player.soundProgressWrapper ? 10 : 0);
          const maxPos = _elementsSizes.volumeProgress;
          const minPos = 0;
          const progress = 100 - (newPos * 100 / _elementsSizes.volumeProgress);
      
          if (newPos <= minPos) {
            _player.soundProgressInner.style.bottom = `${_elementsSizes.volumeProgress - minPos - parseFloat(_elementsSizes.volumeInner / 2)}px`;
          } else if (newPos >= maxPos) {
            _player.soundProgressInner.style.bottom = `${_elementsSizes.volumeProgress - maxPos - parseFloat(_elementsSizes.volumeInner / 2)}px`;
          } else {
            _player.soundProgressInner.style.bottom = `${_elementsSizes.volumeProgress - newPos - parseFloat(_elementsSizes.volumeInner / 2)}px`;
          }
      
          _player.soundProgressBar.style.background = `linear-gradient(to top, ${_initialState.color} 0%, ${_initialState.color} ${progress}%, rgba(215, 215, 215, 0.5) ${progress}%, rgba(215, 215, 215, 0.5) 100%)`;
          setSoundIconByLevel(progress);
        });
      });
    
      new Array('mouseup', 'mouseleave', 'touchend').forEach(evt => {
        _player.soundProgressWrapper.addEventListener(evt, () => {
          _player.soundProgressInner.style.pointerEvents = 'all';
          if (!isVolumeMouseDown) {
            return;
          }
    
          let innerBottomOfsset = parseInt(_player.soundProgressInner.style.bottom);
    
          if (!innerBottomOfsset) {
            const innerBottomOfssetPercent = _player.soundProgressInner.style.bottom.trim().split('%', 1)[0].split('calc(')[1];
            innerBottomOfsset = _elementsSizes.volumeProgress * innerBottomOfssetPercent / 100 - 7.5;
          }
    
          let volumePercent = ((innerBottomOfsset + 7) * 100 / _elementsSizes.volumeProgress);
    
          if (volumePercent >= 100) {
            volumePercent = 100;
          } else if (volumePercent <= 0) {
            volumePercent = 0;
          }
    
          _player.volume = volumePercent;
          setVolume(volumePercent, true);
    
          isVolumeMouseDown = false;
        })
      })
    }
    
    const closePlayer = function () {
      _player.wrapper.remove();
      _player = {};
    }
    
    const update = function () {
      if (!_player.audio) {
        return;
      }
    
      updateCurrentTime();
      updateProgress();
    }
    
    const setCurrentTime = function (time) {
      if (time) {
        _player.audio.currentTime = time;
      }
    }
    
    const updateCurrentTime = function () {
      const currentTime = parseInt(_player.audio.currentTime);
      const minutes = Math.floor(currentTime / 60);
      const seconds = currentTime - minutes * 60;
      const newTime = `${minutes}:${seconds < 10 ? '0' + seconds : seconds}`
    
      _player.currentTimeEl.innerHTML = newTime;
    }
    
    const updateProgress = function () {
      const currentTime  = _player.audio.currentTime;
      const duration = _player.audio.duration;
      const progress = currentTime * 100 / duration;
      
      _player.progressInner.style.left = `calc(${progress}% - ${_elementsSizes.audioInner / 2}px)`;
      _player.progressBar.style.background = `linear-gradient(to right, ${_initialState.color} 0%, ${_initialState.color} ${progress}%, rgba(215, 215, 215, 0.5) ${progress}%, rgba(215, 215, 215, 0.5) 100%)`;
    }
    
    const changeState = function (state) {
      if (!_player.audio) {
        return;
      }

      if (_player.state != state) {
        _player.state = state;
        onChangeState();
      }
    }
    
    const onChangeState = function () {
      if (!_player.audio) {
        return;
      }  
    
      if (_player.state == 'play') {
        _player.audio.play().catch(() => changeState('pause'));
      }
      if (_player.state == 'pause') {
        _player.audio.pause();
      }
    
      setStateIcon();
    }
    
    const audioOnLoad = function () {
      if (!_player.audio) {
        return;
      }
    
      const audioDuration = _player.audio.duration;
      _player.durationTimeEl.innerHTML = audioDuration ? parseFloat(audioDuration / 60).toFixed(2).replace('.', ':') : '0:00';
    
      if (_player.autoplay) {
        changeState('play');
      }
    
      setVolume(_player.volume);
    }
    
    const setVolume = function (value = null, isMove = false, prevMuteState) {
      let newVolume =  0;
    
      if (_player.muted && value == null) {
        _player.audio.volume = 0;
        newVolume = 0;
      } else {
        _player.muted = false;
        
        if (value == null) {
          value = _player.volume;
        }
    
        if (!_player.muted && prevMuteState && value <= 0) {
          value = _initialState.volume;
        }
    
        _player.volume = value;
        newVolume = _player.volume;
        _player.audio.volume = parseFloat(_player.volume / 100).toFixed(2);
      }
    
      if (!isMove) {
        _player.soundProgressInner.style.bottom = `calc(${newVolume}% - 7.5px)`;
      }
      _player.soundProgressBar.style.background = `linear-gradient(to top, ${_initialState.color} 0%, ${_initialState.color} ${newVolume}%, rgba(215, 215, 215, 0.5) ${newVolume}%, rgba(215, 215, 215, 0.5) 100%)`;
    
      setSoundIconByLevel(null);
      updateSettings();
    }

    const updateSettings = function () {
      if (!HELPER.isLocalStorageAvailable() || is_mobile()) {
        return;
      }

      let settings = getSettings();

      settings = {
        ...settings,
        volume: _player.volume,
        muted: _player.muted,
        position: {
          x: _player.position.x,
          y: _player.position.y
        }
      };

      localStorage.setItem('audio_settings', JSON.stringify(settings));
    }

    const getSettings = function () {
      if (!HELPER.isLocalStorageAvailable() || is_mobile()) {
        return;
      }

      const settings = localStorage.getItem('audio_settings') || {};

      if (settings.length) {
        return JSON.parse(settings);
      }

      return {};
    }
  });
});