'use strict';

window.APP = new (function () {
  var self = this;
  var is_ready = false;
  let canReceiveMessages = false;
  this.someUserIteraction = false;
  this.countOfSendedErrorLogs = 0;
  this.accessAllowed = null;
  this.customizeSettings = {};

  this.PATH_CLOUDFRONT_DEMO = 'https://d1u9ua4yk0lyeu.cloudfront.net/cms/publishers/demo';

  this.ROOT_PATH = window._config ? window._config.ROOT_PATH : 'https://va.publuu.com/publuudev/';
  this.API_PUBLUU = window._config ? window._config.API_PUBLUU : 'https://apia.publuu.com';
  this.CMS_PUBLUU_CF = window._config ? window._config.CMS_PUBLUU_CF : 'https://d2w027ie3xfjy7.cloudfront.net'; // nie uzywane 
  this.PATH_CF_FLIP = window._config ? window._config.PATH_CF_FLIP : 'https://dbxsqivh2nmr7.cloudfront.net/flipbook/202310/';
  this.VIEWER_API = window._config.VIEWER_API || 'https://5708wwmg3f.execute-api.eu-west-1.amazonaws.com/viewer/';

  this.CLOUDFRONT_ASSETS_DEBUG = 'https://dbxsqivh2nmr7.cloudfront.net/flipbook/20221118/'
  this.CLOUDFRONT_ASSETS = 'https://d1u9ua4yk0lyeu.cloudfront.net/';
  this.AMAZON_ASSETS = 'https://flipbook-assets.s3.us-east-2.amazonaws.com/';
  this.PATH_V2IMAGE = 'https://ga.publuu.com/v2image.php';
  this.PATH_V2SVG = 'https://ga.publuu.com/v2svg.php';
  this.PATH_FORLANDING = 'https://publuu.com/flipbook-maker';
  this.PATH_FORLOGODEF = 'https://publuu.com/flipbook-maker';

  window._config = {
    VERSION: window._config.VERSION
  };
  var resizeEvent = window.document.createEvent('UIEvents');
  resizeEvent.initUIEvent('resize', true, false, window, 0);

  const initializeCookies = () => {
    this.showCookies = () => {};

    const cookiesRegulation = document.querySelector('#cookies-regulation');
  
    if (!cookiesRegulation) {
      return;
    }
  
    const cookiesLine = cookiesRegulation.querySelector('.cookies__line');
    const cookiesModal = cookiesRegulation.querySelector('.cookies__modal');
    const manageCookiesBtn = cookiesRegulation.querySelector('.cookies__btn--manage');
    const grantChoicesBtn = cookiesRegulation.querySelector('.cookies__btn--grant-choices');
    const grantAllPermissionsBtns = Array.from(cookiesRegulation.querySelectorAll('.cookies__btn--grant-all'));
  
    const ACTIVE_CLASSNAME = 'active';
    const COOKIE_KEY = 'pv-cookies-accepted';
    const COOKIE_VALUE = 'yes';
    const COOKIE_EXPIRE = 31;
    const COOKIE_GRANTED = 'granted';
    const COOKIE_DENIED = 'denied';
  
    const areCookiesEnabled = () => {
      const testCookie = "test_cookie";
      document.cookie = `${testCookie}=1; path=/`;
  
      const cookiesEnabled = document.cookie.indexOf(`${testCookie}=1`) !== -1;
  
      document.cookie = `${testCookie}=; path=/; expires=Thu, 01 Jan 1970 00:00:00 UTC;`;
  
      return cookiesEnabled;
    };
  
    if (!areCookiesEnabled()) {
      return;
    }

    initializeSwitches();
  
    if (!document.cookie.includes('pv-cookies-accepted')) {
      cookiesRegulation.removeAttribute('hidden');
    }

    this.showCookies = () => {
      setTimeout(() => cookiesRegulation.removeAttribute('hidden'), 0);
    };
  
    const setCookie = () => {
      const expireDate = new Date();
      expireDate.setDate(expireDate.getDate() + COOKIE_EXPIRE);
  
      const cookiesValue = `${COOKIE_VALUE}; expires=${expireDate.toUTCString()}`;
  
      document.cookie = `${COOKIE_KEY}=${cookiesValue}; path=/`;
    };
  
    const updateConsent = (consents) => {
      if (!window.gtag) return;
  
      gtag('consent', 'update', consents);
    };
  
    const getOptions = (forceValue = false) => {
      const defaultOptions = {
        'essential-cookies': {
          'analytics_storage': COOKIE_GRANTED
        },
        'advertising-cookies': {
          'ad_storage': COOKIE_DENIED,
          'ad_user_data': COOKIE_DENIED,
          'ad_personalization': COOKIE_DENIED,
        },
        'performance-cookies': {}
      };
  
      const options = Array.from(cookiesRegulation.querySelectorAll('.cookies__option'));
  
      options.forEach(option => {
        if (!defaultOptions.hasOwnProperty(option.id)) {
          return;
        }
  
        Object.keys(defaultOptions[option.id]).forEach(key => defaultOptions[option.id][key] = option.checked || forceValue ? COOKIE_GRANTED : COOKIE_DENIED);
      });
  
      const flatValues = Object.values(defaultOptions).reduce((acc, obj) => {
        if (typeof obj === 'object' && obj !== null) {
          Object.assign(acc, obj);
        }
  
        return acc;
      }, {});
  
      return flatValues;
    };
  
    const handleGrantPermissions = (grantAllPermissions = false) => {
      const consents = getOptions(grantAllPermissions);
      
      console.log(consents);
      setCookie();
      updateConsent(consents);
  
      const isModalVisible = cookiesModal.checkVisibility({
        opacityProperty: true,
        visibilityProperty: true
      });
  
      if (isModalVisible) {
        cookiesModal.classList.remove(ACTIVE_CLASSNAME);
    
        setTimeout(() => {
          cookiesRegulation.setAttribute('hidden', true);
        }, 500);
      } else {
        cookiesRegulation.setAttribute('hidden', true);
      }
    };
  
    const handleManageCookies = () => {
      cookiesModal.classList.add(ACTIVE_CLASSNAME);
      cookiesLine.classList.remove(ACTIVE_CLASSNAME);
    };
    
    grantAllPermissionsBtns.forEach(acceptBtn => acceptBtn.addEventListener('click', () => handleGrantPermissions(true)));
    grantChoicesBtn.addEventListener('click', () => handleGrantPermissions());
    manageCookiesBtn.addEventListener('click', handleManageCookies);
  };

  const initializeSwitches = () => {
    const switches = Array.from(document.querySelectorAll('.form__switch'));
  
    if (switches.length === 0) {
      return;
    }
  
    const handleSwitchText = (sw) => {
      const switchText = sw.querySelector('.form__switch__text');
  
      if (switchText && switchText.dataset && switchText.dataset.textOn && switchText.dataset.textOff) {
        const switchState = sw.querySelector('input').checked;
        const newSwitchText = switchState ? switchText.dataset.textOn : switchText.dataset.textOff;
  
        switchText.innerHTML = newSwitchText;
      }
    };
  
    const handleSwitchChange = (sw) => {
      handleSwitchText(sw);
    };
  
    const initializeSwitch = (sw) => {
      const switchInput = sw.querySelector('input');
  
      if (!switchInput) {
        return;
      }
  
      switchInput.addEventListener('change', () => handleSwitchChange(sw));
    };
  
    switches.forEach(initializeSwitch);
  };

  initializeCookies();

  if (customizemode) {
    window.parent.postMessage({ getCustomizeSettings: 1 }, '*');
  }

  if (customizemode) {
    document.querySelector('body').addEventListener('click', function() {
      window.parent.postMessage({ clicked: true }, '*');
    });
  }

  this.isStringified = function (str) { 
    try {
      return JSON.parse(str);  
    } catch(e) { 
      return str;
    } 
  };

  const decodeBookModel = (bookModel) => {
    bookModel = self.isStringified(bookModel);
    
    if ('error' in bookModel || !Object.keys(bookModel).length) {
      bookModel['error'] = true;
      return bookModel;
    }
    
    for (const [key, value] of Object.entries(bookModel)) {
      if (key == 'interactivities') {
        bookModel['interactivites'] = self.isStringified(value);
        delete bookModel[key];
      } else {
        bookModel[key] = self.isStringified(value);
      }
    }

    
    return bookModel;
  }
  this.bookModel = decodeBookModel(bookModel);

  const formatDomain = (domain) => {
    const protocol = domain.split('://')[0];
    let formatedDomain = protocol + '://' + domain.split('://')[1].split('/')[0];

    if (formatedDomain.startsWith(protocol + '://www.')) {
      formatedDomain = formatedDomain.replace(protocol + '://www.', protocol + '://');
    }
    
    return formatedDomain;
  };
  
  this.checkProtectedEmbed = (settings) => {
    const redirectURI = `https://publuu.com/flipbook-maker/#dae_${settings.pid}_${settings.iid}`;
    const MAX_TIME = 60;
    let serverTime = document.body.getAttribute('servertime');
    let accessAllowed = false;

    // if (serverTime) {
    //   serverTime = new Date(parseInt(document.body.getAttribute('servertime')) * 1000);
    //   console.log(parseInt(Math.abs(serverTime - new Date()) / 1000), MAX_TIME);
    //   if (parseInt(Math.abs(serverTime - new Date()) / 1000) >= MAX_TIME) {
    //     accessAllowed = false;
    //     window.location.href(redirectURI);
    //   }
    // }

    if (!settings.enable_protected_domain || settings.customize_mode) return true;

    const htmlDecodedString = settings.protected_domains.replace(/&quot;/g, '"').replace(/\\\//g, '/');
    const domains = JSON.parse(htmlDecodedString);
    const isEmbed = is_embed();

    if (isEmbed.url.startsWith('https://cmsa.publuu.com') || 
        isEmbed.url.startsWith('https://cms1.publuu.com')) {
      accessAllowed = true;
    } else {
        const formatedDomains = domains.map(domain => formatDomain(domain.domain));

        isEmbed.url = isEmbed.url.replace("://www.","://");

        accessAllowed = formatedDomains.some(domain => domain.startsWith(isEmbed.url) || isEmbed.url.startsWith(domain)) || false;
        
        if (!accessAllowed) {
          const referrer = document.referrer && document.referrer.length > 0 ? formatDomain(document.referrer) : null;

          if (referrer) {
            accessAllowed = formatedDomains.some(domain => domain.startsWith(referrer) || referrer.startsWith(domain)) || false;
          }
        }
       
        if( settings.dlid_verified ){
          console_log('dlid_verified');
          accessAllowed = true;
        }
    }

    if (settings.pp != 0 && !accessAllowed) {
      const decryptedSettings = decryptString(settings.pp); 

      if (decryptedSettings > Date.now() && decryptedSettings <= Date.now() + 30000) {
        accessAllowed = true;
      }
    }
    
    this.accessAllowed = accessAllowed;

    if (!accessAllowed) {
      document.querySelector('body').style.background = '#fff';

      if (!isEmbed.url.includes('publuu.com')) {
        const waitForLogs = setInterval(() => {
          if (oLogs && oLogs.log_send_error) {
            oLogs.log_send_error(bookId, publisherId, {
              acc: 'WrongHost',
              data: document.location.href,
              embed: isEmbed,
              model: APP.bookModel
            });
            clearInterval(waitForLogs);
          }
        }, 100);
      }
    }
    
    return accessAllowed ? true : false; //window.location.href = redirectURI
  };

  const decryptString = (encoded) => {
    const salt = navigator.productSub.toString();
    const textToChars = (text) => text.split("").map((c) => c.charCodeAt(0));
    const applySaltToChar = (code) => textToChars(salt).reduce((a, b) => a ^ b, code);

    return encoded
      .match(/.{1,2}/g)
      .map((hex) => parseInt(hex, 16))
      .map(applySaltToChar)
      .map((charCode) => String.fromCharCode(charCode))
      .join("");
  };

  this._t = (key, options) => {
    if (!window.hasOwnProperty('_translations') || !window._translations.hasOwnProperty(key)) {
      return key;
    }

    let translation = window._translations[key];

    if (Array.isArray(options) && options.length > 0) {
      options.forEach(option => translation = translation.replace('{n}', option));
    }

    return translation;
  }

  var Consoler = new (function () {
    var el = false;
    this.log = function (e) {
      if (!el) {
        el = document.createElement('div');
        el.setAttribute(
          'style',
          'position:fixed;bottom:0;right:0;width:200px;padding:5px;font-size:10px;background:rgba(0,0,0,0.75);color:green;z-index:999999;display:flex;flex-direction:column-reverse;max-height:200px;overflow:auto',
        );
        document.body.appendChild(el);
      }
      var _el;
      for (var i in arguments) {
        if (is_string(arguments[i]) || is_numeric(arguments[i])) {
          if (el.childElementCount > 50) el.removeChild(el.firstChild);
          _el = document.createElement('div');
          _el.innerText = arguments[i];
          el.appendChild(_el);
          el.scrollTop = 0;
        }
      }
    };
  })();
  this.log = console.log; // Simple way to show or not log

  this.onSomeUserIteraction = () => {
    // if (self.Book) {
    //   if (!self.Book.getLoaderStatus()) {
    //     return false;
    //   } else {
        self.someUserIteraction = true;
    //   }
    // }
    if (APP.Book) {
      APP.Book.handleUserInteraction();
    }
  }

  ['mousedown', 'click', 'keydown', 'touchstart', 'scroll'].forEach(evt => {
    document.addEventListener(evt, self.onSomeUserIteraction);
  })

  

  this.v = APPv;
  this.bgcolor_when_changedto_transparent = '';

  var Components = {};
  this.getComponentsList = function () {
    return Object.keys(Components);
  };
  this.checkIfScriptAlreadyLoaded = (script) => {
    return Components.hasOwnProperty(script);
  }
  this.loadComponent = function (Component, callback, id = null) {
    var ttp = typeof callback;
    if (ttp != 'function') var callback = function () {};
    if (typeof Components[Component] == 'undefined') {
      Components[Component] = {
        loaded: false,
        clb: [callback],
      };
      var js = document.createElement('script');
      js.type = 'text/javascript';

      if (id) {
        js.dataset.id = id;
      }

      js.setAttribute('crossorigin', 'anonymous');

      js.src = [
        ( debugMode ? self.ROOT_PATH : self.PATH_CF_FLIP ) + 'assets/scripts/',
        Component,
        APPm ? '.min' : '',
        '.js?v=',
        self.v,
      ].join('');
      js.cmp = Component;
      js.onload = function () {
        Components[this.cmp].loaded = true;
        var i = 0,
          l = Components[this.cmp].clb.length;
        for (i = 0; i < l; i++) Components[this.cmp].clb[i]();
      };
      document.body.appendChild(js);
      Components[Component].added = true;
    } else if (!Components[Component].loaded) {
      Components[Component].clb.push(callback);
    } else {
      callback();
    }
  };

  var cssPars = {
    xs: null,
    sm: 568,
    md: 868,
    lg: 1200,
    xl: 1600,
  };
  var cssLoaded = [];
  this.checkIfStyleAlreadyLoaded = (style) => {
    return cssLoaded.includes(style);
  }
  this.clearLoadedStyles = () => {
    cssLoaded = [];
  }
  this.loadCSS = function (uri, types, callback) {
    //self.log('APP.loadCSS', arguments);
    if (cssLoaded.indexOf(uri) != -1) return false;
    cssLoaded.push(uri);
    if (typeof types == 'undefined') types = ['xs'];
    var id = [uri, 'CSS'].join('_');
    var par = document.createDocumentFragment(),
      css,
      href;
    for (var size in cssPars) {
      if (types.indexOf(size) == -1) continue;
      href = [
        (debugMode ? self.ROOT_PATH : self.CLOUDFRONT_ASSETS_DEBUG) + 'assets/css/',
        uri,
        '/',
        size,
        APPm ? '.min' : '',
        '.css?v=',
        self.v,
      ].join('');
      css = document.createElement('link');
      css.setAttribute('type', 'text/css');
      css.setAttribute('rel', 'stylesheet');
      if (cssPars[size] !== null)
        css.setAttribute('media', ['(min-width:', cssPars[size], 'px)'].join(''));
      css.setAttribute('href', href);
      par.appendChild(css);
    }
    if (typeof callback == 'function') css.onload = callback;
    document.head.appendChild(par);
    return true;
  };

  this.ready = function () {
    return is_ready;
  };

  this.hexToRgb = function (hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result
      ? {
          r: parseInt(result[1], 16),
          g: parseInt(result[2], 16),
          b: parseInt(result[3], 16),
        }
      : null;
  };

  this.makeViewerTransparentDynamicly = function () {
    transparent = true;

    this.bgcolor_when_changedto_transparent = document.body.style.background;
    document.body.style.background = 'transparent';
    var footer = document.getElementById('footer');
    var header = document.getElementById('header');
    footer.classList.add('hide');
    header.classList.add('hide');

    APP.Book.bookTransparentHandler();

    var resizeEvent = window.document.createEvent('UIEvents');
    resizeEvent.initUIEvent('resize', true, false, window, 0);
    window.dispatchEvent(resizeEvent);
  };

  this.makeViewerSolidDynamicly = function () {
    transparent = false;

    document.body.style.background = this.bgcolor_when_changedto_transparent;
    var footer = document.getElementById('footer');
    var header = document.getElementById('header');
    footer.classList.remove('hide');
    header.classList.remove('hide');

    APP.Book.bookTransparentHandler();

    var resizeEvent = window.document.createEvent('UIEvents');
    resizeEvent.initUIEvent('resize', true, false, window, 0);
    window.dispatchEvent(resizeEvent);
  };

  const bookLoaderDiv = function (logo, name) {
    let loader = `${logo}<div class="loader__image-container">
            <div class="book">
                <div class="inner"><div class="left"></div><div class="middle"></div><div class="right"></div></div>
                <ul><li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                </ul>
              </div></div><div class="loader__bookname">${name}</div>
<div class="loader__publuu"><a href='https://publuu.com/' class="a__loader__publuu" style="opacity: 0.0">Flipbook - Powered by Publuu.com</a></div>`;
    return loader;
  };

  const bookLoaderDiv_LogoImageDiv = function (toplogoImage, title) {
    let img = ``;
    if (toplogoImage && toplogoImage.includes('.svg')) {
      img = ``;
    } else {
      img =  `<img src='${toplogoImage}' alt='${title}' />`;
    }
    return toplogoImage
      ? `<div class='loader__logo-container'>${img}</div>`
      : '';
  };

  // (function () {
  //   let bookLoader = document.createElement('div');
  //   bookLoader.className = 'loader app__loader no-animation';

  //   const bookLoaderWrapper = document.createElement('div');
  //   bookLoaderWrapper.className = 'loader__wrapper';

  //   if (transparent) {
  //     let loaderContent = `<div class="loader__image-container"><div class="book" style="--color: #3461c9"><div class="inner"><div class="left"></div><div class="middle"></div><div class="right"></div></div><ul><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li><li></li></ul></div></div><div class="loader__bookname"></div><div class="loader__publuu"><a href='https://publuu.com/' class="a__loader__publuu" style="opacity: 0.0">Flipbook - Powered by Publuu.com</a></div>`;

  //     bookLoaderWrapper.insertAdjacentHTML('afterbegin', loaderContent);
  //     bookLoader.appendChild(bookLoaderWrapper);
  //     document.body.appendChild(bookLoader);

  //     if (loaderInfo.hasOwnProperty('color') && loaderInfo.color != '0' && loaderInfo.color.length >= 3) {
  //       const book = bookLoader.querySelector('.book');

  //       if (book) {
  //         book.style = `--color: #${loaderInfo.color}`;
  //       }
  //     } 
  //   } else {
  //     let logoUrl = loaderInfo.logo;

  //     const title = decodeURIComponent(loaderInfo.title);
  //     let logo = bookLoaderDiv_LogoImageDiv(logoUrl, title);

  //     if (logoUrl && !logoUrl.includes('.svg')) {
  //       const img = new Image();
  //       img.addEventListener('load', (e) => {
  //         document.querySelector('.loader__logo-container').classList.add('show');
  //       })
  //       img.src = logoUrl;
  //     } else {
  //       logo = '';
  //     }

  //     var rgb = self.hexToRgb(`#${loaderInfo.backgroundColor}`);
  //     var theme = 'light';
      
  //     if (rgb !== null) {
  //       theme = rgb['r'] * 0.299 + rgb['g'] * 0.587 + rgb['b'] * 0.114 > 186 ? 'light' : 'dark';
  //     }

  //     bookLoader.style.color = theme == 'light' ? 'var(--light-color)' : 'var(--dark-color)';
  //     bookLoader.style.backgroundColor = `#${loaderInfo.backgroundColor}`;
  //     bookLoaderWrapper.insertAdjacentHTML('afterbegin', bookLoaderDiv(logo, title));
  //     bookLoader.appendChild(bookLoaderWrapper);
  //   }
    
  //   document.body.appendChild(bookLoader);
  // }());

  this.handleResponeToParent = function (data) {
    if (!customizemode) {
      return;
    }

    canReceiveMessages = true;

    if (data.hasOwnProperty('page')) {
      window.parent.postMessage({ page: data.page }, '*');
    }

    if (data.hasOwnProperty('v_book_loaded')) {
      window.parent.postMessage({ v_book_loaded: true }, '*');
    }
  }

  this.hideHeaderDependsOnVisibleElements = () => {
    const header = document.querySelector('#header');
    const headerCenter = header.querySelector('.header__center .header__icons') || header.querySelector('.header__center');
    const headerLeft = header.querySelector('.header__left .header__icons') || header.querySelector('.header__left');
    const headerRight = header.querySelector('.header__right .header__icons') || header.querySelector('.header__right');
    const headerLogo = header.querySelector('.header__logo');
    const headerBorder = header.querySelector('.header__border');

    const headerLeftIsHidden = !headerLeft || (headerLeft && Array.from(headerLeft.childNodes).every(node => node.hasAttribute('hidden')));
    const headerCenterIsHidden = !headerCenter || (headerCenter && Array.from(headerCenter.childNodes).every(node => node.hasAttribute('hidden')));
    const headerRightIsHidden = !headerRight || (headerRight && Array.from(headerRight.childNodes).every(node => node.hasAttribute('hidden') || (node.localName === 'a' && (node.innerHTML === '' || node.innerHTML === '<img src="">'))));

    const headerLogoIsHidden = () => {
      if (!headerLogo) return true;
      if (Array.from(headerLeft.childNodes).length === 0) return true;

      const headerLogoImg = headerLogo.querySelector('img');
      if (!headerLogoImg || headerLogoImg.getAttribute('src') === '') return true;

      return false;
    };

    if (headerLeftIsHidden && headerCenterIsHidden && headerRightIsHidden && headerLogoIsHidden()) {
      header.setAttribute('hidden', true);
      headerBorder && headerBorder.setAttribute('hidden', true);
    } else {
      header.removeAttribute('hidden');
      headerBorder && headerBorder.removeAttribute('hidden');
    }
  }

  this.hideFooterDependsOnVisibleElements = () => {
    const footer = document.querySelector('#footer');
    const footerCenter = footer.querySelector('.footer__center .footer__icons') || footer.querySelector('.footer__center');
    const footerLeft = footer.querySelector('.footer__left .footer__icons') || footer.querySelector('.footer__left');
    const footerRight = footer.querySelector('.footer__right .footer__icons') || footer.querySelector('.footer__right');
    const footerLogo = footer.querySelector('footer .header__logo');
    const footerBorder = footer.querySelector('.footer__border');

    const footerLeftIsHidden = !footerLeft || (footerLeft && Array.from(footerLeft.childNodes).every(node => node.hasAttribute('hidden')));
    const footerCenterIsHidden = !footerCenter || (footerCenter && Array.from(footerCenter.childNodes).every(node => node.hasAttribute('hidden')));
    const footerRightIsHidden = !footerRight || (footerRight && Array.from(footerRight.childNodes).every(node => node.hasAttribute('hidden') || (node.localName === 'a' && (node.innerHTML === '' || node.innerHTML === '<img src="">'))));

    const footerLogoIsHidden = () => {
      if (!footerLogo) return true;
      if (Array.from(footerRight.childNodes).length === 0) return true;

      const footerLogoImg = footerLogo.querySelector('img');
      if (!footerLogoImg || footerLogoImg.getAttribute('src') === '') return true;

      return false;
    };

    if (footerLeftIsHidden && footerCenterIsHidden && footerRightIsHidden && footerLogoIsHidden()) {
      footer.setAttribute('hidden', true);
      footerBorder && footerBorder.setAttribute('hidden', true);
    } else {
      footer.removeAttribute('hidden');
      footerBorder && footerBorder.removeAttribute('hidden');
    }
  };

  this.handleFlipBookEditorResponse = function (data) {
    if (data.hasOwnProperty('customizeSettings')) {
      APP.customizeSettings = data.customizeSettings;
    }

    if (!canReceiveMessages) {
      return;
    }

    if (transparent) {
      document.body.style.background = 'transparent';
    } else {
      if (data.hasOwnProperty('action')) {
        Object.entries(data.properties).forEach(([key, value]) => {
          if (key === 'background_mode') {
            if (value == 'color') {
              value = 0;
            } else if (value == 'texture') {
              value = 1;
            } else if (value == 'image') {
              value = 2;
            }
            
            this.Book.getModel().settings['prev_background_mode'] = this.Book.getModel().settings['background_mode'];
          }

          this.Book.getModel().settings[key] = value;
        });

        if (data.subaction === 'image_removed') {
          this.Book.getModel().settings['background_mode'] = 1;
        }

        this.Book.customizeBookBackground(data.subaction);
        this.Book.setCorrectRangerColor(
          this.Book.getCurrentPage(),
          'pageranger',
          Number(this.Book.getModel().pages),
        );

        this.Book.setCorrectRangerColor(1, 'zoomranger', 20);
      }

      // if (data.hasOwnProperty('background_mode')) {
      //   if (data.background_mode == 'color') {
      //     this.Book.getModel().settings.background_mode = 0;
      //   }
      //   if (data.background_mode == 'texture') {
      //     this.Book.getModel().settings.background_mode = 1;
      //   }
      //   if (data.background_mode == 'image') {
      //     this.Book.getModel().settings.background_mode = 2;
      //   }
      // }

      // if (data.hasOwnProperty('background_color')) {
      //   root.style.backgroundImage = '';
      //   root.style.backgroundUrl = '';
      //   this.Book.getModel().settings.background_color = data.background_color;
      //   this.Book.getModel().settings.background_mode = 0;

      //   this.Book.customizeBookBackground();
      //   this.Book.setCorrectRangerColor(
      //     this.Book.getCurrentPage(),
      //     'pageranger',
      //     Number(this.Book.getModel().pages),
      //   );
      //   this.Book.setCorrectRangerColor(1, 'zoomranger', 20);
      // } else if (data.hasOwnProperty('background_texture')) {
      //   this.Book.getModel().settings.background_mode = 1;
      //   this.Book.getModel().settings.background_texture_color = data.background_texture_color; //avg
      //   this.Book.getModel().settings.background_texture = data.background_texture;
      //   this.Book.customizeBookBackground();
      //   this.Book.setCorrectRangerColor(
      //     this.Book.getCurrentPage(),
      //     'pageranger',
      //     Number(this.Book.getModel().pages),
      //   );
      //   this.Book.setCorrectRangerColor(1, 'zoomranger', 20);
      // } else if (data.hasOwnProperty('background_image')) {
      //   if (data.background_image == null) {
      //   } else {
      //     this.Book.getModel().settings.background_mode = 2;
      //     this.Book.getModel().settings.background_image_color = data.background_image_color; //avg
      //     this.Book.getModel().settings.background_texture = data.background_image;
      //     this.Book.getModel().settings.background_image = data.background_image;
      //     this.Book.customizeBookBackground();
      //     this.Book.setCorrectRangerColor(
      //       this.Book.getCurrentPage(),
      //       'pageranger',
      //       Number(this.Book.getModel().pages),
      //     );
      //     this.Book.setCorrectRangerColor(1, 'zoomranger', 20);
      //   }
      // }
    }

    if (data.hasOwnProperty('auto_flip_enabled')) {
      APP.Book.initializeBookAutoFlip({
        state: data['auto_flip_enabled'] || false,
        duration: data['auto_flip_duration'] || null,
        loop: data['auto_flip_loop_continously'] || false,
        times: data['auto_flip_loop_times'] || null
      });
    }
    
    if (data.hasOwnProperty('hard_cover_enabled')) {
      APP.Book.initializeBookHardCover({
        state: data['hard_cover_enabled'] || false,
        color: data['hard_cover_color'] || '#fff'
      });
    }

    if (data.hasOwnProperty('flip_type')) {
      APP.Book.updateBookFlipType(data.flip_type);
    }

    if (data.hasOwnProperty('page')) {
      // odswiezanie viewera
      // let arr = window.location.href.split('/');
      // arr[arr.length - 1] = data.page;
      // var newLink = arr.join('/');
      // var link = newLink + '?embed&disablelogs' + (!transparent ? '' : '&transparent');
      // window.location.href = link;

      if (APP.Book && APP.Book.setPage) {
        APP.Book.setPage(data.page, 'customize');
      }
    }

    if (data.hasOwnProperty('is_background_transparent')) {
      var setTransparentTo = data.is_background_transparent;
      if (setTransparentTo) {
        this.makeViewerTransparentDynamicly();
      } else {
        this.makeViewerSolidDynamicly();
      }
    }

    if (data.hasOwnProperty('toplogo_image')) {
      let headerLogo = document.getElementsByClassName('header__logo');
      headerLogo[0].innerHTML = '';
      var headerLogoImg = document.createElement('img');
      headerLogoImg.src = data.toplogo_image;
      headerLogo[0].setAttribute('target', '_blank')
      headerLogo[0].appendChild(headerLogoImg);
      this.hideHeaderDependsOnVisibleElements();
      this.hideFooterDependsOnVisibleElements();
    }

    if (data.hasOwnProperty('toplogo_image_url')) {
      let headerLogo = document.querySelector('header .header__logo');
      headerLogo.setAttribute('href', data.toplogo_image_url)
    }

    function doSmth(Book) {
      var modeltmp = Book.getModel();
      let pageranger = document.getElementById('pageranger');
      var numberOfIndexes = Number(modeltmp.pages);

      if (data.show_single_page_mode) {
        forceOnePage = true;
        modeltmp.settings.show_single_page_mode = true;
        APP.Layout.getSidebar().hide();
        APP.Book.renderSidebar();
        //stf__marcinBookPages_left
        let leftThickness = document.getElementById('stf__marcinBookPages_left');
        if (leftThickness) {
          leftThickness.style.display = 'none';
        }
      } else {
        forceOnePage = false;
        modeltmp.settings.show_single_page_mode = false;
        APP.Layout.getSidebar().hide();
        APP.Book.renderSidebar();
        if (is_horisontal()) {
          numberOfIndexes = Math.floor(Number(modeltmp.pages) / 2) + 1;
        }
        let leftThickness = document.getElementById('stf__marcinBookPages_left');
        if (leftThickness) {
          leftThickness.style.display = modeltmp.settings.show_book_thickness ? 'block' : 'none';
        }
      }

      // var curIndex =
      //   is_horisontal() && !modeltmp.settings.showSinglePageMode
      //     ? Math.floor(Book.getCurrentPage() / 2) + 1
      //     : Book.getCurrentPage();
      var curIndex = Book.getCurrentPage();

      if (pageranger) {
        pageranger.max = numberOfIndexes;
        pageranger.value = curIndex;
      }

      Book.setFooterPage(curIndex);

      Book.updateFlipBook();

      window.dispatchEvent(resizeEvent);

      setTimeout(() => {
        document.querySelector('.spinner-modal').classList.remove('show');
        document.querySelector('.Book').style.transition = 'opacity 0.15s';
        document.querySelector('.Book').style.opacity = '1.0';

        APP.handleResponeToParent({
          'v_book_loaded': true
        });
      }, 750);
    }

    function RtlHandler (rtlState) {
      const searchParams = new URLSearchParams({
        rtl: rtlState ? 1 : 0,
        customizemode: true,
        disablelogs: true,
        cmsauth: cmsAuth,
        embed: true
      });

      window.location.href = `${window.location.href}?${searchParams.toString()}`;
    }

    if (data.hasOwnProperty('show_right_to_left')) {
      RtlHandler(data.show_right_to_left);
    }

    if (data.hasOwnProperty('show_single_page_mode')) {
      const modeltmp = this.Book.getModel();
      modeltmp.settings.show_single_page_mode = data.show_single_page_mode;
      
      document.querySelector('.Book').style.transition = 'opacity 0.0s';
      document.querySelector('.Book').style.opacity = '0.0';
      document.querySelector('.spinner-modal').classList.add('show');

      if (this.Book.pageFlipGetState() == 'fold_corner') {
        var self = this;
        setTimeout(() => {
          doSmth(self.Book);
        }, 500);
      } else {
        doSmth(this.Book);
      }

      APP.Book.setArrowsOffsetByThickness();
    }

    if (data.hasOwnProperty('show_shadow_inside')) {
      if (data.show_shadow_inside) {
        document.querySelectorAll('.--right').forEach(function (userItem) {
          userItem.classList.remove('hideshadow');
        });
        document.querySelectorAll('.--left').forEach(function (userItem) {
          userItem.classList.remove('hideshadow');
        });
      } else {
        document.querySelectorAll('.--right').forEach(function (userItem) {
          userItem.classList.add('hideshadow');
        });
        document.querySelectorAll('.--left').forEach(function (userItem) {
          userItem.classList.add('hideshadow');
        });
      }
    }

    if (data.hasOwnProperty('show_corner_fold')) {
      this.Book.updateBookModelSettings('show_corner_fold', data.show_corner_fold);
    }

    if (data.hasOwnProperty('show_book_thickness')) {
      const modeltmp = this.Book.getModel();
      modeltmp.settings.show_book_thickness = data.show_book_thickness;
      
      const thicknessWidth = APP.Book.getThicknessWidth(true);
      const pagesThicknesL = document.getElementById('stf__marcinBookPages_left');
      const pagesThicknesR = document.getElementById('stf__marcinBookPages_right');
      const pagesThicknesOne = document.getElementById('stf__marcinBookPages');

      if (data.show_book_thickness) {
        if (pagesThicknesL || pagesThicknesR || pagesThicknesOne) {
          if (pagesThicknesL && thicknessWidth[0] > 0) {
            pagesThicknesL.style.display = 'block';
          }
          if (pagesThicknesR && thicknessWidth[1] > 0) {
            pagesThicknesR.style.display = 'block';
          }
          if (pagesThicknesOne) {
            pagesThicknesOne.style.display = 'block';
          }

          this.Book.updateFlipBook();
        }
      } else {
        if (pagesThicknesL) {
          pagesThicknesL.style.display = 'none';
        }
        if (pagesThicknesR) {
          pagesThicknesR.style.display = 'none';
        }
        if (pagesThicknesOne) {
          pagesThicknesOne.style.display = 'none';
        }
      }

      APP.Book.initializeBookHardCoverThickness(data.show_book_thickness);
      // APP.Book.setArrowsOffsetByThickness();
    }

    if (data.hasOwnProperty('editor_menu_toggled')) {
      APP.Book.hideAllModals();

      //status
      const isShowed = data.editor_menu_toggled[0];
      const idOfTab = data.editor_menu_toggled[1];

      if (idOfTab === 'settings-lead-capture') {
        if (!isShowed) {
          APP.Book.hideLeadFormModal();
        }
      } else if (idOfTab === 'settings-toc') {
        if (isShowed) {
          APP.Book.showSidebarTOC();
        } else {
          APP.Book.hideSidebar();
        }
      }
    }

    if (data.hasOwnProperty('lead_form_enabled')) {
      APP.Book.hideAllModals();

      if (data.lead_form_enabled) {
        const modeltmp = this.Book.getModel();

        if (customizemode && !data.hasOwnProperty('lead_form_enabled_after_collapse')) {
          window.parent.postMessage({ set_lead_on_page: this.Book.getCurrentPage() }, '*');
        }

        if (customizemode && data.hasOwnProperty('lead_form_enabled_after_collapse')) {
          this.Book.setPage(data.lead_form_enabled_after_collapse, 'ranger');
          this.Book.setFooterPage(parseInt(data.lead_form_enabled_after_collapse));
        }

        modeltmp.settings.lead_form_enabled = true;

        APP.Book.showLeadFormModal();
      } else {
        APP.Book.hideLeadFormModal();
      }
    }

    if (data.hasOwnProperty('lead_form_page')) {
      this.Book.setPage(data.lead_form_page, 'ranger');
      this.Book.setFooterPage(parseInt(data.lead_form_page));
    }

    const leadFormPropertyKeys = [
      'lead_form_image_enabled', 
      'lead_form_caption', 
      'lead_form_allow_skip', 
      'lead_form_custom_policy', 
      'lead_form_custom_policy_link', 
      'lead_form_fields'
    ];

    const leadFormPropertyKey = leadFormPropertyKeys.find(key => data.hasOwnProperty(key));

    if (leadFormPropertyKey) {
      const modeltmp = this.Book.getModel();
      modeltmp.settings[leadFormPropertyKey] = data[leadFormPropertyKey];

      APP.Book.customizeLeadFormModal(data);
    }

    if (data.hasOwnProperty('password_required')) {
      if (data.password_required && data.password_tab_opened) {
        //    console_log("SHOW PASSWORD POPUP");
      } else {
        //   console_log("HIDE PASSWORD POPUP");
      }
    }
    if (data.hasOwnProperty('bottom_menu_color_mode')) {
      document.body.classList.remove('dark');
      document.body.classList.remove('light');
      document.body.classList.add(data.bottom_menu_color_mode);
    }
    if (data.hasOwnProperty('name')) {
      let headerName = document.getElementsByClassName('header__book-name');
      if (headerName.length) headerName[0].innerText = data.name;
    }
    if (data.hasOwnProperty('show_title')) {
      let headerName = document.querySelector('.header__book-name');
      if (headerName) headerName.hidden = !data.show_title;
    }
    if (data.hasOwnProperty('show_page_number')) {
      let footerPageNum = document.querySelector('.footer__page-num');
      if (footerPageNum) footerPageNum.hidden = !data.show_page_number;
    }
    if (data.hasOwnProperty('show_toc_button')) {
      let tocBtn = document.getElementsByClassName('Book__navTOC');
      if (tocBtn.length) tocBtn[0].hidden = !data.show_toc_button;
    }
    if (data.hasOwnProperty('show_note_button')) {
      let bookNote = document.getElementsByClassName('Book__note');
      let noteBottom = document.getElementsByClassName('note__button');
      if (noteBottom.length) noteBottom[0].hidden = !data.show_note_button;
      if (bookNote.length) bookNote[0].hidden = !data.show_note_button;
    }
    if (data.hasOwnProperty('show_search_button')) {
      let searchButton = document.getElementsByClassName('search__button');
      if (searchButton.length) searchButton[0].hidden = !data.show_search_button;

      APP.loadComponent('Search', APP.Layout.render__createSidebarSearch);
    }
    if (data.hasOwnProperty('show_print_button')) {
      let printBtn = document.getElementsByClassName('Book__print');
      if (printBtn.length) printBtn[0].hidden = !data.show_print_button;
    }
    if (data.hasOwnProperty('show_thumbnails_button')) {
      let thumbsBtn = document.getElementsByClassName('Book__navThumbs');
      if (thumbsBtn.length) thumbsBtn[0].hidden = !data.show_thumbnails_button;
    }
    if (data.hasOwnProperty('show_fullscreen_button') && !is_iOS()) {
      let fullscreenBtn = document.getElementsByClassName('Book__navFullScreen');
      if (fullscreenBtn.length) fullscreenBtn[0].hidden = !data.show_fullscreen_button;
    }
    if (data.hasOwnProperty('download_allowed')) {
      const modeltmp = this.Book.getModel();
      modeltmp.settings.show_download_button = data.download_allowed;
      modeltmp.download_allowed = data.download_allowed;

      let downloadBtn = document.getElementsByClassName('Book__download');
      if (downloadBtn.length) downloadBtn[0].hidden = !data.download_allowed;
    }
    if (data.hasOwnProperty('show_page_slider')) {
      let pagesSliderBtn = document.getElementsByClassName('Book__pagesRanger');
      if (pagesSliderBtn.length) pagesSliderBtn[0].hidden = !data.show_page_slider;
    }
    if (data.hasOwnProperty('show_zoom_button')) {
      let zoomBtn = document.getElementsByClassName('Book__zoom');
      if (zoomBtn.length) zoomBtn[0].hidden = !data.show_zoom_button;
    }
    if (data.hasOwnProperty('show_audio_button')) {
      let audioBtn = document.getElementsByClassName('Book__audio');
      if (audioBtn.length) audioBtn[0].hidden = !data.show_audio_button;
    }
    if (data.hasOwnProperty('show_share_button')) {
      APP.Book.updateBookModelSettings('show_share_button', data.show_share_button);
      let shareBtn = document.getElementsByClassName('Book__share');
      if (shareBtn.length) shareBtn[0].hidden = !data.show_share_button;
    }
    if (data.hasOwnProperty('enable_protected_domain')) {
      APP.Book.updateBookModelSettings('enable_protected_domain', data.enable_protected_domain);
      APP.Book.updateBookModelSettings('show_share_button', !data.enable_protected_domain);
    }
    if (data.hasOwnProperty('update_toc')) {
      APP.Book.updateTOC(data.update_toc);
    }
    this.hideHeaderDependsOnVisibleElements();
    this.hideFooterDependsOnVisibleElements();
  };

  is_ready = true;
})();

// Helpers section
var emptyFunction = function () {},
  ElementObserve = function (element, callback) {
    var self = this;
    var observer = new IntersectionObserver(
      function (entries) {
        entries.forEach(function (entry) {
          if (entry.intersectionRatio > 0) {
            self.unobserve();
            callback.call();
          }
        });
      },
      {
        rootMargin: ['0px 0px 0px 0px'].join(''),
        threshold: 0.01,
      },
    );
    observer.observe(element);
    this.unobserve = function () {
      observer.unobserve(element);
    };
  },
  createEvent = function(type, detail = {}, dispatchImmediately = false) {
    const event = new CustomEvent(type, { detail });

    if (dispatchImmediately) {
      window.dispatchEvent(event);
    }

    return event;
  },
  console_log = function (...args) {
    return;
    const type = 'array'; // string
    if (!debugMode) return;

    if (type == 'array') console.log(args);
    if (type == 'string') console.log(args.join(', '));
  },
  is_embed = function () {
    return (window.location != window.parent.location) ? {
      url: document.referrer,
      type: 'ref',
      embed: true
    } : {
      url: document.location.href,
      type: 'loc',
      embed: false
    }
  },
  is_small_embed_not_mobile = function () {
    return window.location != window.parent.location 
      && !is_mobile()
      && (window.innerWidth <= 768 || window.innerHeight <= 576)
  },
  show_fs_modal_button = function () {
    const settingsOption = APP.Book.getModel().settings.show_fullscreen_button;
    const isEmbed = is_embed().embed;

    const transparentMode = 
      !document.querySelector('.Book__navFullScreen') || 
      document.querySelector('.Book__navFullScreen').hasAttribute('hidden');
    const smallScreenMode = window.innerHeight <= 270 || window.innerWidth <= 350;
    const isFullscreenMode = APP.Book.getFullscreenState();

    return settingsOption && isEmbed && !isFullscreenMode && (transparentMode ||  smallScreenMode);
  },
  is_small_desktop_mode = function () {
    return (window.innerHeight < 325 || window.innerWidth < 350 || window.innerWidth <= window.innerHeight);
  },
  isset = function (v) {
    return typeof v != 'undefined';
  },
  is_function = function (v) {
    return typeof v === 'function';
  },
  is_array = function (v) {
    return typeof v === 'object' && v instanceof Array && isset(v.length);
  },
  is_object = function (v) {
    return typeof v === 'object' && v instanceof Object && !(v instanceof Array);
  },
  is_numeric = function (v) {
    return !isNaN(v);
  },
  is_NodeList = function (v) {
    return typeof v === 'object' && v instanceof Object && v instanceof NodeList;
  },
  is_Node = function (v) {
    return typeof v === 'object' && v instanceof Object && v instanceof Node;
  },
  is_string = function (i) {
    return typeof i === 'string';
  },
  _is_iOS = null,
  is_iOS = function () {
    if (_is_iOS === null)
      _is_iOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
    return _is_iOS;
  },
  is_cached_image = function (url) {
    var imgEle = document.createElement('img');
    imgEle.src = url;
    return imgEle.complete || imgEle.width + imgEle.height > 0;
  },
  is_bool = function (i) {
    return typeof i === 'boolean';
  },
  is_empty = function (V) {
    return V === '';
  },
  is_hidden = function (el) {
    return !is_visible(el);
  },
  is_visible = function (el) {
    return !!(el.offsetWidth || el.offsetHeight || el.getClientRects().length);
  },
  is_event = function (e) {
    return isset(e) && is_function(e.preventDefault);
  },
  stopEvent = function (e) {
    if (!is_event(e)) return false;
    if (is_function(e.preventDefault)) e.preventDefault();
    if (is_function(e.stopPropagation)) e.stopPropagation();
    if (is_object(e)) e.cancelBubble = true;
    if (is_object(e)) e.returnValue = false;
    return false;
  },
  is_onepagemode = function () {
    return forceOnePage;
  },
  mobile_test_horizontal = function () {
    return window.innerWidth > window.innerHeight;
  },
  is_horisontal = function () {
    if (is_onepagemode()) {
      return false;
    }
    if (customizemode && !is_mobile()) {
      return true;
    }
    return window.innerWidth > window.innerHeight;
  },
  is_horisontalOld = function () {
    if (customizemode && !is_mobile()) {
      return true;
    }
    return window.innerWidth > window.innerHeight;
  },
  is_vertical = function () {
    return !is_horisontal();
  },
  is_verticalOld = function () {
    return !is_horisontalOld();
  },
  _is_mobile = null,
  is_mobile = function () {
    if (_is_mobile === null)
      _is_mobile = isset(window.orientation) || navigator.userAgent.indexOf('IEMobile') !== -1;
    return _is_mobile;
  },
  is_tablet = function () {
    const userAgent = navigator.userAgent.toLowerCase();
    let isTablet = /(ipad|tablet|(android(?!.*mobile))|(windows(?!.*phone)(.*touch))|kindle|playbook|silk|(puffin(?!.*(IP|AP|WP))))/.test(userAgent);

    if (!isTablet && is_mobile() && window.screen.availWidth >= 780) {
      isTablet = true;
    }

    return isTablet;
  },
  is_iphone_safari = function () {
    if (
      navigator &&
      navigator.userAgent &&
      navigator.userAgent.indexOf('iPhone') !== -1 &&
      navigator.userAgent.indexOf('Safari') !== -1
    ) {
      return true;
    }
    return false;
  },
  is_safari = function () {
    return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  },
  is_desktop = function () {
    return !is_mobile();
  },
  _is_touchscreen = null,
  is_touchscreen = function () {
    if (_is_touchscreen === null) _is_touchscreen = 'ontouchstart' in document.documentElement;
    return _is_touchscreen;
  },
  _is_retina = null,
  is_retina = function () {
    if (window.matchMedia) {
      var mq = window.matchMedia(
        'only screen and (min--moz-device-pixel-ratio: 1.3), only screen and (-o-min-device-pixel-ratio: 2.6/2), only screen and (-webkit-min-device-pixel-ratio: 1.3), only screen  and (min-device-pixel-ratio: 1.3), only screen and (min-resolution: 1.3dppx)',
      );
      return (mq && mq.matches) || window.devicePixelRatio > 1;
    }
  },
  is_fireFox = function () {
    return navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
  },
  is_sizeXs = function () {
    return window.innerWidth < 568;
  },
  is_sizeSM = function () {
    return window.innerWidth >= 568;
  },
  is_sizeMD = function () {
    return window.innerWidth >= 868;
  },
  is_sizeXL = function () {
    return window.innerWidth >= 1200;
  },
  is_sizeXS = function () {
    return window.innerWidth >= 1600;
  },
  get_speed = function () {
    var connection = navigator.connection || navigator.mozConnection || navigator.webkitConnection;
    if (connection) {
      switch (connection) {
        case '4g':
          return 4;
          break;
        case '3g':
          return 3;
          break;
        case '2g':
          return 2;
          break;
        case 'slow-2g':
        case 'cellular':
          return 1;
          break;
      }
    }
    return 0;
  },
  getRandom = function (min, max) {
    return Math.floor(Math.random() * (max - min)) + min;
  },
  getEventPoints = function (e) {
    var _m = [];
    if (isset(e.touches)) {
      if (e.touches.length) {
        _m.push({
          x: e.touches[0].pageX,
          y: e.touches[0].pageY,
        });
        if (e.touches.length > 1) {
          _m.push({
            x: e.touches[1].pageX,
            y: e.touches[1].pageY,
          });
        }
      }
    } else {
      _m.push({
        x: e.x,
        y: e.y,
      });
    }
    return _m;
  },
  mouse_event = function (act) {
    if (is_mobile() && is_touchscreen()) {
      switch (act) {
        case 'start':
          return 'touchstart';
          break;
        case 'move':
          return 'touchmove';
          break;
        case 'end':
          return 'touchend';
          break;
      }
    } else {
      switch (act) {
        case 'start':
          return 'mousedown';
          break;
        case 'move':
          return 'mousemove';
          break;
        case 'end':
          return 'mouseup';
          break;
      }
    }
  };

// Define special methods
// Array
Object.defineProperty(Array.prototype, 'max', {
  value: function () {
    return Math.max.apply(null, this);
  },
});
Object.defineProperty(Array.prototype, 'min', {
  value: function () {
    return Math.min.apply(null, this);
  },
});
Object.defineProperty(Array.prototype, 'clone', {
  value: function () {
    return this.slice(0);
  },
});
Object.defineProperty(Array.prototype, 'diff', {
  value: function (that) {
    return this.length === that.length && this.join('.') === that.join('.');
  },
});
// Object
Object.defineProperty(Array.prototype, 'sortObjects', {
  value: function (field, order) {
    var compare;
    if (order == 'DESC') {
      compare = function (a, b) {
        var x = is_numeric(a[field]) ? parseFloat(a[field]) : a[field],
          y = is_numeric(b[field]) ? parseFloat(b[field]) : b[field];
        if (x < y) return -1;
        if (x > y) return 1;
        return 0;
      };
    } else {
      compare = function (a, b) {
        var x = is_numeric(a[field]) ? parseFloat(a[field]) : a[field],
          y = is_numeric(b[field]) ? parseFloat(b[field]) : b[field];
        if (x > y) return -1;
        if (x < y) return 1;
        return 0;
      };
    }
    return this.clone().sort(compare);
  },
});
Object.defineProperty(Array.prototype, 'objectUnique', {
  value: function (field, ret) {
    ret = isset(ret) ? ret : false;
    var arr = this.clone(),
      values = [],
      unique = [];
    for (var i = arr.length - 1; i >= 0; i--) {
      if (values.indexOf(arr[i][field]) == -1) {
        values.push(arr[i][field]);
        unique.push(arr[i]);
      }
    }
    return ret ? values : unique;
  },
});
// Node
Object.defineProperty(Node.prototype, 'removeChilds', {
  value: function () {
    while (this.firstChild) {
      this.removeChild(this.lastChild);
    }
    return this;
  },
});

if (!isset(window.requestAnimationFrame)) {
  window.requestAnimationFrame = function (clb) {
    clb();
  };
}
