<?php
  if( $obj !== NULL && property_exists($obj, "settings") ){
    $settings = $obj->settings;
    
    if($settings !== NULL && property_exists($settings, 'show_google_index')){
      if( $settings->show_google_index === false ){
        echo  '<meta name="robots" content="noindex">';
      }
    }
  }
?>

<?php
  $version = property_exists($obj, "version") ? intval($obj->version) : 0;
  $issueId = property_exists($obj, 'ref_id') && isset($obj->ref_id) ? $obj->ref_id : $obj->id;
  $cover = APP::$imagesApi ."share/$pid/$issueId";
  $cover = (property_exists($obj, "is_demo") && intval($obj->is_demo) == 1) ? $cover . "?demo=1" : $cover;
  $toplogoImage = property_exists($obj, 'toplogo_image') && isset($obj->toplogo_image) && strpos($obj->toplogo_image, '.svg') === false ? $obj->toplogo_image : null;

  $canonical = APP::getFullRequestUrlWithParams([ 'pathAsString' => true, 'isCustomUrl' => boolval($custom_url) ]);
  $metaNoIndex = null;

  if (isset($obj)) {
    $demandedFlipOrigin = APP::getDemandedFlipOriginByRequestedData($obj);
    
    if ($_SERVER['SERVER_NAME'] == 'publuu.com' && $demandedFlipOrigin != $_SERVER['SERVER_NAME']) {
      $canonical = str_replace('online.publuu.com', 'publuu.com', $canonical);
      $canonical = str_replace('publuu.com', 'online.publuu.com', $canonical);

      $metaNoIndex = '<meta name="robots" content="noindex">';
    }
  }
?>

<meta charset="UTF-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta itemprop="image" content="<?=$cover?>">
<meta property="og:image" content="<?=$cover?>">
<meta name="twitter:image:src" content="<?=$cover?>">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:image:type" content="image/jpeg">
<meta property="og:title" content="<?=$obj->name?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?= APP::getFullRequestUrlWithParams([ 'pathAsString' => true, 'isCustomUrl' => boolval($custom_url) ]) ?>">
<meta property="og:site_name" content="Publuu">
<meta name="twitter:title" content="<?=$obj->name?>">
 
<title><?=$obj->name?></title> 

<meta itemprop="name" content="<?=$obj->name?>">
<meta itemprop="description" content="<?= htmlspecialchars_decode($obj->description) ?>">
<meta itemprop="image" content="<?=$cover?>">
<meta itemprop="bookFormat" content="EBook">
    
<meta name="description" content="<?= htmlspecialchars_decode($obj->description) ?>">
<meta property="og:description" content="<?= htmlspecialchars_decode($obj->description) ?>">
<meta name="twitter:description" content="<?= htmlspecialchars_decode($obj->description) ?>">
<meta name="twitter:text:description" content="<?= htmlspecialchars_decode($obj->description) ?>">        
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no" >

<link rel="canonical" href="<?= $canonical ?>">

<?php if (isset($metaNoIndex)): ?>
  <?= $metaNoIndex ?>
<?php endif; ?>

<link rel="preconnect" href="<?=APP::$rootPathAWS?>">
<link rel="preconnect" href="<?=APP::$contentPathAWS?>">

<?php if ($toplogoImage): ?>
  <link rel="preload" href="<?= $toplogoImage ?>" as="image" media="all">
<?php endif; ?>

<link rel="first" href="<?= APP::getFullRequestUrlWithParams([ 'pathAsString' => true, 'pathWithPage' => false, 'isCustomUrl' => boolval($custom_url) ]) ?>/page/1">
<link rel="last" href="<?= APP::getFullRequestUrlWithParams([ 'pathAsString' => true, 'pathWithPage' => false, 'isCustomUrl' => boolval($custom_url) ]) ?>/page/<?= property_exists($obj, "pages") ? $obj->pages : "1"?>">

<?php
  if (!$customizemode && !$disablelogs) {
    include("Components/templates/googleTags.php");
  }
  
  include("Components/templates/favicons.php");
  include("Components/templates/inlineFonts.php");
?>

<?php if ($customizemode) : ?>
  <link rel="stylesheet" as="style" href="<?= APP::getPathToCssFile("tooltip") ?>" />
<?php endif; ?>

<link rel="stylesheet" as="style" href="<?= APP::getPathToCssFile("loader") ?>" />
<link rel="preload" as="style" href="<?= APP::getPathToCssFile("APP-xs")?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::getPathToCssFile("APP-xs")?>" media="all" />
<link rel="preload" as="style" href="<?= APP::getPathToCssFile("Menu")?>" />
<link rel="stylesheet" type="text/css" href="<?= APP::getPathToCssFile("Menu")?>"  />

<script crossorigin="anonymous" type="text/javascript" defer="defer" src="<?= APP::getPathToJsFile('Helper')?>"></script>
<script crossorigin="anonymous" type="text/javascript" defer="defer" src="<?= APP::getPathToJsFile('Logs')?>"></script>

<?php if ($customizemode) : ?>
  <script crossorigin="anonymous" type="text/javascript" defer="defer" src="<?= APP::getPathToJsFile('Search')?>"></script>
<?php endif; ?>

<script type="text/javascript"> 
  var isLandscape = false;
  var isAndroid = (/android/gi).test(navigator.appVersion);
  var isIDevice = (/iphone|ipad/gi).test(navigator.appVersion);
  var isIPhone = (/iphone/gi).test(navigator.appVersion);
  var iOsHeight = 0;

  window.timingcount = 0;
  window.timingsum = 0;
  window.dlid = <?= $dlid ?>;
</script>
