<?php
  if (property_exists($obj, "settings")) {
    $settings = $obj->settings;
    
    if ($settings !== null && property_exists($settings, 'show_google_index')) {
      if ($settings->show_google_index === false) {
        echo '<meta name="robots" content="noindex">';
      }
    }
  }
?>

<?php
  $version = property_exists($obj, "version") ? intval($obj->version) : 0;
  $issueId = property_exists($obj, "ref_id") && isset($obj->ref_id) ? $obj->ref_id : $obj->id;
  $cover = APP::$imagesApi . "share/$pid/$issueId";
  $cover = (property_exists($obj, "is_demo") && intval($obj->is_demo) == 1) ? $cover . "?demo=1" : $cover;
  $toplogoImage = property_exists($obj, "toplogo_image") && isset($obj->toplogo_image) && strpos($obj->toplogo_image, ".svg") === false ? $obj->toplogo_image : null;

  $canonical = APP::getFullRequestUrlWithParams([ "pathAsString" => true, "isCustomUrl" => boolval($custom_url) ]);
  $metaNoIndex = '<meta name="robots" content="index, nofollow">';

  if ($obj && property_exists($obj, "settings") && property_exists($obj->settings, 'show_google_index') && $obj->settings->show_google_index) {
    if ($obj->plan_id == 23) {
      $metaNoIndex = '<meta name="robots" content="noindex, nofollow">';
    }
  }
?>

<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta charset="utf-8" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no" />

<?php 
  include("Components/templates/favicons.php");
  include("Components/templates/inlineFonts.php");
?>

<title><?= $obj->name ?></title>

<meta name="description" content="<?= htmlspecialchars_decode($obj->description) ?>" />
<meta itemprop="name" content="<?= $obj->name ?>" />
<meta itemprop="description" content="<?= htmlspecialchars_decode($obj->description) ?>" />
<meta itemprop="image" content="<?= $cover ?>" />
<meta itemprop="bookFormat" content="EBook" />

<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:site" content="@Publuu1" />
<meta property="og:site_name" content="Publuu" />
<meta name="twitter:title" content="<?= $obj->name ?>" />
<meta name="twitter:description" content="<?= htmlspecialchars_decode($obj->description) ?>" />
<meta name="twitter:text:description" content="<?= htmlspecialchars_decode($obj->description) ?>" />
<meta name="twitter:image:src" content="<?= $cover ?>" />
<meta property="og:title" content="<?= $obj->name ?>" />
<meta property="og:description" content="<?= htmlspecialchars_decode($obj->description) ?>" />
<meta property="og:type" content="article" />
<meta property="og:url" content="<?= APP::getFullRequestUrlWithParams([ "pathAsString" => true, "isCustomUrl" => boolval($custom_url) ]) ?>" />

<meta name="image" property="og:image" content="<?= $cover ?>" />
<meta property="og:image" content="<?= $cover ?>" />
<meta property="og:image:width" content="1200" />
<meta property="og:image:height" content="630" />
<meta property="og:image:type" content="image/jpeg" />

<link rel="canonical" href="<?= $canonical ?>">

<?php if (isset($metaNoIndex)): ?>
  <?= $metaNoIndex ?>
<?php endif; ?>

<link rel="first" href="<?= APP::getFullRequestUrlWithParams([ "pathAsString" => true, "pathWithPage" => false, "isCustomUrl" => boolval($custom_url) ]) ?>/page/1" />
<link rel="last" href="<?= APP::getFullRequestUrlWithParams([ "pathAsString" => true, "pathWithPage" => false, "isCustomUrl" => boolval($custom_url) ]) ?>/page/<?= property_exists($obj, "pages") ? $obj->pages : "1" ?>" />
<?php if (isset($page) && $page - 1 > 1): ?>
  <link rel="prev" href="<?= APP::getFullRequestUrlWithParams([ "pathAsString" => true, "pathWithPage" => false, "isCustomUrl" => boolval($custom_url) ]) ?>/page/<?= $page - 1 ?>" />
<?php endif; ?>
<?php if (isset($page) && $page + 1 < intval($obj->pages)): ?>
  <link rel="next" href="<?= APP::getFullRequestUrlWithParams([ "pathAsString" => true, "pathWithPage" => false, "isCustomUrl" => boolval($custom_url) ]) ?>/page/<?= $page + 1 ?>" />
<?php endif; ?>
