<!-- generics -->
<?php 
  if (property_exists($settings, 'favicon') && strlen($settings->favicon) > 0) :
    $faviconExt = pathinfo($settings->favicon, PATHINFO_EXTENSION);
    $faviconSizes = [32, 57, 76, 96, 128, 192, 228];

    foreach ($faviconSizes as $size) :
      $path = $settings->favicon;
      $path = str_replace(".$faviconExt", "_$size.$faviconExt", $path);
?>
      <link rel="icon" href="<?= $path ?>" type="image/<?= $faviconExt ?>" sizes="<?= $size . 'x' . $size ?>">
    <?php endforeach; ?>

  <!-- Android -->
  <?php
    $path = $settings->favicon;
    $path = str_replace(".$faviconExt", "_196.$faviconExt", $path);
  ?>
  <link rel="shortcut icon" sizes="196x196" type="image/<?= $faviconExt ?>" href="<?= $path ?>">

  <!-- iOS -->
  <?php
    $faviconSizes = [120, 152, 180];

    foreach ($faviconSizes as $size) :
      $path = $settings->favicon;
      $path = str_replace(".$faviconExt", "_$size.$faviconExt", $path);
  ?>
      <link rel="apple-touch-icon" href="<?= $path ?>" type="image/<?= $faviconExt ?>" sizes="<?= $size . 'x' . $size ?>">
    <?php endforeach; ?>
  
<?php else : ?>
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-32.png" type="image/png" sizes="32x32">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-57.png" type="image/png" sizes="57x57">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-76.png" type="image/png" sizes="76x76">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-96.png" type="image/png" sizes="96x96">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-128.png" type="image/png" sizes="128x128">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-192.png" type="image/png" sizes="192x192">
  <link rel="icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-228.png" type="image/png" sizes="228x228">

  <!-- Android -->
  <link rel="shortcut icon" sizes="196x196" type="image/png" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-196.png">

  <!-- iOS -->
  <link rel="apple-touch-icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-120.png" type="image/png" sizes="120x120">
  <link rel="apple-touch-icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-152.png" type="image/png" sizes="152x152">
  <link rel="apple-touch-icon" href="<?=APP::$rootPathAWS?>/assets/favicons/favicon-180.png" type="image/png" sizes="180x180">
<?php endif; ?>