<?php
  $pagesDescription = [];

  if (!property_exists($obj, "pages_description")) {
    return;
  }

  $pagesDescription = str_replace('\n', '{n}', $obj->pages_description);
  $pagesDescription = json_decode($pagesDescription);

  $linkToPage = APP::getFullRequestUrlWithParams([ "pathAsString" => true, "pathWithPage" => false, "isCustomUrl" => boolval($custom_url) ]) . "/page";
?>

<?php if (isset($pagesDescription) && is_array($pagesDescription) && count($pagesDescription) > 0) : ?>
  <div id="content" style="position: absolute; right: 100%; top: 0; margin-top: 100px">
    <div class="nav-links">
      <?php
        $nextPageIndex = $page < $pagesNum ? $page + 1 : false;
        $prevPageIndex = $page > 1 ? $page - 1 : false;
      ?>
      <a href="<?= $linkToPage ?>/1">First page</a>
      <?php if ($prevPageIndex) : ?>
        <a href="<?= $linkToPage ?>/<?= $prevPageIndex ?>">Previous page</a>
      <?php endif; ?>
      <span><?= $page ?></span>
      <?php if ($nextPageIndex) : ?>
        <a href="<?= $linkToPage ?>/<?= $nextPageIndex ?>">Next page</a>
      <?php endif; ?>
      <a href="<?= $linkToPage ?>/<?= $pagesNum ?>">Last page</a>
    </div>

    <h1 id="page-title"><?= $obj->settings->name ?></h1>
    <p><?= $obj->description ?></p>

    <div class="text" itemprop="text">
      <?php if ($page != 1 && count($pagesDescription) >= $page) :
        $lines = explode("{n}", $pagesDescription[$page - 1]->text);
        
        foreach ($lines as $line) : 
          if (strlen($line) <= 1) {
            continue;
          }
      ?>
        <p><?= $line ?></p>
      <?php endforeach; else :
        foreach ($pagesDescription as $description) :
          $lines = explode("{n}", $description->text);

          foreach ($lines as $line) : 
            if (strlen($line) <= 1) {
              continue;
            }
      ?>
        <p><?= $line ?></p>
        <?php 
          endforeach;
          endforeach;
          endif; 
        ?>
    </div>

    <?php if ($page == 1): ?>
      <?php for ($pageIndex = 1; $pageIndex <= min([$pagesNum, 100]); $pageIndex++) : ?>
        <a href="<?= $linkToPage ?>/<?= $pageIndex ?>"><?= $pageIndex ?></a>
      <?php endfor; ?>
    <?php endif; ?>
  </div>
<?php endif; ?>
