<?php header("HTTP/1.0 404 Not Found"); ?>

<!DOCTYPE html>
<html lang="<?= Locales::getLocale() ?>">
  <head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="robots" content="noodp">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Publuu - Page Not Found</title>

    <link rel="preconnect" href="<?= APP::$rootPathAWS ?>">

    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-32.png" type="image/png" sizes="32x32">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-57.png" type="image/png" sizes="57x57">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-76.png" type="image/png" sizes="76x76">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-96.png" type="image/png" sizes="96x96">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-128.png" type="image/png" sizes="128x128">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-192.png" type="image/png" sizes="192x192">
    <link rel="icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-228.png" type="image/png" sizes="228x228">

    <link rel="shortcut icon" sizes="196x196" type="image/png" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-196.png">

    <link rel="apple-touch-icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-120.png" type="image/png" sizes="120x120">
    <link rel="apple-touch-icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-152.png" type="image/png" sizes="152x152">
    <link rel="apple-touch-icon" href="<?= APP::$rootPathAWS ?>/assets/favicons/favicon-180.png" type="image/png" sizes="180x180">

    <?php include("Components/templates/inlineFonts.php"); ?>

    <link rel="stylesheet" href="<?= APP::getPathToCssFile("404") ?>">
  </head>
  <body>
    <main>
      <header class="not-found__header">
        <a href="https://publuu.com/" class="not-found__logo">
          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="1037.989px" height="336.986px" viewBox="21.063 466.356 1037.989 336.986" enable-background="new 21.063 466.356 1037.989 336.986" xml:space="preserve">
            <rect fill="#3460c8" y="-241.192" display="none" width="1077.38" height="1076.118"/>
            <g>
              <path fill="#3460c8" d="M100.774,557.242c-25.213,0-48.864,11.691-63.561,30.973v-25.924h-16.15v241.052h16.15V682.535   c14.697,19.282,38.348,30.974,63.561,30.974c21.436,0,41.566-8.367,56.683-23.56c14.682-14.755,22.711-34.179,22.608-54.679   C180.065,592.246,144.496,557.242,100.774,557.242z M100.774,697.989c-35.048,0-63.561-28.041-63.561-62.509   c0-34.467,28.513-62.509,63.561-62.509c34.815,0,63.14,28.042,63.14,62.509C163.915,669.948,135.59,697.989,100.774,697.989z" style="&#10;"/>
              <path fill="#3460c8" d="M362.938,635.271c0,34.699-28.513,62.93-63.561,62.93c-33.994,0-61.901-26.279-63.561-59.836v-75.652   h-15.73v73.189c0,43.025,35.57,78.028,79.291,78.028c28.03,0,53.506-14.11,68.159-37.748c0.78-1.157,11.131-16.83,11.131-32.917   v-80.553h-15.729V635.271z"/>
              <path fill="#3460c8" d="M502.398,555.979c-25.168,0-48.385,11.636-63.561,31.498V466.356h-15.729v240.631h15.729v-26.046   c15.058,19.608,38.269,31.095,63.561,31.095c43.722,0,79.291-35.003,79.291-78.028C581.689,590.983,546.12,555.979,502.398,555.979   z M502.398,696.728c-35.047,0-63.561-28.041-63.561-62.509c0-34.467,28.513-62.509,63.561-62.509   c35.048,0,63.562,28.042,63.562,62.509C565.96,668.687,537.446,696.728,502.398,696.728z"/>
              <rect fill="#3460c8" x="636.018" y="468.039" width="15.729" height="240.631"/>
              <path fill="#3460c8" d="M844.088,635.271c0,34.699-28.513,62.93-63.561,62.93c-34.111,0-62.111-26.279-63.771-59.836v-75.652   h-15.519v73.189c0,43.025,35.569,78.028,79.29,78.028c28.03,0,53.507-14.11,68.159-37.748c0.779-1.157,11.131-16.83,11.131-32.917   v-80.553h-15.729V635.271z"/>
              <path fill="#3460c8" d="M1043.322,562.712v72.559c0,34.699-28.513,62.93-63.561,62.93c-33.994,0-61.901-26.279-63.561-59.836   v-75.652h-15.729v73.189c0,43.025,35.569,78.028,79.29,78.028c28.03,0,53.507-14.11,68.159-37.748   c0.779-1.157,11.131-16.83,11.131-32.917v-80.553H1043.322z"/>
            </g>
          </svg>
        </a>
      </header>

      <div class="not-found__container">
        <div class="not-found__info not-found__info--image">
          <img src="<?= APP::getPathToImage('404.webp') ?>" alt="<?= Locales::_t('Not Found Title') ?>" width="600" height="508">
        </div>
        <div class="not-found__info not-found__info--content">
          <h1 class="not-found__title"><?= Locales::_t('Not Found Title') ?></h1>
          <h2 class="not-found__subtitle"><?= Locales::_t('Not Found Subtitle') ?></h2>

          <p class="not-found__text"><?= Locales::_t('Not Found Text Regular') ?></p>
          <p class="not-found__text not-found__text--bold"><?= Locales::_t('Not Found Text Bold') ?></p>
        </div>
      </div>
    </main>
  </body>
</html>
