<?php

class TrackLink {
  private static $NOT_FOUND_URL = null;
  private static $DISALED_URL = null;
  private static $API_URL = null;

  public static $linkId = null;

  public static function init() {
    self::$NOT_FOUND_URL = 'https://' . $_SERVER['SERVER_NAME'] . '/flip-book/track/404.html';
    self::$DISALED_URL = 'https://'. $_SERVER['SERVER_NAME'] . '/flip-book/track/403.html';
    self::$API_URL = 'https://bwa50tws9a.execute-api.us-east-2.amazonaws.com/links/viewer/{link_id}';

    self::parseLinkId();
  }

  public static function validateTrackLink() {
    if (!self::$linkId) {
      return null;
    }

    $linkData = self::getTrackLinkData();

    if (!$linkData) {
      header('Location: ' . self::$NOT_FOUND_URL);
      die();
    }

    if ($linkData['enabled'] == false) {
      header('Location: ' . self::$DISALED_URL);
      die();
    }

    $isValid = self::validateTrackLinkExpiryDate($linkData);

    if (!$isValid) {
      header('Location: ' . self::$NOT_FOUND_URL);
      die();
    }

    return self::$linkId;
  }

  private static function validateTrackLinkExpiryDate($linkData) {
    if (!isset($linkData['expires_at'])) {
      return true;
    }

    $tz = null;

    try {
      $tz = new DateTimeZone($linkData['timezone']);
    } catch(\Exception $e) {
      $tz = new DateTimeZone('UTC');
    }

    $expiryDate = DateTime::createFromFormat('Y-m-d H:i:s', $linkData['expires_at'], $tz);
    $now = new DateTime('now');

    return $expiryDate > $now;
  }

  private static function getTrackLinkData() {
    try {
      $url = str_replace('{link_id}', self::$linkId, self::$API_URL);
      $data = file_get_contents($url);

      return json_decode($data, true);
    } catch (\Exception $e) {
      return null;
    }
  }

  private static function parseLinkId() {
    $regex = '/\/link\/([0-9]{2,})/';

    preg_match($regex, $_SERVER['REQUEST_URI'], $matches);

    if (!$matches || !is_countable($matches) || !count($matches) || count($matches) != 2) {
      return;
    }

    self::$linkId = $matches[1];
  }
}

TrackLink::init();