<?php

class Locales {
  private static $supportedLocales = ['en', 'pl', 'de'];
  private static $defaultLocale = 'en';
  private static $localesPath = __DIR__ . '/locale';
  private static $fileMime = 'json';
  private static $translations = [];

  public static function init() {
    $locale = Locales::getLocale();
    Locales::$translations = json_decode(file_get_contents(Locales::getLocaleFilePath($locale)));
  }

  public static function getLocale() {
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) ?? Locales::$defaultLocale;

    if (!in_array($lang, Locales::$supportedLocales)) {
      return Locales::$defaultLocale;
    }

    return $lang;
  }

  public static function getLocaleFilePath($locale) {
    $path = Locales::$localesPath . '/' . $locale . '.' . Locales::$fileMime;

    if (!file_exists($path)) {
      return Locales::$localesPath . '/' . Locales::$defaultLocale . '.' . Locales::$fileMime;
    }

    return $path;
  } 

  public static function getTranslations() {    
    return Locales::$translations ?? [];
  }

  public static function _t($key, $options = []) {
    if (!is_object(Locales::$translations) || count((array)Locales::$translations) <= 0) {
      return $key;
    }

    $translation = Locales::$translations->$key ?? $key;
    
    if (is_array($options) && count($options) > 0) {
      $needle = '{n}';

      foreach ($options as $option) {
        $index = strpos($translation, $needle);

        if ($index !== false) {
          $translation = substr_replace($translation, $option, $index, strlen($needle));
        }
      }
    }

    return $translation;
  }
}

Locales::init();
