<?php

defined('ABSPATH')||exit;

class APP {
	public static $v = 0.0003;
	public static $minimized = false;
	public static $rootPath = "https://va.publuu.com/publuudev";
	public static $rootPathAWS = "https://dbxsqivh2nmr7.cloudfront.net/flipbook/202311";
  public static $imagesApi = "https://wntacr2o2k.execute-api.eu-west-1.amazonaws.com/images/";
  public static $viewerApi = "https://5708wwmg3f.execute-api.eu-west-1.amazonaws.com/viewer";
  public static $leadsApi = "";
  public static $logsApi = "https://utty56o2qi.execute-api.us-east-2.amazonaws.com/logs";
  public static $rootApi = "https://apib.publuu.com";
  public static $cloudfrontCMS = "https://d2w027ie3xfjy7.cloudfront.net";
  public static $customizeOrigins = ['https://cms1.publuu.com', 'https://cms9.publuu.com', 'https://publuu.com', 'https://cmsa.publuu.com'];
        
	private static $_inited = false;
	public static function init() {
		if (self::$_inited) return;
		self::$_inited = true;
		self::$v = "1057" . time();
	}

  public static function getMainPath() {
    $debugMode = key_exists("debug", $_GET) ? true : false;
    $mainPath = $debugMode ? APP::$rootPath : APP::$rootPathAWS;
    $mainPath = APP::$rootPath; // nadpisywanie dla developerki. nie potrzebne na produkcji

    return $mainPath;
  }

  public static function getPathToJsFile( $file, $forceMinified = false ) {
    $path = APP::getMainPath() . "/assets/scripts/" . $file . ($forceMinified || APP::$minimized ? ".min" : "")  . ".js?v=" . APP::$v;
    return $path;
  }
  public static function getPathToCssFile( $file, $forceMinified = false ) {
    $path = APP::getMainPath() . "/assets/css/" . $file . ($forceMinified || APP::$minimized ? ".min" : "")  . ".css?v=" . APP::$v;
    return $path;
  }
  public static function getPathToImage( $file ) {
    $path = APP::getMainPath() . "/assets/images/" . $file."?v=" . APP::$v;
    return $path;
  }
  
  public static function getModelDataFromCDN( $pid, $iid ){
    $jsonUrl = "https://d1uiew9hysv4w7.cloudfront.net/{$pid}/{$iid}/{$iid}.json";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36');
    curl_setopt($ch, CURLOPT_URL, $jsonUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $output = curl_exec($ch);
    curl_close($ch); 
    return $output;
  }

  public static function getDemandedFlipOriginByRequestedData($data) {
    $ORIGINS = array(
      'PUBLUU' => 'publuu.com',
      'ONLINE' => 'online.publuu.com'
    );

    if (!isset($data)) {
      return null;
    }

    if (!property_exists($data, 'publisher_id') || !property_exists($data, 'country')) {
      return $ORIGINS['PUBLUU'];
    }

    $ORIGIN_ONLINE_LOW_CONVERT_COUNTRIES = ['IN', 'PH', 'ID', 'MY'];
    $ORIGIN_ONLINE_SOUTH_AMERICA_COUNTRIES = ['MX', 'CO', 'BR', 'PE', 'VE', 'AR', 'CL'];

    if (intval($data->publisher_id) > 473200 && in_array($data->country, $ORIGIN_ONLINE_LOW_CONVERT_COUNTRIES)) {
      return $ORIGINS['ONLINE'];
    }

    if (intval($data->publisher_id) > 481850 && in_array($data->country, $ORIGIN_ONLINE_SOUTH_AMERICA_COUNTRIES)) {
      return $ORIGINS['ONLINE'];
    }

    return $ORIGINS['PUBLUU'];
  }

  public static function getFullRequestUrlWithParams($options = []) {
    $options = array_replace([
      'pathAsString' => false,
      'pathWithPage' => true,
      'isCustomUrl' => false
    ], $options);

    $query_str = parse_url($_SERVER["REQUEST_URI"]);
    $aData = explode('/', $query_str['path']);

    if ($options['isCustomUrl']) {
      $requestData = APP::getCustomUrlRequestData();

      $pid = $requestData['pid'];
      $iid = $requestData['iid'];
      $page = $requestData['page'];
    } elseif ($aData[1] == 'view') {
      $pid = $aData[2];
      $iid = $aData[3];
      $page = isset($aData[5]) ? $aData[5] : 1;
    } elseif ($_SERVER['HTTP_HOST'] == 'online.publuu.com') {
      $requestData = APP::getOnlineRequestData();
      
      $pid = $requestData['pid'];
      $iid = $requestData['iid'];
      $page = $requestData['page'];
    } else {
      $pid = $aData[2];
      $iid = $aData[3];
      $page = isset($aData[5]) ? $aData[5] : 1;
    }

    if ($options['pathAsString']) {
      $withPage = array_search('page', $aData) !== false;
      $withFlipBook = array_search('flip-book', $aData) !== false;
      $withFlipBookDev = array_search('publuudev', $aData) !== false;
      $pageString = $withPage && $options['pathWithPage'] ? '/page/' . $page : '';
      $flipBookString = $withFlipBook ? 'flip-book/' : ($withFlipBookDev ? 'publuudev/' : '');

      if ($options['isCustomUrl']) {
        return 'https://' . $_SERVER['SERVER_NAME'] . '/' . $pid . $pageString;
      }

      return 'https://' . $_SERVER['SERVER_NAME'] . '/' . $flipBookString . $pid . '/' . $iid . $pageString;
    }

    return [
      'pid' => $pid, 
      'iid' => $iid,
      'page' => $page
    ];
  }

  private function getCustomUrlRequestData() {
    $query_str = parse_url($_SERVER["REQUEST_URI"]);
    $aData = explode('/', $query_str['path']);

    $pathnameFiltered = array_values(array_filter($aData, function($var) {
      return strlen($var) > 0;
    }));

    $pid = $pathnameFiltered[0];

    if (!isset($pid) || strlen($pid) == 0 || $pid == "robots.txt") {
      return;
    }

    $page = $pathnameFiltered[1] == 'page' && count($pathnameFiltered) >= 3 ? $pathnameFiltered[2] : 1;

    return [
      'pid' => $pid,
      'iid' => 0,
      'page' => $page
    ];
  }

  private function getOnlineRequestData() {
    $pathname = $_SERVER["REQUEST_URI"];
    $pathname = $pathname[0] == '/' ? substr($pathname, 1) : $pathname;
    $pathname = explode('?', $pathname)[0];
    
    $pathnameExploded = explode('/', $pathname);
    $withFlipBook = $pathnameExploded[0] == 'flip-book';
    $withPage = array_search('page', $pathnameExploded) !== false;
    $page = 1;
  
    if ($withPage) {
      $pageIndex = array_search('page', $pathnameExploded);
  
      $page = 
        count($pathnameExploded) > $pageIndex + 1 && 
        isset($pathnameExploded[$pageIndex + 1]) && 
        is_numeric($pathnameExploded[$pageIndex + 1]) &&
        intval($pathnameExploded[$pageIndex + 1]) > 0
          ? $pathnameExploded[$pageIndex + 1] 
          : 1;
    }
  
    if ($withFlipBook) {
      return [
        'pid' => $pathnameExploded[1],
        'iid' => $pathnameExploded[2],
        'page' => $page
      ];
    }
      
    return [
      'pid' => $pathnameExploded[0],
      'iid' => $pathnameExploded[1],
      'page' => $page
    ];
  }
}


APP::init();
